---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, symboles
              grands délimiteurs, délimiteur interne, crochets, parenthèses,
              notation Bayesienne
---

# Comment écrire les bra-kets de Dirac ou une spécification d'ensemble ?

Cette question revient à savoir comment obtenir une barre verticale 
redimensionnable dans une expression mathématique.


## Avec les commandes de base, pour LaTeX

TeX fournit à LaTeX des primitives appelées `\left` et `\right` qui peuvent 
être utilisées pour modifier les parenthèses (ou délimiteurs de toutes sortes)
autour d'une expression mathématique, comme dans l'expression suivante :

```{noedit}
\left( ⟨expression⟩ \right)
``` 
Dans ce cas, la taille des parenthèses sera adaptée à la hauteur 
de leur contenu.

Cependant, dans certaines expressions mathématiques, vous pouvez avoir besoin 
d'adapter un symbole placé entre ces deux parenthèses : ce cas se produit 
dans les [parenthèses de Dirac](wpfr:Notation_bra-ket) (les fameux "bras" 
et "kets") et dans les notations d'ensemble. 

Pour cela, une commande `\middle` est disponible :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{amssymb}        % Notations comme \mathbb

\begin{document}
Un exemple de notation bra-ket :
\[ 
  \left\langle \phi 
  \middle| \frac{\partial^2}{\partial t^2} \middle| \psi
  \right\rangle
\]

Un exemple d'ensemble :
\[
  A = \left\{ x \in \mathbb{N} 
  \middle| \frac{10}{3} < x < \frac{40}{3} 
  \right\}
\]
\end{document}
```


## Avec l'extension <ctanpkg:braket>, pour TeX

Si le [système eTeX](/1_generalites/glossaire/etex) fournit une telle commande,
les utilisateurs du TeX original de Knuth n'ont pas la même chance 
car TeX ne fournit que les primitives `\left` et `\right`.

Ici, l'extension <ctanpkg:braket>, de Donald Arseneau, résout le problème 
en fournissant des commandes dédiées pour les spécifications d'ensembles
et les notations bra-kets.

Notez que l'extension <ctanpkg:braket> utilise la commande intégrée à eTeX 
s'il est chargé sous eTeX.


:::{sources}
- [Set specifications and Dirac brackets](faquk:FAQ-braket)
:::