---
myst:
  html_meta:
    keywords: LaTeX, composition, flottants, légendes, légende d'un tableau,
              légende d'une figure, mise en forme
---

# Comment utiliser la commande `\caption` hors d'un environnement flottant ?

La commande `\caption` ne peut pas être utilisée en dehors d'un environnement 
`figure` ou `table`, pour la simple raison qu'elle a besoin de savoir 
à quel type de flottant elle s'applique (pour choisir entre `\figurename` 
ou `\tablename`).

L'extension <ctanpkg:caption> définit une commande, `\captionof`, qui prend 
deux arguments :

- le premier indique le type (`figure` ou `table`) à utiliser ;
- le deuxième contient la légende elle-même.

Voici un exemple de cette commande :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)  
  \usepackage{mwe}            % Pour inclure des images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{caption}

\begin{document}
Comme le dit la Wikipédia, A (capitale : A, minuscule : a) est la première 
lettre de l'alphabet latin ainsi que sa première voyelle.

\begin{center}
  \begin{tabular}{c}
    \includegraphics[width=.5\linewidth]{example-image-a} \\
  \end{tabular}
  \captionof{figure}{La lettre A}
  \label{monA}
\end{center}

La lettre A est présentée dans la figure~\ref{monA}.
\end{document}
```