---
myst:
  html_meta:
    keywords: programmation, commandes, macros, liste des commandes, commandes à un seul caractère
---
# Quelles sont toutes les commandes à un seul caractère ?

Il existe de nombreuses commandes très courtes et d'usage assez courants.
En voici un tour d'horizon en les présentant par familles de commandes servant aux mêmes objectifs.

Le tableau suivant liste les différentes commandes (dans l'ordre des caractères ASCII).
Tous sont détaillés dans la suite de cette page.

| Commande     | Famille       | Note                                         |
|--------------|---------------|----------------------------------------------|
| `'`          | Symboles      | Apostrophe ou prime, selon le contexte       |
| `~`          | Espaces       | Espace insécable                             |
| `\ `         | Espaces       | Espace simple                                |
| `\!`         | Espaces       | Espace négatif de 3/18 em                    |
| `\"`         | Accents       | Tréma                                        |
| `\#`         | Symboles      | #                                            |
| `\$`         | Symboles      | $                                            |
| `\%`         | Symboles      | %                                            |
| `\&`         | Symboles      | &                                            |
| `\'`         | Accents       | Accent aigu                                  |
| `\'`         | `tabbing`     | (Voir plus bas)                              |
| `\(`         | Mathématiques | Début de mode mathématique en ligne          |
| `\)`         | Mathématiques | Fin de mode mathématique en ligne            |
| `\*`         | Mathématiques | Multiplication implicite                     |
| `\+`         | `tabbing`     | (Voir plus bas)                              |
| `\,`         | Espaces       | Espace de 3/18 em                            |
| `\-`         | Mise en forme | Césure locale                                |
| `\-`         | `tabbing`     | (Voir plus bas)                              |
| `\.`         | Accents       | Point suscrit                                |
| `\/`         | Mise en forme | Correction d'italique                        |
| `\:`         | Espaces       | Espace de 4/18 em                            |
| `\;`         | Espaces       | Espace de 5/18 em                            |
| `\<`         | `tabbing`     | Retour en arrière d'une tabulation           |
| `\=`         | Accents       | Macron                                       |
| `\=`         | `tabbing`     | Tabulation                                   |
| `\>`         | Espaces       | Espace de 4/18 em                            |
| `\>`         | `tabbing`     | Taquet de tabulation                         |
| `\@`         | Mise en forme | Gestion d'espace en typographie anglaise     |
| `\G`         | Accents       | Double accent grave (<ctanpkg:fontenc>, `T4`)|
| `\H`         | Accents       | Double accent aigu                           |
| `\L`         | Lettres       | L barré majuscule                            |
| `\O`         | Lettres       | O barré majuscule                            |
| `\P`         | Symboles      | Pied-de-mouche                               |
| `\S`         | Symboles      | Symbole du paragraphe                        |
| `\[`         | Mathématiques | Début de mode mathématique hors-texte        |
| `\\`         | Mise en forme | Fin de paragraphe ou de ligne de tableau     |
| `\]`         | Mathématiques | Début de mode mathématique hors-texte        |
| `\^`         | Accents       | Accent circonflexe                           |
| `\_`         | Symboles      | _                                            |
| ```` \` ```` | Accents       | Accent grave                                 |
| ```` \` ```` | `tabbing`     | (Voir plus bas)                              |
| `\a`         | `tabbing`     | Appel d'accents dans cet environnement       |
| `\b`         | Accents       | Macron souscrit                              |
| `\c`         | Accents       | Cédille                                      |
| `\d`         | Accents       | Point souscrit                               |
| `\i`         | Lettres       | I minuscule sans le point                    |
| `\j`         | Lettres       | J minuscule sans le point                    |
| `\k`         | Accents       | Ogonek                                       |
| `\l`         | Lettres       | L barré minuscule                            |
| `\o`         | Lettres       | O barré minuscule                            |
| `\r`         | Accents       | Rond en chef                                 |
| `\t`         | Accents       | Double brève inversée                        |
| `\u`         | Accents       | Brève                                        |
| `\v`         | Accents       | Caron                                        |
| `\{`         | Symboles      | Accolade ouvrante                            |
| `\|`         | Mathématiques | Symbole des barres doubles verticales        |
| `\}`         | Symboles      | Accolade fermante                            |
| `\~`         | Accents       | Tilde                                        |


## Commandes de mise en forme du texte

### `\-`

La commande `\-` permet de gérer localement une césure, comme illustré en question "[](/3_composition/langues/cesure/comment_fonctionne_la_cesure.md)".


### `\/`

La commande `\/` insère dans du texte une espace correspondant à la [correction d'italique](/1_generalites/notions_typographie/correction_italique.md).
En mode mathématiques, cette commande ajoute une espace de largeur nulle.


### `\@`

La commande `\@` sert pour la typographie anglaise. 
Après un point, l'espace qui suit doit être un peu plus importante que les espaces intermots. 
LaTeX gère ce cas sauf lorsque la phrase finit par une lettre majuscule. 
La commande `\@` corrige ce point.

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
And so died King Henri VIII. This was...

And so died King Henri VIII\@. This was...

And so died King Henri viii. This was...

And so died King Henri viii\@. This was...
\end{document}
```

Cette commande est parfois vue comme responsable, malgré elle, d'erreurs. 
Ainsi, lorsqu'une commande telle que `\@ne` (ou tout commande dont le nom commence par `\@`) est utilisée alors que le symbole `@` n'est pas considéré comme une lettre, LaTeX comprend qu'il lit la commande `\@` suivi de `ne`. 
Ce comportement est détaillé à la question :"[](makeatletter_et_makeatother.md)", tout comma à la question "[](../syntaxe/catcodes/que_sont_les_catcodes.md)".

LaTeX n'utilisa donc pas la bonne commande et va générer des anomalies. 
Toutefois, l'erreur est souvent plus insidieuse car la commande `\@` contient dans son code la commande `\spacefactor` et cette dernière ne peut être utilisé n'importe où... d'où des messages d'erreur parfois inattendus évoqués aux questions suivantes :
- [](../erreurs/i/improper_spacefactor.md)
- [](../erreurs/y/you_cannot_use_spacefactor_in_math_mode.md)


### `\\`

La commande `\\` a trois significations, selon qu'elle se trouve dans un texte, dans un tableau de texte ou de mathématique. 
Elle peut être suivie d'une étoile (qui est ignorée) d'un argument optionnel entre crochets, qui est une dimension. 

À l'extérieur d'un tableau, `\\` indique la fin d'un paragraphe et le début d'un nouveau, qui n'est pas indenté. 
L'argument optionnel indique l'espace vertical à ajouter (voir aussi la commande ``vskip``).

À l'intérieur d'un tableau, le `\\` indique la fin de la ligne courante, et l'argument facultatif spécifie l'espace supplémentaire entre les lignes. 
Notez que `\\` termine la cellule courante, la ligne courante, et commence une nouvelle ligne et une nouvelle cellule. 
S'il s'agit de la dernière cellule du tableau, et si elle est vide, alors la ligne est supprimée. 
Autrement dit, une "ligne" est ignorée à la fin d'un tableau ; elle est cependant nécessaire avant une "ligne" finale si l'on veut une règle horizontale à la fin du tableau.

En voici quelques exemples, indubitablement peu esthétiques.

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
\section{Un exemple de titre\\[2mm]en deux lignes}
Une première affirmation \\* 
Suivie d'une deuxième \\[5mm] 
Puis d'une troisième \\
Puis d'un tableau dans un texte
\begin{tabular}{ccc}
\hline
a & b & c \\[3mm]
d & e & f \\ \hline
\end{tabular}
et enfin d'un tableau en mode mathématiques :
\[
\begin{array}{lcl}
x & = & 2x + y \\[5mm]
y & = & 7 \\
\end{array}
\]
\end{document}
```


## Commandes pour obtenir des symboles

Parmi les symboles listés ici figurent des symboles très particuliers.
En effet, TeX et LaTeX utilisent des caractères pour des usages spécifiques par le biais des [catcodes](../syntaxe/catcodes/que_sont_les_catcodes.md). 
Par exemple, le `%` indique à LaTeX un début de commentaire ne devant pas figurer dans le document final. 
Cela rend le caractère associé non affichable par défaut. 
Parmi les commandes qui suivent figurent donc les commandes permettant d'afficher ces symboles dans le document final.

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
Enfin, les voici ces symboles bien particuliers : \# \$ \% \& \_ \{ \}.
\end{document}
```

### `'`

Si le caractère `'` se comporte assez classiquement dans le texte en affichant [l'apostrophe](wpfr:Apostrophe_(typographie)), il change de forme en mode mathématique pour devenir le [prime](wpfr:Prime_(typographie)).

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
L'apostrophe n'a pas le même sens dans les mathématiques :
\[ a' \neq a''\]
\end{document}
```


### `\#`

La commande `\#` est valide en mode mathématique et en mode texte. 
Elle permet d'afficher le symbole du [dièse](wpfr:Dièse).


### `\$`

La commande `\$` est valide en mode mathématique et en mode texte. 
Elle permet d'afficher le symbole du [dollar](wpfr:). 


### `\%`

La commande `\%` est valide en mode mathématique et en mode texte. 
Elle permet d'afficher le symbole du [pourcentage](wpfr:Pourcentage). 


### `\&`

La commande `\&` est valide en mode mathématique et en mode texte. 
Elle permet d'afficher le symbole de [l'esperluette](wpfr:Esperluette).


### `\P`

La commande `\P` affiche le [pied-de-mouche](wpfr:Pied-de-mouche), symbole de fin de paragraphe ou d'un alinéa.


### `\S` 

La commande `\S` affiche le [symbole du paragraphe](wpfr:Paragraphe_(symbole)) barré minuscule et majuscule.


### `\_`

La commande `\_` est valide en mode mathématique et en mode texte. 
Elle génère un trait de soulignement.


### `\{` et `\}`

Les commandes `\{` et `\}` sont valides en mode mathématique et en mode texte. 
Elles affichent respectivement une accolade ouvrante et une accolade fermante. Elles peuvent être utilisées comme [délimiteurs mathématiques](/4_domaines_specialises/mathematiques/structures/delimiteurs/delimiteurs_mathematiques.md).


## Commandes d'espacement

Plusieurs commandes sont associées à la génération d'espaces pour les mathématiques ou le texte. 
La question "[](/4_domaines_specialises/mathematiques/espaces_en_mode_mathematique.md)" illustre plus largement les espaces disponibles en mode mathématiques.

### `~`

Le caractère `~` est un caractère associé à un code de catégorie particulier. 
Il se traduit en temps normal par une espace insécable. 
Toutefois, le résultat diffère en mode verbatim et en mode mathématique, comme le montre l'exemple suivant :

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
Quelques tests sur le tilde :
\begin{itemize}
\item ~            % le tilde ici est une espace insécable
\item \verb=~=     % le tilde reste un tilde
\item $a~b$        % le tilde est une espace
\end{itemize}
\end{document}
```

### `\ ` (contre-oblique suivie d'un espace)

La commande `\ ` est valide en mode mathématique et en mode texte. 
Elle génère un espace. 


### `\!`

La commande `\!` est valide en mode mathématique et en mode texte. 
Elle génère un espace négatif de 3/18em en mode mathématique et rien en mode texte. 


### `\,`

La commande `\,` est valide en mode mathématique et en mode texte. 
Elle génère un espace de 3/18em en mode mathématique et un espace insécable dans le cas contraire.


### `\:`

La commande `\:` est valide en mode mathématique et en mode texte. 
Elle génère un espace de 4/18em.


### `\;`

La commande `\;` est valide en mode mathématique et en mode texte. 
Elle génère un espace de 5/18em.


### `\>`

La commande `\>` est valide en mode mathématique et en mode texte. 
Elle génère un espace de 4/18em.


## Commandes mathématiques

### `\(` et `\)`

Les commandes `\(` et `\)` servent respectivement [à entrer et à sortir du mode mathématique](/4_domaines_specialises/mathematiques/passer_en_mode_mathematique.md) en ligne.

Dans le cadre de l’extension <ctanpkg:ifthen>, ces deux commandes sont redéfinies pour servir de parenthèses interprétables par LaTeX dans des tests d’expressions logiques.


### `\*`

La commande `\*` n'est valide qu'en mode mathématique : elle correspond à la multiplication implicite (visible dans le code mais non affichée dans le document final).

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
\[
a \times b = a \* b 
\]
\end{document}
```


### `\[` et  `\]`

Les commandes `\[` et  `\]` servent respectivement à entrer et à sortir du [mode mathématique](/4_domaines_specialises/mathematiques/passer_en_mode_mathematique.md) hors-ligne.


### `\|`

La commande `\|` n'est valide qu'en mode mathématique. 
Elle génère le symbole des barres verticales doubles, ce qui la rend équivalente à `\Vert`. 
Elle peut être utilisée comme [délimiteur mathématique](/4_domaines_specialises/mathematiques/structures/delimiteurs/delimiteurs_mathematiques.md).


## Les commandes pour des lettres particulières

### `\i` et  `\j` 

Les commandes `\i` et `\j` affichent respectivement un `i` et un `j` minuscule sans leur point. 
Ces commandes se combinent généralement avec les commandes d'accentuation, l'absence du point permettant de bien positionner l'accent.
Comme le montrent les exemples portant sur les accents sur cette page, cette règle peut dépendre de l'accent utiliser.

En mode mathématique, d'autres commandes existent et sont détaillées à la question "[](/4_domaines_specialises/mathematiques/structures/les_accents_en_mode_mathematique.md)".


### `\l` et `\L`

Les commandes `\l` et `\L` affichent respectivement le [l barré](wpfr:Ł) minuscule et majuscule.


### `\o` et `\O`

Les commandes `\o` et `\O` affichent respectivement le [o barré](wpfr:Ø) barré minuscule et majuscule.


## Les commandes d'accentuation

De nombreuses commandes d'un caractère servent à l'accentuation. 

### `\"`

La commande `\"` met un [tréma](wpfr:Tréma) sur toutes les lettres. 

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
\Large
\"A \"B \"C \"D \"E \"F \"G \"H \"I \"J \"K \"L \"M

\"N \"O \"P \"Q \"R \"S \"T \"U \"V \"W \"X \"Y \"Z 

\"\OE\ \"\AE\ \"{\O}

\"a \"b \"c \"d \"e \"f \"g \"h \"\i\ \"\j\ \"k \"l \"m
\"n \"o \"p \"q \"r \"s \"t \"u \"v \"w \"x \"y \"z 

\"\oe\ \"\ae\ \"{\o}
\end{document}
```


### `\'` 

La commande `\'` met un [accent aigu](/3_composition/langues/utiliser_les_lettres_accentuees.md) sur les lettres.
Il ne faut pas la confondre avec `\acute`, une commande réservée aux mathématiques.

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
\Large
\'A \'B \'C \'D \'E \'F \'G \'H \'I \'J \'K \'L \'M

\'N \'O \'P \'Q \'R \'S \'T \'U \'V \'W \'X \'Y \'Z 

\'\OE\ \'\AE\ \'{\O}

\'a \'b \'c \'d \'e \'f \'g \'h \'i \'\j\ \'k \'l \'m
\'n \'o \'p \'q \'r \'s \'t \'u \'v \'w \'x \'y \'z 

\'\oe\ \'\ae\ \'{\o}
\end{document}
```


### `\.`

La commande `\.` permet de placer un [point suscrit](wpfr:Point_suscrit) sur toutes les lettres. 
Il ne faut pas la confondre avec `\dot`, une commande réservée aux mathématiques.

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
\Large
\.A \.B \.C \.D \.E \.F \.G \.H \.I \.J \.K \.L \.M

\.N \.O \.P \.Q \.R \.S \.T \.U \.V \.W \.X \.Y \.Z 

\.\OE\ \.\AE\ \.{\O}

\.a \.b \.c \.d \.e \.f \.g \.h \.i \.\j\ \.k \.l \.m
\.n \.o \.p \.q \.r \.s \.t \.u \.v \.w \.x \.y \.z 

\.\oe\ \.\ae\ \.{\o}
\end{document}
```


### `\=` 

La commande `\=` permet de placer un [macron](wpfr:Macron_(diacritique)) sur toutes les lettres. 
Il ne faut pas la confondre avec `\bar`, une commande réservée aux mathématiques.

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
\Large
\=A \=B \=C \=D \=E \=F \=G \=H \=I \=J \=K \=L \=M

\=N \=O \=P \=Q \=R \=S \=T \=U \=V \=W \=X \=Y \=Z 

\=\OE\ \=\AE\ \={\O}

\=a \=b \=c \=d \=e \=f \=g \=h \=\i\ \=\j\ \=k \=l \=m
\=n \=o \=p \=q \=r \=s \=t \=u \=v \=w \=x \=y \=z 

\=\oe\ \=\ae\ \={\o}
\end{document}
```


### `\G`

La commande `\G` permet de placer un [double accent grave](wpfr:Double_accent_grave) sur toutes les lettres. 
Elle demande l'appel à l'extension <ctanpkg:fontenc> avec l'option `T4`.

```{warning}
Ceci ne fonctionne qu'avec le moteur `pdflatex`.
```

```
%!TEX engine=pdflatex
\documentclass{article}
  \usepackage[T4]{fontenc} % Encodage T4
  \pagestyle{empty}        % N'affiche pas de numéro de page

\begin{document}
\Large
\G{A} \G{B} \G{C} \G{D} \G{E} \G{F} \G{G} \G{H} \G{I} \G{J} \G{K} \G{L} \G{M}

\G{N} \G{O} \G{P} \G{Q} \G{R} \G{S} \G{T} \G{U} \G{V} \G{W} \G{X} \G{Y} \G{Z} 

\G{\OE} \G{\AE} \G{\O}

\G{a} \G{b} \G{c} \G{d} \G{e} \G{f} \G{g} \G{h} \G{\i} \G{\j} \G{k} \G{l} \G{m}
\G{n} \G{o} \G{p} \G{q} \G{r} \G{s} \G{t} \G{u} \G{v} \G{w} \G{x} \G{y} \G{z} 

\G{\oe} \G{\ae} \G{\o}
\end{document}
```


### `\H`

La commande `\H` permet de placer un [double accent aigu](wpfr:Double_accent_aigu) sur toutes les lettres. 

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
\Large
\H{A} \H{B} \H{C} \H{D} \H{E} \H{F} \H{G} \H{H} \H{I} \H{J} \H{K} \H{L} \H{M}

\H{N} \H{O} \H{P} \H{Q} \H{R} \H{S} \H{T} \H{U} \H{V} \H{W} \H{X} \H{Y} \H{Z} 

\H{\OE} \H{\AE} \H{\O}

\H{a} \H{b} \H{c} \H{d} \H{e} \H{f} \H{g} \H{h} \H{\i} \H{\j} \H{k} \H{l} \H{m}
\H{n} \H{o} \H{p} \H{q} \H{r} \H{s} \H{t} \H{u} \H{v} \H{w} \H{x} \H{y} \H{z} 

\H{\oe} \H{\ae} \H{\o}
\end{document}
```


### `\^`

La commande `\^` permet de placer un [accent circonflexe](wpfr:Accent_circonflexe) sur toutes les lettres. 
Il ne faut pas la confondre avec `\hat`, une commande réservée aux mathématiques.

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
\Large
\^A \^B \^C \^D \^E \^F \^G \^H \^I \^J \^K \^L \^M

\^N \^O \^P \^Q \^R \^S \^T \^U \^V \^W \^X \^Y \^Z 

\^\OE\ \^\AE\ \^{\O}

\^a \^b \^c \^d \^e \^f \^g \^h \^i \^\j\ \^k \^l \^m
\^n \^o \^p \^q \^r \^s \^t \^u \^v \^w \^x \^y \^z 

\^\oe\ \^\ae\ \^{\o}
\end{document}
```


### ```` \` ````

La commande ```` \` ```` met un [accent grave](wpfr:Accent_grave) sur toutes les lettres. 
Il ne faut pas la confondre avec `\grave`, une commande réservée aux mathématiques.

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
\Large
\`A \`B \`C \`D \`E \`F \`G \`H \`I \`J \`K \`L \`M

\`N \`O \`P \`Q \`R \`S \`T \`U \`V \`W \`X \`Y \`Z 

\`\OE\ \`\AE\ \`{\O}

\`a \`b \`c \`d \`e \`f \`g \`h \`i \`\j\ \`k \`l \`m
\`n \`o \`p \`q \`r \`s \`t \`u \`v \`w \`x \`y \`z 

\`\oe\ \`\ae\ \`{\o}
\end{document}
```


### `\b`

La commande `\b` permet de placer un [macron souscrit](wpfr:Macron_souscrit) sur toutes les lettres. 

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
\Large
\b{A} \b{B} \b{C} \b{D} \b{E} \b{F} \b{G} \b{H} \b{I} \b{J} \b{K} \b{L} \b{M}

\b{N} \b{O} \b{P} \b{Q} \b{R} \b{S} \b{T} \b{U} \b{V} \b{W} \b{X} \b{Y} \b{Z} 

\b{\OE} \b{\AE} \b{\O}

\b{a} \b{b} \b{c} \b{d} \b{e} \b{f} \b{g} \b{h} \b{i} \b{j} \b{k} \b{l} \b{m}
\b{n} \b{o} \b{p} \b{q} \b{r} \b{s} \b{t} \b{u} \b{v} \b{w} \b{x} \b{y} \b{z} 

\b{\oe} \b{\ae} \b{\o}
\end{document}
```


### `\c`

La commande `\c` permet de placer une [cédille](wpfr:Cédille) sur toutes les lettres (certains cas n'étant cependant pas très adaptés).

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
\Large
\c{A} \c{B} \c{C} \c{D} \c{E} \c{F} \c{G} \c{H} \c{I} \c{J} \c{K} \c{L} \c{M}

\c{N} \c{O} \c{P} \c{Q} \c{R} \c{S} \c{T} \c{U} \c{V} \c{W} \c{X} \c{Y} \c{Z} 

\c{\OE} \c{\AE} \c{\O}

\c{a} \c{b} \c{c} \c{d} \c{e} \c{f} \c{g} \c{h} \c{i} \c{j} \c{k} \c{l} \c{m}
\c{n} \c{o} \c{p} \c{q} \c{r} \c{s} \c{t} \c{u} \c{v} \c{w} \c{x} \c{y} \c{z} 

\c{\oe} \c{\ae} \c{\o}
\end{document}
```


### `\d`

La commande `\d` permet de placer un [point souscrit](wpfr:Point_souscrit) sur toutes les lettres. 

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
\Large
\d{A} \d{B} \d{C} \d{D} \d{E} \d{F} \d{G} \d{H} \d{I} \d{J} \d{K} \d{L} \d{M}

\d{N} \d{O} \d{P} \d{Q} \d{R} \d{S} \d{T} \d{U} \d{V} \d{W} \d{X} \d{Y} \d{Z} 

\d{\OE} \d{\AE} \d{\O}

\d{a} \d{b} \d{c} \d{d} \d{e} \d{f} \d{g} \d{h} \d{i} \d{j} \d{k} \d{l} \d{m}
\d{n} \d{o} \d{p} \d{q} \d{r} \d{s} \d{t} \d{u} \d{v} \d{w} \d{x} \d{y} \d{z} 

\d{\oe} \d{\ae} \d{\o}
\end{document}
```


### `\k`

La commande `\k` permet de placer un [ogonek](wpfr:Ogonek) sur toutes les lettres. 
Elle demande l'appel à l'extension <ctanpkg:fontenc> avec l'option `T1`.

```
\documentclass{article}
  \usepackage[T1]{fontenc} % Encodage T1
  \usepackage{lmodern}     % Caractères plus lisibles
  \pagestyle{empty}        % N'affiche pas de numéro de page

\begin{document}
\Large
\k{A} \k{B} \k{C} \k{D} \k{E} \k{F} \k{G} \k{H} \k{I} \k{J} \k{K} \k{L} \k{M}

\k{N} \k{O} \k{P} \k{Q} \k{R} \k{S} \k{T} \k{U} \k{V} \k{W} \k{X} \k{Y} \k{Z} 

\k{\OE} \k{\AE} \k{\O}

\k{a} \k{b} \k{c} \k{d} \k{e} \k{f} \k{g} \k{h} \k{i} \k{j} \k{k} \k{l} \k{m}
\k{n} \k{o} \k{p} \k{q} \k{r} \k{s} \k{t} \k{u} \k{v} \k{w} \k{x} \k{y} \k{z} 

\k{\oe} \k{\ae} \k{\o}
\end{document}
```


### `\r`

La commande `\r` permet de placer un [rond en chef](wpfr:Rond_en_chef) sur toutes les lettres. 

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
\Large
\r{A} \r{B} \r{C} \r{D} \r{E} \r{F} \r{G} \r{H} \r{I} \r{J} \r{K} \r{L} \r{M}

\r{N} \r{O} \r{P} \r{Q} \r{R} \r{S} \r{T} \r{U} \r{V} \r{W} \r{X} \r{Y} \r{Z} 

\r{\OE} \r{\AE} \r{\O}

\r{a} \r{b} \r{c} \r{d} \r{e} \r{f} \r{g} \r{h} \r{\i} \r{\j} \r{k} \r{l} \r{m}
\r{n} \r{o} \r{p} \r{q} \r{r} \r{s} \r{t} \r{u} \r{v} \r{w} \r{x} \r{y} \r{z} 

\r{\oe} \r{\ae} \r{\o}
\end{document}
```


### `\t`

La commande `\t` permet de placer une double brève inversée sur toutes les lettres. 

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
\Large
\t{A} \t{B} \t{C} \t{D} \t{E} \t{F} \t{G} \t{H} \t{I} \t{J} \t{K} \t{L} \t{M}

\t{N} \t{O} \t{P} \t{Q} \t{R} \t{S} \t{T} \t{U} \t{V} \t{W} \t{X} \t{Y} \t{Z} 

\t{\OE} \t{\AE} \t{\O}

\t{a} \t{b} \t{c} \t{d} \t{e} \t{f} \t{g} \t{h} \t{\i} \t{\j} \t{k} \t{l} \t{m}
\t{n} \t{o} \t{p} \t{q} \t{r} \t{s} \t{t} \t{u} \t{v} \t{w} \t{x} \t{y} \t{z} 

\t{\oe} \t{\ae} \t{\o}
\end{document}
```


### `\u`

La commande `\u` permet de placer une [brève](wpfr:Brève) sur toutes les lettres. 

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
\Large
\u{A} \u{B} \u{C} \u{D} \u{E} \u{F} \u{G} \u{H} \u{I} \u{J} \u{K} \u{L} \u{M}

\u{N} \u{O} \u{P} \u{Q} \u{R} \u{S} \u{T} \u{U} \u{V} \u{W} \u{X} \u{Y} \u{Z} 

\u{\OE} \u{\AE} \u{\O}

\u{a} \u{b} \u{c} \u{d} \u{e} \u{f} \u{g} \u{h} \u{\i} \u{\j} \u{k} \u{l} \u{m}
\u{n} \u{o} \u{p} \u{q} \u{r} \u{s} \u{t} \u{u} \u{v} \u{w} \u{x} \u{y} \u{z} 

\u{\oe} \u{\ae} \u{\o}
\end{document}
```


### `\v`

La commande `\v` permet de placer un [caron](wpfr:Caron_(diacritique)) sur toutes les lettres. 
Certaines lettres, comme le `L` ou le `d` donnent une graphie légèrement différente.

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
\Large
\v{A} \v{B} \v{C} \v{D} \v{E} \v{F} \v{G} \v{H} \v{I} \v{J} \v{K} \v{L} \v{M}

\v{N} \v{O} \v{P} \v{Q} \v{R} \v{S} \v{T} \v{U} \v{V} \v{W} \v{X} \v{Y} \v{Z} 

\v{\OE} \v{\AE} \v{\O}

\v{a} \v{b} \v{c} \v{d} \v{e} \v{f} \v{g} \v{h} \v{\i} \v{\j} \v{k} \v{l} \v{m}
\v{n} \v{o} \v{p} \v{q} \v{r} \v{s} \v{t} \v{u} \v{v} \v{w} \v{x} \v{y} \v{z} 

\v{\oe} \v{\ae} \v{\o}
\end{document}
```


### `\~`

La commande `\~` permet de placer un [tilde](wpfr:Tilde) sur une lettre (voir aussi la commande `\tilde`).

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
\Large
\~A \~B \~C \~D \~E \~F \~G \~H \~I \~J \~K \~L \~M

\~N \~O \~P \~Q \~R \~S \~T \~U \~V \~W \~X \~Y \~Z 

\~\OE\ \~\AE\ \~{\O}

\~a \~b \~c \~d \~e \~f \~g \~h \~\i\ \~\j\ \~k \~l \~m
\~n \~o \~p \~q \~r \~s \~t \~u \~v \~w \~x \~y \~z 

\~\oe\ \~\ae\ \~{\o}
\end{document}
```


## Commandes dans l'environnement `tabbing`

Plusieurs commandes existent (ou sont redéfinies) dans le cadre de l'environnement `tabbing` détaillé à la question "[](/3_composition/tableaux/tabulations/composer_un_tableau_avec_des_tabulations.md)".

:::{sources}
[Tralics: All commands, non-letters ](https://www-sop.inria.fr/marelle/tralics/doc-symbols.html)
[What is the proper use of \@ (i.e., backslash-at)?](https://tex.stackexchange.com/questions/22561/what-is-the-proper-use-of-i-e-backslash-at)
:::
