/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.rules;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.files.FileType;
import org.islandoftex.arara.api.rules.Directive;
import org.islandoftex.arara.api.rules.DirectiveConditionalType;
import org.islandoftex.arara.core.files.FileHandling;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.rules.DirectiveAssembler;
import org.islandoftex.arara.core.rules.DirectiveConditional;
import org.islandoftex.arara.core.rules.DirectiveFetchingHooks;
import org.islandoftex.arara.core.rules.Directives;
import org.islandoftex.arara.core.rules.DirectivesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0015\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ2\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00060 2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J2\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010#\u001a\u00020\u00012\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010 2\u0006\u0010%\u001a\u00020\u0016H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/islandoftex/arara/core/rules/Directives;", "", "()V", "directivePattern", "Ljava/util/regex/Pattern;", "directivestart", "", "hooks", "Lorg/islandoftex/arara/core/rules/DirectiveFetchingHooks;", "getHooks$annotations", "getHooks", "()Lorg/islandoftex/arara/core/rules/DirectiveFetchingHooks;", "setHooks", "(Lorg/islandoftex/arara/core/rules/DirectiveFetchingHooks;)V", "linebreakPattern", "namePattern", "pattern", "checkLinePattern", "", "line", "extractDirectives", "", "Lorg/islandoftex/arara/api/rules/Directive;", "lines", "parseOnlyHeader", "fileType", "Lorg/islandoftex/arara/api/files/FileType;", "generateDirective", "assembler", "Lorg/islandoftex/arara/core/rules/DirectiveAssembler;", "generateDirective$core", "getPotentialDirectiveLines", "", "", "replicateDirective", "holder", "parameters", "directive", "core"})
public final class Directives {
    @NotNull
    private static DirectiveFetchingHooks hooks;
    private static final String directivestart = "^\\s*(\\w+)\\s*(:\\s*(\\{.*\\})\\s*)?";
    private static final String pattern = "(\\s+(if|while|until|unless)\\s+(\\S.*))?$";
    private static final Pattern directivePattern;
    private static final String namePattern = "arara:\\s";
    private static final Pattern linebreakPattern;
    @NotNull
    public static final Directives INSTANCE;

    @JvmStatic
    public static /* synthetic */ void getHooks$annotations() {
    }

    @NotNull
    public static final DirectiveFetchingHooks getHooks() {
        return hooks;
    }

    public static final void setHooks(@NotNull DirectiveFetchingHooks directiveFetchingHooks) {
        Intrinsics.checkNotNullParameter(directiveFetchingHooks, "<set-?>");
        hooks = directiveFetchingHooks;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, String> getPotentialDirectiveLines(List<String> lines, boolean parseOnlyHeader, String pattern) {
        String string = pattern;
        int n = 0;
        int n2 = 0;
        Pattern pattern2 = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue(pattern2, "java.util.regex.Pattern.compile(this, flags)");
        Pattern validLinePattern = pattern2;
        String string2 = pattern + namePattern;
        n2 = 0;
        boolean bl = false;
        Pattern pattern3 = Pattern.compile(string2, n2);
        Intrinsics.checkNotNullExpressionValue(pattern3, "java.util.regex.Pattern.compile(this, flags)");
        Pattern validLineStartPattern = pattern3;
        n2 = 0;
        Map map = new LinkedHashMap();
        n2 = 0;
        for (String text2 : (Iterable)lines) {
            void i;
            Matcher validLineMatcher = validLineStartPattern.matcher(text2);
            if (validLineMatcher.find()) {
                String line;
                String string3 = text2;
                int n3 = validLineMatcher.end();
                boolean bl2 = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue(string4.substring(n3), "(this as java.lang.String).substring(startIndex)");
                map.put((int)(i + true), hooks.getProcessPotentialDirective().invoke((int)(i + true), line));
            } else if (parseOnlyHeader && !this.checkLinePattern(validLinePattern, text2)) break;
            ++i;
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<Directive> extractDirectives(@NotNull List<String> lines, boolean parseOnlyHeader, @NotNull FileType fileType) throws AraraException {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter(fileType, "fileType");
        Map<Integer, String> map = INSTANCE.getPotentialDirectiveLines(lines, parseOnlyHeader, fileType.getPattern());
        boolean bl = false;
        boolean bl2 = false;
        Object it = map;
        boolean $i$a$-takeIf-Directives$extractDirectives$pairs$222 = false;
        Map<Integer, String> map2 = it;
        boolean bl3 = false;
        Map<Integer, String> map3 = !map2.isEmpty() ? map : null;
        if (map3 == null) {
            return CollectionsKt.emptyList();
        }
        Map<Integer, String> pairs = map3;
        bl = false;
        List assemblers = new ArrayList();
        DirectiveAssembler assembler = new DirectiveAssembler();
        Map<Integer, String> $i$a$-takeIf-Directives$extractDirectives$pairs$222 = pairs;
        boolean bl4 = false;
        it = $i$a$-takeIf-Directives$extractDirectives$pairs$222.entrySet().iterator();
        while (it.hasNext()) {
            void lineno;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)it.next();
            boolean bl5 = false;
            int $i$a$-takeIf-Directives$extractDirectives$pairs$222 = ((Number)entry2.getKey()).intValue();
            entry2 = entry;
            bl5 = false;
            String content = (String)entry2.getValue();
            Matcher linebreakMatcher = linebreakPattern.matcher(content);
            if (linebreakMatcher.find()) {
                if (!assembler.isAppendAllowed()) {
                    String string = LanguageController.getMessages().getERROR_VALIDATE_ORPHAN_LINEBREAK();
                    Object[] objectArray = new Object[]{(int)lineno};
                    boolean bl6 = false;
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string2, "java.lang.String.format(this, *args)");
                    throw (Throwable)new AraraException(string2);
                }
                assembler.addLineNumber((int)lineno);
                String string = linebreakMatcher.group(1);
                Intrinsics.checkNotNullExpressionValue(string, "linebreakMatcher.group(1)");
                assembler.appendLine(string);
                continue;
            }
            if (assembler.isAppendAllowed()) {
                assemblers.add(assembler);
            }
            assembler = new DirectiveAssembler();
            assembler.addLineNumber((int)lineno);
            assembler.appendLine(content);
        }
        if (assembler.isAppendAllowed()) {
            assemblers.add(assembler);
        }
        Iterable $this$map$iv = assemblers;
        boolean $i$f$map = false;
        Iterable lineno = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            DirectiveAssembler directiveAssembler = (DirectiveAssembler)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl7 = false;
            Directive directive = INSTANCE.generateDirective$core((DirectiveAssembler)it2);
            collection.add(directive);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Directive generateDirective$core(@NotNull DirectiveAssembler assembler) throws AraraException {
        Intrinsics.checkNotNullParameter(assembler, "assembler");
        Matcher matcher = directivePattern.matcher(assembler.getText());
        if (matcher.find()) {
            Function4<String, String, org.islandoftex.arara.api.rules.DirectiveConditional, List<Integer>, Directive> function4 = hooks.getBuildDirectiveRaw();
            String string = matcher.group(1);
            Intrinsics.checkNotNull(string);
            String string2 = matcher.group(3);
            DirectiveConditionalType directiveConditionalType = DirectivesKt.access$toDirectiveConditional(matcher.group(5));
            String string3 = matcher.group(6);
            if (string3 == null) {
                string3 = "";
            }
            return function4.invoke(string, string2, new DirectiveConditional(directiveConditionalType, string3), assembler.getLineNumbers());
        }
        String string = LanguageController.getMessages().getERROR_VALIDATE_INVALID_DIRECTIVE_FORMAT();
        Object[] objectArray = new Object[]{CollectionsKt.joinToString$default(assembler.getLineNumbers(), ", ", "(", ")", 0, null, null, 56, null)};
        boolean bl = false;
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string4, "java.lang.String.format(this, *args)");
        throw (Throwable)new AraraException(string4);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<Directive> replicateDirective(@NotNull Object holder, @NotNull Map<String, ? extends Object> parameters2, @NotNull Directive directive) throws AraraException {
        Object object;
        Intrinsics.checkNotNullParameter(holder, "holder");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(directive, "directive");
        if (holder instanceof List) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = (Iterable)holder;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Object)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Object object2 = SequencesKt.toList(SequencesKt.map(SequencesKt.map(SequencesKt.map(SequencesKt.map(CollectionsKt.asSequence((List)destination$iv$iv), replicateDirective.1.INSTANCE), (Function1)new Function1<Path, Path>(FileHandling.INSTANCE){

                @NotNull
                public final Path invoke(@NotNull Path p1) {
                    Intrinsics.checkNotNullParameter(p1, "p1");
                    FileHandling cfr_ignored_0 = (FileHandling)this.receiver;
                    return FileHandling.normalize(p1);
                }
            }), replicateDirective.3.INSTANCE), (Function1)new Function1<File, Directive>(directive, parameters2){
                final /* synthetic */ Directive $directive;
                final /* synthetic */ Map $parameters;

                @NotNull
                public final Directive invoke(File reference) {
                    return Directives.getHooks().getBuildDirective().invoke(this.$directive.getIdentifier(), MapsKt.plus(this.$parameters, TuplesKt.to("reference", reference)), this.$directive.getConditional(), this.$directive.getLineNumbers());
                }
                {
                    this.$directive = directive;
                    this.$parameters = map;
                    super(1);
                }
            }));
            boolean bl = false;
            boolean bl2 = false;
            List<Directive> it = object2;
            boolean bl3 = false;
            Collection collection = it;
            boolean bl4 = false;
            object = !collection.isEmpty() && ((List)holder).size() == it.size() ? object2 : null;
            if (object == null) {
                object2 = LanguageController.getMessages().getERROR_VALIDATE_EMPTY_FILES_LIST();
                Object[] objectArray = new Object[]{CollectionsKt.joinToString$default(directive.getLineNumbers(), ", ", "(", ")", 0, null, null, 56, null)};
                bl2 = false;
                String string = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string, "java.lang.String.format(this, *args)");
                throw (Throwable)new AraraException(string);
            }
        } else {
            String string = LanguageController.getMessages().getERROR_VALIDATE_FILES_IS_NOT_A_LIST();
            Object[] objectArray = new Object[]{CollectionsKt.joinToString$default(directive.getLineNumbers(), ", ", "(", ")", 0, null, null, 56, null)};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "java.lang.String.format(this, *args)");
            throw (Throwable)new AraraException(string2);
        }
        return object;
    }

    private final boolean checkLinePattern(Pattern pattern, String line) {
        return StringsKt.isBlank(line) || pattern.matcher(line).find();
    }

    private Directives() {
    }

    static {
        Directives directives;
        INSTANCE = directives = new Directives();
        hooks = new DirectiveFetchingHooks(null, null, null, 7, null);
        String string = "^\\s*(\\w+)\\s*(:\\s*(\\{.*\\})\\s*)?(\\s+(if|while|until|unless)\\s+(\\S.*))?$";
        int n = 0;
        boolean bl = false;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue(pattern, "java.util.regex.Pattern.compile(this, flags)");
        directivePattern = pattern;
        string = "^\\s*-->\\s(.*)$";
        n = 0;
        bl = false;
        Pattern pattern2 = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue(pattern2, "java.util.regex.Pattern.compile(this, flags)");
        linebreakPattern = pattern2;
    }
}

