/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.load.java.components.TypeUsage;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeAttributes;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeFlexibility;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeResolverKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawTypeImpl;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RawSubstitution
extends TypeSubstitution {
    @NotNull
    public static final RawSubstitution INSTANCE = new RawSubstitution();
    @NotNull
    private static final JavaTypeAttributes lowerTypeAttr = JavaTypeResolverKt.toAttributes$default(TypeUsage.COMMON, false, null, 3, null).withFlexibility(JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND);
    @NotNull
    private static final JavaTypeAttributes upperTypeAttr = JavaTypeResolverKt.toAttributes$default(TypeUsage.COMMON, false, null, 3, null).withFlexibility(JavaTypeFlexibility.FLEXIBLE_UPPER_BOUND);

    private RawSubstitution() {
    }

    @Override
    @NotNull
    public TypeProjectionImpl get(@NotNull KotlinType key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return new TypeProjectionImpl(this.eraseType(key));
    }

    private final KotlinType eraseType(KotlinType type2) {
        KotlinType kotlinType;
        ClassifierDescriptor declaration = type2.getConstructor().getDeclarationDescriptor();
        ClassifierDescriptor classifierDescriptor = declaration;
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            kotlinType = this.eraseType(JavaTypeResolverKt.getErasedUpperBound$default((TypeParameterDescriptor)declaration, null, null, 3, null));
        } else if (classifierDescriptor instanceof ClassDescriptor) {
            ClassifierDescriptor declarationForUpper = FlexibleTypesKt.upperIfFlexible(type2).getConstructor().getDeclarationDescriptor();
            boolean bl = declarationForUpper instanceof ClassDescriptor;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "For some reason declaration for upper bound is not a class but \"" + declarationForUpper + "\" while for lower it's \"" + declaration + '\"';
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Pair<SimpleType, Boolean> pair2 = this.eraseInflexibleBasedOnClassDescriptor(FlexibleTypesKt.lowerIfFlexible(type2), (ClassDescriptor)declaration, lowerTypeAttr);
            SimpleType lower = pair2.component1();
            boolean isRawL = pair2.component2();
            Pair<SimpleType, Boolean> pair3 = this.eraseInflexibleBasedOnClassDescriptor(FlexibleTypesKt.upperIfFlexible(type2), (ClassDescriptor)declarationForUpper, upperTypeAttr);
            SimpleType upper = pair3.component1();
            boolean isRawU = pair3.component2();
            kotlinType = isRawL || isRawU ? (UnwrappedType)new RawTypeImpl(lower, upper) : KotlinTypeFactory.flexibleType(lower, upper);
        } else {
            String string = Intrinsics.stringPlus("Unexpected declaration kind: ", declaration);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<SimpleType, Boolean> eraseInflexibleBasedOnClassDescriptor(SimpleType type2, ClassDescriptor declaration, JavaTypeAttributes attr) {
        Collection<TypeProjection> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (type2.getConstructor().getParameters().isEmpty()) {
            return TuplesKt.to(type2, false);
        }
        if (KotlinBuiltIns.isArray(type2)) {
            TypeProjection componentTypeProjection = type2.getArguments().get(0);
            Variance variance = componentTypeProjection.getProjectionKind();
            KotlinType kotlinType = componentTypeProjection.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "componentTypeProjection.type");
            List<TypeProjectionImpl> arguments2 = CollectionsKt.listOf(new TypeProjectionImpl(variance, this.eraseType(kotlinType)));
            return TuplesKt.to(KotlinTypeFactory.simpleType$default(type2.getAnnotations(), type2.getConstructor(), arguments2, type2.isMarkedNullable(), null, 16, null), false);
        }
        if (KotlinTypeKt.isError(type2)) {
            SimpleType componentTypeProjection = ErrorUtils.createErrorType(Intrinsics.stringPlus("Raw error type: ", type2.getConstructor()));
            Intrinsics.checkNotNullExpressionValue(componentTypeProjection, "createErrorType(\"Raw error type: ${type.constructor}\")");
            return TuplesKt.to(componentTypeProjection, false);
        }
        Iterable<TypeParameterDescriptor> arguments2 = declaration.getMemberScope(this);
        Intrinsics.checkNotNullExpressionValue(arguments2, "declaration.getMemberScope(RawSubstitution)");
        MemberScope memberScope2 = arguments2;
        Annotations annotations2 = type2.getAnnotations();
        arguments2 = declaration.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(arguments2, "declaration.typeConstructor");
        List<TypeParameterDescriptor> list = arguments2;
        arguments2 = declaration.getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(arguments2, "declaration.typeConstructor.parameters");
        arguments2 = arguments2;
        List<TypeParameterDescriptor> list2 = list;
        Annotations annotations3 = annotations2;
        boolean $i$f$map = false;
        void var7_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void parameter;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(parameter, "parameter");
            TypeProjection typeProjection = RawSubstitution.computeProjection$default(this, (TypeParameterDescriptor)parameter, attr, null, 4, null);
            collection.add(typeProjection);
        }
        collection = (List)destination$iv$iv;
        return TuplesKt.to(KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(annotations3, list2, (List<? extends TypeProjection>)collection, type2.isMarkedNullable(), memberScope2, (Function1<? super KotlinTypeRefiner, ? extends SimpleType>)new Function1<KotlinTypeRefiner, SimpleType>(declaration, this, type2, attr){
            final /* synthetic */ ClassDescriptor $declaration;
            final /* synthetic */ RawSubstitution this$0;
            final /* synthetic */ SimpleType $type;
            final /* synthetic */ JavaTypeAttributes $attr;
            {
                this.$declaration = $declaration;
                this.this$0 = $receiver;
                this.$type = $type;
                this.$attr = $attr;
                super(1);
            }

            @Nullable
            public final SimpleType invoke(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
                ClassId classId;
                Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
                ClassDescriptor classDescriptor = this.$declaration;
                ClassDescriptor classDescriptor2 = classDescriptor instanceof ClassDescriptor ? classDescriptor : null;
                ClassId classId2 = classId = classDescriptor2 == null ? null : DescriptorUtilsKt.getClassId(classDescriptor2);
                if (classId == null) {
                    return null;
                }
                ClassId classId3 = classId;
                classDescriptor2 = kotlinTypeRefiner.findClassAcrossModuleDependencies(classId3);
                if (classDescriptor2 == null) {
                    return null;
                }
                ClassDescriptor refinedClassDescriptor = classDescriptor2;
                if (Intrinsics.areEqual(refinedClassDescriptor, this.$declaration)) {
                    return null;
                }
                return (SimpleType)RawSubstitution.access$eraseInflexibleBasedOnClassDescriptor(this.this$0, this.$type, refinedClassDescriptor, this.$attr).getFirst();
            }
        }), true);
    }

    @NotNull
    public final TypeProjection computeProjection(@NotNull TypeParameterDescriptor parameter, @NotNull JavaTypeAttributes attr, @NotNull KotlinType erasedUpperBound2) {
        TypeProjection typeProjection;
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(attr, "attr");
        Intrinsics.checkNotNullParameter(erasedUpperBound2, "erasedUpperBound");
        JavaTypeFlexibility javaTypeFlexibility = attr.getFlexibility();
        int n = WhenMappings.$EnumSwitchMapping$0[javaTypeFlexibility.ordinal()];
        switch (n) {
            case 1: {
                typeProjection = new TypeProjectionImpl(Variance.INVARIANT, erasedUpperBound2);
                break;
            }
            case 2: 
            case 3: {
                if (!parameter.getVariance().getAllowsOutPosition()) {
                    typeProjection = new TypeProjectionImpl(Variance.INVARIANT, DescriptorUtilsKt.getBuiltIns(parameter).getNothingType());
                    break;
                }
                Collection<TypeParameterDescriptor> collection = erasedUpperBound2.getConstructor().getParameters();
                Intrinsics.checkNotNullExpressionValue(collection, "erasedUpperBound.constructor.parameters");
                collection = collection;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    typeProjection = new TypeProjectionImpl(Variance.OUT_VARIANCE, erasedUpperBound2);
                    break;
                }
                typeProjection = JavaTypeResolverKt.makeStarProjection(parameter, attr);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return typeProjection;
    }

    public static /* synthetic */ TypeProjection computeProjection$default(RawSubstitution rawSubstitution, TypeParameterDescriptor typeParameterDescriptor, JavaTypeAttributes javaTypeAttributes, KotlinType kotlinType, int n, Object object) {
        if ((n & 4) != 0) {
            kotlinType = JavaTypeResolverKt.getErasedUpperBound$default(typeParameterDescriptor, null, null, 3, null);
        }
        return rawSubstitution.computeProjection(typeParameterDescriptor, javaTypeAttributes, kotlinType);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public static final /* synthetic */ Pair access$eraseInflexibleBasedOnClassDescriptor(RawSubstitution $this, SimpleType type2, ClassDescriptor declaration, JavaTypeAttributes attr) {
        return $this.eraseInflexibleBasedOnClassDescriptor(type2, declaration, attr);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JavaTypeFlexibility.values().length];
            nArray[JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND.ordinal()] = 1;
            nArray[JavaTypeFlexibility.FLEXIBLE_UPPER_BOUND.ordinal()] = 2;
            nArray[JavaTypeFlexibility.INFLEXIBLE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

