/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.islandoftex.arara.Arara;
import org.islandoftex.arara.configuration.AraraSpec;
import org.islandoftex.arara.filehandling.FileHandlingUtils;
import org.islandoftex.arara.localization.Language;
import org.islandoftex.arara.localization.LanguageController;
import org.islandoftex.arara.localization.Messages;
import org.islandoftex.arara.model.AraraException;
import org.islandoftex.arara.ruleset.Argument;
import org.islandoftex.arara.utils.CommonUtils;
import org.islandoftex.arara.utils.InterpreterUtils;
import org.islandoftex.arara.utils.SystemCallUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005J\u0016\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005J\u0016\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005J\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u0004J\u001f\u0010%\u001a\u00020\u00052\u0012\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010'\"\u00020\u0001\u00a2\u0006\u0002\u0010(J\u0016\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0005J\u0010\u0010,\u001a\u0004\u0018\u00010\u00052\u0006\u0010*\u001a\u00020\u0005J.\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001002\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u0004J\u000e\u00103\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0005J\u0012\u00104\u001a\u0004\u0018\u00010\u00052\b\u00105\u001a\u0004\u0018\u00010\u0005J\u000e\u00106\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u0005J\"\u00107\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u00108\u001a\u00020\u00052\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0011\u0010\u0013\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006:"}, d2={"Lorg/islandoftex/arara/utils/CommonUtils;", "", "()V", "allRulePaths", "", "", "getAllRulePaths", "()Ljava/util/List;", "exitStatus", "", "getExitStatus", "()I", "fileTypesList", "getFileTypesList", "()Ljava/lang/String;", "messages", "Lorg/islandoftex/arara/localization/LanguageController;", "preambleContent", "getPreambleContent", "ruleErrorHeader", "getRuleErrorHeader", "appendExtensions", "command", "byteSizeToString", "size", "", "checkBoolean", "", "value", "checkOS", "checkRegex", "file", "Ljava/io/File;", "regex", "extension", "flatten", "list", "generateString", "objects", "", "([Ljava/lang/Object;)Ljava/lang/String;", "getSystemProperty", "key", "fallback", "getSystemPropertyOrNull", "getUnknownKeys", "", "parameters", "", "arguments", "Lorg/islandoftex/arara/ruleset/Argument;", "isOnPath", "removeKeyword", "line", "removeKeywordNotNull", "replicateList", "pattern", "values", "application"})
public final class CommonUtils {
    private static final LanguageController messages;
    public static final CommonUtils INSTANCE;

    @NotNull
    public final String getFileTypesList() {
        return "[ " + CollectionsKt.joinToString$default((Iterable)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getFileTypes()), " | ", null, null, 0, null, null, 62, null) + " ]";
    }

    @NotNull
    public final String getRuleErrorHeader() {
        String string;
        if (Arara.INSTANCE.getConfig().get(AraraSpec.Execution.InfoSpec.INSTANCE.getRuleId()) != null && Arara.INSTANCE.getConfig().get(AraraSpec.Execution.InfoSpec.INSTANCE.getRulePath()) != null) {
            Object t = Arara.INSTANCE.getConfig().get(AraraSpec.Execution.InfoSpec.INSTANCE.getRuleId());
            if (t == null) {
                Intrinsics.throwNpe();
            }
            String id = (String)t;
            Object t2 = Arara.INSTANCE.getConfig().get(AraraSpec.Execution.InfoSpec.INSTANCE.getRulePath());
            if (t2 == null) {
                Intrinsics.throwNpe();
            }
            String path = (String)t2;
            string = messages.getMessage((Enum)Messages.ERROR_RULE_IDENTIFIER_AND_PATH, id, path) + " ";
        } else {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAllRulePaths() throws AraraException {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getRulePaths());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File location = new File(InterpreterUtils.INSTANCE.construct((String)it, "quack"));
            String string2 = FileHandlingUtils.INSTANCE.getParentCanonicalPath(location);
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    public final int getExitStatus() {
        return ((Number)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getStatus())).intValue();
    }

    @NotNull
    public final List<String> getPreambleContent() {
        List<String> list2;
        if (((Boolean)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getPreamblesActive())).booleanValue()) {
            List list3;
            List $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getPreamblesContent()), new String[]{"\n"}, false, 0, 6, null);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    CharSequence charSequence = it;
                    boolean bl2 = false;
                    if (charSequence.length() == 0) continue;
                    list3 = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list3 = CollectionsKt.emptyList();
            }
            list2 = CollectionsKt.toList(list3);
        } else {
            boolean bl = false;
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public final boolean checkBoolean(@NotNull String value2) throws AraraException {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        List<String> yes = CollectionsKt.listOf("yes", "true", "1", "on");
        List<String> no = CollectionsKt.listOf("no", "false", "0", "off");
        String string = value2;
        Collection<Object> collection = CollectionsKt.union((Iterable)yes, (Iterable)no);
        boolean bl = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull(string2, "(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        if (!collection.contains(string3)) {
            throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_CHECKBOOLEAN_NOT_VALID_BOOLEAN, value2));
        }
        string = value2;
        collection = yes;
        bl = false;
        String string4 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.String).toLowerCase()");
        string3 = string4;
        return collection.contains(string3);
    }

    @Nullable
    public final String removeKeyword(@Nullable String line) {
        return line == null ? null : this.removeKeywordNotNull(line);
    }

    @NotNull
    public final String removeKeywordNotNull(@NotNull String line) {
        Intrinsics.checkParameterIsNotNull(line, "line");
        String tempLine = line;
        String string = "^(\\s)*<arara>\\s";
        int n = 0;
        int n2 = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkExpressionValueIsNotNull(pattern, "java.util.regex.Pattern.compile(this, flags)");
        Pattern pattern2 = pattern;
        Matcher matcher = pattern2.matcher(tempLine);
        if (matcher.find()) {
            String string2 = tempLine;
            n2 = matcher.end();
            boolean bl = false;
            String string3 = string2.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull(string3, "(this as java.lang.String).substring(startIndex)");
            tempLine = string3;
        }
        String string4 = tempLine;
        n2 = 0;
        String string5 = string4;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string5)).toString();
    }

    @NotNull
    public final List<Object> flatten(@NotNull List<?> list2) {
        Intrinsics.checkParameterIsNotNull(list2, "list");
        boolean bl = false;
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object item2 = element$iv = iterator2.next();
            boolean bl2 = false;
            if (item2 instanceof List) {
                result2.addAll((Collection)INSTANCE.flatten((List)item2));
                continue;
            }
            Object t = item2;
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Any");
            }
            result2.add(t);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getUnknownKeys(@NotNull Map<String, ? extends Object> parameters2, @NotNull List<Argument> arguments2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Set<String> found = parameters2.keySet();
        Iterable $this$mapNotNull$iv = arguments2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Argument it = (Argument)element$iv$iv;
            boolean bl2 = false;
            if (it.getIdentifier() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List expected = (List)destination$iv$iv;
        return CollectionsKt.subtract((Iterable)found, expected);
    }

    @NotNull
    public final String byteSizeToString(long size) {
        String string;
        Language language = (Language)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getLanguage());
        double conversionFactor = 1000.0;
        if ((double)size < conversionFactor) {
            string = size + " B";
        } else {
            Object[] objectArray;
            double d = size;
            boolean bl = false;
            double d2 = Math.log(d);
            int n = 0;
            double d3 = Math.log(conversionFactor);
            n = (int)(d2 / d3);
            boolean bl2 = false;
            bl = false;
            int exp = n;
            boolean bl3 = false;
            String string2 = "%.1f %sB";
            Locale locale = language.getLocale();
            double d4 = conversionFactor;
            double d5 = exp;
            double d6 = size;
            int n2 = 0;
            Object[] objectArray2 = objectArray = new Object[2];
            boolean bl4 = false;
            double d7 = Math.pow(d4, d5);
            objectArray[n2] = d6 / d7;
            objectArray2[1] = Character.valueOf("kMGTPE".charAt(exp - 1));
            Object[] objectArray3 = objectArray2;
            boolean bl5 = false;
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray3, objectArray3.length));
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(locale, this, *args)");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generateString(Object ... objects) {
        void $this$filterTo$iv$iv;
        CharSequence charSequence;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(objects, "objects");
        Object[] $this$map$iv = objects;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            charSequence = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            collection.add(string);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            charSequence = it;
            boolean bl2 = false;
            if (!(charSequence.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, null, 62, null);
    }

    public final boolean checkRegex(@NotNull String extension, @NotNull String regex) throws AraraException {
        Intrinsics.checkParameterIsNotNull(extension, "extension");
        Intrinsics.checkParameterIsNotNull(regex, "regex");
        File file2 = new File(FileHandlingUtils.INSTANCE.getPath(extension));
        return this.checkRegex(file2, regex);
    }

    public final boolean checkRegex(@NotNull File file2, @NotNull String regex) throws AraraException {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        Intrinsics.checkParameterIsNotNull(regex, "regex");
        try {
            String text2 = FilesKt.readText$default(file2, null, 1, null);
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(text2);
            return matcher.find();
        }
        catch (IOException exception) {
            Enum enum_ = Messages.ERROR_CHECKREGEX_IO_EXCEPTION;
            Object[] objectArray = new Object[1];
            String string = file2.getName();
            Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
            objectArray[0] = string;
            throw (Throwable)new AraraException(messages.getMessage(enum_, objectArray), exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Object> replicateList(@NotNull String pattern, @NotNull List<? extends Object> values2) throws AraraException {
        List list2;
        Intrinsics.checkParameterIsNotNull(pattern, "pattern");
        Intrinsics.checkParameterIsNotNull(values2, "values");
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = values2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String string;
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = pattern;
                Object[] objectArray = new Object[]{it};
                boolean bl2 = false;
                Intrinsics.checkExpressionValueIsNotNull(String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), "java.lang.String.format(format, *args)");
                collection.add(string);
            }
            list2 = (List)destination$iv$iv;
        }
        catch (MissingFormatArgumentException exception) {
            throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_REPLICATELIST_MISSING_FORMAT_ARGUMENTS_EXCEPTION), exception);
        }
        return list2;
    }

    public final boolean checkOS(@NotNull String value2) throws AraraException {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        checkOS.1 $fun$checkOSProperty$1 = checkOS.1.INSTANCE;
        boolean bl = false;
        Map values2 = new LinkedHashMap();
        values2.put("windows", $fun$checkOSProperty$1.invoke("Windows"));
        values2.put("linux", $fun$checkOSProperty$1.invoke("Linux"));
        values2.put("mac", $fun$checkOSProperty$1.invoke("Mac OS X"));
        values2.put("unix", $fun$checkOSProperty$1.invoke("Mac OS X") || $fun$checkOSProperty$1.invoke("Linux"));
        Object object = SystemCallUtils.INSTANCE.get("cygwin");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        values2.put("cygwin", (Boolean)object);
        String string = value2;
        Map map2 = values2;
        boolean bl2 = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull(string2, "(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        if (!map2.containsKey(string3)) {
            throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_CHECKOS_INVALID_OPERATING_SYSTEM, value2));
        }
        string = value2;
        map2 = values2;
        bl2 = false;
        String string4 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.String).toLowerCase()");
        string3 = string4;
        return (Boolean)MapsKt.getValue(map2, string3);
    }

    @NotNull
    public final String getSystemProperty(@NotNull String key, @NotNull String fallback) {
        Object object;
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(fallback, "fallback");
        Object object2 = System.getProperties();
        boolean bl = false;
        try {
            object = Result.Companion;
            Properties $this$runCatching = object2;
            boolean bl2 = false;
            String string = $this$runCatching.getOrDefault((Object)key, fallback).toString();
            boolean bl3 = false;
            boolean bl4 = false;
            String it = string;
            boolean bl5 = false;
            String string2 = Intrinsics.areEqual(it, "") ^ true ? string : null;
            boolean bl6 = false;
            object = Result.constructor-impl(string2);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl7 = false;
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        object2 = object;
        bl = false;
        String string = (String)(Result.isFailure-impl(object2) ? null : object2);
        if (string == null) {
            string = fallback;
        }
        return string;
    }

    @Nullable
    public final String getSystemPropertyOrNull(@NotNull String key) {
        Object object;
        Intrinsics.checkParameterIsNotNull(key, "key");
        Object object2 = System.getProperties();
        boolean bl = false;
        try {
            object = Result.Companion;
            Properties $this$runCatching = object2;
            boolean bl2 = false;
            String string = MapsKt.getValue($this$runCatching, key).toString();
            boolean bl3 = false;
            object = Result.constructor-impl(string);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        object2 = object;
        bl = false;
        return (String)(Result.isFailure-impl(object2) ? null : object2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> appendExtensions(String command) {
        void $this$mapTo$iv$iv;
        List<String> extensions = this.checkOS("windows") ? CollectionsKt.listOf(".com", ".exe", ".bat", ".cmd") : CollectionsKt.listOf("");
        Iterable $this$map$iv = extensions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = command + (String)it;
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isOnPath(@NotNull String command) {
        Object object;
        Intrinsics.checkParameterIsNotNull(command, "command");
        List<String> filenames = this.appendExtensions(command);
        boolean bl = false;
        try {
            Boolean bl2;
            Object v6;
            block7: {
                object = Result.Companion;
                boolean bl3 = false;
                String string = System.getenv("PATH");
                Intrinsics.checkExpressionValueIsNotNull(string, "System.getenv(\"PATH\")");
                CharSequence charSequence = string;
                String[] stringArray = new String[1];
                String string2 = File.pathSeparator;
                Intrinsics.checkExpressionValueIsNotNull(string2, "File.pathSeparator");
                stringArray[0] = string2;
                Sequence $this$firstOrNull$iv = SequencesKt.mapNotNull(CollectionsKt.asSequence(StringsKt.split$default(charSequence, stringArray, false, 0, 6, null)), isOnPath.1.1.INSTANCE);
                boolean $i$f$firstOrNull = false;
                Iterator iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    boolean bl4;
                    Object element$iv;
                    block6: {
                        element$iv = iterator2.next();
                        File[] it = (File[])element$iv;
                        boolean bl5 = false;
                        File[] $this$any$iv = it;
                        boolean $i$f$any = false;
                        File[] fileArray = $this$any$iv;
                        int n = fileArray.length;
                        for (int i = 0; i < n; ++i) {
                            File element$iv2;
                            File file2 = element$iv2 = fileArray[i];
                            boolean bl6 = false;
                            File file3 = file2;
                            Intrinsics.checkExpressionValueIsNotNull(file3, "file");
                            if (!(filenames.contains(file3.getName()) && !file2.isDirectory())) continue;
                            bl4 = true;
                            break block6;
                        }
                        bl4 = false;
                    }
                    if (!bl4) continue;
                    v6 = element$iv;
                    break block7;
                }
                v6 = null;
            }
            File[] fileArray = v6;
            if (fileArray != null) {
                File[] fileArray2 = fileArray;
                boolean bl7 = false;
                boolean bl8 = false;
                File[] it = fileArray2;
                boolean bl9 = false;
                bl2 = true;
            } else {
                bl2 = null;
            }
            Boolean bl10 = bl2;
            boolean bl11 = false;
            object = Result.constructor-impl(bl10);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl12 = false;
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        Object object2 = object;
        boolean bl13 = false;
        Boolean bl14 = (Boolean)(Result.isFailure-impl(object2) ? null : object2);
        return bl14 != null ? bl14 : false;
    }

    private CommonUtils() {
    }

    static {
        CommonUtils commonUtils;
        INSTANCE = commonUtils = new CommonUtils();
        messages = LanguageController.INSTANCE;
    }
}

