/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.clikt.output;

import com.github.ajalt.clikt.mpp.MppImplKt;
import com.github.ajalt.clikt.output.TermUi;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\u001c\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0000\u00a8\u0006\t"}, d2={"getWhichCommand", "", "inferEditorPath", "commandExists", "Lkotlin/Function1;", "", "normalizeEditorText", "editor", "text", "clikt"})
public final class EditorKt {
    @NotNull
    public static final String inferEditorPath(@NotNull Function1<? super String, Boolean> commandExists) {
        String[] editors;
        String[] stringArray;
        Intrinsics.checkParameterIsNotNull(commandExists, "commandExists");
        for (String key : new String[]{"VISUAL", "EDITOR"}) {
            String string = MppImplKt.readEnvvar(key);
            if (string == null) {
                continue;
            }
            return string;
        }
        if (TermUi.INSTANCE.isWindows()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "vim";
            stringArray2[1] = "nano";
            stringArray = stringArray2;
            stringArray2[2] = "notepad";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "vim";
            stringArray = stringArray3;
            stringArray3[1] = "nano";
        }
        for (String editor : editors = stringArray) {
            if (!commandExists.invoke(editor).booleanValue()) continue;
            return editor;
        }
        return TermUi.INSTANCE.isWindows() ? "notepad" : "vi";
    }

    @NotNull
    public static final String normalizeEditorText(@NotNull String editor, @NotNull String text2) {
        String string;
        Intrinsics.checkParameterIsNotNull(editor, "editor");
        Intrinsics.checkParameterIsNotNull(text2, "text");
        String string2 = editor;
        switch (string2.hashCode()) {
            case 2129240929: {
                if (string2.equals("notepad")) {
                    CharSequence charSequence = text2;
                    Regex regex = new Regex("(?<!\r)\n");
                    String string3 = "\r\n";
                    boolean bl = false;
                    string = regex.replace(charSequence, string3);
                    break;
                }
            }
            default: {
                string = StringsKt.replace$default(text2, "\r\n", "\n", false, 4, null);
            }
        }
        return string;
    }

    @NotNull
    public static final String getWhichCommand() {
        return MppImplKt.isWindowsMpp() ? "where" : "which";
    }
}

