/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import org.islandoftex.arara.Arara;
import org.islandoftex.arara.configuration.AraraSpec;
import org.islandoftex.arara.localization.LanguageController;
import org.islandoftex.arara.localization.Messages;
import org.islandoftex.arara.model.AraraException;
import org.islandoftex.arara.ruleset.Command;
import org.islandoftex.arara.ruleset.Conditional;
import org.islandoftex.arara.utils.DisplayUtils;
import org.islandoftex.arara.utils.InterpreterUtils$WhenMappings;
import org.islandoftex.arara.utils.TeeOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.listener.ShutdownHookProcessDestroyer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/islandoftex/arara/utils/InterpreterUtils;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "messages", "Lorg/islandoftex/arara/localization/LanguageController;", "buildRulePath", "Ljava/io/File;", "name", "", "construct", "path", "getProcessExecutorForCommand", "Lorg/zeroturnaround/exec/ProcessExecutor;", "command", "Lorg/islandoftex/arara/ruleset/Command;", "buffer", "Ljava/io/OutputStream;", "run", "", "runPriorEvaluation", "", "conditional", "Lorg/islandoftex/arara/ruleset/Conditional;", "application"})
public final class InterpreterUtils {
    private static final LanguageController messages;
    private static final Logger logger;
    public static final InterpreterUtils INSTANCE;

    public final boolean runPriorEvaluation(@NotNull Conditional conditional) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(conditional, "conditional");
        if (((Boolean)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getDryrun())).booleanValue()) {
            bl = false;
        } else {
            switch (InterpreterUtils$WhenMappings.$EnumSwitchMapping$0[conditional.getType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    @ExperimentalTime
    private final ProcessExecutor getProcessExecutorForCommand(Command command, OutputStream buffer) {
        TeeOutputStream teeOutputStream;
        double timeOutValue = ((Duration)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getTimeoutValue())).unbox-impl();
        ProcessExecutor executor2 = new ProcessExecutor().command(command.getElements()).directory(command.getWorkingDirectory().getAbsoluteFile()).addDestroyer(new ShutdownHookProcessDestroyer());
        if (((Boolean)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getTimeout())).booleanValue()) {
            if (Intrinsics.areEqual(Duration.box-impl(timeOutValue), Duration.box-impl(Duration.Companion.getZERO()))) {
                throw (Throwable)new AraraException(messages.getMessage((Enum)Messages.ERROR_RUN_TIMEOUT_INVALID_RANGE));
            }
            executor2 = executor2.timeout(Duration.toLongNanoseconds-impl(timeOutValue), TimeUnit.NANOSECONDS);
        }
        if (((Boolean)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getVerbose())).booleanValue()) {
            executor2 = executor2.redirectInput(System.in);
            OutputStream[] outputStreamArray = new OutputStream[2];
            PrintStream printStream = System.out;
            Intrinsics.checkExpressionValueIsNotNull(printStream, "System.out");
            outputStreamArray[0] = printStream;
            outputStreamArray[1] = buffer;
            teeOutputStream = new TeeOutputStream(outputStreamArray);
        } else {
            teeOutputStream = new TeeOutputStream(buffer);
        }
        TeeOutputStream tee = teeOutputStream;
        ProcessExecutor processExecutor = executor2 = executor2.redirectOutput(tee).redirectError(tee);
        Intrinsics.checkExpressionValueIsNotNull(processExecutor, "executor");
        return processExecutor;
    }

    @ExperimentalTime
    public final int run(@NotNull Command command) throws AraraException {
        Object object;
        Intrinsics.checkParameterIsNotNull(command, "command");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ProcessExecutor executor2 = this.getProcessExecutorForCommand(command, buffer);
        Object object2 = executor2;
        boolean bl = false;
        try {
            object = Result.Companion;
            Object $this$runCatching = object2;
            boolean bl2 = false;
            ProcessResult processResult = ((ProcessExecutor)$this$runCatching).execute();
            Intrinsics.checkExpressionValueIsNotNull(processResult, "execute()");
            int exit = processResult.getExitValue();
            logger.info(DisplayUtils.INSTANCE.displayOutputSeparator(messages.getMessage((Enum)Messages.LOG_INFO_BEGIN_BUFFER)));
            logger.info(buffer.toString());
            logger.info(DisplayUtils.INSTANCE.displayOutputSeparator(messages.getMessage((Enum)Messages.LOG_INFO_END_BUFFER)));
            $this$runCatching = exit;
            bl2 = false;
            object = Result.constructor-impl($this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl(ResultKt.createFailure($this$runCatching));
        }
        object2 = object;
        bl = false;
        boolean bl4 = false;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl5 = false;
            Throwable throwable2 = it;
            throw (Throwable)new AraraException(messages.getMessage((Enum)(throwable2 instanceof IOException ? Messages.ERROR_RUN_IO_EXCEPTION : (throwable2 instanceof InterruptedException ? Messages.ERROR_RUN_INTERRUPTED_EXCEPTION : (throwable2 instanceof InvalidExitValueException ? Messages.ERROR_RUN_INVALID_EXIT_VALUE_EXCEPTION : (throwable2 instanceof TimeoutException ? Messages.ERROR_RUN_TIMEOUT_EXCEPTION : Messages.ERROR_RUN_GENERIC_EXCEPTION))))), it);
        }
        return ((Number)object2).intValue();
    }

    @Nullable
    public final File buildRulePath(@NotNull String name) throws AraraException {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Iterable $this$forEach$iv = (Iterable)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getRulePaths());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String path = (String)element$iv;
            boolean bl = false;
            File location = new File(INSTANCE.construct(path, name));
            if (!location.exists()) continue;
            return location;
        }
        return null;
    }

    @NotNull
    public final String construct(@NotNull String path, @NotNull String name) throws AraraException {
        String string;
        Intrinsics.checkParameterIsNotNull(path, "path");
        Intrinsics.checkParameterIsNotNull(name, "name");
        String fileName = name + ".yaml";
        File location = new File(path);
        if (location.isAbsolute()) {
            String string2 = FilesKt.resolve(location, fileName).toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "location.resolve(fileName).toString()");
        } else {
            string = ((Object)((Path)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getWorkingDirectory())).resolve(path).resolve(fileName).toAbsolutePath()).toString();
        }
        return string;
    }

    private InterpreterUtils() {
    }

    static {
        InterpreterUtils interpreterUtils;
        INSTANCE = interpreterUtils = new InterpreterUtils();
        messages = LanguageController.INSTANCE;
        logger = LoggerFactory.getLogger(InterpreterUtils.class);
    }
}

