/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.CompositeDecoder;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ElementValueDecoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.ShorthandsKt;
import kotlinx.serialization.UpdateMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonInput;
import kotlinx.serialization.json.internal.JsonParser;
import kotlinx.serialization.json.internal.JsonReader;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonInput$WhenMappings;
import kotlinx.serialization.json.internal.StringOpsKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerialModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ1\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u001a\u0010\u001e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030 0\u001f\"\u0006\u0012\u0002\b\u00030 H\u0016\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u001dH\u0016J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u0011H\u0016J\b\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020%H\u0002J\b\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u00112\u0006\u00103\u001a\u00020%H\u0002J\b\u00107\u001a\u00020#H\u0016J\n\u00108\u001a\u0004\u0018\u000109H\u0016J\u0018\u0010:\u001a\u00020\u00112\u0006\u00103\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J!\u0010;\u001a\u0002H<\"\u0004\b\u0000\u0010<2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H<0>H\u0016\u00a2\u0006\u0002\u0010?J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020E2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006F"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonInput;", "Lkotlinx/serialization/json/JsonInput;", "Lkotlinx/serialization/ElementValueDecoder;", "json", "Lkotlinx/serialization/json/Json;", "mode", "Lkotlinx/serialization/json/internal/WriteMode;", "reader", "Lkotlinx/serialization/json/internal/JsonReader;", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;Lkotlinx/serialization/json/internal/JsonReader;)V", "configuration", "Lkotlinx/serialization/json/JsonConfiguration;", "context", "Lkotlinx/serialization/modules/SerialModule;", "getContext", "()Lkotlinx/serialization/modules/SerialModule;", "currentIndex", "", "getJson", "()Lkotlinx/serialization/json/Json;", "updateMode", "Lkotlinx/serialization/UpdateMode;", "updateMode$annotations", "()V", "getUpdateMode", "()Lkotlinx/serialization/UpdateMode;", "beginStructure", "Lkotlinx/serialization/CompositeDecoder;", "desc", "Lkotlinx/serialization/SerialDescriptor;", "typeParams", "", "Lkotlinx/serialization/KSerializer;", "(Lkotlinx/serialization/SerialDescriptor;[Lkotlinx/serialization/KSerializer;)Lkotlinx/serialization/CompositeDecoder;", "decodeBoolean", "", "decodeByte", "", "decodeChar", "", "decodeDouble", "", "decodeElementIndex", "decodeEnum", "enumDescription", "decodeFloat", "", "decodeInt", "decodeJson", "Lkotlinx/serialization/json/JsonElement;", "decodeListIndex", "tokenClass", "decodeLong", "", "decodeMapIndex", "decodeNotNullMark", "decodeNull", "", "decodeObjectIndex", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "decodeShort", "", "decodeString", "", "endStructure", "", "kotlinx-serialization-runtime"})
public final class StreamingJsonInput
extends ElementValueDecoder
implements JsonInput {
    @NotNull
    private final SerialModule context;
    private int currentIndex;
    private final JsonConfiguration configuration;
    @NotNull
    private final Json json;
    private final WriteMode mode;
    @JvmField
    @NotNull
    public final JsonReader reader;

    @Override
    @NotNull
    public SerialModule getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public JsonElement decodeJson() {
        return new JsonParser(this.reader).read();
    }

    public static /* synthetic */ void updateMode$annotations() {
    }

    @Override
    @NotNull
    public UpdateMode getUpdateMode() {
        return this.configuration.updateMode;
    }

    @Override
    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<T> deserializer) {
        Intrinsics.checkParameterIsNotNull(deserializer, "deserializer");
        return PolymorphicKt.decodeSerializableValuePolymorphic(this, deserializer);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor desc, KSerializer<?> ... typeParams) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkParameterIsNotNull(desc, "desc");
        Intrinsics.checkParameterIsNotNull(typeParams, "typeParams");
        WriteMode newMode = WriteModeKt.switchMode(this.getJson(), desc);
        if (newMode.begin != '\u0000') {
            void this_$iv;
            JsonReader jsonReader = this.reader;
            byte expected$iv = newMode.beginTc;
            boolean $i$f$requireTokenClass$kotlinx_serialization_runtime = false;
            if (this_$iv.tokenClass != expected$iv) {
                char c = (char)this_$iv.tokenClass;
                void var9_8 = this_$iv;
                boolean bl = false;
                String string = "Expected '" + newMode.begin + ", kind: " + desc.getKind() + '\'';
                Void void_ = var9_8.fail(string, JsonReader.access$getTokenPosition$p((JsonReader)this_$iv));
                throw null;
            }
            this.reader.nextToken();
        }
        switch (StreamingJsonInput$WhenMappings.$EnumSwitchMapping$0[newMode.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                compositeDecoder = new StreamingJsonInput(this.getJson(), newMode, this.reader);
                break;
            }
            default: {
                compositeDecoder = this.mode == newMode ? this : new StreamingJsonInput(this.getJson(), newMode, this.reader);
            }
        }
        return compositeDecoder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void endStructure(@NotNull SerialDescriptor desc) {
        Intrinsics.checkParameterIsNotNull(desc, "desc");
        if (this.mode.end != '\u0000') {
            void this_$iv;
            JsonReader jsonReader = this.reader;
            byte expected$iv = this.mode.endTc;
            boolean $i$f$requireTokenClass$kotlinx_serialization_runtime = false;
            if (this_$iv.tokenClass != expected$iv) {
                char c = (char)this_$iv.tokenClass;
                void var7_6 = this_$iv;
                boolean bl = false;
                String string = "Expected '" + this.mode.end + '\'';
                Void void_ = var7_6.fail(string, JsonReader.access$getTokenPosition$p((JsonReader)this_$iv));
                throw null;
            }
            this.reader.nextToken();
        }
    }

    @Override
    public boolean decodeNotNullMark() {
        return this.reader.tokenClass != 10;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Void decodeNull() {
        void this_$iv;
        JsonReader jsonReader = this.reader;
        byte expected$iv = 10;
        boolean $i$f$requireTokenClass$kotlinx_serialization_runtime = false;
        if (this_$iv.tokenClass != expected$iv) {
            char c = (char)this_$iv.tokenClass;
            void var6_5 = this_$iv;
            boolean bl = false;
            String string = "Expected 'null' literal";
            Void void_ = var6_5.fail(string, JsonReader.access$getTokenPosition$p((JsonReader)this_$iv));
            throw null;
        }
        this.reader.nextToken();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor desc) {
        int n;
        Intrinsics.checkParameterIsNotNull(desc, "desc");
        byte tokenClass = this.reader.tokenClass;
        if (tokenClass == 4) {
            void condition$iv;
            JsonReader jsonReader = this.reader;
            boolean bl = this.currentIndex != -1;
            int position$iv = this.reader.currentPosition;
            boolean $i$f$require$kotlinx_serialization_runtime = false;
            if (condition$iv == false) {
                void this_$iv;
                void var8_7 = this_$iv;
                boolean bl2 = false;
                String string = "Unexpected leading comma";
                Void void_ = var8_7.fail(string, position$iv);
                throw null;
            }
            this.reader.nextToken();
        }
        block0 : switch (StreamingJsonInput$WhenMappings.$EnumSwitchMapping$1[this.mode.ordinal()]) {
            case 1: {
                n = this.decodeListIndex(tokenClass);
                break;
            }
            case 2: {
                n = this.decodeMapIndex(tokenClass);
                break;
            }
            case 3: {
                StreamingJsonInput streamingJsonInput = this;
                ++streamingJsonInput.currentIndex;
                switch (streamingJsonInput.currentIndex) {
                    case 0: {
                        n = 0;
                        break block0;
                    }
                    case 1: {
                        n = 1;
                        break block0;
                    }
                }
                n = -1;
                break;
            }
            default: {
                n = this.decodeObjectIndex(tokenClass, desc);
            }
        }
        return n;
    }

    private final int decodeMapIndex(byte tokenClass) {
        int n;
        JsonReader this_$iv;
        boolean $i$f$requireTokenClass$kotlinx_serialization_runtime;
        byte expected$iv;
        if (tokenClass != 4 && this.currentIndex % 2 == 1) {
            JsonReader jsonReader = this.reader;
            expected$iv = 7;
            $i$f$requireTokenClass$kotlinx_serialization_runtime = false;
            if (this_$iv.tokenClass != expected$iv) {
                char c = (char)this_$iv.tokenClass;
                JsonReader jsonReader2 = this_$iv;
                boolean bl = false;
                String string = "Expected end of the object or comma";
                Void void_ = jsonReader2.fail(string, JsonReader.access$getTokenPosition$p(this_$iv));
                throw null;
            }
        }
        if (this.currentIndex % 2 == 0) {
            this_$iv = this.reader;
            expected$iv = 5;
            $i$f$requireTokenClass$kotlinx_serialization_runtime = false;
            if (this_$iv.tokenClass != expected$iv) {
                char it = (char)this_$iv.tokenClass;
                JsonReader jsonReader = this_$iv;
                boolean bl = false;
                String string = "Expected ':' after the key";
                Void void_ = jsonReader.fail(string, JsonReader.access$getTokenPosition$p(this_$iv));
                throw null;
            }
            this.reader.nextToken();
        }
        if (!this.reader.getCanBeginValue()) {
            this_$iv = this.reader;
            boolean condition$iv = tokenClass != 4;
            int position$iv = this_$iv.currentPosition;
            boolean $i$f$require$kotlinx_serialization_runtime = false;
            if (!condition$iv) {
                JsonReader jsonReader = this_$iv;
                boolean bl = false;
                String string = "Unexpected trailing comma";
                Void void_ = jsonReader.fail(string, position$iv);
                throw null;
            }
            n = -1;
        } else {
            StreamingJsonInput streamingJsonInput = this;
            n = ++streamingJsonInput.currentIndex;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final int decodeObjectIndex(byte tokenClass, SerialDescriptor desc) {
        if (tokenClass == 4 && !this.reader.getCanBeginValue()) {
            Void void_ = JsonReader.fail$default(this.reader, "Unexpected trailing comma", 0, 2, null);
            throw null;
        }
        while (this.reader.getCanBeginValue()) {
            void this_$iv;
            void condition$iv;
            void this_$iv2;
            StreamingJsonInput streamingJsonInput = this;
            ++streamingJsonInput.currentIndex;
            int cfr_ignored_0 = streamingJsonInput.currentIndex;
            String key = this.reader.takeString();
            JsonReader jsonReader = this.reader;
            byte expected$iv22 = 5;
            boolean $i$f$requireTokenClass$kotlinx_serialization_runtime = false;
            if (this_$iv2.tokenClass != expected$iv22) {
                char c = (char)this_$iv2.tokenClass;
                void var10_11 = this_$iv2;
                boolean bl = false;
                String string = "Expected ':'";
                Void void_ = var10_11.fail(string, JsonReader.access$getTokenPosition$p((JsonReader)this_$iv2));
                throw null;
            }
            this.reader.nextToken();
            int index = desc.getElementIndex(key);
            if (index != -3) {
                return index;
            }
            if (this.configuration.strictMode) {
                Void void_ = JsonReader.fail$default(this.reader, "Encountered an unknown key " + key, 0, 2, null);
                throw null;
            }
            this.reader.skipElement();
            if (this.reader.tokenClass != 4) continue;
            this.reader.nextToken();
            JsonReader expected$iv22 = this.reader;
            $i$f$requireTokenClass$kotlinx_serialization_runtime = this.reader.getCanBeginValue();
            int position$iv = this.reader.currentPosition;
            boolean $i$f$require$kotlinx_serialization_runtime = false;
            if (condition$iv != false) continue;
            void var10_12 = this_$iv;
            boolean bl = false;
            String string = "Unexpected trailing comma";
            Void void_ = var10_12.fail(string, position$iv);
            throw null;
        }
        return -1;
    }

    private final int decodeListIndex(byte tokenClass) {
        int n;
        JsonReader this_$iv;
        if (tokenClass != 4 && this.currentIndex != -1) {
            JsonReader jsonReader = this.reader;
            byte expected$iv = 9;
            boolean $i$f$requireTokenClass$kotlinx_serialization_runtime = false;
            if (this_$iv.tokenClass != expected$iv) {
                char c = (char)this_$iv.tokenClass;
                JsonReader jsonReader2 = this_$iv;
                boolean bl = false;
                String string = "Expected end of the array or comma";
                Void void_ = jsonReader2.fail(string, JsonReader.access$getTokenPosition$p(this_$iv));
                throw null;
            }
        }
        if (!this.reader.getCanBeginValue()) {
            this_$iv = this.reader;
            boolean condition$iv = tokenClass != 4;
            int position$iv = this_$iv.currentPosition;
            boolean $i$f$require$kotlinx_serialization_runtime = false;
            if (!condition$iv) {
                JsonReader jsonReader = this_$iv;
                boolean bl = false;
                String string = "Unexpected trailing comma";
                Void void_ = jsonReader.fail(string, position$iv);
                throw null;
            }
            n = -1;
        } else {
            StreamingJsonInput streamingJsonInput = this;
            n = ++streamingJsonInput.currentIndex;
        }
        return n;
    }

    @Override
    public boolean decodeBoolean() {
        boolean bl;
        String string = this.reader.takeString();
        boolean bl2 = false;
        boolean bl3 = false;
        String $this$run = string;
        boolean bl4 = false;
        if (this.configuration.strictMode) {
            bl = StringOpsKt.toBooleanStrict($this$run);
        } else {
            String string2 = $this$run;
            boolean bl5 = false;
            bl = Boolean.parseBoolean(string2);
        }
        return bl;
    }

    @Override
    public byte decodeByte() {
        String string = this.reader.takeString();
        boolean bl = false;
        return Byte.parseByte(string);
    }

    @Override
    public short decodeShort() {
        String string = this.reader.takeString();
        boolean bl = false;
        return Short.parseShort(string);
    }

    @Override
    public int decodeInt() {
        String string = this.reader.takeString();
        boolean bl = false;
        return Integer.parseInt(string);
    }

    @Override
    public long decodeLong() {
        String string = this.reader.takeString();
        boolean bl = false;
        return Long.parseLong(string);
    }

    @Override
    public float decodeFloat() {
        String string = this.reader.takeString();
        boolean bl = false;
        return Float.parseFloat(string);
    }

    @Override
    public double decodeDouble() {
        String string = this.reader.takeString();
        boolean bl = false;
        return Double.parseDouble(string);
    }

    @Override
    public char decodeChar() {
        return StringsKt.single(this.reader.takeString());
    }

    @Override
    @NotNull
    public String decodeString() {
        return this.reader.takeString();
    }

    @Override
    public int decodeEnum(@NotNull SerialDescriptor enumDescription) {
        Intrinsics.checkParameterIsNotNull(enumDescription, "enumDescription");
        return ShorthandsKt.getElementIndexOrThrow(enumDescription, this.reader.takeString());
    }

    @Override
    @NotNull
    public Json getJson() {
        return this.json;
    }

    public StreamingJsonInput(@NotNull Json json, @NotNull WriteMode mode, @NotNull JsonReader reader) {
        Intrinsics.checkParameterIsNotNull(json, "json");
        Intrinsics.checkParameterIsNotNull((Object)mode, "mode");
        Intrinsics.checkParameterIsNotNull(reader, "reader");
        this.json = json;
        this.mode = mode;
        this.reader = reader;
        this.context = this.getJson().getContext();
        this.currentIndex = -1;
        this.configuration = this.getJson().configuration;
    }

    @Override
    @Nullable
    public <T> T decodeNullableSerializableValue(@NotNull DeserializationStrategy<T> deserializer) {
        Intrinsics.checkParameterIsNotNull(deserializer, "deserializer");
        return JsonInput.DefaultImpls.decodeNullableSerializableValue(this, deserializer);
    }

    @Override
    public <T> T updateSerializableValue(@NotNull DeserializationStrategy<T> deserializer, T old) {
        Intrinsics.checkParameterIsNotNull(deserializer, "deserializer");
        return JsonInput.DefaultImpls.updateSerializableValue(this, deserializer, old);
    }

    @Override
    @Nullable
    public <T> T updateNullableSerializableValue(@NotNull DeserializationStrategy<T> deserializer, @Nullable T old) {
        Intrinsics.checkParameterIsNotNull(deserializer, "deserializer");
        return JsonInput.DefaultImpls.updateNullableSerializableValue(this, deserializer, old);
    }

    @Override
    public int decodeCollectionSize(@NotNull SerialDescriptor desc) {
        Intrinsics.checkParameterIsNotNull(desc, "desc");
        return JsonInput.DefaultImpls.decodeCollectionSize(this, desc);
    }
}

