/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.clikt.output;

import com.github.ajalt.clikt.core.CliktError;
import com.github.ajalt.clikt.output.TermUi;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0003H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/ajalt/clikt/output/Editor;", "", "editorPath", "", "env", "", "requireSave", "", "extension", "(Ljava/lang/String;Ljava/util/Map;ZLjava/lang/String;)V", "edit", "text", "editFile", "", "filename", "getEditorCommand", "", "()[Ljava/lang/String;", "getEditorPath", "clikt"})
public final class Editor {
    private final String editorPath;
    private final Map<String, String> env;
    private final boolean requireSave;
    private final String extension;

    private final String getEditorPath() {
        if (this.editorPath != null) {
            return this.editorPath;
        }
        for (String key : new String[]{"VISUAL", "EDITOR"}) {
            String string = System.getenv(key);
            if (string == null) {
                continue;
            }
            return string;
        }
        if (TermUi.INSTANCE.isWindows()) {
            return "notepad";
        }
        for (String editor : new String[]{"vim", "nano"}) {
            try {
                Process process = new ProcessBuilder("which", editor).start();
                if (!process.waitFor(250L, TimeUnit.MILLISECONDS) || process.exitValue() != 0) continue;
                return editor;
            }
            catch (Exception err) {
                Exception exception = err;
                if (exception instanceof IOException || exception instanceof SecurityException || exception instanceof InterruptedException || exception instanceof IllegalThreadStateException) continue;
                throw (Throwable)new CliktError("Error staring editor", err);
            }
        }
        return "vi";
    }

    private final String[] getEditorCommand() {
        String string = this.getEditorPath();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString(), new String[]{" "}, false, 0, 6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    public final void editFile(@NotNull String filename) {
        Intrinsics.checkParameterIsNotNull(filename, "filename");
        String[] editorCmd = this.getEditorCommand();
        try {
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.addSpread(editorCmd);
            spreadBuilder.add(filename);
            ProcessBuilder processBuilder = new ProcessBuilder((String[])spreadBuilder.toArray(new String[spreadBuilder.size()]));
            boolean bl = false;
            boolean bl2 = false;
            ProcessBuilder $this$apply = processBuilder;
            boolean bl3 = false;
            Map<String, String> map2 = $this$apply.environment();
            Map<String, String> map3 = this.env;
            boolean bl4 = false;
            map2.putAll(map3);
            $this$apply.inheritIO();
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw (Throwable)new CliktError(editorCmd[0] + ": Editing failed!", null, 2, null);
            }
        }
        catch (Exception err) {
            Exception exception = err;
            if (exception instanceof CliktError) {
                throw (Throwable)err;
            }
            throw (Throwable)new CliktError("Error staring editor", err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String edit(@NotNull String text2) {
        String textToEdit;
        Intrinsics.checkParameterIsNotNull(text2, "text");
        String string = textToEdit = StringsKt.endsWith$default(text2, "\n", false, 2, null) ? text2 : text2 + "\n";
        if (TermUi.INSTANCE.isWindows()) {
            CharSequence charSequence = textToEdit;
            Regex regex = new Regex("(?<!\r)\n");
            String string2 = "\r\n";
            boolean bl = false;
            textToEdit = regex.replace(charSequence, string2);
        }
        File file2 = FilesKt.createTempFile$default(null, this.extension, null, 5, null);
        try {
            FilesKt.writeText$default(file2, textToEdit, null, 2, null);
            long ts = file2.lastModified();
            String string3 = file2.getCanonicalPath();
            Intrinsics.checkExpressionValueIsNotNull(string3, "file.canonicalPath");
            this.editFile(string3);
            if (this.requireSave && file2.lastModified() == ts) {
                String string4 = null;
                return string4;
            }
            String string5 = StringsKt.replace$default(FilesKt.readText$default(file2, null, 1, null), "\r\n", "\n", false, 4, null);
            return string5;
        }
        catch (Exception err) {
            throw (Throwable)new CliktError("Error staring editor", err);
        }
        finally {
            file2.delete();
        }
    }

    public Editor(@Nullable String editorPath, @NotNull Map<String, String> env, boolean requireSave, @NotNull String extension) {
        Intrinsics.checkParameterIsNotNull(env, "env");
        Intrinsics.checkParameterIsNotNull(extension, "extension");
        this.editorPath = editorPath;
        this.env = env;
        this.requireSave = requireSave;
        this.extension = extension;
    }
}

