/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.util;

public final class MathUtils {
    private static final byte ZB = 0;
    private static final byte NB = -1;
    private static final byte PB = 1;
    private static final short ZS = 0;
    private static final short NS = -1;
    private static final short PS = 1;

    private MathUtils() {
    }

    public static double sign(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        return x == 0.0 ? 0.0 : (x > 0.0 ? 1.0 : -1.0);
    }

    public static float sign(float x) {
        if (Float.isNaN(x)) {
            return Float.NaN;
        }
        return x == 0.0f ? 0.0f : (x > 0.0f ? 1.0f : -1.0f);
    }

    public static byte sign(byte x) {
        return (byte)(x == 0 ? 0 : (x > 0 ? 1 : -1));
    }

    public static short sign(short x) {
        return (short)(x == 0 ? 0 : (x > 0 ? 1 : -1));
    }

    public static int sign(int x) {
        return x == 0 ? 0 : (x > 0 ? 1 : -1);
    }

    public static long sign(long x) {
        return x == 0L ? 0L : (x > 0L ? 1L : -1L);
    }

    public static double indicator(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        return x >= 0.0 ? 1.0 : -1.0;
    }

    public static float indicator(float x) {
        if (Float.isNaN(x)) {
            return Float.NaN;
        }
        return x >= 0.0f ? 1.0f : -1.0f;
    }

    public static byte indicator(byte x) {
        return x >= 0 ? (byte)1 : -1;
    }

    public static short indicator(short x) {
        return x >= 0 ? (short)1 : -1;
    }

    public static int indicator(int x) {
        return x >= 0 ? 1 : -1;
    }

    public static long indicator(long x) {
        return x >= 0L ? 1L : -1L;
    }

    public static long binomialCoefficient(int n, int k) {
        if (n < k) {
            throw new IllegalArgumentException("must have n >= k for binomial coefficient (n,k)");
        }
        if (n < 0) {
            throw new IllegalArgumentException("must have n >= 0 for binomial coefficient (n,k)");
        }
        if (n == k || k == 0) {
            return 1L;
        }
        if (k == 1 || k == n - 1) {
            return n;
        }
        long result = Math.round(MathUtils.binomialCoefficientDouble(n, k));
        if (result == Long.MAX_VALUE) {
            throw new ArithmeticException("result too large to represent in a long integer");
        }
        return result;
    }

    public static double binomialCoefficientDouble(int n, int k) {
        return Math.floor(Math.exp(MathUtils.binomialCoefficientLog(n, k)) + 0.5);
    }

    public static double binomialCoefficientLog(int n, int k) {
        int i;
        if (n < k) {
            throw new IllegalArgumentException("must have n >= k for binomial coefficient (n,k)");
        }
        if (n < 0) {
            throw new IllegalArgumentException("must have n >= 0 for binomial coefficient (n,k)");
        }
        if (n == k || k == 0) {
            return 0.0;
        }
        if (k == 1 || k == n - 1) {
            return Math.log(n);
        }
        double logSum = 0.0;
        for (i = k + 1; i <= n; ++i) {
            logSum += Math.log(i);
        }
        for (i = 2; i <= n - k; ++i) {
            logSum -= Math.log(i);
        }
        return logSum;
    }

    public static long factorial(int n) {
        long result = Math.round(MathUtils.factorialDouble(n));
        if (result == Long.MAX_VALUE) {
            throw new ArithmeticException("result too large to represent in a long integer");
        }
        return result;
    }

    public static double factorialDouble(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("must have n >= 0 for n!");
        }
        return Math.floor(Math.exp(MathUtils.factorialLog(n)) + 0.5);
    }

    public static double factorialLog(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("must have n > 0 for n!");
        }
        double logSum = 0.0;
        for (int i = 2; i <= n; ++i) {
            logSum += Math.log(i);
        }
        return logSum;
    }

    public static double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    public static double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }

    public static int hash(double value) {
        long bits = Double.doubleToLongBits(value);
        return (int)(bits ^ bits >>> 32);
    }

    public static boolean equals(double x, double y) {
        return Double.isNaN(x) && Double.isNaN(y) || x == y;
    }
}

