/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.api.visage;

import de.cinderella.api.CindyObject;
import de.cinderella.api.visage.DirectedEdge;
import de.cinderella.api.visage.Edge;
import de.cinderella.api.visage.GraphAlgorithm;
import de.cinderella.api.visage.Vertex;
import de.cinderella.geometry.PGElement;
import de.cinderella.geometry.PGPoint;
import de.cinderella.proguard.API;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Logger;

@API
public class Graph {
    private static final Logger b = Logger.getLogger((String)"de.cinderella.api.visage.Graph");
    private Vector<Vertex> c;
    private Vector<Edge> d;
    private Vector<DirectedEdge> e;
    GraphAlgorithm a;
    private Hashtable<CindyObject, Vertex> f;
    private Hashtable<CindyObject, Edge> g;
    private static Random h = new Random();

    public Graph(GraphAlgorithm graphAlgorithm) {
        this.a = graphAlgorithm;
        this.c = new Vector();
        this.d = new Vector();
        this.e = new Vector();
        this.f = new Hashtable();
        this.g = new Hashtable();
    }

    @API
    public Vector<Vertex> vertices() {
        if (this.a.randomness()) {
            Graph.a(this.c);
        }
        return new Vector<Vertex>(this.c);
    }

    private static void a(Vector vector) {
        int n2 = vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 + h.nextInt(n2 - i2);
            Object e2 = vector.get(n3);
            vector.set(n3, vector.get(i2));
            vector.set(i2, e2);
        }
    }

    @API
    public Vertex addVertex(CindyObject cindyObject) {
        Vertex vertex = new Vertex(cindyObject);
        int n2 = this.c.indexOf(vertex);
        if (n2 != -1) {
            return this.c.get(n2);
        }
        this.c.add(vertex);
        this.f.put(cindyObject, vertex);
        return vertex;
    }

    @API
    public Edge addUndirectedEdge(Vertex object, Vertex vertex, CindyObject cindyObject) {
        object = new Edge((Vertex)object, vertex, cindyObject);
        this.d.add((Edge)object);
        this.g.put(cindyObject, (Edge)object);
        return object;
    }

    @API
    public DirectedEdge addDirectedEdge(Vertex object, Vertex vertex, CindyObject cindyObject) {
        object = new DirectedEdge((Vertex)object, vertex, cindyObject);
        this.e.add((DirectedEdge)object);
        this.g.put(cindyObject, (Edge)object);
        return object;
    }

    @API
    public Vector<Edge> edges() {
        Vector<Edge> vector = new Vector<Edge>();
        vector.addAll(this.e);
        vector.addAll(this.d);
        return vector;
    }

    @API
    public Vertex randomVertex() {
        if (this.c.isEmpty()) {
            return null;
        }
        int n2 = h.nextInt(this.c.size());
        Vertex vertex = this.c.get(n2);
        return vertex;
    }

    @API
    public Vector<Edge> outgoing(Vertex vertex) {
        Vector<Edge> vector = new Vector<Edge>();
        for (Edge edge : this.d) {
            if (!edge.getVertex1().equals(vertex) && !edge.getVertex2().equals(vertex)) continue;
            vector.add(edge);
        }
        for (DirectedEdge directedEdge : this.e) {
            if (!directedEdge.getVertex1().equals(vertex)) continue;
            vector.add(directedEdge);
        }
        if (this.a.randomness()) {
            Graph.a(vector);
        }
        return vector;
    }

    @API
    public Vector<Edge> incoming(Vertex vertex) {
        Vector<Edge> vector = new Vector<Edge>();
        for (Edge edge : this.d) {
            if (!edge.getVertex1().equals(vertex) && !edge.getVertex2().equals(vertex)) continue;
            vector.add(edge);
        }
        for (DirectedEdge directedEdge : this.e) {
            if (!directedEdge.getVertex2().equals(vertex)) continue;
            vector.add(directedEdge);
        }
        if (this.a.randomness()) {
            Graph.a(vector);
        }
        return vector;
    }

    @API
    public boolean isEmpty() {
        return this.c.isEmpty() && this.d.isEmpty() && this.e.isEmpty();
    }

    @API
    public int numVertices() {
        return this.c.size();
    }

    @API
    public Vertex vertex(int n2) {
        return this.c.get(n2);
    }

    public final void a(PGElement pGElement) {
        Edge edge;
        Iterator<Edge> iterator = this.e.iterator();
        while (iterator.hasNext()) {
            edge = iterator.next();
            if (!edge.a(pGElement)) continue;
            b.debug((Object)("removing dir edge " + edge));
            iterator.remove();
            this.g.remove(edge.getCindyObject());
        }
        iterator = this.d.iterator();
        while (iterator.hasNext()) {
            edge = iterator.next();
            if (!edge.a(pGElement)) continue;
            b.debug((Object)("removing undir edge " + edge));
            iterator.remove();
            this.g.remove(edge.getCindyObject());
        }
    }

    public final void b(PGElement pGElement) {
        Object object;
        Iterator<Object> iterator = this.e.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!((Edge)object).getVertex1().a(pGElement) && !((Edge)object).getVertex2().a(pGElement)) continue;
            b.debug((Object)("remove v, removing dir edge " + object));
            iterator.remove();
            this.g.remove(((Edge)object).getCindyObject());
        }
        iterator = this.d.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!((Edge)object).getVertex1().a(pGElement) && !((Edge)object).getVertex2().a(pGElement)) continue;
            b.debug((Object)("remove v, removing undir edge  " + object));
            iterator.remove();
            this.g.remove(((Edge)object).getCindyObject());
        }
        iterator = this.c.iterator();
        while (iterator.hasNext()) {
            object = (Vertex)iterator.next();
            if (!((Vertex)object).a(pGElement)) continue;
            b.debug((Object)("remove v, removing " + object));
            iterator.remove();
            this.f.remove(new CindyObject(pGElement.D, pGElement));
        }
    }

    public final Vertex c(PGElement pGElement) {
        for (Vertex vertex : this.c) {
            if (!vertex.a(pGElement)) continue;
            return vertex;
        }
        return null;
    }

    @API
    public boolean edgeExists(Vertex vertex, Vertex vertex2) {
        for (DirectedEdge edge : this.e) {
            if (!edge.getStart().equals(vertex) || !edge.getEnd().equals(vertex2)) continue;
            b.debug((Object)("found directedEdge = " + edge));
            return true;
        }
        for (Edge edge : this.d) {
            if ((!edge.getVertex1().equals(vertex) || !edge.getVertex2().equals(vertex2)) && (!edge.getVertex2().equals(vertex) || !edge.getVertex1().equals(vertex2))) continue;
            b.debug((Object)("found edge = " + edge));
            return true;
        }
        return false;
    }

    @API
    public Edge findEdge(Vertex vertex, Vertex vertex2) {
        Object object = this.outgoing(vertex);
        object = ((Vector)object).iterator();
        while (object.hasNext()) {
            Edge edge = (Edge)object.next();
            if (!edge.otherVertex(vertex).equals(vertex2)) continue;
            return edge;
        }
        return null;
    }

    @API
    public DirectedEdge findDirectedEdge(Vertex vertex, Vertex vertex2) {
        for (DirectedEdge directedEdge : this.e) {
            if (!directedEdge.getStart().equals(vertex) || !directedEdge.getEnd().equals(vertex2)) continue;
            return directedEdge;
        }
        return null;
    }

    @API
    public Vertex vertexForName(String string) {
        for (Vertex vertex : this.c) {
            if (!vertex.name().equals(string)) continue;
            return vertex;
        }
        return null;
    }

    public final Vertex a(PGPoint pGPoint) {
        return this.f.get(new CindyObject(pGPoint.D, pGPoint));
    }

    @API
    public Vertex vertex(CindyObject cindyObject) {
        return this.f.get(cindyObject);
    }

    @API
    public Edge edge(CindyObject cindyObject) {
        return this.g.get(cindyObject);
    }
}

