/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.DataObjectList;
import com.dickimawbooks.texparserlib.NumericRegister;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.UserNumber;
import java.io.IOException;

public class GlsXtrLoadResources
extends ControlSequence {
    public GlsXtrLoadResources() {
        this("GlsXtrLoadResources");
    }

    public GlsXtrLoadResources(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new GlsXtrLoadResources(this.getName());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        this.popOptArg(teXParser, teXObjectList);
        NumericRegister numericRegister = teXSettings.getNumericRegister("glsxtrresourcecount");
        int n = numericRegister.number(teXParser);
        numericRegister.setValue(teXParser, new UserNumber(n + 1));
        String string = teXParser.getJobname();
        DataObjectList dataObjectList = n == 0 ? teXParser.getListener().createDataList(string + ".glstex") : teXParser.getListener().createDataList(string + "-" + n + ".glstex");
        teXObjectList.push(dataObjectList);
        if (teXParser == teXObjectList || teXObjectList == null) {
            teXParser.getListener().getControlSequence("input").process(teXParser);
        } else {
            teXParser.getListener().getControlSequence("input").process(teXParser, teXObjectList);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

