/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class UserNumber
extends AbstractTeXObject
implements TeXNumber {
    private int value;
    public static final UserNumber MINUS_ONE = new UserNumber(-1);
    public static final UserNumber ZERO = new UserNumber(0);
    public static final UserNumber ONE = new UserNumber(1);
    public static final UserNumber TWO = new UserNumber(2);
    public static final UserNumber THREE = new UserNumber(3);
    public static final UserNumber FOUR = new UserNumber(4);
    public static final UserNumber FIVE = new UserNumber(5);

    public UserNumber() {
        this(0);
    }

    public UserNumber(int n) {
        this.value = n;
    }

    public UserNumber(TeXParser teXParser, String string) throws TeXSyntaxException {
        try {
            this.value = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TeXSyntaxException((Throwable)numberFormatException, teXParser, "tex.error.number_expected", string);
        }
    }

    public UserNumber(TeXParser teXParser, String string, int n) throws TeXSyntaxException {
        try {
            this.value = Integer.parseInt(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TeXSyntaxException((Throwable)numberFormatException, teXParser, "tex.error.number_expected", string);
        }
    }

    @Override
    public Object clone() {
        return new UserNumber(this.value);
    }

    @Override
    public boolean isDataObject() {
        return true;
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public void setValue(float f) {
        this.value = (int)f;
    }

    @Override
    public void multiply(int n) {
        this.value *= n;
    }

    @Override
    public void divide(int n) {
        this.value /= n;
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        this.value += numerical.number(teXParser);
    }

    @Override
    public String format() {
        return "" + this.value;
    }

    public String toString() {
        return String.format("%s[value=%d]", this.getClass().getSimpleName(), this.value);
    }

    @Override
    public String toString(TeXParser teXParser) {
        return "" + this.value;
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return teXParser.string(this.toString(teXParser));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.getListener().getWriteable().write("" + this.value);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }
}

