#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.18';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD6',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD850',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::ShotInfoZ7II',
	'Image::ExifTool::Nikon::ShotInfoZ9',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 108 => 0x69 },
	'about' => { 496 => 'about' },
	'aboutcvterm' => { 488 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 488 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 488 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 488 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 488 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 115 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 502 => 'absPeakAudioFilePath' },
	'academicfield' => { 492 => 'academicField' },
	'acceleration' => { 118 => 0x9404, 483 => 'Acceleration' },
	'accelerationtracking' => { 83 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 389 => 0x3 },
	'accelerometerdata' => { 379 => 'vrot' },
	'accelerometerx' => { 319 => 0x8d },
	'accelerometery' => { 319 => 0x8e },
	'accelerometerz' => { 319 => 0x8c },
	'accessoryserialnumber' => { 319 => 0x54 },
	'accessorytype' => { 319 => 0x53 },
	'actionadvised' => { 130 => 0x2a },
	'activearea' => { 118 => 0xc68d },
	'actived-lighting' => { 225 => 0x22, 269 => 0x24 },
	'actived-lightingmode' => { 269 => 0x25 },
	'adaptervoltage' => { 137 => 0x407 },
	'addaspectratioinfo' => { 83 => 0x80e },
	'addiptcinformation' => { 83 => 0x815 },
	'additionalmodelinformation' => { 488 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 83 => 0x80f, 84 => 0x11, 85 => 0x13, 88 => 0x14 },
	'address' => { 160 => 'Address' },
	'adjustmentmode' => { 396 => 0x15 },
	'adlbracketingstep' => { 247 => 0x883 },
	'adlbracketingtype' => { 247 => 0x884 },
	'adobe' => { 119 => 'Adobe' },
	'adultcontentwarning' => { 306 => 'AdultContentWarning', 495 => 'adultContentWarning' },
	'advancedfilter' => { 126 => 0x1201 },
	'advancedraw' => { 271 => 0x76a43203 },
	'advancedscenetype' => { 319 => 0x3d },
	'advisory' => { 500 => 'Advisory' },
	'ae_iso' => { 327 => 0x2, 328 => 0x4, 329 => 0x12 },
	'aeaperture' => { 327 => 0x1, 328 => 0x3, 329 => 0x11 },
	'aeaperturesteps' => { 327 => 0x8, 328 => 0xb },
	'aebautocancel' => { 83 => 0x104 },
	'aebbracketvalue' => { 76 => 0x11 },
	'aebracketingsteps' => { 246 => 0x174c, 247 => 0x87b, 256 => 0x1756 },
	'aebsequence' => { 83 => 0x105 },
	'aebsequenceautocancel' => { 81 => 0x9, 82 => 0x9, 84 => 0x8, 85 => 0x9, 88 => 0x9, 89 => 0x7 },
	'aebshotcount' => { 83 => 0x106 },
	'aebxv' => { 327 => 0x4, 328 => 0x6 },
	'aeerror' => { 328 => 0x8 },
	'aeexposuretime' => { 327 => 0x0, 328 => 0x2, 329 => 0x10 },
	'aelbutton' => { 183 => 0x45 },
	'aelexposureindicator' => { 183 => 0x51 },
	'aelock' => { 183 => 0x5b, 280 => '4.2', 289 => '4.2', 296 => 0x201, 354 => 0x48, 406 => 0x40, 407 => 0x40, 408 => [0x86,0x286] },
	'aelockbutton' => { 278 => '16.1', 280 => '4.1', 283 => '15.1', 284 => '16.1', 285 => '16.1', 287 => '30.1', 288 => '16.1', 289 => '4.1', 291 => '17.1', 293 => '17.1' },
	'aelockbuttonplusdials' => { 278 => '16.2', 287 => '32.1', 291 => '44.1' },
	'aelockformb-d80' => { 293 => '3.1' },
	'aelockmetermodeafterfocus' => { 83 => 0x114 },
	'aemaxaperture' => { 327 => 0x9, 328 => 0x10, 329 => 0x1c },
	'aemaxaperture2' => { 327 => 0xa, 328 => 0x11, 329 => 0x1d },
	'aemeteringmode' => { 327 => 0xc },
	'aemeteringmode2' => { 327 => '13.1' },
	'aemeteringsegments' => { 186 => 0x628, 354 => 0x209 },
	'aemicroadjustment' => { 83 => 0x110 },
	'aeminaperture' => { 327 => 0xb, 328 => 0x12, 329 => 0x1e },
	'aeminexposuretime' => { 327 => 0x5, 328 => 0x13, 329 => 0x1f },
	'aeprogrammode' => { 327 => 0x6 },
	'aeprojectlink' => { 477 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 477 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 477 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 477 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 477 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 477 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 34 => 0x21 },
	'aewhitebalance' => { 327 => 0xd },
	'aexv' => { 327 => 0x3, 328 => 0x5 },
	'af-assistilluminator' => { 294 => 0x19 },
	'af-cfocusdisplay' => { 294 => 0x234 },
	'af-cpriority' => { 127 => '0.2' },
	'af-cpriorityselection' => { 278 => '1.1', 279 => '1.1', 281 => '1.1', 282 => '1.1', 284 => '0.1', 285 => '0.1', 286 => '0.1', 287 => '1.1', 288 => '0.1', 291 => '1.1', 292 => '1.1', 294 => 0x3 },
	'af-csetting' => { 123 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 123 => '0.2' },
	'af-ctrackingsensitivity' => { 123 => '0.1' },
	'af-czoneareaswitching' => { 123 => '0.3' },
	'af-onbutton' => { 281 => '70.1', 282 => '70.1', 292 => '70.1' },
	'af-onformb-d10' => { 278 => '3.3', 287 => '3.2' },
	'af-onformb-d11' => { 288 => '2.2' },
	'af-onformb-d12' => { 291 => '50.1' },
	'af-onoutoffocusrelease' => { 294 => 0x10 },
	'af-spriority' => { 127 => '0.1' },
	'af-spriorityselection' => { 278 => '1.2', 279 => '1.2', 281 => '1.2', 282 => '1.2', 286 => '0.2', 287 => '1.2', 288 => '0.2', 291 => '1.2', 292 => '1.2', 294 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 278 => '2.1', 279 => '2.1', 281 => '78.3', 282 => '78.3', 287 => '2.1', 291 => '2.1', 292 => '78.3', 294 => 0xf },
	'afadjustment' => { 354 => 0x72, 363 => 0x267 },
	'afandmeteringbuttons' => { 83 => 0x701 },
	'afaperture' => { 218 => 0x5, 219 => 0x5, 223 => 0x5 },
	'afareaheight' => { 192 => [0x1a,0x34,0x50], 193 => 0x48 },
	'afareaillumination' => { 183 => 0x4b, 289 => '15.3' },
	'afareamode' => { 125 => '0.3', 179 => 0x33, 183 => 0xe, 191 => 0x0, 192 => 0x5, 319 => 0xf, 386 => 0x1205, 399 => [0xa,0x3a], 406 => 0x11, 407 => 0x10, 408 => 0x24, 419 => 0xb043, 443 => 0x17 },
	'afareamodesetting' => { 280 => '11.1', 283 => '0.1', 289 => '16.1', 293 => '2.1', 419 => 0x201c },
	'afareapointsize' => { 125 => '0.4' },
	'afareas' => { 296 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 83 => 0x51b },
	'afareawidth' => { 192 => [0x18,0x32,0x4e], 193 => 0x46 },
	'afareaxposition' => { 192 => [0x14,0x2e,0x4a], 386 => 0x1203 },
	'afareaxposition1' => { 386 => 0x1201 },
	'afareayposition' => { 192 => [0x16,0x30,0x4c], 386 => 0x1204 },
	'afareayposition1' => { 386 => 0x1202 },
	'afareazonesize' => { 125 => '0.5' },
	'afassist' => { 81 => 0x5, 89 => 0x5, 183 => 0x48, 278 => '2.5', 280 => '0.2', 283 => '0.2', 284 => '1.1', 285 => '1.1', 286 => '1.3', 287 => '2.4', 288 => '1.3', 289 => '0.2', 291 => '2.4', 293 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 83 => 0x50e, 84 => 0x4, 85 => 0x5, 86 => 0x4, 87 => 0x4, 88 => 0x5 },
	'afassistlamp' => { 319 => 0x31 },
	'afbuttonpressed' => { 408 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 330 => 0x6 },
	'afduringliveview' => { 83 => 0x511 },
	'affinea' => { 470 => 'AffineA' },
	'affineb' => { 470 => 'AffineB' },
	'affinec' => { 470 => 'AffineC' },
	'affined' => { 470 => 'AffineD' },
	'affinetune' => { 194 => 0x0, 228 => 0x5b0, 296 => 0x306 },
	'affinetuneadj' => { 194 => 0x2, 239 => 0x2d1, 240 => 0x2dc, 296 => 0x307 },
	'affinetuneadjtele' => { 194 => 0x3 },
	'affinetuneindex' => { 194 => 0x1 },
	'affinex' => { 470 => 'AffineX' },
	'affiney' => { 470 => 'AffineY' },
	'affocuspointxposition' => { 192 => 0x2f },
	'affocuspointyposition' => { 192 => 0x31 },
	'afhold' => { 330 => 0x1fd },
	'afilluminator' => { 406 => 0x29, 419 => 0xb044 },
	'afimageheight' => { 192 => [0x12,0x2c,0x48], 193 => 0x40 },
	'afimagewidth' => { 192 => [0x10,0x2a,0x46], 193 => 0x3e },
	'afintegrationtime' => { 330 => 0x7 },
	'afmicroadj' => { 399 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 403 => 0x131 },
	'afmicroadjregisteredlenses' => { 403 => '305.1' },
	'afmicroadjustment' => { 83 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 403 => 0x130 },
	'afmode' => { 112 => 0x3009, 126 => 0x1022, 179 => 0x16, 396 => 0x5 },
	'afmoderestrictions' => { 279 => '50.3', 281 => '48.3', 282 => '48.3', 291 => '48.3', 292 => '48.3' },
	'afonaelockbuttonswitch' => { 83 => 0x702 },
	'afonbutton' => { 278 => '3.1', 279 => '47.1', 294 => 0x83 },
	'afpoint' => { 34 => 0x13, 111 => 0x18, 179 => 0x15, 191 => 0x1, 299 => 0x308, 396 => 0x1f, 399 => [0x37,0x7], 403 => 0x19, 404 => 0x18, 405 => [0x18,0x20] },
	'afpointactivationarea' => { 82 => 0x11, 88 => 0x11 },
	'afpointareaexpansion' => { 83 => 0x508 },
	'afpointatshutterrelease' => { 399 => [0x39,0x9] },
	'afpointautoselection' => { 83 => 0x50b },
	'afpointbrightness' => { 83 => 0x50d, 278 => '2.4', 279 => '46.5', 281 => '2.2', 282 => '2.2', 291 => '2.3', 292 => '2.2' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 83 => 0x50c },
	'afpointillumination' => { 82 => 0xa, 278 => '2.3', 279 => '46.2', 281 => '47.2', 282 => '47.2', 286 => '1.2', 287 => '2.3', 288 => '1.2', 291 => '47.2', 292 => '47.2', 293 => '2.4' },
	'afpointinfocus' => { 399 => [0x38,0x8] },
	'afpointmode' => { 335 => 0x3 },
	'afpointposition' => { 112 => 0x2021, 319 => 0x4d },
	'afpointregistration' => { 81 => 0x7 },
	'afpoints' => { 182 => 0x10 },
	'afpointsel' => { 294 => 0xb },
	'afpointselected' => { 183 => 0xd, 296 => 0x305, 354 => 0xe, 403 => 0x15, 404 => 0x14, 405 => [0x14,0x1c], 419 => 0x201e },
	'afpointselected2' => { 335 => 0x4 },
	'afpointselection' => { 82 => 0xb, 278 => '1.3', 279 => '1.3', 287 => '1.3', 291 => '1.3', 292 => '1.3' },
	'afpointselectionmethod' => { 83 => 0x50f, 84 => 0xc, 85 => 0xd, 88 => 0xd },
	'afpointsetting' => { 406 => 0x12, 407 => 0x11 },
	'afpointsinfocus' => { 76 => 0xe, 191 => 0x2, 192 => 0x30, 330 => 0xb, 331 => 0x4, 354 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 82 => 0xd },
	'afpointsselected' => { 192 => 0x1c, 331 => '4.1', 451 => 0x4 },
	'afpointsspecial' => { 331 => '4.2' },
	'afpointsunknown1' => { 330 => 0x0 },
	'afpointsunknown2' => { 330 => 0x2 },
	'afpointsused' => { 192 => [0xa,0x8], 399 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 330 => 0x4 },
	'afresponse' => { 225 => 0xad },
	'afresult' => { 301 => 0x1038 },
	'afsearch' => { 296 => 0x303 },
	'afsensoractive' => { 179 => 0x1 },
	'afstatus' => { 386 => 0x1200 },
	'afstatus_00_b4' => { 402 => 0x0 },
	'afstatus_01_c4' => { 402 => 0x2 },
	'afstatus_02_d4' => { 402 => 0x4 },
	'afstatus_03_e4' => { 402 => 0x6 },
	'afstatus_04_f4' => { 402 => 0x8 },
	'afstatus_05_g4' => { 402 => 0xa },
	'afstatus_06_h4' => { 402 => 0xc },
	'afstatus_07_b3' => { 402 => 0xe },
	'afstatus_08_c3' => { 402 => 0x10 },
	'afstatus_09_d3' => { 402 => 0x12 },
	'afstatus_10_e3' => { 402 => 0x14 },
	'afstatus_11_f3' => { 402 => 0x16 },
	'afstatus_12_g3' => { 402 => 0x18 },
	'afstatus_13_h3' => { 402 => 0x1a },
	'afstatus_14_b2' => { 402 => 0x1c },
	'afstatus_15_c2' => { 402 => 0x1e },
	'afstatus_16_d2' => { 402 => 0x20 },
	'afstatus_17_e2' => { 402 => 0x22 },
	'afstatus_18_f2' => { 402 => 0x24 },
	'afstatus_19_g2' => { 402 => 0x26 },
	'afstatus_20_h2' => { 402 => 0x28 },
	'afstatus_21_c1' => { 402 => 0x2a },
	'afstatus_22_d1' => { 402 => 0x2c },
	'afstatus_23_e1' => { 402 => 0x2e },
	'afstatus_24_f1' => { 402 => 0x30 },
	'afstatus_25_g1' => { 402 => 0x32 },
	'afstatus_26_a7_vertical' => { 402 => 0x34 },
	'afstatus_27_a6_vertical' => { 402 => 0x36 },
	'afstatus_28_a5_vertical' => { 402 => 0x38 },
	'afstatus_29_c7_vertical' => { 402 => 0x3a },
	'afstatus_30_c6_vertical' => { 402 => 0x3c },
	'afstatus_31_c5_vertical' => { 402 => 0x3e },
	'afstatus_32_e7_vertical' => { 402 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 402 => 0x42 },
	'afstatus_34_e5_vertical' => { 402 => 0x44 },
	'afstatus_35_g7_vertical' => { 402 => 0x46 },
	'afstatus_36_g6_vertical' => { 402 => 0x48 },
	'afstatus_37_g5_vertical' => { 402 => 0x4a },
	'afstatus_38_i7_vertical' => { 402 => 0x4c },
	'afstatus_39_i6_vertical' => { 402 => 0x4e },
	'afstatus_40_i5_vertical' => { 402 => 0x50 },
	'afstatus_41_a7' => { 402 => 0x52 },
	'afstatus_42_b7' => { 402 => 0x54 },
	'afstatus_43_c7' => { 402 => 0x56 },
	'afstatus_44_d7' => { 402 => 0x58 },
	'afstatus_45_e7' => { 402 => 0x5a },
	'afstatus_46_f7' => { 402 => 0x5c },
	'afstatus_47_g7' => { 402 => 0x5e },
	'afstatus_48_h7' => { 402 => 0x60 },
	'afstatus_49_i7' => { 402 => 0x62 },
	'afstatus_50_a6' => { 402 => 0x64 },
	'afstatus_51_b6' => { 402 => 0x66 },
	'afstatus_52_c6' => { 402 => 0x68 },
	'afstatus_53_d6' => { 402 => 0x6a },
	'afstatus_54_e6_center' => { 402 => 0x6c },
	'afstatus_55_f6' => { 402 => 0x6e },
	'afstatus_56_g6' => { 402 => 0x70 },
	'afstatus_57_h6' => { 402 => 0x72 },
	'afstatus_58_i6' => { 402 => 0x74 },
	'afstatus_59_a5' => { 402 => 0x76 },
	'afstatus_60_b5' => { 402 => 0x78 },
	'afstatus_61_c5' => { 402 => 0x7a },
	'afstatus_62_d5' => { 402 => 0x7c },
	'afstatus_63_e5' => { 402 => 0x7e },
	'afstatus_64_f5' => { 402 => 0x80 },
	'afstatus_65_g5' => { 402 => 0x82 },
	'afstatus_66_h5' => { 402 => 0x84 },
	'afstatus_67_i5' => { 402 => 0x86 },
	'afstatus_68_c11' => { 402 => 0x88 },
	'afstatus_69_d11' => { 402 => 0x8a },
	'afstatus_70_e11' => { 402 => 0x8c },
	'afstatus_71_f11' => { 402 => 0x8e },
	'afstatus_72_g11' => { 402 => 0x90 },
	'afstatus_73_b10' => { 402 => 0x92 },
	'afstatus_74_c10' => { 402 => 0x94 },
	'afstatus_75_d10' => { 402 => 0x96 },
	'afstatus_76_e10' => { 402 => 0x98 },
	'afstatus_77_f10' => { 402 => 0x9a },
	'afstatus_78_g10' => { 402 => 0x9c },
	'afstatus_79_h10' => { 402 => 0x9e },
	'afstatus_80_b9' => { 402 => 0xa0 },
	'afstatus_81_c9' => { 402 => 0xa2 },
	'afstatus_82_d9' => { 402 => 0xa4 },
	'afstatus_83_e9' => { 402 => 0xa6 },
	'afstatus_84_f9' => { 402 => 0xa8 },
	'afstatus_85_g9' => { 402 => 0xaa },
	'afstatus_86_h9' => { 402 => 0xac },
	'afstatus_87_b8' => { 402 => 0xae },
	'afstatus_88_c8' => { 402 => 0xb0 },
	'afstatus_89_d8' => { 402 => 0xb2 },
	'afstatus_90_e8' => { 402 => 0xb4 },
	'afstatus_91_f8' => { 402 => 0xb6 },
	'afstatus_92_g8' => { 402 => 0xb8 },
	'afstatus_93_h8' => { 402 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 402 => 0xbc },
	'afstatusactivesensor' => { 179 => 0x2, 399 => [0x4,0x3b], 403 => 0x1e, 404 => 0x1b, 405 => [0x1b,0x21] },
	'afstatusbottom' => { 179 => 0x8, 403 => 0x2a, 404 => 0x21, 405 => 0x21 },
	'afstatusbottom-left' => { 179 => 0x12, 404 => 0x2b, 405 => 0x2b },
	'afstatusbottom-right' => { 179 => 0x6, 404 => 0x1f, 405 => 0x1f },
	'afstatusbottomassist-left' => { 403 => 0x28 },
	'afstatusbottomassist-right' => { 403 => 0x2c },
	'afstatusbottomhorizontal' => { 400 => 0x10, 401 => 0x1c },
	'afstatusbottomvertical' => { 400 => 0x16, 401 => 0x26 },
	'afstatuscenter-10' => { 403 => 0x34 },
	'afstatuscenter-11' => { 403 => 0x36 },
	'afstatuscenter-12' => { 403 => 0x38 },
	'afstatuscenter-14' => { 403 => 0x3c },
	'afstatuscenter-7' => { 403 => 0x2e },
	'afstatuscenter-9' => { 403 => 0x32 },
	'afstatuscenter-horizontal' => { 403 => 0x30 },
	'afstatuscenter-vertical' => { 403 => 0x3a },
	'afstatuscenterf2-8' => { 403 => 0x4c },
	'afstatuscenterhorizontal' => { 179 => 0x2f, 400 => 0xc, 401 => 0x18, 404 => 0x2f, 405 => 0x2f },
	'afstatuscentervertical' => { 179 => 0xc, 400 => 0x14, 401 => 0x22, 404 => 0x25, 405 => 0x25 },
	'afstatusfarleft' => { 400 => 0x6, 403 => 0x26 },
	'afstatusfarlefthorizontal' => { 401 => 0x4 },
	'afstatusfarleftvertical' => { 401 => 0x12 },
	'afstatusfarright' => { 400 => 0x18, 403 => 0x44 },
	'afstatusfarrighthorizontal' => { 401 => 0x2c },
	'afstatusfarrightvertical' => { 401 => 0x34 },
	'afstatusleft' => { 179 => 0x2d, 400 => 0x2, 403 => 0x22, 404 => 0x2d, 405 => 0x2d },
	'afstatuslefthorizontal' => { 401 => 0x6 },
	'afstatusleftvertical' => { 401 => 0xe },
	'afstatuslower-left' => { 400 => 0x4, 403 => 0x24 },
	'afstatuslower-lefthorizontal' => { 401 => 0xa },
	'afstatuslower-leftvertical' => { 401 => 0x10 },
	'afstatuslower-middle' => { 400 => 0x22, 401 => 0x24 },
	'afstatuslower-right' => { 400 => 0x1e, 403 => 0x4a },
	'afstatuslower-righthorizontal' => { 401 => 0x32 },
	'afstatuslower-rightvertical' => { 401 => 0x3a },
	'afstatuslowerfarleft' => { 401 => 0x8 },
	'afstatuslowerfarright' => { 401 => 0x30 },
	'afstatusmiddlehorizontal' => { 179 => 0xa, 404 => 0x23, 405 => 0x23 },
	'afstatusnearleft' => { 400 => 0xe, 401 => 0x1a },
	'afstatusnearright' => { 400 => 0xa, 401 => 0x16 },
	'afstatusright' => { 179 => 0x31, 400 => 0x1c, 403 => 0x48, 404 => 0x31, 405 => 0x31 },
	'afstatusrighthorizontal' => { 401 => 0x2e },
	'afstatusrightvertical' => { 401 => 0x38 },
	'afstatustop' => { 179 => 0xe, 403 => 0x40, 404 => 0x27, 405 => 0x27 },
	'afstatustop-left' => { 179 => 0x10, 404 => 0x29, 405 => 0x29 },
	'afstatustop-right' => { 179 => 0x4, 404 => 0x1d, 405 => 0x1d },
	'afstatustopassist-left' => { 403 => 0x3e },
	'afstatustopassist-right' => { 403 => 0x42 },
	'afstatustophorizontal' => { 400 => 0x8, 401 => 0x14 },
	'afstatustopvertical' => { 400 => 0x12, 401 => 0x1e },
	'afstatusupper-left' => { 400 => 0x0, 403 => 0x20 },
	'afstatusupper-lefthorizontal' => { 401 => 0x2 },
	'afstatusupper-leftvertical' => { 401 => 0xc },
	'afstatusupper-middle' => { 400 => 0x20, 401 => 0x20 },
	'afstatusupper-right' => { 400 => 0x1a, 403 => 0x46 },
	'afstatusupper-righthorizontal' => { 401 => 0x2a },
	'afstatusupper-rightvertical' => { 401 => 0x36 },
	'afstatusupperfarleft' => { 401 => 0x0 },
	'afstatusupperfarright' => { 401 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 419 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 399 => 0x2 },
	'afwithshutter' => { 406 => 0x2a },
	'aggregateissuenumber' => { 492 => 'aggregateIssueNumber' },
	'aggregationtype' => { 492 => 'aggregationType' },
	'agreement' => { 495 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 137 => 0xe4e },
	'airplanemode' => { 228 => 0x624 },
	'aiservocontinuousshooting' => { 82 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 83 => 0x519 },
	'aiservoimagepriority' => { 83 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 83 => 0x51a },
	'aiservotrackingmethod' => { 83 => 0x504 },
	'aiservotrackingsensitivity' => { 82 => 0x14, 83 => 0x502 },
	'album' => { 371 => ['albm',"\xa9alb"], 373 => 'album', 379 => ['albm',"\xa9alb"], 502 => 'album' },
	'albumartist' => { 178 => 'WM/AlbumArtist', 371 => 'aART', 379 => 'albr' },
	'albumcoverurl' => { 178 => 'WM/AlbumCoverURL' },
	'albumtitle' => { 178 => 'WM/AlbumTitle' },
	'albumtitleid' => { 371 => 'atID' },
	'alreadyapplied' => { 476 => 'AlreadyApplied', 478 => 'AlreadyApplied' },
	'alternatetitle' => { 492 => 'alternateTitle' },
	'alternatetitlea-lang' => { 492 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 492 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 492 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 195 => 0x6 },
	'alttapename' => { 502 => 'altTapeName' },
	'alttextaccessibility' => { 487 => 'AltTextAccessibility' },
	'alttimecode' => { 502 => 'altTimecode' },
	'alttimecodetimeformat' => { 502 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 502 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 502 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 382 => 0x5c },
	'ambientlight' => { 382 => 0x5e },
	'ambienttemperature' => { 118 => 0x9400, 380 => 0x14, 381 => 0x46, 382 => 0x50, 443 => 0x4, 483 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 380 => 0x13, 381 => 0x44, 382 => 0x4e },
	'analogbalance' => { 118 => 0xc627 },
	'analogcaptureiso' => { 137 => 0x89e },
	'analogisotable' => { 137 => 0x89d },
	'androidversion' => { 373 => 'com.android.version' },
	'angleadj' => { 102 => 0x10003, 108 => 0x8b },
	'angleinforoll' => { 472 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 472 => 'AngleInfoYaw' },
	'anti-blur' => { 419 => 0xb04b },
	'antialiasstrength' => { 118 => 0xc632 },
	'aperturelock' => { 279 => '38.2', 281 => '38.2', 282 => '38.2', 291 => '38.2', 292 => '38.2', 294 => 0xb8 },
	'aperturemode' => { 379 => 'apmd' },
	'aperturerange' => { 83 => 0x10d },
	'apertureringuse' => { 335 => '1.4' },
	'aperturesetting' => { 183 => 0x7, 406 => 0x30, 407 => 0x29, 408 => 0x1 },
	'aperturevalue' => { 92 => 0x2, 118 => 0x9202, 301 => 0x1002, 363 => 0x401, 482 => 'ApertureValue' },
	'appinfo' => { 456 => 'AppInfo' },
	'appinfoapplication' => { 456 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 456 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 456 => [\'AppInfo','AppInfoVersion'] },
	'applekeywords' => { 305 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 373 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 371 => 'apID' },
	'applestoreaccounttype' => { 371 => 'akID' },
	'applestorecatalogid' => { 371 => 'cnID' },
	'applestorecountry' => { 371 => 'sfID' },
	'applicationkeystring' => { 137 => 0x400 },
	'applicationnotes' => { 118 => 0x2bc, 324 => 0x2bc },
	'applicationrecordversion' => { 130 => 0x0 },
	'applyshootingmeteringmode' => { 83 => 0x10e },
	'approved' => { 484 => 'Approved' },
	'approvedby' => { 484 => 'ApprovedBy' },
	'approximatefnumber' => { 314 => 0x313, 321 => 0x3406 },
	'approximatefocusdistance' => { 473 => 'ApproximateFocusDistance' },
	'appversion' => { 486 => 'AppVersion' },
	'aps-csizecapture' => { 437 => 0x114, 438 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 102 => 0x20914 },
	'armidentifier' => { 131 => 0x78 },
	'armversion' => { 131 => 0x7a },
	'arranger' => { 371 => "\xa9arg", 379 => "\xa9arg" },
	'arrangerkeywords' => { 379 => "\xa9ark" },
	'artdirector' => { 371 => "\xa9ard" },
	'artfilter' => { 296 => 0x529 },
	'artfiltereffect' => { 296 => 0x52f },
	'artist' => { 118 => 0x13b, 309 => 'Artist', 354 => 0x22e, 371 => "\xa9ART", 373 => 'artist', 379 => "\xa9ART", 498 => 'Artist', 502 => 'artist' },
	'artmode' => { 112 => 0x301b },
	'artmodeparameters' => { 112 => 0x310b },
	'artwork' => { 373 => 'artwork' },
	'artworkcircadatecreated' => { 488 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 488 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 488 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 488 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 488 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 488 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 488 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 488 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 488 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 488 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 488 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 488 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 488 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 488 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 488 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 488 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 488 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 488 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 300 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 300 => 0x1112, 354 => 0x80, 406 => 0x55, 407 => 0x55, 408 => 0xa },
	'assetid' => { 466 => 'AssetID' },
	'asshoticcprofile' => { 118 => 0xc68f },
	'asshotneutral' => { 118 => 0xc628 },
	'asshotpreprofilematrix' => { 118 => 0xc690 },
	'asshotprofilename' => { 118 => 0xc6f6 },
	'asshotwhitexy' => { 118 => 0xc629 },
	'assignbktbutton' => { 278 => '4.2', 279 => '16.1', 281 => '16.1', 282 => '16.1', 291 => '16.1', 292 => '16.1' },
	'assignfuncbutton' => { 83 => 0x70b },
	'assignmb-d17af-onbutton' => { 282 => '79.1' },
	'assignmb-d17funcbutton' => { 282 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 282 => '68.1' },
	'assignmb-d18af-onbutton' => { 292 => '79.1' },
	'assignmb-d18funcbutton' => { 292 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 292 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 281 => '75.1', 282 => '75.1', 292 => '75.1' },
	'assignmoviefunc2button' => { 281 => '82.1', 282 => '82.1', 292 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 281 => '75.2', 282 => '75.2', 292 => '75.2' },
	'assignmovierecordbutton' => { 279 => '43.2', 291 => '45.1', 294 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 281 => '45.1', 282 => '45.1', 292 => '45.1' },
	'assignmoviesubselector' => { 281 => '74.1', 282 => '74.1', 292 => '74.1' },
	'assignmoviesubselectorplusdials' => { 281 => '76.1', 282 => '76.1', 292 => '76.1' },
	'assignremotefnbutton' => { 279 => '54.1', 291 => '51.1' },
	'assistbuttonfunction' => { 81 => 0xd },
	'atcaptureusercrop' => { 137 => 0x943 },
	'attributionname' => { 474 => 'attributionName' },
	'attributionurl' => { 474 => 'attributionURL' },
	'audio' => { 319 => 0x20 },
	'audiobitrate' => { 66 => 0x6c, 488 => 'audioBitRate' },
	'audiobitratemode' => { 488 => 'audioBitRateMode' },
	'audiobitspersample' => { 488 => 'audioBitsPerSample' },
	'audiobutton' => { 294 => 0x17b },
	'audiobuttonplaybackmode' => { 294 => 0x1b9 },
	'audiochannelcount' => { 488 => 'audioChannelCount' },
	'audiochannels' => { 66 => 0x70 },
	'audiochanneltype' => { 502 => 'audioChannelType' },
	'audiocompression' => { 83 => 0x816, 154 => 'Compression' },
	'audiocompressor' => { 502 => 'audioCompressor' },
	'audiodata' => { 458 => 'Data' },
	'audioduration' => { 130 => 0x99 },
	'audiogain' => { 373 => 'player.movie.audio.gain' },
	'audiomimetype' => { 458 => 'Mime' },
	'audiomoddate' => { 502 => 'audioModDate' },
	'audiooutcue' => { 130 => 0x9a },
	'audiosamplerate' => { 66 => 0x6e, 502 => 'audioSampleRate' },
	'audiosampletype' => { 502 => 'audioSampleType' },
	'audiosamplingrate' => { 130 => 0x97 },
	'audiosamplingresolution' => { 130 => 0x98 },
	'audiotype' => { 130 => 0x96 },
	'author' => { 156 => 'Author', 305 => 'Author', 309 => 'Author', 370 => 'Author', 371 => ['auth',"\xa9aut"], 373 => 'author', 379 => 'auth', 471 => 'author', 489 => 'Author', 500 => 'Author' },
	'authorsposition' => { 490 => 'AuthorsPosition' },
	'authorurl' => { 178 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 83 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 345 => '0.1' },
	'autobracket' => { 396 => 0x19 },
	'autobracketing' => { 126 => 0x1100, 354 => 0x18, 386 => 0x1007 },
	'autobracketingmode' => { 290 => '12.3' },
	'autobracketingset' => { 290 => '12.1' },
	'autobracketmodem' => { 278 => '21.2', 279 => '13.3', 281 => '13.2', 282 => '13.2', 287 => '26.2', 291 => '13.3', 292 => '13.2', 294 => 0x5f },
	'autobracketorder' => { 183 => 0x43, 278 => '21.3', 279 => '13.2', 281 => '13.1', 282 => '13.1', 287 => '26.3', 288 => '12.2', 289 => '2.2', 290 => '12.2', 291 => '13.2', 292 => '13.1', 293 => '13.2', 294 => 0x61 },
	'autobracketset' => { 278 => '21.1', 279 => '13.1', 283 => '11.1', 284 => '12.1', 285 => '12.1', 287 => '26.1', 288 => '12.1', 289 => '2.1', 291 => '13.1', 293 => '13.1' },
	'autobrightness' => { 476 => 'AutoBrightness', 478 => 'AutoBrightness' },
	'autocontrast' => { 476 => 'AutoContrast', 478 => 'AutoContrast' },
	'autodistortioncontrol' => { 205 => 0x4, 227 => 0x143 },
	'autodynamicrange' => { 126 => 0x140b },
	'autoexposure' => { 476 => 'AutoExposure', 478 => 'AutoExposure' },
	'autoexposurebracketing' => { 76 => 0x10 },
	'autoflashisosensitivity' => { 281 => '38.5', 282 => '38.5', 292 => '38.5', 294 => 0x5b },
	'autofocus' => { 299 => 0x209 },
	'autofocusmoderestrictions' => { 294 => 0x107 },
	'autofp' => { 289 => '7.3', 293 => '31.4' },
	'autoiso' => { 76 => 0x1, 112 => 0x3008, 228 => 0x142, 280 => '1.1', 289 => '1.1' },
	'autoisomax' => { 280 => '1.2', 289 => '1.2' },
	'autoisominshutterspeed' => { 280 => '1.3', 289 => '1.3' },
	'autolateralca' => { 476 => 'AutoLateralCA', 478 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 62 => 0x2, 83 => 0x204, 102 => 0x20500, 108 => 0x6f },
	'autolightingoptimizeron' => { 102 => '0x20500.0', 108 => 0x6e },
	'autoportraitframed' => { 419 => 0x2016 },
	'autoredeye' => { 271 => 0xfe28a44f },
	'autorotate' => { 76 => 0x1b },
	'autoshadows' => { 476 => 'AutoShadows', 478 => 'AutoShadows' },
	'autotone' => { 476 => 'AutoTone', 478 => 'AutoTone' },
	'autotonedigest' => { 476 => 'AutoToneDigest', 478 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 476 => 'AutoToneDigestNoSat', 478 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 476 => 'AutoWhiteVersion', 478 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 225 => 0x82 },
	'avaperturesetting' => { 335 => 0x13 },
	'averageblacklevel' => { 45 => 0xe7, 47 => 0xfb, 48 => 0x114, 49 => 0x146 },
	'averagelv' => { 186 => 0x38 },
	'avsettingwithoutlens' => { 83 => 0x707 },
	'azimuth' => { 164 => 'Azimuth' },
	'babyage' => { 319 => [0x8010,0x33] },
	'babyname' => { 319 => 0x66 },
	'backgroundalpha' => { 497 => 'bgalpha' },
	'balance' => { 373 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 335 => 0x15 },
	'baseiso' => { 76 => 0x2, 96 => 0x101c, 137 => 0x903, 321 => 0x312a, 449 => 0x6 },
	'baseisodaylight' => { 137 => 0x910 },
	'baseisoflash' => { 137 => 0x913 },
	'baseisofluorescent' => { 137 => 0x912 },
	'baseisotungsten' => { 137 => 0x911 },
	'baselineexposure' => { 118 => 0xc62a },
	'baselineexposureoffset' => { 118 => 0xc7a5 },
	'baselinenoise' => { 118 => 0xc62b },
	'baselinesharpness' => { 118 => 0xc62c },
	'baseurl' => { 500 => 'BaseURL' },
	'bass' => { 373 => 'player.movie.audio.bass' },
	'batterylevel' => { 319 => 0x38, 406 => 0x51, 410 => 0xc, 411 => 0x4, 412 => 0x4, 450 => 0x7 },
	'batterylevelgrip1' => { 450 => 0x6 },
	'batterylevelgrip2' => { 450 => 0x8 },
	'batteryorder' => { 278 => '12.5', 287 => '13.2', 288 => '2.1', 291 => '3.1' },
	'batterystate' => { 183 => 0x60, 406 => 0x50, 412 => 0x14 },
	'batterytemperature' => { 410 => 0x1, 412 => 0x2, 450 => 0x5 },
	'batterytype' => { 63 => 0x38, 382 => 0x66 },
	'batteryunknown' => { 410 => 0x2, 412 => 0x0 },
	'batteryvoltage' => { 137 => 0x408, 380 => 0x2a, 381 => 0x49, 382 => 0x62, 410 => 0x8 },
	'batteryvoltage1' => { 412 => 0x6 },
	'batteryvoltage2' => { 412 => 0x8 },
	'batteryvoltageavg' => { 382 => 0x64 },
	'bayergreensplit' => { 118 => 0xc62d },
	'bayerpattern' => { 136 => 0xf902, 187 => 0x17 },
	'beatsperminute' => { 371 => 'tmpo' },
	'beatspliceparams' => { 502 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 502 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 502 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 502 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 502 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 502 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 278 => '13.1', 279 => '5.4', 280 => '0.1', 283 => '2.1', 284 => '3.1', 285 => '3.1', 287 => '10.1', 289 => '0.1', 291 => '5.5', 293 => '4.1' },
	'beeppitch' => { 288 => '3.1' },
	'beepvolume' => { 288 => '4.5' },
	'bestqualityscale' => { 118 => 0xc65c },
	'bestshotmode' => { 112 => 0x3007 },
	'bitdepth' => { 161 => 'BitDepth', 187 => 0x11, 236 => 0x41 },
	'bitspercomponent' => { 132 => 0x87 },
	'bitspersample' => { 118 => 0x102, 324 => 0xa, 498 => 'BitsPerSample' },
	'blackacquirerows' => { 137 => 0x18ba },
	'blacklevel' => { 118 => 0xc61a, 203 => 0x20, 225 => 0x3d, 301 => [0x401,0x1012], 363 => 0x21d },
	'blacklevel2' => { 300 => 0x600, 304 => 0x600 },
	'blacklevelblue' => { 324 => 0x1e },
	'blacklevelbottom' => { 137 => 0x3f0 },
	'blackleveldata' => { 363 => 0x223 },
	'blackleveldeltah' => { 118 => 0xc61b },
	'blackleveldeltav' => { 118 => 0xc61c },
	'blacklevelgreen' => { 324 => 0x1d },
	'blacklevelred' => { 324 => 0x1c },
	'blacklevelrepeatdim' => { 118 => 0xc619 },
	'blacklevelrough' => { 137 => 0x40e },
	'blacklevelroughafter' => { 137 => 0x416 },
	'blacklevels' => { 35 => 0x1d },
	'blackleveltop' => { 137 => 0x3ef },
	'blackpoint' => { 354 => 0x200 },
	'blacks2012' => { 476 => 'Blacks2012', 478 => 'Blacks2012' },
	'blacksadj' => { 453 => 0x9018 },
	'bleachbypasstoning' => { 354 => 0x7f },
	'blockshotafresponse' => { 281 => '1.5', 282 => '1.5', 292 => '1.5', 294 => 0x7 },
	'blogtitle' => { 492 => 'blogTitle' },
	'blogurl' => { 492 => 'blogURL' },
	'bluebalance' => { 301 => 0x1018, 324 => 0x12, 354 => 0x1b },
	'bluecurvelimits' => { 107 => 0x1fe },
	'bluecurvepoints' => { 106 => 0x79, 107 => 0x1d4 },
	'bluehsl' => { 102 => 0x20915 },
	'bluehue' => { 476 => 'BlueHue', 478 => 'BlueHue' },
	'bluesaturation' => { 476 => 'BlueSaturation', 478 => 'BlueSaturation' },
	'bluratinfinity' => { 462 => 'BlurAtInfinity' },
	'blurcontrol' => { 354 => 0x82 },
	'blurwarning' => { 126 => 0x1300 },
	'bodybatteryadload' => { 333 => 0x3 },
	'bodybatteryadnoload' => { 333 => 0x2 },
	'bodybatterystate' => { 333 => '1.1' },
	'bodybatteryvoltage1' => { 333 => 0x2 },
	'bodybatteryvoltage2' => { 333 => 0x4 },
	'bodybatteryvoltage3' => { 333 => 0x6 },
	'bodybatteryvoltage4' => { 333 => 0x8 },
	'bodyfirmware' => { 387 => 0x0 },
	'bodyfirmwareversion' => { 297 => 0x104, 298 => 0x100, 301 => 0x104 },
	'bodyserialnumber' => { 387 => 0x10 },
	'bookedition' => { 492 => 'bookEdition' },
	'bootloaderversion' => { 381 => 0x26 },
	'bracketincrement' => { 228 => 0x21a },
	'bracketmode' => { 57 => 0x3 },
	'bracketprogram' => { 228 => 0x218 },
	'bracketsequence' => { 112 => 0x301d },
	'bracketset' => { 228 => 0x216 },
	'bracketsettings' => { 319 => 0x45 },
	'bracketshotnumber' => { 57 => 0x5, 335 => 0x9, 417 => 0x2b },
	'bracketshotnumber2' => { 417 => 0x2d },
	'bracketstep' => { 180 => 0xe },
	'bracketvalue' => { 57 => 0x4 },
	'brightness' => { 118 => 0xfe53, 155 => 'Brightness', 175 => 'Brightness', 180 => 0x2c, 230 => 0x34, 231 => 0x39, 232 => 0x41, 373 => 'player.movie.visual.brightness', 380 => 0x25, 382 => 0x54, 406 => 0x22, 419 => 0x2007, 476 => 'Brightness', 478 => 'Brightness' },
	'brightnessadj' => { 107 => 0x114, 264 => 0x0, 274 => 0x2d, 453 => 0x8018 },
	'brightnessvalue' => { 118 => 0x9203, 186 => [0x691,0x49c3], 301 => 0x1003, 424 => 0x1e, 427 => 0x1140, 428 => 0x1140, 429 => 0x111c, 430 => 0x1198, 431 => 0x1174, 432 => 0x102c, 433 => 0x224, 434 => 0x224, 435 => 0x219, 482 => 'BrightnessValue' },
	'buildnumber' => { 190 => 0x5500 },
	'bulbduration' => { 76 => 0x18 },
	'burstcount' => { 137 => 0x40d },
	'burstid' => { 459 => 'BurstID' },
	'burstmode' => { 139 => 0xa, 319 => 0x2a },
	'burstmode2' => { 139 => 0x18 },
	'burstprimary' => { 459 => 'BurstPrimary' },
	'burstshot' => { 396 => 0x34 },
	'burstspeed' => { 319 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 83 => 0x70a },
	'bwadjustment' => { 126 => 0x1049 },
	'bwfilter' => { 180 => 0x2a, 188 => 0x39 },
	'bwmode' => { 301 => 0x203 },
	'by-line' => { 130 => 0x50 },
	'by-linetitle' => { 130 => 0x55 },
	'bytecount' => { 492 => 'byteCount' },
	'c14configuration' => { 137 => 0x1964 },
	'cacheversion' => { 118 => 0xc7aa },
	'calibratedfocallength' => { 115 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 115 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 115 => 'CalibratedOpticalCenterY' },
	'calibration' => { 396 => [0x24,0x30] },
	'calibrationhistory' => { 137 => 0x9c9 },
	'calibrationilluminant1' => { 118 => 0xc65a },
	'calibrationilluminant2' => { 118 => 0xc65b },
	'calibrationilluminant3' => { 118 => 0xcd31 },
	'calibrationversion' => { 137 => 0x9c6 },
	'callforimage' => { 466 => 'CallForImage' },
	'camera' => { 456 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 379 => 'angl', 502 => 'cameraAngle' },
	'cameraappinfo' => { 456 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 456 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 456 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 456 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 460 => 'CameraBurstID' },
	'cameracalibration' => { 396 => 0x11f },
	'cameracalibration1' => { 118 => 0xc623 },
	'cameracalibration2' => { 118 => 0xc624 },
	'cameracalibration3' => { 118 => 0xcd32 },
	'cameracalibrationsig' => { 118 => 0xc6f3 },
	'cameracolorcalibration01' => { 36 => 0x0, 37 => 0x0 },
	'cameracolorcalibration02' => { 36 => 0x4, 37 => 0x5 },
	'cameracolorcalibration03' => { 36 => 0x8, 37 => 0xa },
	'cameracolorcalibration04' => { 36 => 0xc, 37 => 0xf },
	'cameracolorcalibration05' => { 36 => 0x10, 37 => 0x14 },
	'cameracolorcalibration06' => { 36 => 0x14, 37 => 0x19 },
	'cameracolorcalibration07' => { 36 => 0x18, 37 => 0x1e },
	'cameracolorcalibration08' => { 36 => 0x1c, 37 => 0x23 },
	'cameracolorcalibration09' => { 36 => 0x20, 37 => 0x28 },
	'cameracolorcalibration10' => { 36 => 0x24, 37 => 0x2d },
	'cameracolorcalibration11' => { 36 => 0x28, 37 => 0x32 },
	'cameracolorcalibration12' => { 36 => 0x2c, 37 => 0x37 },
	'cameracolorcalibration13' => { 36 => 0x30, 37 => 0x3c },
	'cameracolorcalibration14' => { 36 => 0x34, 37 => 0x41 },
	'cameracolorcalibration15' => { 36 => 0x38, 37 => 0x46 },
	'cameradepthmap' => { 456 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 456 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 456 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 456 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 456 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 456 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 456 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 456 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 456 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 456 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 456 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 456 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 373 => 'direction.facing' },
	'camerae-mountversion' => { 452 => 0xb },
	'cameraelevationangle' => { 118 => 0x9405, 483 => 'CameraElevationAngle' },
	'camerafilename' => { 466 => 'CameraFilename' },
	'cameraid' => { 301 => 0x209, 379 => 'cmid', 395 => 0x209 },
	'cameraidentifier' => { 373 => 'camera.identifier' },
	'cameraimage' => { 456 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 456 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 456 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 456 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 456 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 456 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 456 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 456 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 456 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 456 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 456 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 456 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 456 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 456 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 34 => 0x10 },
	'cameralabel' => { 118 => 0xc7a1, 502 => 'cameraLabel' },
	'cameralightestimate' => { 456 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 456 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 456 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 456 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 456 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 466 => 'CameraMakeModel' },
	'cameramodel' => { 363 => 0x410, 502 => 'cameraModel' },
	'cameramodelid' => { 175 => 'CameraModelID' },
	'cameramodelrestriction' => { 476 => 'CameraModelRestriction', 478 => 'CameraModelRestriction' },
	'cameramotion' => { 373 => 'direction.motion' },
	'cameramove' => { 502 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 319 => 0x8f, 358 => 0x1, 363 => 0x100, 412 => [0x16,0x18], 440 => 0x28, 441 => 0x24, 442 => 0x29 },
	'cameraowner' => { 140 => 0xc353 },
	'cameraparameters' => { 301 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 114 => 0x9, 379 => "\xa9gpt" },
	'camerapointcloud' => { 456 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 456 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 456 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 456 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 456 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 456 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 456 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 456 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 456 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 456 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 456 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 456 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 456 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 476 => 'CameraProfile', 478 => 'CameraProfile' },
	'cameraprofiledigest' => { 476 => 'CameraProfileDigest', 478 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 108 => 0xe1 },
	'camerarawcontrast' => { 108 => 0xe3 },
	'camerarawhighlightpoint' => { 108 => 0xe6 },
	'camerarawlinear' => { 108 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 108 => 0xe8 },
	'camerarawoutputshadowpoint' => { 108 => 0xe9 },
	'camerarawsaturation' => { 108 => 0xe2 },
	'camerarawshadowpoint' => { 108 => 0xe7 },
	'camerarawsharpness' => { 108 => 0xe5 },
	'cameraroll' => { 114 => 0xb, 379 => "\xa9grl" },
	'cameras' => { 456 => 'Cameras' },
	'cameraserialnumber' => { 118 => 0xc62f, 177 => 'CameraSerialNumber', 466 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 296 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 30 => [0x87,0x91], 31 => [0x99,0x9f,0xa4,0xa8,0x105], 33 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 76 => 0xc, 137 => 0x406, 300 => 0x1306, 314 => 0x320, 321 => 0x3402, 354 => 0x47, 393 => 0x43, 444 => 0x5 },
	'cameratemperature4' => { 359 => 0x14 },
	'cameratemperature5' => { 359 => 0x16 },
	'cameratemperaturerangemax' => { 120 => 0x5 },
	'cameratemperaturerangemin' => { 120 => 0x6 },
	'cameratrait' => { 456 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 76 => 0x1a, 301 => 0x207 },
	'cameratype2' => { 297 => 0x100 },
	'cameravendorinfo' => { 456 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 456 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 456 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 456 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 114 => 0xa, 379 => "\xa9gyw" },
	'camreverse' => { 115 => 'CamReverse' },
	'canondr4' => { 119 => 'CanonDR4' },
	'canonexposuremode' => { 34 => 0x14 },
	'canonfiledescription' => { 96 => 0x805 },
	'canonfilelength' => { 63 => 0xe },
	'canonfirmwareversion' => { 63 => 0x7, 96 => 0x80b },
	'canonflashinfo' => { 96 => 0x1028 },
	'canonflashmode' => { 34 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 34 => 0xa },
	'canonimagetype' => { 63 => 0x6, 96 => 0x815 },
	'canonmodelid' => { 63 => 0x10, 96 => 0x1834 },
	'canonvrd' => { 119 => 'CanonVRD' },
	'caption' => { 471 => 'caption' },
	'caption-abstract' => { 130 => 0x78 },
	'captionsauthornames' => { 481 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 481 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 490 => 'CaptionWriter' },
	'captureframerate' => { 112 => 0x4001 },
	'captureheightnormal' => { 137 => 0x1839 },
	'capturelook' => { 137 => 0xc48 },
	'capturemode' => { 373 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 464 => 'CaptureSoftware' },
	'capturewidthnormal' => { 137 => 0x1838 },
	'capturewidthtest' => { 137 => 0x1842 },
	'cardshutterlock' => { 183 => 0x49 },
	'casioimagesize' => { 112 => 0x9 },
	'catalogsets' => { 130 => 0xff, 457 => 'CatalogSets', 469 => 'CatalogSets' },
	'categories' => { 63 => 0x23, 471 => 'categories' },
	'category' => { 130 => 0xf, 178 => 'WM/Category', 295 => 0x30, 371 => 'catg', 490 => 'Category' },
	'cbcrgain' => { 393 => 0xa036 },
	'cbcrgaindefault' => { 393 => 0xa035 },
	'cbcrmatrix' => { 393 => 0xa034 },
	'cbcrmatrixdefault' => { 393 => 0xa033 },
	'ccdboardversion' => { 314 => 0x331 },
	'ccdscanmode' => { 301 => 0x1039 },
	'ccdsensitivity' => { 261 => 0x6 },
	'ccdversion' => { 314 => 0x330 },
	'cellglobalid' => { 475 => 'cgi' },
	'celllength' => { 118 => 0x109 },
	'cellr' => { 475 => 'r' },
	'celltowerid' => { 475 => 'cellid' },
	'cellwidth' => { 118 => 0x108 },
	'centerafarea' => { 289 => '15.1' },
	'centerfocuspoint' => { 293 => '2.2' },
	'centerpixel' => { 137 => 0x40c },
	'centerweightedareasize' => { 278 => '7.1', 279 => '8.1', 281 => '8.1', 282 => '8.1', 286 => '7.1', 287 => '5.1', 288 => '7.1', 289 => '6.3', 291 => '8.1', 292 => '8.1', 293 => '8.1', 294 => 0x1f },
	'certificate' => { 506 => 'Certificate' },
	'cfainterpolationalgorithm' => { 137 => 0xe60 },
	'cfainterpolationmetric' => { 137 => 0xe61 },
	'cfaoffsetcols' => { 137 => 0xc71 },
	'cfaoffsetrows' => { 137 => 0xc6f },
	'cfapattern' => { 118 => 0xa302, 324 => 0x9, 482 => 'CFAPattern' },
	'cfapattern2' => { 118 => 0x828e },
	'cfapatterncolumns' => { 482 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 482 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 482 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 118 => 0x828d },
	'cfazipperfixthreshold' => { 137 => 0xe62 },
	'channel' => { 492 => 'channel' },
	'channela-lang' => { 492 => [\'channel','channelA-lang'] },
	'channelchannel' => { 492 => [\'channel','channelChannel'] },
	'channels' => { 154 => 'Channels' },
	'channelsubchannel1' => { 492 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 492 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 492 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 492 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 379 => 'chpl' },
	'checkmark' => { 102 => 0x10101, 107 => 0x26a },
	'checkmark2' => { 108 => 0x8e },
	'childfontfiles' => { 507 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 278 => '10.3', 279 => '11.2', 294 => 0x10b },
	'chromablurradius' => { 118 => 0xc631 },
	'chromanoisecolorspace' => { 137 => 0xe6d },
	'chromanoiseedgemapthresh' => { 137 => 0xe6c },
	'chromanoisehighfthresh' => { 137 => 0xe6a },
	'chromanoiselowfthresh' => { 137 => 0xe6b },
	'chromaticaberration' => { 102 => 0x20703, 108 => 0x66, 393 => 0xa051 },
	'chromaticaberrationb' => { 476 => 'ChromaticAberrationB', 478 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 102 => 0x20708, 108 => 0x6b },
	'chromaticaberrationcorr' => { 78 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 118 => 0x7034, 344 => 0x1, 453 => 0x900d },
	'chromaticaberrationcorrparams' => { 118 => 0x7035, 448 => 0x66a, 449 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 102 => '0x20703.0', 108 => 0x62 },
	'chromaticaberrationr' => { 476 => 'ChromaticAberrationR', 478 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 102 => 0x20707, 108 => 0x6a },
	'chromaticaberrationsetting' => { 79 => 0x6 },
	'chrominancenoisereduction' => { 102 => 0x20601, 108 => 0x5e, 396 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 108 => 0x60 },
	'circadatecreated' => { 488 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 476 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 478 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 476 => 'CircularGradientBasedCorrections', 478 => 'CircularGradientBasedCorrections' },
	'city' => { 130 => 0x5a, 160 => 'City', 319 => 0x6d, 490 => 'City' },
	'city2' => { 319 => 0x80 },
	'clarity' => { 231 => 0x35, 232 => 0x3d, 419 => 0x2036, 476 => 'Clarity', 478 => 'Clarity' },
	'clarity2012' => { 476 => 'Clarity2012', 478 => 'Clarity2012' },
	'claritycontrol' => { 354 => 0x96 },
	'classification' => { 379 => 'clsf' },
	'classifystate' => { 130 => 0xe1 },
	'clearretouch' => { 319 => 0x7c },
	'clearretouchvalue' => { 319 => 0xa3 },
	'client' => { 502 => 'client' },
	'clientname' => { 484 => 'ClientName' },
	'clipboardaspectratio' => { 476 => 'ClipboardAspectRatio', 478 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 476 => 'ClipboardOrientation', 478 => 'ClipboardOrientation' },
	'clipfilename' => { 379 => 'clfn' },
	'clipid' => { 379 => 'clid' },
	'clmodeshootingspeed' => { 278 => '10.2', 279 => '11.3', 281 => '11.2', 282 => '11.2', 287 => '11.2', 288 => '10.2', 291 => '11.2', 292 => '11.2', 293 => '11.1', 294 => 0x3b },
	'cluster' => { 476 => 'Cluster', 478 => 'Cluster' },
	'cmcontrast' => { 304 => 0x2022 },
	'cmddialsreverserotation' => { 294 => 0xba },
	'cmexposurecompensation' => { 304 => 0x2000 },
	'cmhue' => { 304 => 0x2021 },
	'cmsaturation' => { 304 => 0x2020 },
	'cmsharpness' => { 304 => 0x2023 },
	'cmwhitebalance' => { 304 => 0x2001 },
	'cmwhitebalancecomp' => { 304 => 0x2002 },
	'cmwhitebalancegraypoint' => { 304 => 0x2010 },
	'codec' => { 168 => 'Codec' },
	'codedcharacterset' => { 131 => 0x5a },
	'codeversion' => { 379 => 'cver' },
	'collection' => { 309 => 'Collection' },
	'collectionname' => { 169 => [\'Collections','CollectionsCollectionName'], 379 => 'coll' },
	'collections' => { 169 => 'Collections', 471 => 'collections' },
	'collectionuri' => { 169 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 373 => 'player.movie.visual.color', 491 => 'color' },
	'coloraberrationcontrol' => { 271 => 0xc89224b },
	'coloradjustment' => { 396 => 0x14 },
	'coloradjustmentmode' => { 395 => 0x210 },
	'coloranta' => { 507 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 507 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 507 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 507 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 507 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 507 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 507 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 507 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 507 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 507 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 507 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 507 => 'Colorants' },
	'colorantswatchname' => { 507 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 507 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 507 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 507 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 155 => 'ColorBalance' },
	'colorbalanceadj' => { 271 => 0x76a43202 },
	'colorbalanceblue' => { 180 => 0x1e },
	'colorbalancegreen' => { 180 => 0x1d },
	'colorbalancered' => { 180 => 0x1c },
	'colorbalanceversion' => { 202 => 0x4, 203 => 0x4, 204 => 0x0 },
	'colorblur' => { 108 => 0x65 },
	'colorbluron' => { 102 => 0x20704 },
	'colorbooster' => { 271 => 0x5f0e7d23 },
	'colorboostlevel' => { 265 => 0x1 },
	'colorboosttype' => { 265 => 0x0 },
	'colorchromeeffect' => { 126 => 0x1048 },
	'colorchromefxblue' => { 126 => 0x104e },
	'colorclass' => { 365 => 0xde, 366 => 'ColorClass' },
	'colorcompensationfilter' => { 183 => [0x3a,0x5f], 185 => 0x111, 419 => 0xb022 },
	'colorcompensationfiltercustom' => { 406 => 0xd, 407 => 0xc },
	'colorcompensationfilterset' => { 406 => 0x8, 407 => 0x7, 408 => 0x18, 424 => 0xf },
	'colorcontrol' => { 301 => 0x102b },
	'colorcorrection' => { 453 => 0x8015 },
	'colorcreatoreffect' => { 296 => 0x532 },
	'colordataversion' => { 41 => 0x0, 42 => 0x0, 44 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0 },
	'coloreffect' => { 319 => 0x28 },
	'colorfilter' => { 111 => 0x17, 112 => 0x3017, 180 => 0x29, 188 => [0x38,0x4d,0x4f], 361 => 0x17 },
	'colorgain' => { 236 => 0x51 },
	'colorgradeblending' => { 476 => 'ColorGradeBlending', 478 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 476 => 'ColorGradeGlobalHue', 478 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 476 => 'ColorGradeGlobalLum', 478 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 476 => 'ColorGradeGlobalSat', 478 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 476 => 'ColorGradeHighlightLum', 478 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 476 => 'ColorGradeMidtoneHue', 478 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 476 => 'ColorGradeMidtoneLum', 478 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 476 => 'ColorGradeMidtoneSat', 478 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 476 => 'ColorGradeShadowLum', 478 => 'ColorGradeShadowLum' },
	'colorhue' => { 102 => 0x20900, 225 => 0x8d },
	'colorimetricreference' => { 118 => 0xc6bf },
	'colorlabel' => { 481 => 'ColorLabel' },
	'colormatrix' => { 300 => 0x200, 301 => 0x1011, 393 => 0xa030 },
	'colormatrix1' => { 118 => 0xc621, 363 => 0x106 },
	'colormatrix2' => { 118 => 0xc622, 304 => 0x200, 363 => 0x226 },
	'colormatrix3' => { 118 => 0xcd33 },
	'colormatrixa' => { 354 => 0x203 },
	'colormatrixa2' => { 354 => 0x21c },
	'colormatrixadobergb' => { 393 => 0xa032 },
	'colormatrixb' => { 354 => 0x204 },
	'colormatrixb2' => { 354 => 0x21d },
	'colormatrixnumber' => { 301 => 0x1019 },
	'colormatrixsrgb' => { 393 => 0xa031 },
	'colormode' => { 112 => 0x3015, 126 => 0x1210, 139 => 0x66, 180 => 0x28, 183 => 0x16, 185 => 0x101, 186 => 0x36, 188 => 0x7, 225 => 0x3, 261 => 0x4, 319 => 0x32, 396 => 0x2c, 419 => 0xb029, 490 => 'ColorMode' },
	'colormoirereduction' => { 102 => 0x20670, 272 => 0x15 },
	'colormoirereductionmode' => { 272 => 0x5 },
	'colormoirereductionon' => { 102 => '0x20670.0' },
	'colornoisereduction' => { 453 => 0x8029, 476 => 'ColorNoiseReduction', 478 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 476 => 'ColorNoiseReductionDetail', 478 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 272 => 0x18 },
	'colornoisereductionsharpness' => { 272 => 0x1c },
	'colornoisereductionsmoothness' => { 476 => 'ColorNoiseReductionSmoothness', 478 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 122 => 0x2 },
	'colorprofile' => { 180 => 0x33 },
	'colorprofilesettings' => { 296 => 0x539 },
	'colorrepresentation' => { 132 => 0x3c },
	'colorsaturationadj' => { 102 => 0x20305 },
	'colorsequence' => { 132 => 0x41 },
	'colorspace' => { 51 => 0x3, 63 => 0xb4, 96 => 0x10b4, 118 => 0xa001, 134 => 0x3, 161 => 'ColorSpace', 181 => 0x2f, 182 => 0x25, 183 => 0x17, 225 => 0x1e, 296 => 0x507, 354 => 0x37, 393 => 0xa011, 396 => 0xb, 406 => 0x1b, 407 => 0x83, 408 => 0xe, 424 => 0x6, 482 => 'ColorSpace' },
	'colorspecapproximation' => { 134 => 0x2 },
	'colorspecdata' => { 134 => 0x3 },
	'colorspecmethod' => { 134 => 0x0 },
	'colorspecprecedence' => { 134 => 0x1 },
	'colortempasshot' => { 38 => 0x4, 39 => 0x7, 40 => 0x1d, 41 => 0x59, 42 => 0x6d, 43 => 0x26, 44 => 0x43, 47 => 0x43, 48 => 0x43, 49 => 0x43, 50 => 0x4b },
	'colortempauto' => { 38 => 0x9, 39 => 0xf, 40 => 0x22, 41 => 0x5e, 42 => 0x72, 43 => 0x1c, 44 => 0x48, 47 => 0x48, 48 => 0x48, 49 => 0x48, 50 => 0x50 },
	'colortempcloudy' => { 38 => 0x22, 39 => 0x37, 40 => 0x31, 41 => 0xa4, 42 => 0xdb, 43 => 0x35, 44 => 0x5c, 47 => 0x75, 48 => 0x8e, 49 => 0x93, 50 => 0x96, 354 => 0x55 },
	'colortempcustom' => { 44 => 0x84 },
	'colortempcustom1' => { 40 => 0x45 },
	'colortempcustom2' => { 40 => 0x4a },
	'colortempdaylight' => { 38 => 0x18, 39 => 0x27, 40 => 0x27, 41 => 0x9a, 42 => 0xd1, 43 => 0x2b, 44 => 0x52, 47 => 0x6b, 48 => 0x84, 49 => 0x89, 50 => 0x8c, 354 => 0x53 },
	'colortemperature' => { 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 63 => 0xae, 73 => 0x9, 96 => 0x10ae, 126 => 0x1005, 137 => 0x846, 155 => 'ColorTemperature', 181 => [0x6e,0x49], 182 => 0x3f, 183 => [0x39,0x5e], 185 => 0x10b, 188 => [0x3c,0x4c,0x4e], 314 => 0x321, 354 => 0x50, 386 => 0x1308, 419 => 0xb021, 476 => 'Temperature', 478 => 'Temperature' },
	'colortemperatureadj' => { 453 => 0x8013 },
	'colortemperatureauto' => { 225 => 0x4f },
	'colortemperaturebg' => { 301 => 0x1013 },
	'colortemperaturecustom' => { 406 => 0xc, 407 => 0xb },
	'colortemperaturerg' => { 301 => 0x1014 },
	'colortemperatureset' => { 406 => 0x7, 407 => 0x6 },
	'colortemperaturesetting' => { 183 => 0x25, 408 => 0x17, 424 => 0xe },
	'colortempflash' => { 38 => 0x36, 39 => 0x57, 40 => 0x40, 41 => 0xb8, 42 => 0xef, 43 => 0x49, 44 => 0x70, 47 => 0x89, 48 => 0xa2, 49 => 0xa7, 50 => 0xaa, 354 => 0x5a },
	'colortempflashdata' => { 44 => 0x24a },
	'colortempfluorescent' => { 38 => 0x2c, 39 => 0x47, 40 => 0x3b, 41 => 0xae, 42 => 0xe5, 43 => 0x3f, 44 => 0x66, 47 => 0x7f, 48 => 0x98, 49 => 0x9d, 50 => 0xa0 },
	'colortempfluorescentd' => { 354 => 0x57 },
	'colortempfluorescentn' => { 354 => 0x58 },
	'colortempfluorescentw' => { 354 => 0x59 },
	'colortempkelvin' => { 38 => 0x31, 39 => 0x4f, 41 => 0xb3, 42 => 0xea, 43 => 0x44, 44 => 0x6b, 47 => 0x84, 48 => 0x9d, 49 => 0xa2, 50 => 0xa5, 319 => 0x44, 386 => 0x1307 },
	'colortempmeasured' => { 38 => 0xe, 39 => 0x17, 41 => 0x63, 42 => 0x77, 44 => 0x4d, 47 => 0x4d, 48 => 0x4d, 49 => 0x4d, 50 => 0x55 },
	'colortemppc1' => { 43 => 0x94, 44 => 0x75 },
	'colortemppc2' => { 43 => 0x99, 44 => 0x7a },
	'colortemppc3' => { 43 => 0x9e, 44 => 0x7f },
	'colortempshade' => { 38 => 0x1d, 39 => 0x2f, 40 => 0x2c, 41 => 0x9f, 42 => 0xd6, 43 => 0x30, 44 => 0x57, 47 => 0x70, 48 => 0x89, 49 => 0x8e, 50 => 0x91, 354 => 0x54 },
	'colortemptungsten' => { 38 => 0x27, 39 => 0x3f, 40 => 0x36, 41 => 0xa9, 42 => 0xe0, 43 => 0x3a, 44 => 0x61, 47 => 0x7a, 48 => 0x93, 49 => 0x98, 50 => 0x9b, 354 => 0x56 },
	'colortempunknown' => { 38 => 0x13, 39 => 0x1f, 41 => 0x68, 42 => 0x7c, 43 => 0x21, 47 => 0x52, 48 => 0x52, 49 => 0x52, 50 => 0x5a },
	'colortempunknown10' => { 38 => 0x63, 39 => 0x9f, 41 => 0x95, 42 => 0xa9, 43 => 0x76, 47 => 0xa2, 48 => 0x7f, 49 => 0x7f, 50 => 0x87 },
	'colortempunknown11' => { 38 => 0x68, 39 => 0xa7, 41 => 0xbd, 42 => [0xae,0xb3], 43 => 0x7b, 47 => 0xa7, 48 => 0xa7, 49 => 0x84, 50 => 0xaf },
	'colortempunknown12' => { 38 => 0x6d, 39 => 0xaf, 41 => 0xc2, 42 => 0xb8, 43 => 0x80, 47 => 0xac, 48 => 0xac, 49 => 0xac, 50 => 0xb4 },
	'colortempunknown13' => { 38 => 0x72, 39 => 0xb7, 41 => 0xc7, 42 => 0xbd, 43 => 0x85, 47 => 0xb1, 48 => 0xb1, 49 => 0xb1, 50 => 0xb9 },
	'colortempunknown14' => { 41 => 0xcc, 42 => 0xc2, 43 => 0x8a, 47 => 0xb6, 48 => 0xb6, 49 => 0xb6, 50 => 0xbe },
	'colortempunknown15' => { 41 => 0xd1, 42 => 0xc7, 43 => 0x8f, 47 => 0xbb, 48 => 0xbb, 49 => 0xbb, 50 => 0xc3 },
	'colortempunknown16' => { 41 => 0xd6, 42 => 0xcc, 43 => 0xa3, 48 => 0xc0, 49 => 0xc0, 50 => 0xc8 },
	'colortempunknown17' => { 41 => 0xdb, 42 => 0xf4, 48 => 0xc5, 49 => 0xc5, 50 => 0xcd },
	'colortempunknown18' => { 41 => 0xe0, 42 => 0xf9, 48 => 0xca, 49 => 0xca, 50 => 0xd2 },
	'colortempunknown19' => { 41 => 0xe5, 42 => 0xfe, 48 => 0xcf, 49 => 0xcf, 50 => 0xd7 },
	'colortempunknown2' => { 38 => 0x3b, 39 => 0x5f, 41 => 0x6d, 42 => 0x81, 43 => 0x4e, 47 => 0x57, 48 => 0x57, 49 => 0x57, 50 => 0x5f },
	'colortempunknown20' => { 41 => 0xea, 42 => 0x103, 48 => 0xd4, 49 => 0xd4, 50 => 0xdc },
	'colortempunknown21' => { 41 => 0xef, 42 => 0x108, 49 => 0xd9, 50 => 0xe1 },
	'colortempunknown22' => { 41 => 0xf4, 42 => 0x10d, 49 => 0xde, 50 => 0xe6 },
	'colortempunknown23' => { 41 => 0xf9, 42 => 0x112, 49 => 0xe3, 50 => 0xeb },
	'colortempunknown24' => { 41 => 0xfe, 42 => 0x117, 49 => 0xe8, 50 => 0xf0 },
	'colortempunknown25' => { 41 => 0x103, 42 => 0x11c, 49 => 0xed, 50 => 0xf5 },
	'colortempunknown26' => { 41 => 0x108, 42 => 0x121, 49 => 0xf2, 50 => 0xfa },
	'colortempunknown27' => { 41 => 0x10d, 42 => 0x126, 49 => 0xf7, 50 => 0xff },
	'colortempunknown28' => { 41 => 0x112, 49 => 0xfc, 50 => 0x104 },
	'colortempunknown29' => { 41 => 0x117, 49 => 0x101, 50 => 0x109 },
	'colortempunknown3' => { 38 => 0x40, 39 => 0x67, 41 => 0x72, 42 => 0x86, 43 => 0x53, 47 => 0x5c, 48 => 0x5c, 49 => 0x5c, 50 => 0x64 },
	'colortempunknown30' => { 49 => 0x106 },
	'colortempunknown4' => { 38 => 0x45, 39 => 0x6f, 41 => 0x77, 42 => 0x8b, 43 => 0x58, 47 => 0x61, 48 => 0x61, 49 => 0x61, 50 => 0x69 },
	'colortempunknown5' => { 38 => 0x4a, 39 => 0x77, 41 => 0x7c, 42 => 0x90, 43 => 0x5d, 47 => 0x66, 48 => 0x66, 49 => 0x66, 50 => 0x6e },
	'colortempunknown6' => { 38 => 0x4f, 39 => 0x7f, 41 => 0x81, 42 => 0x95, 43 => 0x62, 47 => 0x8e, 48 => 0x6b, 49 => 0x6b, 50 => 0x73 },
	'colortempunknown7' => { 38 => 0x54, 39 => 0x87, 41 => 0x86, 42 => 0x9a, 43 => 0x67, 47 => 0x93, 48 => 0x70, 49 => 0x70, 50 => 0x78 },
	'colortempunknown8' => { 38 => 0x59, 39 => 0x8f, 41 => 0x8b, 42 => 0x9f, 43 => 0x6c, 47 => 0x98, 48 => 0x75, 49 => 0x75, 50 => 0x7d },
	'colortempunknown9' => { 38 => 0x5e, 39 => 0x97, 41 => 0x90, 42 => 0xa4, 43 => 0x71, 47 => 0x9d, 48 => 0x7a, 49 => 0x7a, 50 => 0x82 },
	'colortint' => { 318 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 34 => 0x2a, 51 => 0x2 },
	'colortoneadj' => { 102 => 0x20304, 107 => 0x11e },
	'colortoneauto' => { 70 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 69 => 0x6c, 70 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 69 => 0x3c, 70 => 0x3c },
	'colortonemonochrome' => { 69 => 0x84, 70 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 69 => 0x54, 70 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 69 => 0x24, 70 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 69 => 0xc, 70 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 69 => 0x9c, 70 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 69 => 0xb4, 70 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 69 => 0xcc, 70 => 0xe4 },
	'comlenblksize' => { 137 => 0xfde8 },
	'commanddialplaybackmode' => { 294 => 0x1cb },
	'commanddials' => { 289 => '5.1' },
	'commanddialsaperturesetting' => { 278 => '17.3', 279 => '18.3', 281 => '18.3', 282 => '18.3', 287 => '33.3', 288 => '17.3', 291 => '18.3', 292 => '18.3' },
	'commanddialschangemainsub' => { 278 => '17.2', 279 => '18.1', 281 => '18.1', 282 => '18.1', 287 => '33.2', 288 => '17.2', 291 => '18.1', 292 => '18.1' },
	'commanddialsmenuandplayback' => { 278 => '17.4', 279 => '18.2', 281 => '18.2', 282 => '18.2', 287 => '33.4', 288 => '17.4', 291 => '18.2', 292 => '18.2' },
	'commanddialsreverserotation' => { 278 => '17.1', 279 => '6.4', 281 => '6.2', 282 => '6.2', 283 => '16.2', 284 => '17.2', 287 => '33.1', 288 => '17.1', 291 => '6.2', 292 => '6.2', 293 => '18.1' },
	'commanderchannel' => { 289 => '10.2', 290 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 289 => '13.1', 290 => '31.1' },
	'commandergroupa_ttlcomp' => { 293 => '32.1' },
	'commandergroupamanualoutput' => { 289 => '13.2', 290 => '28.2' },
	'commandergroupamode' => { 289 => '11.2', 290 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 289 => '14.1', 290 => '32.1' },
	'commandergroupb_ttlcomp' => { 293 => '33.1' },
	'commandergroupbmanualoutput' => { 289 => '14.2', 290 => '29.2' },
	'commandergroupbmode' => { 289 => '11.3', 290 => '29.1' },
	'commanderinternalflash' => { 289 => '11.1', 290 => '27.1' },
	'commanderinternalmanualoutput' => { 289 => '12.2', 290 => '27.2' },
	'commanderinternalttlchannel' => { 287 => '18.2' },
	'commanderinternalttlcomp' => { 289 => '12.1', 290 => '30.2', 293 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 287 => '20.1', 288 => '26.1' },
	'commanderinternalttlcompgroupa' => { 287 => '21.1', 288 => '27.1' },
	'commanderinternalttlcompgroupb' => { 287 => '22.1', 288 => '28.1' },
	'comment' => { 0 => 0x2, 119 => 'Comment', 156 => 'Comment', 309 => 'Comment', 371 => "\xa9cmt", 373 => 'comment', 379 => "\xa9cmt" },
	'compass' => { 389 => 0x4 },
	'compatibleversion' => { 476 => 'CompatibleVersion', 478 => 'CompatibleVersion' },
	'compilation' => { 371 => 'cpil' },
	'compimageimagespersequence' => { 483 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 483 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 483 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 483 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 483 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 483 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 483 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 483 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 483 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 483 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 492 => 'complianceProfile' },
	'componentsconfiguration' => { 118 => 0x9101, 161 => 'Components', 482 => 'ComponentsConfiguration' },
	'componentversion' => { 96 => 0x80c },
	'composer' => { 178 => 'WM/Composer', 371 => ["\xa9com","\xa9wrt"], 379 => ["\xa9com","\xa9wrt"], 502 => 'composer' },
	'composerkeywords' => { 379 => "\xa9cok" },
	'compositeimage' => { 118 => 0xa460, 483 => 'CompositeImage' },
	'compositeimagecount' => { 118 => 0xa461, 483 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 118 => 0xa462, 483 => 'CompositeImageExposureTimes' },
	'composition' => { 466 => 'Composition' },
	'compositionadjust' => { 353 => '0.1' },
	'compositionadjustrotation' => { 353 => 0x7 },
	'compositionadjustx' => { 353 => 0x5 },
	'compositionadjusty' => { 353 => 0x6 },
	'compressedbitsperpixel' => { 118 => 0x9102, 482 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 185 => 0x40, 301 => 0x40 },
	'compression' => { 118 => 0x103, 324 => 0xb, 498 => 'Compression' },
	'compressionfactor' => { 296 => 0x50d },
	'compressionratio' => { 161 => 'Compression', 301 => 0x1034 },
	'compressorversion' => { 379 => 'CNCV' },
	'condadobvfactor' => { 137 => 0xf3e },
	'condadodaybvthresh' => { 137 => 0xf3c },
	'condadodayoffsets' => { 137 => 0xf42 },
	'condadofluoffsets' => { 137 => 0xf44 },
	'condadofluthresh' => { 137 => 0xf41 },
	'condadoillfactor' => { 137 => 0xf3f },
	'condadoneurange' => { 137 => 0xf3d },
	'condadotunoffsets' => { 137 => 0xf43 },
	'condadotunthresh' => { 137 => 0xf40 },
	'conductor' => { 178 => 'WM/Conductor', 371 => "\xa9con" },
	'confidence' => { 461 => 'Confidence' },
	'confidencelevel' => { 472 => 'ConfidenceLevel' },
	'confidencemime' => { 461 => 'ConfidenceMime' },
	'constrainedcropheight' => { 107 => 0x266, 365 => 0xd6 },
	'constrainedcropwidth' => { 107 => 0x262, 365 => 0xd5 },
	'contact' => { 130 => 0x76 },
	'contactinfo' => { 476 => 'ContactInfo', 478 => 'ContactInfo', 491 => 'contactInfo' },
	'container' => { 456 => 'Container' },
	'containerdirectory' => { 456 => [\'Container','ContainerDirectory'] },
	'containerdirectoryitem' => { 456 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 456 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 456 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 456 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 456 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 488 => 'ContainerFormat' },
	'containerformatidentifier' => { 488 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 488 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 371 => "\xa9day", 379 => ['@day',"\xa9day"] },
	'contentdistributor' => { 178 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 379 => 'cdis' },
	'contentid' => { 379 => 'ccid' },
	'contentlocationcode' => { 130 => 0x1a },
	'contentlocationname' => { 130 => 0x1b },
	'contenttype' => { 492 => 'contentType' },
	'continuousbracketing' => { 183 => 0x20 },
	'continuousdrive' => { 34 => 0x5 },
	'continuousmodedisplay' => { 294 => 0x51 },
	'continuousmodeliveview' => { 292 => '77.2' },
	'continuousshootingspeed' => { 83 => 0x610 },
	'continuousshotlimit' => { 83 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 34 => 0xd, 111 => 0xc, 112 => [0x3012,0x20], 118 => [0xa408,0xfe54], 126 => [0x1004,0x1006], 155 => 'Contrast', 175 => 'Contrast', 180 => 0x20, 181 => 0x31, 182 => 0x27, 183 => 0x19, 188 => 0x2, 230 => 0x33, 231 => 0x37, 232 => 0x3f, 301 => 0x1029, 319 => 0x39, 321 => 0x300a, 354 => 0x20, 361 => 0xc, 373 => 'player.movie.visual.contrast', 380 => 0x24, 382 => 0x52, 386 => 0x1012, 396 => 0xd, 406 => 0x1d, 407 => 0x1a, 419 => 0x2004, 476 => 'Contrast', 478 => 'Contrast', 482 => 'Contrast' },
	'contrast2012' => { 476 => 'Contrast2012', 478 => 'Contrast2012' },
	'contrastadj' => { 102 => 0x20303, 107 => 0x115, 274 => 0x2c, 453 => 0x8017 },
	'contrastauto' => { 70 => 0x90 },
	'contrastcurve' => { 225 => 0x8c },
	'contrastdetectaf' => { 192 => 0x4 },
	'contrastdetectafarea' => { 354 => 0x231 },
	'contrastdetectafinfocus' => { 192 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 69 => 0x60, 70 => 0x60 },
	'contrasthighlight' => { 354 => 0x6d },
	'contrasthighlightshadowadj' => { 354 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 69 => 0x30, 70 => 0x30 },
	'contrastmode' => { 319 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 69 => 0x78, 70 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 69 => 0x48, 70 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 69 => 0x18, 70 => 0x18 },
	'contrastsetting' => { 296 => 0x505, 304 => 0x1012, 408 => 0x10, 424 => 0x8 },
	'contrastshadow' => { 354 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 69 => 0x0, 70 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 69 => 0x90, 70 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 69 => 0xa8, 70 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 69 => 0xc0, 70 => 0xd8 },
	'contributedmedia' => { 502 => 'contributedMedia' },
	'contributedmediaduration' => { 502 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 502 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 502 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 502 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 502 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 502 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 502 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 502 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 502 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 502 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 479 => 'contributor', 488 => 'Contributor' },
	'contributoridentifier' => { 488 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 488 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 488 => [\'Contributor','ContributorRole'] },
	'contributors' => { 156 => 'Contributors' },
	'controldialset' => { 183 => 0x46 },
	'controlledvocabularyterm' => { 488 => 'CVterm' },
	'controllerboardversion' => { 314 => 0x332 },
	'controlmode' => { 76 => 0x12 },
	'controlringresponse' => { 294 => 0x1d5 },
	'controlringrotation' => { 83 => 0x712 },
	'conversionlens' => { 297 => 0x403, 319 => 0x35 },
	'converter' => { 118 => 0xfe4d, 261 => 0xb, 476 => 'Converter', 478 => 'Converter' },
	'converttograyscale' => { 476 => 'ConvertToGrayscale', 478 => 'ConvertToGrayscale' },
	'cookingequipment' => { 494 => 'cookingEquipment' },
	'cookingmethod' => { 494 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 118 => 0x8298, 156 => 'Copyright', 309 => 'Copyright', 354 => 0x22f, 370 => 'Copyright', 371 => ['cprt',"\xa9cpy"], 373 => 'copyright', 379 => ['cprt',"\xa9cpy"], 476 => 'Copyright', 478 => 'Copyright', 489 => 'Copyright', 495 => 'copyright', 498 => 'Copyright', 502 => 'copyright' },
	'copyrightflag' => { 368 => 0x40a },
	'copyrightnotice' => { 130 => 0x74 },
	'copyrightowner' => { 306 => 'CopyrightOwner' },
	'copyrightownerid' => { 306 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 306 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 306 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 306 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 306 => 'CopyrightStatus' },
	'copyrightyear' => { 488 => 'CopyrightYear', 492 => 'copyrightYear' },
	'coringfilter' => { 300 => 0x310, 301 => 0x102d, 304 => 0x310 },
	'coringvalues' => { 300 => 0x311, 304 => 0x311 },
	'corporateentity' => { 492 => 'corporateEntity' },
	'correlatedcolortemp' => { 318 => 0x35b },
	'country' => { 160 => 'Country', 319 => 0x69, 490 => 'Country' },
	'country-primarylocationcode' => { 130 => 0x64 },
	'country-primarylocationname' => { 130 => 0x65 },
	'countrycode' => { 224 => 0x5, 366 => 'CountryCode', 487 => 'CountryCode' },
	'course' => { 494 => 'course' },
	'coverage' => { 479 => 'coverage' },
	'coverart' => { 371 => 'covr' },
	'coverdate' => { 492 => 'coverDate' },
	'coverdisplaydate' => { 492 => 'coverDisplayDate' },
	'coveruri' => { 379 => 'cvru' },
	'cpufirmwareversion' => { 354 => 0x28 },
	'crc32' => { 480 => 'crc32' },
	'createdate' => { 118 => 0x9004, 156 => 'CreateDate', 305 => 'CreationDate', 309 => 'create-date', 370 => 'CreationDate', 376 => 0x1, 500 => 'CreateDate' },
	'creationdate' => { 373 => 'creationdate', 489 => 'CreationDate', 492 => 'creationDate' },
	'creationtime' => { 309 => 'Creation Time' },
	'creativestyle' => { 406 => 0x1a, 407 => 0x18, 417 => 0x41, 419 => 0xb020, 449 => 0x4a },
	'creativestylesetting' => { 408 => 0xf, 424 => 0x7 },
	'creativestylewaschanged' => { 453 => 0x8001 },
	'creator' => { 305 => 'Creator', 370 => 'Creator', 479 => 'creator', 488 => 'Creator', 489 => 'Creator' },
	'creatoraddress' => { 487 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 177 => 'CreatorAppId' },
	'creatorcity' => { 487 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 487 => 'CreatorContactInfo' },
	'creatorcountry' => { 487 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 488 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 488 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 177 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 487 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 487 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 488 => [\'Creator','CreatorRole'] },
	'creatortool' => { 500 => 'CreatorTool' },
	'creatorworkemail' => { 487 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 487 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 487 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 130 => 0x6e, 490 => 'Credit' },
	'creditline' => { 495 => 'creditLine' },
	'creditlinereq' => { 505 => 'CreditLineReq' },
	'creditlinerequired' => { 306 => 'CreditLineRequired' },
	'cropactive' => { 100 => 0x0, 107 => 0x244 },
	'cropangle' => { 476 => 'CropAngle', 478 => 'CropAngle' },
	'croparea' => { 225 => 0x45, 453 => 0x9011 },
	'cropaspectratio' => { 102 => 0x30101, 107 => 0x260 },
	'cropaspectratiocustom' => { 102 => 0x30102 },
	'cropbottom' => { 122 => 0x9, 266 => 0x36, 324 => 0x31, 365 => 0xdc, 476 => 'CropBottom', 478 => 'CropBottom' },
	'cropbottommargin' => { 53 => 0x3 },
	'cropcircleactive' => { 108 => 0xd6 },
	'cropcircleradius' => { 108 => 0xd9 },
	'cropcirclex' => { 108 => 0xd7 },
	'cropcircley' => { 108 => 0xd8 },
	'cropconstraintowarp' => { 476 => 'CropConstrainToWarp', 478 => 'CropConstrainToWarp' },
	'croph' => { 470 => 'CropH' },
	'cropheight' => { 100 => 0x6, 107 => 0x24c, 300 => 0x615, 304 => 0x615, 476 => 'CropHeight', 478 => 'CropHeight' },
	'crophispeed' => { 225 => 0x1b },
	'cropleft' => { 107 => 0x246, 122 => 0x6, 266 => 0x1e, 300 => 0x612, 304 => 0x612, 324 => 0x30, 365 => 0xd9, 476 => 'CropLeft', 478 => 'CropLeft' },
	'cropleftmargin' => { 53 => 0x0 },
	'cropmode' => { 126 => 0x104d, 386 => 0x1018 },
	'croporiginalheight' => { 100 => 0xb },
	'croporiginalwidth' => { 100 => 0xa },
	'cropoutputheight' => { 266 => 0xce },
	'cropoutputheightinches' => { 266 => 0x96 },
	'cropoutputpixels' => { 266 => 0xd6 },
	'cropoutputresolution' => { 266 => 0xb6 },
	'cropoutputscale' => { 266 => 0xbe },
	'cropoutputwidth' => { 266 => 0xc6 },
	'cropoutputwidthinches' => { 266 => 0x8e },
	'croppedareaimageheightpixels' => { 464 => 'CroppedAreaImageHeightPixels', 465 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 464 => 'CroppedAreaImageWidthPixels', 465 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 464 => 'CroppedAreaLeftPixels', 465 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 464 => 'CroppedAreaTopPixels', 465 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 386 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 386 => 0x1603 },
	'cropping' => { 453 => 0x9010 },
	'cropright' => { 122 => 0x8, 266 => 0x2e, 324 => 0x32, 365 => 0xdb, 476 => 'CropRight', 478 => 'CropRight' },
	'croprightmargin' => { 53 => 0x1 },
	'croprotatedoriginalheight' => { 100 => 0x2 },
	'croprotatedoriginalwidth' => { 100 => 0x1 },
	'croprotation' => { 100 => 0x8, 122 => 0xb },
	'cropscaledresolution' => { 266 => 0x9e },
	'cropsourceresolution' => { 266 => 0xae },
	'croptop' => { 107 => 0x248, 122 => 0x7, 266 => 0x26, 300 => 0x613, 304 => 0x613, 324 => 0x2f, 365 => 0xda, 476 => 'CropTop', 478 => 'CropTop' },
	'croptopmargin' => { 53 => 0x2 },
	'cropunit' => { 476 => 'CropUnit', 478 => 'CropUnit' },
	'cropunits' => { 476 => 'CropUnits', 478 => 'CropUnits' },
	'cropw' => { 470 => 'CropW' },
	'cropwidth' => { 100 => 0x5, 107 => 0x24a, 300 => 0x614, 304 => 0x614, 476 => 'CropWidth', 478 => 'CropWidth' },
	'cropx' => { 100 => 0x3, 470 => 'CropX' },
	'cropy' => { 100 => 0x4, 470 => 'CropY' },
	'crossprocess' => { 354 => 0x7b },
	'crossprocessparams' => { 354 => 0x235 },
	'cuisine' => { 494 => 'cuisine' },
	'currenticcprofile' => { 118 => 0xc691 },
	'currentpreprofilematrix' => { 118 => 0xc692 },
	'currentversion' => { 453 => 0xd000 },
	'curve0x' => { 470 => 'Curve0x' },
	'curve0y' => { 470 => 'Curve0y' },
	'curve1x' => { 470 => 'Curve1x' },
	'curve1y' => { 470 => 'Curve1y' },
	'curve2x' => { 470 => 'Curve2x' },
	'curve2y' => { 470 => 'Curve2y' },
	'curve3x' => { 470 => 'Curve3x' },
	'curve3y' => { 470 => 'Curve3y' },
	'curve4x' => { 470 => 'Curve4x' },
	'curve4y' => { 470 => 'Curve4y' },
	'curves' => { 271 => 0x76a43201 },
	'custom1' => { 306 => 'Custom1' },
	'custom10' => { 306 => 'Custom10' },
	'custom2' => { 306 => 'Custom2' },
	'custom3' => { 306 => 'Custom3' },
	'custom4' => { 306 => 'Custom4' },
	'custom5' => { 306 => 'Custom5' },
	'custom6' => { 306 => 'Custom6' },
	'custom7' => { 306 => 'Custom7' },
	'custom8' => { 306 => 'Custom8' },
	'custom9' => { 306 => 'Custom9' },
	'customcolortone' => { 108 => 0x4c },
	'customcontrast' => { 108 => 0x4e },
	'customcontrols' => { 83 => 0x70c },
	'customdefaultunsharpfineness' => { 108 => 0xbe },
	'customdefaultunsharpstrength' => { 108 => 0xbc },
	'customdefaultunsharpthreshold' => { 108 => 0xc0 },
	'customilluminant' => { 137 => 0x405 },
	'customizedials' => { 83 => 0x715 },
	'customlinear' => { 108 => 0x4f },
	'customoutputhighlightpoint' => { 108 => 0x53 },
	'customoutputshadowpoint' => { 108 => 0x54 },
	'custompicturestyle' => { 102 => 0x10021 },
	'custompicturestyledata' => { 102 => 0xf0500 },
	'custompicturestylefilename' => { 63 => 0x4010 },
	'customrawhighlight' => { 108 => 0x7c },
	'customrawhighlightpoint' => { 108 => 0x51 },
	'customrawshadow' => { 108 => 0x85 },
	'customrawshadowpoint' => { 108 => 0x52 },
	'customrendered' => { 118 => 0xa401, 482 => 'CustomRendered' },
	'customsaturation' => { 108 => 0x4d, 296 => 0x503 },
	'customsettingsalldefault' => { 278 => '0.2', 287 => '0.2' },
	'customsettingsbank' => { 278 => '0.1', 279 => '0.1', 281 => '0.1', 282 => '0.1', 287 => '0.1', 291 => '0.2', 292 => '0.2', 294 => 0x1 },
	'customsharpness' => { 108 => 0x50 },
	'customunsharpmaskfineness' => { 108 => 0xb8 },
	'customunsharpmaskstrength' => { 108 => 0xb6 },
	'customunsharpmaskthreshold' => { 108 => 0xba },
	'customwb_rblevels' => { 424 => 0x1a },
	'customwb_rgblevels' => { 407 => 0x8, 408 => 0x19 },
	'customwbbluelevel' => { 183 => 0x36 },
	'customwberror' => { 183 => 0x37 },
	'customwbgreenlevel' => { 183 => 0x35 },
	'customwbredlevel' => { 183 => 0x34 },
	'customwbsetting' => { 183 => 0x26 },
	'cx' => { 379 => '_cx_' },
	'cy' => { 379 => '_cy_' },
	'd-lightinghq' => { 271 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 267 => 0x2 },
	'd-lightinghqhighlight' => { 267 => 0x1 },
	'd-lightinghqselected' => { 271 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 267 => 0x0 },
	'd-lightinghs' => { 271 => 0xce5554aa },
	'd-lightinghsadjustment' => { 268 => 0x0 },
	'd-lightinghscolorboost' => { 268 => 0x1 },
	'd-rangeoptimizerhighlight' => { 453 => 0x8024 },
	'd-rangeoptimizermode' => { 453 => 0x8022 },
	'd-rangeoptimizershadow' => { 453 => 0x802d },
	'd-rangeoptimizervalue' => { 453 => 0x8023 },
	'darkblacksegrows' => { 137 => 0x18d8 },
	'darkfocusenvironment' => { 319 => 0x8003 },
	'darkframecountfactor' => { 137 => 0xc85 },
	'darkframelongexposure' => { 137 => 0xc84 },
	'darkframeshortexposure' => { 137 => 0xc83 },
	'darkpedestal' => { 137 => 0xc7f },
	'datacompressionmethod' => { 132 => 0x6e },
	'dataimprint' => { 180 => 0x34 },
	'dataonscreen' => { 488 => 'DataOnScreen' },
	'dataonscreenregion' => { 488 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 488 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 488 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 488 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 488 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 488 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 488 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 488 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 354 => 0x3d },
	'date' => { 354 => 0x6, 479 => 'date' },
	'dateacquired' => { 177 => 'DateAcquired', 178 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 130 => 0x37, 490 => 'DateCreated' },
	'datedisplayformat' => { 263 => 0x3 },
	'dateidentified' => { 117 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 283 => '4.2' },
	'daterecieved' => { 492 => 'dateRecieved' },
	'datesent' => { 131 => 0x46 },
	'datestampmode' => { 63 => 0x1c, 225 => 0x9d },
	'datetime' => { 471 => 'datetime', 498 => 'DateTime' },
	'datetimedigitized' => { 482 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 99 => 0x0, 118 => 0x9003, 153 => 0x14, 156 => 'OriginalDate', 374 => 'IDIT', 379 => 'date', 380 => 0xb, 381 => 0x3b, 382 => 0x3e, 482 => 'DateTimeOriginal' },
	'datetimestamp' => { 139 => 0x64 },
	'datetimeutc' => { 296 => 0x908 },
	'daylightsavings' => { 77 => 0x3, 263 => 0x2 },
	'dayofweek' => { 381 => 0x42, 382 => 0x4a },
	'dccontinent' => { 117 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 117 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 117 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 117 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 117 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 117 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 117 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 117 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 117 => 'Event' },
	'dcfootprintspatialfit' => { 117 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 117 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 117 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 117 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 117 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 117 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 117 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 117 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 117 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 117 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 117 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 117 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 117 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 117 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 117 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 117 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 117 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 117 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 117 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 117 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 117 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 117 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 117 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 117 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 117 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 117 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 117 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 117 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 117 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 117 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 117 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 117 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 117 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 117 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 117 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 117 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 117 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 164 => 'Declination' },
	'decposition' => { 180 => 0x32 },
	'defaultautogray' => { 476 => 'DefaultAutoGray', 478 => 'DefaultAutoGray' },
	'defaultautotone' => { 476 => 'DefaultAutoTone', 478 => 'DefaultAutoTone' },
	'defaultblackrender' => { 118 => 0xc7a6 },
	'defaultcroporigin' => { 118 => 0xc61f },
	'defaultcropsize' => { 118 => 0xc620 },
	'defaulteraseoption' => { 83 => 0x813 },
	'defaultscale' => { 118 => 0xc61e },
	'defaultsspecifictoiso' => { 476 => 'DefaultsSpecificToISO', 478 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 476 => 'DefaultsSpecificToSerial', 478 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 118 => 0xc7b5 },
	'defectisocode' => { 137 => 0x90f },
	'defringe' => { 476 => 'Defringe', 478 => 'Defringe' },
	'defringegreenamount' => { 476 => 'DefringeGreenAmount', 478 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 476 => 'DefringeGreenHueHi', 478 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 476 => 'DefringeGreenHueLo', 478 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 476 => 'DefringePurpleAmount', 478 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 476 => 'DefringePurpleHueHi', 478 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 476 => 'DefringePurpleHueLo', 478 => 'DefringePurpleHueLo' },
	'dehaze' => { 476 => 'Dehaze', 478 => 'Dehaze' },
	'deletedimagecount' => { 225 => 0xa6, 237 => 0x6e },
	'deprecatedon' => { 474 => 'deprecatedOn' },
	'depthfar' => { 118 => 0xc7eb },
	'depthformat' => { 118 => 0xc7e9 },
	'depthimage' => { 461 => 'Data' },
	'depthmeasuretype' => { 118 => 0xc7ed },
	'depthnear' => { 118 => 0xc7ea },
	'depthunits' => { 118 => 0xc7ec },
	'derivedfrom' => { 503 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 503 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 503 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 503 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 503 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 503 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 503 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 503 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 503 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 503 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 503 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 503 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 503 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 503 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 503 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 503 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 503 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 503 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 503 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 503 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 503 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 503 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 503 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 503 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 309 => 'Description', 371 => ['desc','dscp',"\xa9des"], 373 => 'description', 379 => 'dscp', 476 => 'Description', 478 => 'Description', 479 => 'description', 500 => 'Description' },
	'destination' => { 131 => 0x5 },
	'destinationcity' => { 354 => 0x24, 360 => 0x3 },
	'destinationcitycode' => { 361 => 0x1001 },
	'destinationdst' => { 354 => 0x26, 360 => '0.3' },
	'developmentdynamicrange' => { 126 => 0x1403 },
	'deviantmatrixcustom' => { 137 => 0x7de },
	'deviantmatrixdaylight' => { 137 => 0x7da },
	'deviantmatrixflash' => { 137 => 0x7dd },
	'deviantmatrixfluorescent' => { 137 => 0x7dc },
	'deviantmatrixtungsten' => { 137 => 0x7db },
	'deviantwhitecustom' => { 137 => 0x842 },
	'deviantwhitedaylight' => { 137 => 0x83e },
	'deviantwhiteflash' => { 137 => 0x841 },
	'deviantwhitefluorescent' => { 137 => 0x840 },
	'deviantwhitetungsten' => { 137 => 0x83f },
	'device' => { 492 => 'device' },
	'devicesettingdescription' => { 482 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 482 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 482 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 482 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 393 => 0x2 },
	'dewarpdata' => { 115 => 'DewarpData' },
	'dewarpflag' => { 115 => 'DewarpFlag' },
	'dialdirectiontvav' => { 83 => 0x706 },
	'dietaryneeds' => { 494 => 'dietaryNeeds' },
	'diffractioncompensation' => { 227 => 0x142, 228 => 0x1a2, 251 => 0xc4a0 },
	'diffractioncorrection' => { 319 => 0xbc, 344 => 0x3 },
	'diffractioncorrectionon' => { 102 => 0x2070b },
	'digitalcreationdate' => { 130 => 0x3e },
	'digitalcreationtime' => { 130 => 0x3f },
	'digitaldeehighlightadj' => { 236 => 0x202 },
	'digitaldeeshadowadj' => { 236 => 0x200 },
	'digitaldeethreshold' => { 236 => 0x201 },
	'digitalfilter' => { 396 => 0x59 },
	'digitalfilter01' => { 341 => 0x5 },
	'digitalfilter02' => { 341 => 0x16 },
	'digitalfilter03' => { 341 => 0x27 },
	'digitalfilter04' => { 341 => 0x38 },
	'digitalfilter05' => { 341 => 0x49 },
	'digitalfilter06' => { 341 => 0x5a },
	'digitalfilter07' => { 341 => 0x6b },
	'digitalfilter08' => { 341 => 0x7c },
	'digitalfilter09' => { 341 => 0x8d },
	'digitalfilter10' => { 341 => 0x9e },
	'digitalfilter11' => { 341 => 0xaf },
	'digitalfilter12' => { 341 => 0xc0 },
	'digitalfilter13' => { 341 => 0xd1 },
	'digitalfilter14' => { 341 => 0xe2 },
	'digitalfilter15' => { 341 => 0xf3 },
	'digitalfilter16' => { 341 => 0x104 },
	'digitalfilter17' => { 341 => 0x115 },
	'digitalfilter18' => { 341 => 0x126 },
	'digitalfilter19' => { 341 => 0x137 },
	'digitalfilter20' => { 341 => 0x148 },
	'digitalgain' => { 73 => 0xb },
	'digitalgem' => { 214 => 0x0 },
	'digitalice' => { 236 => 0x100 },
	'digitalimageguid' => { 488 => 'DigImageGUID' },
	'digitalroc' => { 234 => 0x0 },
	'digitalsourcefiletype' => { 488 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 488 => 'DigitalSourceType' },
	'digitalzoom' => { 34 => 0xc, 111 => 0xa, 126 => 0x1044, 139 => 0x68, 150 => 0x22, 151 => 0x1e, 155 => 'DigitalZoom', 180 => 0xc, 225 => 0x86, 261 => 0xa, 301 => 0x204, 354 => 0x1e, 361 => 0xa, 395 => 0x204, 440 => 0x12, 441 => 0x12 },
	'digitalzoomon' => { 395 => 0x21b },
	'digitalzoomratio' => { 118 => 0xa404, 429 => 0x200, 431 => 0x21c, 482 => 'DigitalZoomRatio' },
	'director' => { 178 => 'WM/Director', 371 => "\xa9dir", 373 => 'director', 379 => "\xa9dir", 502 => 'director' },
	'directorphotography' => { 502 => 'directorPhotography' },
	'directory' => { 119 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba },
	'directoryindex2' => { 21 => 0x29c },
	'directorynumber' => { 207 => 0x3, 382 => 0x12 },
	'disableautocreation' => { 459 => 'DisableAutoCreation' },
	'disclaimer' => { 309 => 'Disclaimer' },
	'discnumber' => { 502 => 'discNumber' },
	'dishtype' => { 494 => 'dishType' },
	'disknumber' => { 371 => 'disk' },
	'displayallafpoints' => { 83 => 0x514 },
	'displayaperture' => { 34 => 0x23 },
	'displayedunitsx' => { 369 => 0x2 },
	'displayedunitsy' => { 369 => 0x6 },
	'displayname' => { 373 => 'displayname', 491 => 'displayName' },
	'distance1' => { 139 => 0x28 },
	'distance2' => { 139 => 0x2c },
	'distance3' => { 139 => 0x30 },
	'distance4' => { 139 => 0x34 },
	'distortion' => { 393 => 0xa050 },
	'distortioncompensation' => { 453 => 0x8040 },
	'distortioncontrol' => { 237 => 0x10 },
	'distortioncorrection' => { 78 => 0x3, 102 => 0x20705, 108 => 0x67, 118 => 0x7036, 296 => 0x50b, 323 => '7.1', 344 => 0x0, 448 => 0x601, 449 => 0x5b },
	'distortioncorrection2' => { 300 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 473 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 102 => '0x20705.0', 108 => 0x63 },
	'distortioncorrectionsetting' => { 79 => 0x7, 419 => 0x2013 },
	'distortioncorrectionvalue' => { 78 => 0x9 },
	'distortioncorrparams' => { 118 => 0x7037, 428 => 0x1a23, 431 => 0x1870, 433 => 0x189c, 434 => 0x18cc, 435 => 0x17d0, 448 => 0x6ca, 449 => 0x64 },
	'distortioncorrparamsnumber' => { 431 => 0x1899, 433 => 0x18c5, 434 => 0x18f5, 435 => 0x17f9 },
	'distortioncorrparamspresent' => { 431 => 0x1898, 433 => 0x18c4, 434 => 0x18f4, 435 => 0x17f8, 437 => 0x10b, 438 => 0x10b, 448 => 0x600, 449 => 0x5a },
	'distortioneffect' => { 102 => 0x20709 },
	'distortionn' => { 323 => 0xc },
	'distortionparam02' => { 323 => 0x2 },
	'distortionparam04' => { 323 => 0x4 },
	'distortionparam08' => { 323 => 0x8 },
	'distortionparam09' => { 323 => 0x9 },
	'distortionparam11' => { 323 => 0xb },
	'distortionscale' => { 323 => 0x5 },
	'distributor' => { 492 => 'distributor' },
	'distributorproductid' => { 491 => 'distributorProductID' },
	'dloon' => { 102 => '0x20706.0', 108 => 0xdc },
	'dlosetting' => { 102 => 0x20706, 108 => 0xdd },
	'dlosettingapplied' => { 101 => 0x4 },
	'dloshootingdistance' => { 108 => 0xde },
	'dloversion' => { 101 => 0x5 },
	'dmcomment' => { 502 => 'comment' },
	'dmdithermatrix' => { 137 => 0xc7a },
	'dmdithermatrixheight' => { 137 => 0xc7c },
	'dmdithermatrixwidth' => { 137 => 0xc7b },
	'dngadobedata' => { 118 => 0xc634 },
	'dngbackwardversion' => { 118 => 0xc613 },
	'dngignoresidecars' => { 476 => 'DNGIgnoreSidecars', 478 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 118 => 0xc630 },
	'dngprivatedata' => { 118 => 0xc634 },
	'dngversion' => { 118 => 0xc612 },
	'document' => { 309 => 'Document' },
	'documentancestors' => { 490 => 'DocumentAncestors' },
	'documenthistory' => { 130 => 0xe7 },
	'documentid' => { 503 => 'DocumentID' },
	'documentname' => { 118 => 0x10d },
	'documentnotes' => { 130 => 0xe6 },
	'doi' => { 492 => 'doi' },
	'dopesheet' => { 488 => 'Dopesheet' },
	'dopesheetlink' => { 488 => 'DopesheetLink' },
	'dopesheetlinklink' => { 488 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 488 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 137 => 0xc82 },
	'dpp' => { 471 => 'dpp' },
	'dr4cameramodel' => { 103 => 0x3 },
	'drangepriority' => { 126 => 0x1443 },
	'drangepriorityauto' => { 126 => 0x1444 },
	'drangepriorityfixed' => { 126 => 0x1445 },
	'drivemode' => { 112 => 0x3103, 124 => '0.1', 180 => 0x6, 183 => 0x1e, 186 => 0xe, 296 => 0x600, 354 => 0x34, 386 => 0x1002, 396 => 0x3, 406 => 0x4, 407 => 0x7e, 408 => 0x34 },
	'drivemode2' => { 183 => 0xa, 335 => 0x7, 417 => 0xe, 424 => 0x1 },
	'drivemodesetting' => { 408 => 0x4 },
	'drivespeed' => { 124 => '0.2' },
	'dspfirmwareversion' => { 354 => 0x27 },
	'duration' => { 66 => 0x6a, 154 => 'Duration', 168 => 'Duration', 494 => 'duration', 502 => 'duration' },
	'durationscale' => { 502 => [\'duration','durationScale'] },
	'durationvalue' => { 502 => [\'duration','durationValue'] },
	'dustremovaldata' => { 63 => 0x97 },
	'dxcropalert' => { 228 => 0x23c },
	'dynamicafarea' => { 278 => '1.4', 287 => '1.4' },
	'dynamicareaafassist' => { 294 => 0x18 },
	'dynamicareaafdisplay' => { 279 => '46.1', 281 => '47.1', 282 => '47.1', 291 => '47.1', 292 => '47.1' },
	'dynamicrange' => { 126 => 0x1400 },
	'dynamicrangeexpansion' => { 354 => 0x69, 386 => 0x100e },
	'dynamicrangemax' => { 107 => 0x7c },
	'dynamicrangemin' => { 107 => 0x7a },
	'dynamicrangeoptimizer' => { 183 => 0x15, 419 => [0xb025,0xb04f], 427 => 0x1144, 428 => [0x1144,0x324], 429 => [0x1120,0x300], 430 => [0x119c,0x37c], 431 => [0x1178,0x328], 432 => [0x1030,0x50], 433 => [0x228,0x50], 434 => [0x228,0x50], 435 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 417 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 406 => 0x19, 407 => 0x17, 408 => 0xd, 417 => 0x79, 424 => 0x5 },
	'dynamicrangeoptimizermode' => { 186 => 0x15, 406 => 0x18, 407 => 0x16, 417 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 183 => 0x27, 408 => 0xc, 424 => 0x4 },
	'dynamicrangesetting' => { 126 => 0x1402 },
	'e-dialinprogram' => { 335 => '1.3' },
	'earliestageorloweststage' => { 117 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 117 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 117 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 117 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 117 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 456 => 'EarthPos' },
	'earthposaltitude' => { 456 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 456 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 456 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 456 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 456 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 456 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 456 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 456 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 293 => '6.1' },
	'easyexposurecompensation' => { 278 => '6.4', 279 => '6.5', 281 => '6.3', 282 => '6.3', 286 => '5.1', 287 => '4.4', 288 => '5.2', 291 => '6.3', 292 => '6.3', 294 => 0x1d },
	'easymode' => { 34 => 0xb },
	'edgemapslope' => { 137 => 0x930 },
	'edgemapx1' => { 137 => 0x931 },
	'edgemapx2' => { 137 => 0x932 },
	'edgemapx3' => { 137 => 0x934 },
	'edgemapx4' => { 137 => 0x935 },
	'edgenoisereduction' => { 272 => 0x4, 453 => 0x8028 },
	'edit1' => { 379 => "\xa9ed1" },
	'edit2' => { 379 => "\xa9ed2" },
	'edit3' => { 379 => "\xa9ed3" },
	'edit4' => { 379 => "\xa9ed4" },
	'edit5' => { 379 => "\xa9ed5" },
	'edit6' => { 379 => "\xa9ed6" },
	'edit7' => { 379 => "\xa9ed7" },
	'edit8' => { 379 => "\xa9ed8" },
	'edit9' => { 379 => "\xa9ed9" },
	'edition' => { 492 => 'edition' },
	'editorialupdate' => { 130 => 0x8 },
	'editstatus' => { 130 => 0x7, 366 => 'EditStatus', 471 => 'EditStatus' },
	'editversionname' => { 271 => 0x3d136244 },
	'effectivelv' => { 354 => 0x2d },
	'effectivemaxaperture' => { 218 => 0x12, 219 => 0x13, 223 => 0x14 },
	'eissn' => { 492 => 'eIssn' },
	'electricalblackcolumns' => { 137 => 0x1810 },
	'electronicfront-curtainshutter' => { 281 => '5.2', 282 => '5.2', 291 => '5.3', 292 => '5.2' },
	'electronicfrontcurtainshutter' => { 419 => 0x201a },
	'elevation' => { 164 => 'Elevation' },
	'email' => { 156 => 'EMail' },
	'embargodate' => { 495 => 'embargoDate' },
	'embdencrightsexpr' => { 488 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 488 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 488 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 488 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 490 => 'EmbeddedXMPDigest' },
	'emissivity' => { 120 => 0x3 },
	'emptyslotrelease' => { 228 => 0x625 },
	'enablechromanoisereduction' => { 137 => 0xe6e },
	'enablesharpening' => { 137 => 0x92e },
	'encodedby' => { 178 => 'WM/EncodedBy', 371 => "\xa9enc" },
	'encodedwith' => { 373 => 'Encoded_With' },
	'encoder' => { 371 => "\xa9too", 379 => "\xa9too" },
	'encoderid' => { 379 => "\xa9enc" },
	'encodingtime' => { 178 => 'WM/EncodingTime' },
	'encryptionkey' => { 393 => 0xa020 },
	'endingpage' => { 492 => 'endingPage' },
	'enduser' => { 306 => 'EndUser' },
	'enduserid' => { 306 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 306 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 228 => 0x648 },
	'engineer' => { 502 => 'engineer' },
	'enhancedarktones' => { 264 => 0x8 },
	'enhancement' => { 111 => 0x16, 112 => 0x3016 },
	'enhanceparams' => { 118 => 0xc7ee },
	'enhancer' => { 300 => 0x300 },
	'enhancervalues' => { 300 => 0x301 },
	'envelopenumber' => { 131 => 0x28 },
	'envelopepriority' => { 131 => 0x3c },
	'enveloperecordversion' => { 131 => 0x0 },
	'episode' => { 488 => 'Episode' },
	'episodeglobaluniqueid' => { 371 => 'egid' },
	'episodeidentifier' => { 488 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 488 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 488 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 301 => 0x20c },
	'epsonimagewidth' => { 301 => 0x20b },
	'epsonsoftware' => { 301 => 0x20d },
	'equipmentinstitution' => { 455 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 455 => 'EquipmentManufacturer' },
	'equipmentversion' => { 297 => 0x0 },
	'ettlii' => { 83 => 0x304, 84 => 0xd, 85 => 0xe, 86 => 0x7, 87 => 0x7, 88 => 0xe },
	'event' => { 457 => 'Event', 469 => 'Event', 488 => 'Event', 492 => 'event' },
	'eventalias' => { 491 => 'eventAlias' },
	'eventdate' => { 117 => [\'Event','EventEventDate'] },
	'eventday' => { 117 => [\'Event','EventDay'] },
	'eventearliestdate' => { 117 => [\'Event','EventEarliestDate'] },
	'eventend' => { 491 => 'eventEnd' },
	'eventenddayofyear' => { 117 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 117 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 117 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 117 => [\'Event','EventHabitat'] },
	'eventid' => { 117 => [\'Event','EventEventID'], 488 => 'EventId' },
	'eventlatestdate' => { 117 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 117 => [\'Event','EventMonth'] },
	'eventnumber' => { 380 => 0x9, 381 => 0x37, 382 => 0x3a },
	'eventparenteventid' => { 117 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 117 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 117 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 117 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 117 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 117 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 491 => 'eventStart' },
	'eventstartdayofyear' => { 117 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 491 => 'eventSubtype' },
	'eventtime' => { 117 => [\'Event','EventEventTime'] },
	'eventtype' => { 491 => 'eventType' },
	'eventverbatimeventdate' => { 117 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 117 => [\'Event','EventYear'] },
	'evfgrid' => { 294 => 0x165 },
	'evfimageframe' => { 294 => 0x164 },
	'evfreleaseindicator' => { 294 => 0x24f },
	'evfwarmdisplaybrightness' => { 294 => 0x24d },
	'evfwarmdisplaymode' => { 294 => 0x24b },
	'evsteps' => { 335 => '1.2', 337 => 0x0 },
	'evstepsize' => { 283 => '5.1', 284 => '6.1', 285 => '6.1', 289 => '0.7' },
	'exclusivecoverage' => { 466 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 495 => 'exclusivityEndDate' },
	'excursiontolerance' => { 132 => 0x82 },
	'executiveproducer' => { 371 => "\xa9xpd" },
	'exif' => { 119 => 'EXIF' },
	'exifbyteorder' => { 119 => 'ExifByteOrder' },
	'exifcamerainfo' => { 130 => 0xe8 },
	'exifimageheight' => { 118 => 0xa003, 482 => 'PixelYDimension' },
	'exifimagewidth' => { 118 => 0xa002, 482 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 119 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 118 => 0x9000, 482 => 'ExifVersion' },
	'exitpupilposition' => { 218 => 0x4, 219 => 0x4, 223 => 0x4 },
	'expirationdate' => { 130 => 0x25, 495 => 'expirationDate' },
	'expirationtime' => { 130 => 0x26 },
	'exposure' => { 118 => 0xfe51, 476 => 'Exposure', 478 => 'Exposure' },
	'exposure2012' => { 476 => 'Exposure2012', 478 => 'Exposure2012' },
	'exposureadj' => { 269 => 0x0 },
	'exposureadj2' => { 269 => 0x12 },
	'exposureadjust' => { 396 => 0xc },
	'exposurebracketingindicatorlast' => { 183 => 0x52 },
	'exposurebracketshotnumber' => { 186 => 0x2d, 417 => 0x2f },
	'exposurebracketstepsize' => { 335 => 0x8 },
	'exposurebracketvalue' => { 225 => 0x19 },
	'exposurecompautocancel' => { 83 => 0x113 },
	'exposurecompensation' => { 76 => 0x6, 92 => 0x0, 118 => 0x9204, 139 => 0x24, 155 => 'ExposureComp', 175 => 'ExposureCompensation', 180 => 0xd, 181 => 0x53, 182 => 0x1e, 186 => 0x49c0, 301 => 0x1006, 354 => 0x16, 363 => 0x402, 393 => 0xa013, 396 => [0xc,0x35,0x4d], 427 => 0x114c, 428 => 0x114c, 429 => 0x1128, 431 => 0x1180, 432 => 0x1038, 433 => 0x230, 434 => 0x230, 435 => 0x223, 482 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 424 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 183 => 0x47, 186 => 0x2a },
	'exposurecompensationset' => { 406 => 0x3, 407 => 0x3, 408 => 0x3, 424 => 0x1e },
	'exposurecompensationsetting' => { 183 => 0x1 },
	'exposurecompstepsize' => { 278 => '6.3', 279 => '7.3', 281 => '7.3', 282 => '7.3', 287 => '4.3', 291 => '7.3', 292 => '7.3' },
	'exposurecontrolstep' => { 286 => '6.1', 288 => '6.1' },
	'exposurecontrolstepsize' => { 278 => '6.2', 279 => '7.1', 281 => '7.1', 282 => '7.1', 287 => '4.2', 291 => '7.1', 292 => '7.1', 293 => '7.1', 294 => 0x1b },
	'exposurecount' => { 126 => 0x1032 },
	'exposuredelaymode' => { 278 => '10.1', 279 => '11.1', 281 => '11.1', 282 => '11.1', 283 => '9.1', 284 => '10.1', 285 => '10.1', 287 => '10.4', 288 => '10.1', 289 => '6.4', 291 => '11.1', 292 => '11.1', 293 => '11.2' },
	'exposuredifference' => { 225 => 0xe },
	'exposuregaincustom' => { 137 => 0x89c },
	'exposuregaindaylight' => { 137 => 0x898 },
	'exposuregainflash' => { 137 => 0x89b },
	'exposuregainfluorescent' => { 137 => 0x89a },
	'exposuregaintungsten' => { 137 => 0x899 },
	'exposureindex' => { 118 => 0xa215, 482 => 'ExposureIndex' },
	'exposureindicator' => { 183 => 0x50 },
	'exposurelevelincrements' => { 81 => 0x6, 82 => 0x6, 83 => 0x101, 84 => 0x5, 85 => 0x6, 86 => 0x5, 87 => 0x5, 88 => 0x6, 89 => 0x4, 406 => 0x58, 407 => 0x58 },
	'exposurelockused' => { 464 => 'ExposureLockUsed' },
	'exposuremode' => { 118 => 0xa402, 155 => 'ExposureMode', 180 => 0x1, 181 => 0xa, 182 => 0x0, 183 => 0x0, 186 => 0x34, 296 => 0x200, 316 => 0x40d, 396 => 0x8, 419 => 0xb041, 482 => 'ExposureMode' },
	'exposuremodeinmanual' => { 83 => 0x10b },
	'exposureprogram' => { 118 => 0x8822, 386 => 0x1001, 399 => [0x17e,0x43], 406 => 0x3c, 407 => 0x3c, 408 => 0x5, 412 => 0x14, 417 => 0x3f, 424 => 0x2, 427 => 0x1175, 428 => 0x1179, 429 => 0x1155, 430 => 0x11d1, 431 => 0x11ad, 432 => 0x1065, 433 => 0x25d, 434 => 0x25d, 435 => 0x24c, 445 => 0xb, 446 => 0xc, 447 => 0xb, 449 => 0x48, 482 => 'ExposureProgram' },
	'exposureshift' => { 296 => 0x203 },
	'exposurestandardadjustment' => { 419 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 30 => 0x6, 31 => 0x7, 76 => 0x16, 118 => 0x829a, 136 => 0xfd05, 139 => 0x20, 141 => 0xfa24, 143 => 0xf104, 146 => 0x12, 148 => 0x38, 150 => 0x14, 151 => 0x10, 153 => 0x10, 155 => 'ExposureTime', 180 => 0x9, 181 => 0x35, 182 => 0x48, 183 => 0x8, 186 => 0x49b8, 354 => 0x12, 393 => 0xa018, 396 => [0x32,0x4a], 406 => 0x0, 407 => 0x0, 424 => [0x21,0x23,0x27], 449 => 0x10, 482 => 'ExposureTime' },
	'exposuretime2' => { 396 => [0x33,0x4b] },
	'exposuretuning' => { 225 => 0x1c },
	'exposurevalue' => { 137 => 0x3 },
	'exposurewarning' => { 126 => 0x1302 },
	'exrauto' => { 126 => 0x1033 },
	'exrmode' => { 126 => 0x1034 },
	'extdescraccessibility' => { 487 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 228 => 0x114 },
	'extendedshutterspeeds' => { 294 => 0x102 },
	'extendedwbdetect' => { 296 => 0x902 },
	'extender' => { 297 => 0x301 },
	'extenderfirmwareversion' => { 297 => 0x304 },
	'extendermagnification' => { 157 => 'Magnification' },
	'extendermake' => { 157 => 'Make' },
	'extendermodel' => { 157 => 'Model', 297 => 0x303 },
	'extenderserialnumber' => { 157 => 'SerialNumber', 297 => 0x302 },
	'extenderstatus' => { 352 => 0x3 },
	'externalflash' => { 299 => 0x1201 },
	'externalflashae1' => { 301 => 0x101f },
	'externalflashae1_0' => { 301 => 0x101b },
	'externalflashae2' => { 301 => 0x1020 },
	'externalflashae2_0' => { 301 => 0x101c },
	'externalflashbounce' => { 299 => 0x1204, 301 => 0x1026, 342 => 0x1a },
	'externalflashcompensation' => { 210 => 0x1b },
	'externalflashexposurecomp' => { 225 => 0x17, 342 => 0x19 },
	'externalflashfirmware' => { 208 => 0x6, 209 => 0x6, 210 => 0x6, 211 => 0x6, 212 => 0x6, 213 => 0x6 },
	'externalflashflags' => { 208 => 0x8, 209 => 0x8, 210 => 0x8, 211 => 0x8 },
	'externalflashguidenumber' => { 299 => 0x1203, 342 => '24.1' },
	'externalflashgvalue' => { 301 => 0x1025 },
	'externalflashmode' => { 301 => 0x1028, 342 => 0x2 },
	'externalflashreadystate' => { 212 => '9.1' },
	'externalflashstatus' => { 212 => '8.2' },
	'externalflashzoom' => { 299 => 0x1205, 301 => 0x1027 },
	'externalflashzoomoverride' => { 212 => '8.1' },
	'externalmetadatalink' => { 488 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 314 => 0x311, 317 => 0x311, 318 => 0x311, 321 => 0x3408 },
	'extrainfoversion' => { 410 => 0x1a },
	'eyestartaf' => { 183 => 0x40 },
	'fac100per' => { 137 => 0xe94 },
	'fac170per' => { 137 => 0xe93 },
	'fac18per' => { 137 => 0xe92 },
	'face10position' => { 109 => 0x3f4, 110 => 0x1ec, 206 => 0x28, 339 => 0x12 },
	'face10size' => { 340 => 0x12 },
	'face11position' => { 206 => 0x2c, 339 => 0x14 },
	'face11size' => { 340 => 0x14 },
	'face12position' => { 206 => 0x30, 339 => 0x16 },
	'face12size' => { 340 => 0x16 },
	'face13position' => { 339 => 0x18 },
	'face13size' => { 340 => 0x18 },
	'face14position' => { 339 => 0x1a },
	'face14size' => { 340 => 0x1a },
	'face15position' => { 339 => 0x1c },
	'face15size' => { 340 => 0x1c },
	'face16position' => { 339 => 0x1e },
	'face16size' => { 340 => 0x1e },
	'face17position' => { 339 => 0x20 },
	'face17size' => { 340 => 0x20 },
	'face18position' => { 339 => 0x22 },
	'face18size' => { 340 => 0x22 },
	'face19position' => { 339 => 0x24 },
	'face19size' => { 340 => 0x24 },
	'face1position' => { 54 => 0x8, 109 => 0xd, 110 => 0x18, 206 => 0x4, 311 => 0x1, 339 => 0x0, 383 => 0xbc, 413 => 0x1, 414 => 0x0, 415 => 0x0, 416 => 0x5b },
	'face1size' => { 340 => 0x0 },
	'face20position' => { 339 => 0x26 },
	'face20size' => { 340 => 0x26 },
	'face21position' => { 339 => 0x28 },
	'face21size' => { 340 => 0x28 },
	'face22position' => { 339 => 0x2a },
	'face22size' => { 340 => 0x2a },
	'face23position' => { 339 => 0x2c },
	'face23size' => { 340 => 0x2c },
	'face24position' => { 339 => 0x2e },
	'face24size' => { 340 => 0x2e },
	'face25position' => { 339 => 0x30 },
	'face25size' => { 340 => 0x30 },
	'face26position' => { 339 => 0x32 },
	'face26size' => { 340 => 0x32 },
	'face27position' => { 339 => 0x34 },
	'face27size' => { 340 => 0x34 },
	'face28position' => { 339 => 0x36 },
	'face28size' => { 340 => 0x36 },
	'face29position' => { 339 => 0x38 },
	'face29size' => { 340 => 0x38 },
	'face2position' => { 54 => 0xa, 109 => 0x7c, 110 => 0x4c, 206 => 0x8, 311 => 0x5, 339 => 0x2, 383 => 0xc8, 413 => 0x6, 414 => 0x20, 415 => 0x25, 416 => 0x65 },
	'face2size' => { 340 => 0x2 },
	'face30position' => { 339 => 0x3a },
	'face30size' => { 340 => 0x3a },
	'face31position' => { 339 => 0x3c },
	'face31size' => { 340 => 0x3c },
	'face32position' => { 339 => 0x3e },
	'face32size' => { 340 => 0x3e },
	'face3position' => { 54 => 0xc, 109 => 0xeb, 110 => 0x80, 206 => 0xc, 311 => 0x9, 339 => 0x4, 383 => 0xd4, 413 => 0xb, 414 => 0x40, 415 => 0x4a, 416 => 0x6f },
	'face3size' => { 340 => 0x4 },
	'face4position' => { 54 => 0xe, 109 => 0x15a, 110 => 0xb4, 206 => 0x10, 311 => 0xd, 339 => 0x6, 383 => 0xe0, 413 => 0x10, 414 => 0x60, 415 => 0x6f, 416 => 0x79 },
	'face4size' => { 340 => 0x6 },
	'face5position' => { 54 => 0x10, 109 => 0x1c9, 110 => 0xe8, 206 => 0x14, 311 => 0x11, 339 => 0x8, 383 => 0xec, 413 => 0x15, 414 => 0x80, 415 => 0x94 },
	'face5size' => { 340 => 0x8 },
	'face6position' => { 54 => 0x12, 109 => 0x238, 110 => 0x11c, 206 => 0x18, 339 => 0xa, 383 => 0xf8, 413 => 0x1a, 414 => 0xa0, 415 => 0xb9 },
	'face6size' => { 340 => 0xa },
	'face7position' => { 54 => 0x14, 109 => 0x2a7, 110 => 0x150, 206 => 0x1c, 339 => 0xc, 383 => 0x104, 413 => 0x1f, 414 => 0xc0, 415 => 0xde },
	'face7size' => { 340 => 0xc },
	'face8position' => { 54 => 0x16, 109 => 0x316, 110 => 0x184, 206 => 0x20, 339 => 0xe, 383 => 0x110, 413 => 0x24, 414 => 0xe0, 415 => 0x103 },
	'face8size' => { 340 => 0xe },
	'face9position' => { 54 => 0x18, 109 => 0x385, 110 => 0x1b8, 206 => 0x24, 339 => 0x10 },
	'face9size' => { 340 => 0x10 },
	'facebalanceorigi' => { 470 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 470 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 470 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 470 => 'FaceBalanceWarmth' },
	'facedetect' => { 354 => 0x76, 393 => 0x100 },
	'facedetectarea' => { 300 => 0x1201 },
	'facedetectframecrop' => { 300 => 0x1207 },
	'facedetectframesize' => { 54 => 0x3, 109 => 0x1, 110 => 0x4, 206 => 0x1, 300 => 0x1203, 354 => 0x77, 383 => 0xb6 },
	'facedetection' => { 408 => 0x30, 424 => 0x19 },
	'faceelementpositions' => { 126 => 0x4203 },
	'faceelementselected' => { 126 => 0x4005 },
	'faceelementtypes' => { 126 => 0x4201 },
	'faceid' => { 472 => 'FaceID' },
	'faceinfounknown' => { 112 => 0x2089 },
	'facename' => { 393 => 0x123 },
	'faceorientation' => { 110 => 0x8 },
	'faceposition' => { 338 => 0x2, 394 => 0x4 },
	'facepositions' => { 126 => 0x4103 },
	'facerecognition' => { 393 => 0x120 },
	'facesdetected' => { 54 => 0x2, 55 => 0x2, 56 => 0x3, 109 => 0x0, 110 => 0x2, 112 => 0x211c, 126 => 0x4100, 206 => 0x3, 300 => 0x1200, 319 => 0x3f, 338 => 0x0, 383 => 0xb5, 394 => 0x0, 413 => 0x0, 416 => 0x3, 426 => 0x30 },
	'facesrecognized' => { 312 => 0x0 },
	'facewidth' => { 55 => 0x1 },
	'fade' => { 419 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 108 => 0x38 },
	'faithfuloutputshadowpoint' => { 108 => 0x39 },
	'faithfulrawcolortone' => { 108 => 0x31 },
	'faithfulrawcontrast' => { 108 => 0x33 },
	'faithfulrawhighlight' => { 108 => 0x79 },
	'faithfulrawhighlightpoint' => { 108 => 0x36 },
	'faithfulrawlinear' => { 108 => 0x34 },
	'faithfulrawsaturation' => { 108 => 0x32 },
	'faithfulrawshadow' => { 108 => 0x82 },
	'faithfulrawshadowpoint' => { 108 => 0x37 },
	'faithfulrawsharpness' => { 108 => 0x35 },
	'faithfulunsharpmaskfineness' => { 108 => 0xac },
	'faithfulunsharpmaskstrength' => { 108 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 108 => 0xae },
	'far' => { 461 => 'Far' },
	'fastresetlinetime' => { 137 => 0x1860 },
	'feedidentifier' => { 488 => 'FeedIdentifier' },
	'femicroadjustment' => { 83 => 0x111 },
	'ffid' => { 480 => 'ffid' },
	'field' => { 491 => 'field' },
	'fieldcount' => { 301 => 0x103f },
	'fieldofview' => { 379 => "FOV\x00" },
	'fifoenonepixeldelay' => { 137 => 0x1901 },
	'filecreatedate' => { 119 => 'FileCreateDate' },
	'filedatarate' => { 502 => 'fileDataRate' },
	'fileformat' => { 94 => 0x0, 131 => 0x14, 396 => [0x22,0x26], 419 => 0xb000 },
	'filegroupid' => { 119 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 320 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 119 => 'FileModifyDate' },
	'filename' => { 119 => 'FileName' },
	'filenameasdelivered' => { 306 => 'FileNameAsDelivered' },
	'filenumber' => { 57 => 0x1, 63 => 0x8, 96 => 0x1817, 113 => 'Canon-FileNumber', 207 => 0x4, 382 => 0x10 },
	'filenumbermemory' => { 180 => 0x1a },
	'filenumbersequence' => { 278 => '12.2', 283 => '3.1', 284 => '4.1', 285 => '4.1', 287 => '11.1', 288 => '4.3', 293 => '5.2', 294 => 0x48 },
	'filepermissions' => { 119 => 'FilePermissions' },
	'filesource' => { 118 => 0xa300, 126 => 0x8000, 482 => 'FileSource' },
	'fileuserid' => { 119 => 'FileUserID' },
	'fileversion' => { 131 => 0x16 },
	'fillflashautoreduction' => { 81 => 0xe, 82 => 0xe, 89 => 0xa },
	'filllight' => { 476 => 'FillLight', 478 => 'FillLight' },
	'fillorder' => { 118 => 0x10a },
	'filmgraineffect' => { 296 => 0x538 },
	'filmmode' => { 126 => 0x1401, 316 => 0x412, 319 => 0x42 },
	'filmtype' => { 236 => 0x2 },
	'filtereffect' => { 57 => 0xe, 230 => 0x37, 231 => 0x3f, 232 => 0x47, 319 => 0xa1 },
	'filtereffectauto' => { 70 => 0xa0 },
	'filtereffectfaithful' => { 69 => 0x70, 70 => 0x70 },
	'filtereffectlandscape' => { 69 => 0x40, 70 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 69 => 0x88, 70 => 0x88 },
	'filtereffectneutral' => { 69 => 0x58, 70 => 0x58 },
	'filtereffectportrait' => { 69 => 0x28, 70 => 0x28 },
	'filtereffectstandard' => { 69 => 0x10, 70 => 0x10 },
	'filtereffectuserdef1' => { 69 => 0xa0, 70 => 0xb8 },
	'filtereffectuserdef2' => { 69 => 0xb8, 70 => 0xd0 },
	'filtereffectuserdef3' => { 69 => 0xd0, 70 => 0xe8 },
	'finderdisplayduringexposure' => { 82 => 0x1 },
	'finesharpness' => { 354 => 0x70 },
	'finetuneoptcenterweighted' => { 278 => '7.2', 279 => '9.1', 281 => '9.1', 282 => '9.1', 286 => '8.1', 291 => '9.1', 292 => '9.1', 293 => '9.1', 294 => 0x23 },
	'finetuneopthighlightweighted' => { 281 => '46.1', 282 => '46.1', 291 => '46.1', 292 => '46.1', 294 => 0x27 },
	'finetuneoptmatrixmetering' => { 278 => '8.1', 279 => '8.2', 281 => '8.2', 282 => '8.2', 286 => '7.2', 287 => '6.1', 291 => '8.2', 292 => '8.2', 293 => '8.2', 294 => 0x21 },
	'finetuneoptspotmetering' => { 278 => '8.2', 279 => '9.2', 281 => '9.2', 282 => '9.2', 286 => '8.2', 287 => '6.2', 291 => '9.2', 292 => '9.2', 293 => '9.2', 294 => 0x25 },
	'finishexposure' => { 137 => 0xdbd },
	'finishfiletype' => { 137 => 0xdb8 },
	'finishlook' => { 137 => 0xdbc },
	'finishnoise' => { 137 => 0xdba },
	'finishresolution' => { 137 => 0xdb9 },
	'finishsharpening' => { 137 => 0xdbb },
	'firmware' => { 301 => 0x405, 396 => [0x8c,0x17,0x3b], 473 => 'Firmware' },
	'firmware2' => { 396 => 0x57 },
	'firmwaredate' => { 111 => 0x15, 112 => 0x2001, 380 => 0x4, 382 => 0x30 },
	'firmwareid' => { 187 => 0x0 },
	'firmwarename' => { 393 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 63 => 0x1e, 384 => 0x0 },
	'firmwarerevision2' => { 384 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 137 => [0x415,0xce5], 153 => 0x57, 155 => 'FirmwareVersion', 317 => 0x320, 319 => 0x2, 321 => 0x3109, 354 => 0x230, 379 => ['CNFV','FIRM'], 381 => 0x18, 382 => 0x2a, 386 => 0x2 },
	'firmwareversions' => { 363 => 0x301 },
	'firstphotodate' => { 464 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 306 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 130 => 0x16, 471 => 'FixtureIdentifier' },
	'flash' => { 113 => 'XMP-Flash', 118 => 0x9209, 151 => 0x22, 181 => 0x1f, 182 => 0x15, 382 => 0x5a, 482 => 'Flash' },
	'flashaction' => { 406 => 0x3e, 407 => 0x3e, 419 => 0x2017, 424 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 406 => 0x4c, 407 => 0x4c, 424 => 0x77 },
	'flashactionexternal' => { 424 => [0x78,0x7c] },
	'flashactivity' => { 34 => 0x1c },
	'flashbatterylevel' => { 44 => 0x249 },
	'flashbias' => { 319 => 0x24 },
	'flashbits' => { 34 => 0x1d },
	'flashburstpriority' => { 294 => 0x111 },
	'flashbuttonfunction' => { 83 => 0x70e },
	'flashchargelevel' => { 301 => 0x1010 },
	'flashcolorfilter' => { 210 => 0x10, 211 => 0x10 },
	'flashcommandermode' => { 208 => '9.1', 209 => '9.1', 210 => '9.1', 211 => '9.1' },
	'flashcompensation' => { 137 => 0x3f3, 208 => 0xa, 209 => 0xa, 210 => 0xa, 211 => 0x27, 212 => 0xa, 213 => 0xa, 473 => 'FlashCompensation' },
	'flashcontrol' => { 406 => 0x23, 407 => 0x1f, 408 => 0x21 },
	'flashcontrolbuilt-in' => { 287 => '16.1', 288 => '23.1', 290 => '23.1', 291 => '24.1' },
	'flashcontrolmode' => { 208 => '9.2', 209 => '9.2', 210 => '9.2', 211 => '9.2', 227 => 0x148, 228 => 0x1a8, 251 => 0xc4a6, 296 => 0x404 },
	'flashcurtain' => { 319 => 0x48 },
	'flashdefault' => { 183 => 0x42 },
	'flashdevice' => { 301 => 0x1005 },
	'flashdistance' => { 112 => 0x2034 },
	'flashenergy' => { 118 => 0xa20b, 482 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 225 => 0x18 },
	'flashexposurecomp' => { 76 => 0xf, 126 => 0x1011, 158 => 'ExposureComp', 180 => 0x23, 185 => 0x104, 186 => 0x49c1, 225 => 0x12, 296 => 0x401, 301 => 0x1023, 354 => 0x4d, 386 => 0x100b, 396 => [0x3a,0x56], 419 => 0x104 },
	'flashexposurecomp2' => { 255 => 0x4d2 },
	'flashexposurecomp3' => { 210 => 0x1d },
	'flashexposurecomp4' => { 210 => 0x27 },
	'flashexposurecomparea' => { 279 => '38.4', 281 => '38.4', 282 => '38.4', 291 => '38.4', 292 => '38.4', 294 => 0x59 },
	'flashexposurecompset' => { 183 => 0x10, 327 => 0xe, 406 => 0x14, 407 => 0x12, 408 => 0x23, 424 => 0x1f },
	'flashexposurecompset2' => { 424 => [0x26,0x2c] },
	'flashexposureindicator' => { 183 => 0x54 },
	'flashexposureindicatorlast' => { 183 => 0x56 },
	'flashexposureindicatornext' => { 183 => 0x55 },
	'flashexposurelock' => { 57 => 0x19 },
	'flashfired' => { 139 => 0x5d, 158 => 'Fired', 180 => 0x14, 254 => '590.3', 482 => [\'Flash','FlashFired'] },
	'flashfiring' => { 83 => 0x306, 84 => 0x6, 85 => 0x7, 88 => 0x7 },
	'flashfirmwareversion' => { 297 => 0x1002 },
	'flashfocallength' => { 208 => 0xb, 209 => 0xc, 210 => 0xc, 211 => 0xc, 212 => 0xc },
	'flashfunction' => { 186 => 0x31, 482 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 208 => 0xe, 209 => 0xf, 210 => 0xf, 211 => 0xf, 212 => 0xf, 227 => 0x14e, 228 => 0x1ae, 251 => 0xc4ac },
	'flashgroupacompensation' => { 208 => 0x11, 209 => 0x12, 210 => 0x13, 211 => 0x28, 212 => 0x28 },
	'flashgroupacontrolmode' => { 208 => 0xf, 209 => '16.1', 210 => '17.1', 211 => '17.1', 212 => '17.1' },
	'flashgroupaoutput' => { 208 => 0x11, 209 => 0x12, 210 => 0x13, 211 => 0x28, 212 => 0x28 },
	'flashgroupbcompensation' => { 208 => 0x12, 209 => 0x13, 210 => 0x14, 211 => 0x29, 212 => 0x29 },
	'flashgroupbcontrolmode' => { 208 => 0x10, 209 => '17.1', 210 => '18.1', 211 => '18.1', 212 => '18.1' },
	'flashgroupboutput' => { 208 => 0x12, 209 => 0x13, 210 => 0x14, 211 => 0x29, 212 => 0x29 },
	'flashgroupccompensation' => { 209 => 0x14, 210 => 0x15, 211 => 0x2a, 212 => 0x2a },
	'flashgroupccontrolmode' => { 209 => '17.2', 210 => '18.2', 211 => '18.2', 212 => '18.2' },
	'flashgroupcoutput' => { 209 => 0x14, 210 => 0x15, 211 => 0x2a, 212 => 0x2a },
	'flashguidenumber' => { 76 => 0xd, 93 => 0x0, 158 => 'GuideNumber' },
	'flashintensity' => { 111 => [0x19,0x5], 296 => 0x405 },
	'flashlevel' => { 280 => 0x9, 419 => 0xb048 },
	'flashmake' => { 158 => 'Make' },
	'flashmanufacturer' => { 177 => 'FlashManufacturer' },
	'flashmastercompensation' => { 227 => 0x162, 228 => 0x1aa, 251 => 0xc4c0 },
	'flashmastercontrolmode' => { 227 => 0x160, 251 => 0xc4be },
	'flashmasteroutput' => { 227 => 0x166, 251 => 0xc4c4 },
	'flashmetering' => { 180 => 0x3f, 183 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 354 => 0x20a },
	'flashmode' => { 111 => 0x4, 137 => 0x3f2, 139 => 0x5c, 150 => 0x27, 158 => 'Mode', 180 => 0x2, 181 => 0x20, 182 => 0x16, 183 => 0xf, 225 => 0x87, 296 => 0x400, 301 => 0x1004, 354 => 0xc, 361 => 0x4, 385 => 0x20, 386 => 0x100a, 395 => 0x225, 406 => 0x13, 407 => 0x7f, 408 => 0x20, 424 => 0x10, 427 => 0x1138, 428 => 0x1138, 429 => 0x1114, 430 => 0x1190, 431 => 0x116c, 432 => 0x1024, 433 => 0x21c, 434 => 0x21c, 435 => 0x211, 482 => [\'Flash','FlashMode'] },
	'flashmodel' => { 158 => 'Model', 177 => 'FlashModel', 297 => 0x1001 },
	'flashoptions' => { 335 => 0x2 },
	'flashoptions2' => { 335 => 0x10 },
	'flashoutput' => { 44 => 0x248, 76 => 0x21, 208 => 0xa, 209 => 0xa, 210 => 0xa, 211 => 0x27, 227 => 0x152, 228 => 0x1b2, 251 => 0xc4b0 },
	'flashpixversion' => { 118 => 0xa000, 482 => 'FlashpixVersion' },
	'flashredeyemode' => { 482 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 227 => 0x15c, 228 => 0x1bc, 251 => 0xc4ba, 296 => 0x403 },
	'flashreturn' => { 482 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 158 => 'SerialNumber', 297 => 0x1003 },
	'flashsetting' => { 225 => 0x8 },
	'flashshutterspeed' => { 278 => '20.2', 279 => '23.2', 281 => '23.2', 282 => '23.2', 287 => '15.2', 288 => '22.2', 289 => '7.2', 290 => '22.2', 291 => '23.2', 292 => '23.2', 293 => '23.1', 294 => 0x57 },
	'flashsource' => { 208 => 0x4, 209 => 0x4, 210 => 0x4, 211 => 0x4, 212 => 0x4, 213 => 0x4 },
	'flashstatus' => { 342 => 0x0, 424 => [0x82,0x86], 437 => 0x31, 438 => 0x39, 439 => 0x39 },
	'flashstatusbuilt-in' => { 408 => [0x87,0x287] },
	'flashstatusexternal' => { 408 => [0x88,0x288] },
	'flashsyncspeed' => { 278 => '20.1', 279 => '23.1', 281 => '23.1', 282 => '23.1', 287 => '15.1', 288 => '22.1', 290 => '22.1', 291 => '23.1', 292 => '23.1', 294 => 0x53 },
	'flashsyncspeedav' => { 81 => 0x3, 83 => 0x10f, 84 => 0x2, 85 => 0x3, 86 => 0x2, 87 => 0x2, 88 => 0x3, 89 => 0x6 },
	'flashthreshold' => { 93 => 0x1 },
	'flashtype' => { 158 => 'Type', 183 => 0x59, 225 => 0x9, 297 => 0x1000 },
	'flashwarning' => { 288 => '30.1', 289 => '7.1', 293 => '31.1', 319 => 0x62 },
	'flashwirelessoption' => { 227 => 0x15a, 228 => 0x1c8, 251 => 0xc4c6 },
	'flexiblespotposition' => { 419 => 0x201d },
	'flickadvancedirection' => { 294 => 0x25f },
	'flickerreduce' => { 395 => 0x218 },
	'flickerreduction' => { 126 => 0x1446, 247 => 0xe84 },
	'flickerreductionindicator' => { 247 => 0x5e2 },
	'flickerreductionshooting' => { 228 => 0x1a4 },
	'flightpitchdegree' => { 115 => 'FlightPitchDegree' },
	'flightrolldegree' => { 115 => 'FlightRollDegree' },
	'flightxspeed' => { 115 => 'FlightXSpeed' },
	'flightyawdegree' => { 115 => 'FlightYawDegree' },
	'flightyspeed' => { 115 => 'FlightYSpeed' },
	'flightzspeed' => { 115 => 'FlightZSpeed' },
	'fliphorizontal' => { 271 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 30 => 0x5, 31 => 0x6, 76 => 0x15, 118 => 0x829d, 136 => 0xfd04, 139 => 0x1e, 141 => 0xfa23, 143 => 0xf103, 146 => 0x13, 148 => 0x3c, 150 => 0x1c, 151 => 0x18, 153 => 0xc, 162 => 'FNumber', 180 => 0xa, 181 => 0x36, 182 => 0x47, 183 => 0x9, 186 => 0x49c7, 223 => 0x38, 318 => 0x35a, 354 => 0x13, 393 => 0xa019, 396 => [0x31,0x49], 406 => 0x1, 407 => 0x1, 424 => [0x20,0x22,0x26], 482 => 'FNumber' },
	'focaldistance' => { 462 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 59 => 0x1, 112 => 0x1d, 118 => 0x920a, 146 => 0x1d, 162 => 'FocalLength', 180 => 0x12, 218 => 0xa, 219 => 0xb, 223 => [0xc,0x3c], 313 => 0x1, 354 => 0x1d, 363 => 0x403, 386 => 0x1500, 405 => 0xe, 431 => 0x1278, 432 => 0x1134, 433 => 0x32c, 434 => 0x32c, 435 => 0x30a, 482 => 'FocalLength' },
	'focallength2' => { 424 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 118 => 0xa405, 393 => 0xa01a, 482 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 405 => 0x10 },
	'focalplaneafpointarea' => { 436 => 0x2 },
	'focalplaneafpointlocation1' => { 436 => 0x6 },
	'focalplaneafpointlocation10' => { 436 => 0x2a },
	'focalplaneafpointlocation11' => { 436 => 0x2e },
	'focalplaneafpointlocation12' => { 436 => 0x32 },
	'focalplaneafpointlocation13' => { 436 => 0x36 },
	'focalplaneafpointlocation14' => { 436 => 0x3a },
	'focalplaneafpointlocation15' => { 436 => 0x3e },
	'focalplaneafpointlocation2' => { 436 => 0xa },
	'focalplaneafpointlocation3' => { 436 => 0xe },
	'focalplaneafpointlocation4' => { 436 => 0x12 },
	'focalplaneafpointlocation5' => { 436 => 0x16 },
	'focalplaneafpointlocation6' => { 436 => 0x1a },
	'focalplaneafpointlocation7' => { 436 => 0x1e },
	'focalplaneafpointlocation8' => { 436 => 0x22 },
	'focalplaneafpointlocation9' => { 436 => 0x26 },
	'focalplaneafpointsused' => { 436 => 0x1 },
	'focalplanediagonal' => { 297 => 0x103, 301 => 0x205 },
	'focalplaneresolutionunit' => { 118 => 0xa210, 482 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 118 => 0xa20e, 482 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 59 => 0x2 },
	'focalplanexunknown' => { 59 => 0x2 },
	'focalplaneyresolution' => { 118 => 0xa20f, 482 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 59 => 0x3 },
	'focalplaneyunknown' => { 59 => 0x3 },
	'focalpointx' => { 462 => 'FocalPointX' },
	'focalpointy' => { 462 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 59 => 0x0 },
	'focalunits' => { 34 => 0x19 },
	'focus' => { 261 => 0x8 },
	'focusarea' => { 180 => 0x31 },
	'focusareaselection' => { 289 => '15.2' },
	'focusbracket' => { 319 => 0xbd },
	'focusbracketstepsize' => { 296 => 0x308 },
	'focuscontinuous' => { 34 => 0x20 },
	'focusdisplayaiservoandmf' => { 83 => 0x515 },
	'focusdistance' => { 162 => 'FocusDistance', 180 => 0x13, 186 => 0x49bb, 218 => 0x9, 219 => 0xa, 223 => [0xb,0x4f], 299 => 0x305, 313 => 0x0, 317 => 0x304, 318 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 57 => 0x15, 76 => 0x14 },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 57 => 0x14, 76 => 0x13 },
	'focusholdbutton' => { 183 => 0x44 },
	'focusinfoversion' => { 299 => 0x0 },
	'focusingscreen' => { 82 => 0x0, 83 => 0x80b, 88 => 0x0 },
	'focuslocation' => { 419 => 0x2027 },
	'focuslocked' => { 179 => 0x14 },
	'focusmode' => { 34 => 0x7, 111 => 0x3, 112 => [0x3003,0xd], 126 => 0x1021, 137 => 0x3f5, 139 => 0x38, 155 => 'FocusMode', 180 => 0x30, 182 => 0xe, 183 => 0xc, 225 => 0x7, 296 => 0x301, 301 => 0x100b, 319 => 0x7, 354 => 0xd, 361 => 0x3, 386 => 0x1006, 399 => [0xb,0x5], 405 => [0x15,0x1d], 406 => 0x4d, 407 => 0x4d, 419 => [0xb042,0xb04e,0x201b], 424 => 0x13, 443 => 0x16 },
	'focusmode2' => { 125 => '0.1', 335 => '3.1', 424 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 280 => '10.1', 403 => 0x14, 404 => 0x15, 406 => 0x10, 407 => 0xf, 408 => 0x6 },
	'focusmodeswitch' => { 183 => 0x58, 406 => 0x2e },
	'focuspeakingdisplay' => { 294 => 0x235 },
	'focuspeakinghighlightcolor' => { 294 => 0x4b },
	'focuspeakinglevel' => { 294 => 0x49 },
	'focuspixel' => { 126 => 0x1023 },
	'focuspointlock' => { 294 => 0x1d3 },
	'focuspointpersistence' => { 294 => 0x105 },
	'focuspointwrap' => { 278 => '2.2', 279 => '2.2', 281 => '2.1', 282 => '2.1', 286 => '1.1', 287 => '2.2', 288 => '1.1', 291 => '2.2', 292 => '2.1', 293 => '2.5', 294 => 0x16 },
	'focusposition' => { 218 => 0x8, 219 => 0x8, 223 => 0x9, 354 => 0x10, 417 => 0x9bb },
	'focusposition2' => { 424 => [0x29,0x2b,0x2f], 443 => 0x2d, 446 => 0x20 },
	'focuspositionhoriontal' => { 193 => 0x43 },
	'focuspositionvertical' => { 193 => 0x45 },
	'focusprocess' => { 296 => 0x302 },
	'focusrange' => { 34 => 0x12, 301 => 0x100a },
	'focusrangeindex' => { 345 => '3.1' },
	'focusringrotation' => { 83 => 0x713 },
	'focussetting' => { 396 => 0x6 },
	'focusshiftexposurelock' => { 227 => 0xe8, 228 => 0xf4, 251 => 0xc446 },
	'focusshiftinterval' => { 227 => 0xe4, 228 => 0xf0, 251 => 0xc442 },
	'focusshiftnumbershots' => { 227 => 0xdc, 228 => 0xe8, 251 => 0xc43a },
	'focusshiftshooting' => { 260 => 0x7844 },
	'focusshiftstepwidth' => { 227 => 0xe0, 228 => 0xec, 251 => 0xc43e },
	'focusstatus' => { 405 => 0x19, 406 => 0x53, 407 => 0x53 },
	'focusstepcount' => { 299 => 0x301, 301 => 0x100e },
	'focusstepinfinity' => { 299 => 0x303, 301 => 0x103b },
	'focusstepnear' => { 299 => 0x304, 301 => 0x103c },
	'focustrackinglockon' => { 278 => ['1.5','4.1'], 279 => '1.4', 286 => '0.4', 287 => '3.1', 288 => '0.4', 291 => '1.4' },
	'focuswarning' => { 126 => 0x1301 },
	'foldername' => { 180 => 0x27 },
	'foldernumber' => { 406 => 0x9a, 408 => [0x402,0x114,0x316] },
	'fontcomposite' => { 507 => [\'Fonts','FontsComposite'] },
	'fontface' => { 507 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 507 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 507 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 507 => [\'Fonts','FontsFontName'] },
	'fonts' => { 507 => 'Fonts' },
	'fonttype' => { 507 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 507 => [\'Fonts','FontsVersionString'] },
	'for' => { 370 => 'For' },
	'forcewrite' => { 119 => 'ForceWrite' },
	'format' => { 379 => "\xa9fmt", 461 => 'Format', 479 => 'format', 500 => 'Format' },
	'forwardlock' => { 497 => 'forwardlock' },
	'forwardmatrix1' => { 118 => 0xc714 },
	'forwardmatrix2' => { 118 => 0xc715 },
	'forwardmatrix3' => { 118 => 0xcd34 },
	'fossilspecimen' => { 117 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 117 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 66 => [0x2,0x4] },
	'frameheight' => { 126 => 0x3822 },
	'framenum' => { 365 => 0xd7 },
	'framenumber' => { 126 => 0x8003, 186 => 0x3c, 354 => 0x29 },
	'framerate' => { 66 => [0x1,0x6], 118 => 0xc764, 126 => 0x3820 },
	'framereadouttime' => { 373 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 126 => 0x3821 },
	'framing' => { 491 => 'framing' },
	'freebytes' => { 96 => 0x1 },
	'freememorycardimages' => { 181 => [0x37,0x54], 182 => [0x2d,0x4a], 183 => 0x32 },
	'fujiflashmode' => { 126 => 0x1010 },
	'fullhdhighspeedrec' => { 126 => 0x3824 },
	'fullimagesize' => { 419 => 0xb02b },
	'fullpanoheightpixels' => { 464 => 'FullPanoHeightPixels', 465 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 464 => 'FullPanoWidthPixels', 465 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 386 => 0x100d },
	'fullsizeimage' => { 161 => 'data' },
	'fullsizeimagename' => { 161 => '1Name' },
	'fullsizeimagetype' => { 161 => '0Type' },
	'func1button' => { 281 => '14.1', 282 => '14.1', 292 => '14.1', 294 => 0x63 },
	'func1buttonplaybackmode' => { 294 => 0x1a5 },
	'func1buttonplusdials' => { 281 => '42.1', 282 => '42.1', 292 => '42.1' },
	'func2button' => { 281 => '80.1', 282 => '80.1', 292 => '80.1', 294 => 0x73 },
	'func2buttonplaybackmode' => { 294 => 0x1a7 },
	'func2buttonplusdials' => { 281 => '81.1' },
	'func3button' => { 281 => '83.1', 294 => 0x119 },
	'func3buttonplaybackmode' => { 294 => 0x1a9 },
	'func4button' => { 294 => 0x175 },
	'func4buttonplaybackmode' => { 294 => 0x1af },
	'funcbutton' => { 278 => ['14.1','15.1'], 279 => '14.1', 287 => '28.1', 288 => '13.1', 291 => '14.1', 293 => '14.1' },
	'funcbuttonplusdials' => { 278 => ['14.2','15.2'], 279 => '14.2', 287 => '31.1', 291 => '42.1' },
	'functionbutton' => { 285 => '13.1', 289 => '5.2' },
	'gainbase' => { 300 => 0x610 },
	'gaincontrol' => { 118 => 0xa407, 482 => 'GainControl' },
	'gamma' => { 118 => 0xa500, 137 => 0x8fe, 307 => 'gAMA', 324 => 0x11c, 483 => 'Gamma' },
	'gammablackpoint' => { 104 => 0xc },
	'gammacolortone' => { 104 => 0x3 },
	'gammacompensatedvalue' => { 132 => 0x91 },
	'gammacontrast' => { 104 => 0x2 },
	'gammacurveoutputrange' => { 104 => 0xf },
	'gammahighlight' => { 104 => 0xa },
	'gammalinear' => { 102 => 0x20200 },
	'gammamidpoint' => { 104 => 0xe },
	'gammasaturation' => { 104 => 0x4 },
	'gammashadow' => { 104 => 0x9 },
	'gammasharpnessstrength' => { 104 => 0x8 },
	'gammaunsharpmaskfineness' => { 104 => 0x6 },
	'gammaunsharpmaskstrength' => { 104 => 0x5 },
	'gammaunsharpmaskthreshold' => { 104 => 0x7 },
	'gammawhitepoint' => { 104 => 0xd },
	'garminsettings' => { 379 => 'pmcc' },
	'garminsoftware' => { 379 => 'uuid' },
	'gdalmetadata' => { 118 => 0xa480 },
	'gdalnodata' => { 118 => 0xa481 },
	'geimagesize' => { 126 => 0x1304 },
	'gemake' => { 128 => 0x300 },
	'gemodel' => { 128 => 0x207 },
	'genre' => { 371 => ['gnre',"\xa9gen"], 373 => 'genre', 379 => ['gnre',"\xa9gen"], 488 => 'Genre', 492 => 'genre', 502 => 'genre' },
	'genrecvid' => { 488 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 488 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 488 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 488 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 371 => 'geID' },
	'geography' => { 493 => 'geography' },
	'geologicalcontext' => { 117 => 'GeologicalContext' },
	'geologicalcontextbed' => { 117 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 117 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 117 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 117 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 117 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 119 => 'Geosync' },
	'geotag' => { 119 => 'Geotag' },
	'geotiffasciiparams' => { 118 => 0x87b1 },
	'geotiffdirectory' => { 118 => 0x87af },
	'geotiffdoubleparams' => { 118 => 0x87b0 },
	'geotime' => { 119 => 'Geotime' },
	'giftftppriority' => { 466 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 115 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 115 => 'GimbalReverse' },
	'gimbalrolldegree' => { 115 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 115 => 'GimbalYawDegree' },
	'globalaltitude' => { 368 => 0x419 },
	'globalangle' => { 368 => 0x40d },
	'good' => { 502 => 'good' },
	'googlehostheader' => { 371 => 'gshh' },
	'googlepingmessage' => { 371 => 'gspm' },
	'googlepingurl' => { 371 => 'gspu' },
	'googleplusuploadcode' => { 118 => 0x9009 },
	'googlesourcedata' => { 371 => 'gssd' },
	'googlestarttime' => { 371 => 'gsst' },
	'googletrackduration' => { 371 => 'gstd' },
	'goprotype' => { 379 => 'GoPr' },
	'gpsaltitude' => { 129 => 0x6, 159 => 'Altitude', 482 => 'GPSAltitude' },
	'gpsaltituderef' => { 129 => 0x5, 482 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 129 => 0x1c, 482 => 'GPSAreaInformation' },
	'gpscoordinates' => { 371 => "\xa9xyz", 373 => 'location.ISO6709', 379 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 129 => 0x1d },
	'gpsdatetime' => { 159 => 'DateTime', 482 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 129 => 0x18, 159 => 'Bearing', 482 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 129 => 0x17, 482 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 129 => 0x1a, 159 => 'Distance', 482 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 129 => 0x19, 482 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 129 => 0x14, 482 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 129 => 0x13 },
	'gpsdestlongitude' => { 129 => 0x16, 482 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 129 => 0x15 },
	'gpsdifferential' => { 129 => 0x1e, 159 => 'Differential', 482 => 'GPSDifferential' },
	'gpsdop' => { 129 => 0xb, 482 => 'GPSDOP' },
	'gpshpositioningerror' => { 129 => 0x1f, 482 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 129 => 0x11, 482 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 129 => 0x10, 482 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 115 => 'GpsLatitude', 129 => 0x2, 159 => 'Latitude', 482 => 'GPSLatitude' },
	'gpslatituderef' => { 129 => 0x1 },
	'gpslongitude' => { 115 => 'GpsLongitude', 129 => 0x4, 159 => 'Longitude', 482 => 'GPSLongitude' },
	'gpslongituderef' => { 129 => 0x3 },
	'gpslongtitude' => { 115 => 'GpsLongtitude' },
	'gpsmapdatum' => { 129 => 0x12, 159 => 'Datum', 482 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 129 => 0xa, 159 => 'MeasureMode', 482 => 'GPSMeasureMode' },
	'gpsposition' => { 113 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 129 => 0x1b, 482 => 'GPSProcessingMethod' },
	'gpssatellites' => { 129 => 0x8, 159 => 'Satellites', 482 => 'GPSSatellites' },
	'gpsspeed' => { 129 => 0xd, 159 => 'Speed', 482 => 'GPSSpeed' },
	'gpsspeedref' => { 129 => 0xc, 482 => 'GPSSpeedRef' },
	'gpsstatus' => { 129 => 0x9, 482 => 'GPSStatus' },
	'gpsstring' => { 137 => 0x402 },
	'gpstimestamp' => { 129 => 0x7 },
	'gpstrack' => { 129 => 0xf, 159 => 'Heading', 482 => 'GPSTrack' },
	'gpstrackref' => { 129 => 0xe, 482 => 'GPSTrackRef' },
	'gpsversionid' => { 129 => 0x0, 482 => 'GPSVersionID' },
	'gradation' => { 296 => 0x50f },
	'gradientbasedcorractive' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 476 => 'GradientBasedCorrections', 478 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 476 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 478 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 476 => 'GrainAmount', 478 => 'GrainAmount' },
	'graineffect' => { 126 => 0x1047 },
	'grainfrequency' => { 476 => 'GrainFrequency', 478 => 'GrainFrequency' },
	'grainseed' => { 476 => 'GrainSeed', 478 => 'GrainSeed' },
	'grainsize' => { 476 => 'GrainSize', 478 => 'GrainSize' },
	'graymixeraqua' => { 476 => 'GrayMixerAqua', 478 => 'GrayMixerAqua' },
	'graymixerblue' => { 476 => 'GrayMixerBlue', 478 => 'GrayMixerBlue' },
	'graymixergreen' => { 476 => 'GrayMixerGreen', 478 => 'GrayMixerGreen' },
	'graymixermagenta' => { 476 => 'GrayMixerMagenta', 478 => 'GrayMixerMagenta' },
	'graymixerorange' => { 476 => 'GrayMixerOrange', 478 => 'GrayMixerOrange' },
	'graymixerpurple' => { 476 => 'GrayMixerPurple', 478 => 'GrayMixerPurple' },
	'graymixerred' => { 476 => 'GrayMixerRed', 478 => 'GrayMixerRed' },
	'graymixeryellow' => { 476 => 'GrayMixerYellow', 478 => 'GrayMixerYellow' },
	'graypoint' => { 453 => 0x8021 },
	'grayresponseunit' => { 118 => 0x122 },
	'greencurvelimits' => { 107 => 0x1c4 },
	'greencurvepoints' => { 106 => 0x53, 107 => 0x19a },
	'greenhsl' => { 102 => 0x20913 },
	'greenhue' => { 476 => 'GreenHue', 478 => 'GreenHue' },
	'greensaturation' => { 476 => 'GreenSaturation', 478 => 'GreenSaturation' },
	'griddisplay' => { 278 => '13.3', 279 => '4.3', 281 => '4.2', 282 => '4.2', 283 => '2.2', 287 => '10.5', 288 => '3.4', 289 => '6.1', 291 => '4.4', 292 => '4.2', 293 => '4.2' },
	'gripbatteryadload' => { 333 => 0x5 },
	'gripbatteryadnoload' => { 333 => 0x4 },
	'gripbatterystate' => { 333 => '1.2' },
	'group' => { 476 => 'Group', 478 => 'Group' },
	'groupareaafillumination' => { 279 => '46.4', 282 => '47.4', 291 => '47.4' },
	'grouping' => { 371 => ['grup',"\xa9grp"], 379 => "\xa9grp" },
	'guid' => { 371 => 'GUID' },
	'h2resetblackpixels' => { 137 => 0x18a6 },
	'h3resetblackcolumns' => { 137 => 0x18ce },
	'h3resetblackpixels' => { 137 => 0x18b0 },
	'halftonehints' => { 118 => 0x141 },
	'hardlink' => { 119 => 'HardLink' },
	'hasalternative' => { 492 => 'hasAlternative' },
	'hascorrection' => { 492 => 'hasCorrection' },
	'hascorrectiona-lang' => { 492 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 492 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 492 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 476 => 'HasCrop', 478 => 'HasCrop' },
	'hasextendedxmp' => { 504 => 'HasExtendedXMP' },
	'hassettings' => { 476 => 'HasSettings', 478 => 'HasSettings' },
	'hastranslation' => { 492 => 'hasTranslation' },
	'hasvisibleoverprint' => { 507 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 507 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 227 => 0x35a },
	'hdmioutputresolution' => { 228 => 0x610 },
	'hdmiviewassist' => { 294 => 0x20f },
	'hdr' => { 60 => 0x1, 215 => 0x4, 319 => 0x9e, 354 => 0x85, 419 => 0x200a },
	'hdreffect' => { 60 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 215 => 0x0 },
	'hdrlevel' => { 215 => 0x5, 408 => 0x2e, 424 => 0x17 },
	'hdrlevel2' => { 215 => 0x7 },
	'hdrpmakernote' => { 459 => 'hdrp_makernote' },
	'hdrsetting' => { 408 => 0x2d, 424 => 0x16, 427 => 0x1148, 428 => 0x1148, 429 => 0x1124, 430 => 0x11a0, 431 => 0x117c, 432 => 0x1034, 433 => 0x22c, 434 => 0x22c, 435 => 0x21f },
	'hdrshot' => { 319 => 0x76 },
	'hdrsmoothing' => { 215 => 0x6 },
	'hdvideo' => { 371 => 'hdvd' },
	'headline' => { 130 => 0x69, 488 => 'Headline', 490 => 'Headline' },
	'hierarchicalkeywords' => { 170 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 170 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 170 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 170 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 170 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 170 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 170 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 170 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 170 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 170 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 170 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 170 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 170 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 170 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 170 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 170 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 170 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 170 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 468 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 117 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 324 => 0x1a },
	'highisomultipliergreen' => { 324 => 0x19 },
	'highisomultiplierred' => { 324 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 62 => 0x5, 83 => 0x202, 225 => 0xb1, 354 => 0x71, 406 => 0x2c, 407 => 0x26, 408 => 0x26, 419 => 0x2009, 424 => 0x12, 449 => 0x42 },
	'highisonoisereduction2' => { 419 => 0xb050 },
	'highlight' => { 396 => 0xf },
	'highlight2012' => { 476 => 'Highlight2012', 478 => 'Highlight2012' },
	'highlightadj' => { 102 => 0x2030c },
	'highlightcolordistortreduct' => { 453 => 0x8026 },
	'highlightlinearitylimit' => { 393 => 0xa025 },
	'highlightprotection' => { 270 => 0x6 },
	'highlightrecovery' => { 476 => 'HighlightRecovery', 478 => 'HighlightRecovery' },
	'highlights' => { 419 => 0x2033, 470 => 'Highlights' },
	'highlights2012' => { 476 => 'Highlights2012', 478 => 'Highlights2012' },
	'highlightsadj' => { 453 => 0x9019 },
	'highlightshadow' => { 319 => 0xad },
	'highlighttone' => { 126 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 62 => 0x3, 83 => 0x203 },
	'highlightwarning' => { 319 => 0x8002 },
	'highlowkeyadj' => { 354 => 0x6c },
	'highspeedsync' => { 183 => 0x5, 294 => 0x55, 406 => 0x2, 407 => 0x2 },
	'hintversion' => { 379 => 'hinv' },
	'histogramxml' => { 271 => 0x83a1a25 },
	'history' => { 490 => 'History', 503 => 'History' },
	'historyaction' => { 503 => [\'History','HistoryAction'] },
	'historychanged' => { 503 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 503 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 503 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 503 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 503 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 137 => 0xc88 },
	'holefilldeltathreshold' => { 137 => 0xc7e },
	'hometowncity' => { 112 => 0x3006, 354 => 0x23, 360 => 0x2 },
	'hometowncitycode' => { 361 => 0x1000 },
	'hometowndst' => { 354 => 0x25, 360 => '0.2' },
	'hostcomputer' => { 118 => 0x13c },
	'hostsoftwarerendering' => { 137 => 0xce7 },
	'hue' => { 188 => 0x3b, 231 => 0x3d, 232 => 0x45, 354 => 0x67 },
	'hueadj' => { 274 => 0x2f, 453 => 0x8019 },
	'hueadjust' => { 386 => 0x1016 },
	'hueadjustment' => { 181 => 0x4a, 182 => 0x40, 225 => 0x92, 230 => 0x36 },
	'hueadjustmentaqua' => { 476 => 'HueAdjustmentAqua', 478 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 476 => 'HueAdjustmentBlue', 478 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 476 => 'HueAdjustmentGreen', 478 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 476 => 'HueAdjustmentMagenta', 478 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 476 => 'HueAdjustmentOrange', 478 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 476 => 'HueAdjustmentPurple', 478 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 476 => 'HueAdjustmentRed', 478 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 476 => 'HueAdjustmentYellow', 478 => 'HueAdjustmentYellow' },
	'huesetting' => { 304 => 0x1011 },
	'humanobservation' => { 117 => 'HumanObservation' },
	'humanobservationday' => { 117 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 117 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 117 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 117 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 117 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 117 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 117 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 117 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 117 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 117 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 117 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 117 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 117 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 117 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 117 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 117 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 117 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 117 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 117 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 117 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 118 => 0x9401, 483 => 'Humidity' },
	'icc_profile' => { 119 => 'ICC_Profile' },
	'iccprofilename' => { 490 => 'ICCProfile' },
	'iconuri' => { 379 => 'icnu' },
	'idccreativestyle' => { 453 => 0x8000 },
	'idcpreviewlength' => { 453 => 0x202 },
	'idcpreviewstart' => { 453 => 0x201 },
	'identification' => { 117 => 'Identification' },
	'identificationid' => { 117 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 117 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 117 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 117 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 117 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 117 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 479 => 'identifier', 500 => 'Identifier' },
	'ifcameramodel' => { 137 => 0x9c8 },
	'illuminantdata1' => { 118 => 0xcd35 },
	'illuminantdata2' => { 118 => 0xcd36 },
	'illuminantdata3' => { 118 => 0xcd37 },
	'illumination' => { 289 => '0.5', 381 => 0x48 },
	'imageabsolutex' => { 137 => 0x3fe },
	'imageabsolutey' => { 137 => 0x3ff },
	'imageadjustment' => { 225 => 0x80, 261 => 0x5 },
	'imagealterationconstraints' => { 306 => 'ImageAlterationConstraints' },
	'imagearea' => { 241 => 0x10, 244 => 0x10 },
	'imageareaoffset' => { 354 => 0x38 },
	'imageauthentication' => { 225 => 0x20 },
	'imageboundary' => { 225 => 0x16 },
	'imagecount' => { 126 => 0x1438, 225 => 0xa5, 422 => 0x11b },
	'imagecreator' => { 306 => 'ImageCreator' },
	'imagecreatorid' => { 306 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 306 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 306 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 137 => 0x41f },
	'imagecropy' => { 137 => 0x420 },
	'imagedata' => { 463 => 'Data' },
	'imagedatasize' => { 225 => 0xa2 },
	'imagedescription' => { 118 => 0x10e, 498 => 'ImageDescription' },
	'imageduplicationconstraints' => { 306 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 271 => 0xfe443a45 },
	'imageeditcount' => { 354 => 0x41 },
	'imageediting' => { 354 => 0x32 },
	'imageeffects' => { 386 => 0x1010 },
	'imagefileconstraints' => { 306 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 306 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 306 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 126 => 0x1436 },
	'imageheight' => { 118 => 0x101, 187 => 0xc, 363 => 0x10d, 461 => 'ImageHeight', 498 => 'ImageLength' },
	'imagehistory' => { 118 => 0x9213, 481 => 'ImageHistory' },
	'imageidnumber' => { 314 => 0x340 },
	'imagemimetype' => { 463 => 'Mime' },
	'imagenumber' => { 118 => 0x9211, 155 => 'ImageNumber', 181 => 0xae, 182 => 0x5e, 363 => 0x113, 406 => 0x9b, 408 => [0x400,'276.1',0x314], 473 => 'ImageNumber' },
	'imagenumber2' => { 182 => 0x62 },
	'imageoptimization' => { 225 => 0xa9 },
	'imageorientation' => { 130 => 0x83 },
	'imageprocessing' => { 225 => 0x1a },
	'imageprocessingfiledatecreated' => { 137 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 137 => 0xc80 },
	'imageprocessingversion' => { 300 => 0x0 },
	'imagequality' => { 155 => 'ImageQuality', 243 => '723.2', 244 => '732.2', 254 => '708.1', 319 => 0x1 },
	'imagequality2' => { 296 => 0x603 },
	'imagerank' => { 466 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 137 => 0x600 },
	'imagerboardversion' => { 137 => 0x439 },
	'imagercols' => { 137 => 0x17d4 },
	'imageref' => { 486 => 'ImageRef' },
	'imageregion' => { 488 => 'ImageRegion' },
	'imageregionboundary' => { 488 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 488 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 488 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 488 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 488 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 488 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 488 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 488 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 488 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 488 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 488 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 488 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 488 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 488 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 488 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 488 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 488 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 488 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 488 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 137 => 0x944 },
	'imageresolutionjpg' => { 137 => 0x945 },
	'imagereview' => { 280 => '0.4', 289 => '0.4' },
	'imagereviewmonitorofftime' => { 279 => '21.1', 281 => '21.1', 282 => '21.1', 286 => '20.1', 291 => '21.1', 292 => '21.1', 294 => 0x39 },
	'imagereviewtime' => { 278 => '25.1', 280 => '2.1', 283 => '19.1', 284 => '20.1', 285 => '20.1', 287 => '9.2', 288 => '20.1', 293 => '21.2' },
	'imagerfiledatecreated' => { 137 => 0x9c5 },
	'imagerfileproductionlevel' => { 137 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 137 => 0x9c7 },
	'imagerotated' => { 150 => 0x2a },
	'imagerpowerondelaymsec' => { 137 => 0x5fd },
	'imagerrows' => { 137 => 0x17de },
	'imagesegmentlines' => { 137 => 0x184d },
	'imagesegmentstartline' => { 137 => 0x184c },
	'imagesize' => { 161 => 'ImageSize' },
	'imagesizeraw' => { 225 => 0x3e },
	'imagesizerestriction' => { 495 => 'imageSizeRestriction' },
	'imagesourcedata' => { 118 => 0x935c },
	'imagespace' => { 137 => 0x909 },
	'imagestabilization' => { 34 => 0x22, 112 => 0x3020, 126 => 0x1422, 155 => 'ImageStabilization', 181 => 0xbd, 182 => 0x71, 183 => 0x57, 184 => 0x0, 185 => [0x18,0x107,0x113], 186 => 0x49c2, 225 => 0xac, 296 => 0x604, 299 => 0x1600, 319 => 0x1a, 411 => 0x12, 412 => 0x11, 419 => 0xb026 },
	'imagestabilization2' => { 410 => 0xa },
	'imagestabilizationsetting' => { 186 => 0x14, 406 => 0x3d, 407 => 0x3d, 417 => 0x14 },
	'imagestyle' => { 406 => 0x2d, 407 => 0x27 },
	'imagesupplier' => { 306 => 'ImageSupplier' },
	'imagesupplierid' => { 306 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 306 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 306 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 120 => 0x1 },
	'imagetemperaturemin' => { 120 => 0x2 },
	'imagetone' => { 354 => 0x4f },
	'imagetype' => { 130 => 0x82, 306 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 63 => 0x28, 118 => 0xa420, 481 => 'ImageUniqueID', 482 => 'ImageUniqueID' },
	'imagewidth' => { 118 => 0x100, 187 => 0xe, 363 => 0x10c, 461 => 'ImageWidth', 498 => 'ImageWidth' },
	'inclinationangle' => { 453 => 0x900f },
	'inclinationcorrection' => { 453 => 0x900e },
	'incrementaltemperature' => { 476 => 'IncrementalTemperature', 478 => 'IncrementalTemperature' },
	'incrementaltint' => { 476 => 'IncrementalTint', 478 => 'IncrementalTint' },
	'industry' => { 492 => 'industry', 493 => 'industry' },
	'infobuttonwhenshooting' => { 83 => 0x409 },
	'information' => { 373 => 'information', 379 => "\xa9inf" },
	'infourl' => { 379 => 'infu' },
	'infraredilluminator' => { 380 => 0x28 },
	'ingredientexclusion' => { 494 => 'ingredientExclusion' },
	'ingredients' => { 503 => 'Ingredients' },
	'ingredientsalternatepaths' => { 503 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 503 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 503 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 503 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 503 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 503 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 503 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 503 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 503 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 503 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 503 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 503 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 503 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 503 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 503 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 503 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 503 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 503 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 503 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 503 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 503 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 503 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 503 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 83 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 464 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 464 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 178 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 464 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 464 => 'InitialViewHeadingDegrees', 465 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 464 => 'InitialViewPitchDegrees', 465 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 464 => 'InitialViewRollDegrees', 465 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 278 => '4.4' },
	'initialzoomsetting' => { 278 => '9.3', 287 => '27.3' },
	'inkset' => { 118 => 0x14c },
	'inputprofile' => { 137 => 0x1389 },
	'instanceid' => { 503 => 'InstanceID' },
	'instantplaybacksetup' => { 183 => 0x3e },
	'instantplaybacktime' => { 183 => 0x3d },
	'instructions' => { 490 => 'Instructions' },
	'instrument' => { 502 => 'instrument' },
	'integrationtime' => { 137 => 0x423 },
	'intellectualgenre' => { 487 => 'IntellectualGenre' },
	'intelligentauto' => { 419 => 0xb052, 445 => 0xd, 446 => 0xe, 447 => 0xd },
	'intelligentcontrast' => { 52 => 0x4 },
	'intelligentd-range' => { 319 => 0x79 },
	'intelligentexposure' => { 319 => 0x5d },
	'intelligentresolution' => { 319 => 0x70 },
	'interchangecolorspace' => { 132 => 0x40 },
	'intergraphmatrix' => { 118 => 0x8480 },
	'internalflash' => { 180 => 0x2b, 278 => '23.1', 280 => '8.1', 283 => '22.1', 285 => '23.1', 289 => '8.1', 293 => '24.1', 299 => 0x1208 },
	'internalflashae1' => { 301 => 0x1021 },
	'internalflashae1_0' => { 301 => 0x101d },
	'internalflashae2' => { 301 => 0x1022 },
	'internalflashae2_0' => { 301 => 0x101e },
	'internalflashmode' => { 342 => 0x1 },
	'internalflashstrength' => { 342 => 0x3 },
	'internalflashtable' => { 301 => 0x1024 },
	'internallensserialnumber' => { 393 => 0xa005 },
	'internalndfilter' => { 319 => 0x9d },
	'internalserialnumber' => { 63 => 0x96, 75 => 0x9, 126 => 0x10, 186 => 0x49dc, 295 => 0x18, 297 => 0x102, 316 => 0x500, 319 => 0x25, 334 => 0x4, 386 => 0x5, 437 => [0x7c,0xf0], 438 => 0x88, 439 => [0x88,0x8a] },
	'interopindex' => { 118 => 0x1, 483 => 'InteroperabilityIndex' },
	'interopversion' => { 118 => 0x2 },
	'interval' => { 247 => 0xd0 },
	'intervaldurationhours' => { 227 => 0xa0 },
	'intervaldurationminutes' => { 227 => 0xa4 },
	'intervaldurationseconds' => { 227 => 0xa8 },
	'intervalexposuresmoothing' => { 227 => 0xb8, 251 => 0xc416 },
	'intervalframe' => { 247 => 0xd4 },
	'intervallength' => { 180 => 0x10 },
	'intervalmode' => { 180 => 0x26 },
	'intervalnumber' => { 180 => 0x11 },
	'intervalpriority' => { 227 => 0xba, 251 => 0xc418 },
	'intervals' => { 227 => 0xb0, 228 => 0xbc, 251 => 0xc40e },
	'intervalshooting' => { 251 => 0x760c, 259 => 0x760c, 260 => 0x6c98, 354 => 0x92 },
	'introtime' => { 502 => 'introTime' },
	'introtimescale' => { 502 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 502 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 137 => 0xdae },
	'ipfcameramodel' => { 137 => 0xe4d },
	'iptc' => { 119 => 'IPTC' },
	'iptc-naa' => { 118 => 0x83bb, 324 => 0x83bb },
	'iptcbitspersample' => { 132 => 0x56 },
	'iptcdigest' => { 368 => 0x425 },
	'iptcimageheight' => { 132 => 0x1e },
	'iptcimagerotation' => { 132 => 0x66 },
	'iptcimagewidth' => { 132 => 0x14 },
	'iptclastedited' => { 488 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 132 => 0xa },
	'iptcpixelheight' => { 132 => 0x32 },
	'iptcpixelwidth' => { 132 => 0x28 },
	'isalternativeof' => { 492 => 'isAlternativeOf' },
	'isbn' => { 492 => 'isbn' },
	'iscorrectionof' => { 492 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 108 => 0x3 },
	'ismergedhdr' => { 473 => 'IsMergedHDR' },
	'ismergedpanorama' => { 473 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 30 => 0x0, 31 => 0x1, 111 => 0x14, 112 => [0x3014,0x14], 118 => 0x8827, 136 => 0xfd06, 137 => 0x1784, 139 => 0x60, 141 => [0xfa2e,0xfa46], 142 => [0x27,0x28], 143 => 0xf105, 146 => 0x14, 148 => 0x4e, 150 => 0x1e, 151 => 0x1a, 153 => 0x34, 155 => 'ISO', 180 => 0x8, 186 => 0x49ba, 216 => 0x0, 225 => 0x2, 319 => 0xd1, 324 => 0x17, 354 => [0x8b,0x14], 361 => 0x14, 363 => 0x105, 393 => 0xa014, 396 => 0x86, 417 => 0x6f, 424 => [0x1f,0x21,0x25], 482 => 'ISOSpeedRatings' },
	'iso2' => { 216 => 0x6, 238 => 0x265, 239 => 0x25c, 240 => 0x265, 241 => 0x221, 242 => 0x25d, 243 => 0x256, 244 => 0x25d, 248 => 0x2b5, 252 => 0x265, 258 => 0x2b5 },
	'isoauto' => { 335 => '14.4' },
	'isoautoflashlimit' => { 228 => 0x146 },
	'isoautohilimit' => { 228 => 0x144, 246 => 0x18eb, 247 => 0xe82, 256 => 0x185d },
	'isoautomax' => { 418 => 0x4 },
	'isoautomin' => { 418 => 0x2 },
	'isoautoparameters' => { 354 => 0x7a },
	'isoautoshuttertime' => { 228 => 0x14e, 246 => 0x18ea, 247 => 0xe81, 256 => 0x185c },
	'isocalibrationgain' => { 137 => 0x89f },
	'isodisplay' => { 281 => '4.1', 282 => '4.1', 283 => '2.3', 284 => '3.3', 285 => '3.3', 288 => '3.3', 291 => '4.3', 292 => '4.1', 293 => '4.3' },
	'isoexpansion' => { 83 => 0x103, 84 => 0x7, 85 => 0x8, 88 => 0x8, 216 => 0x4 },
	'isoexpansion2' => { 216 => 0xa },
	'isofloor' => { 335 => 0x6 },
	'isoselected' => { 318 => 0x359 },
	'isoselection' => { 225 => 0xf },
	'isosensitivitystep' => { 286 => '6.2', 288 => '6.2' },
	'isosetting' => { 139 => 0x5e, 151 => 0x14, 155 => 'ISOSetting', 180 => 0x24, 181 => 0x26, 182 => 0x1c, 183 => 0x13, 188 => 0x6, 225 => 0x13, 335 => '17.3', 385 => 0x27, 406 => 0x16, 407 => 0x14, 408 => 0x2, 417 => 0x6d, 418 => 0x0 },
	'isospeed' => { 118 => 0x8833, 483 => 'ISOSpeed' },
	'isospeedexpansion' => { 82 => 0x3 },
	'isospeedincrements' => { 83 => 0x102 },
	'isospeedlatitudeyyy' => { 118 => 0x8834, 483 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 118 => 0x8835, 483 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 83 => 0x103 },
	'isostepsize' => { 278 => '6.1', 279 => '7.2', 281 => '7.2', 282 => '7.2', 287 => '4.1', 291 => '7.2', 292 => '7.2', 294 => 0x15d },
	'isovalue' => { 301 => 0x1001 },
	'isrccode' => { 379 => "\xa9isr" },
	'issn' => { 492 => 'issn' },
	'issueidentifier' => { 492 => 'issueIdentifier' },
	'issuename' => { 492 => 'issueName' },
	'issueteaser' => { 492 => 'issueTeaser' },
	'issuetype' => { 492 => 'issueType' },
	'istranslationof' => { 492 => 'isTranslationOf' },
	'itemsubtype' => { 177 => 'ItemSubType' },
	'itunesu' => { 371 => 'itnu' },
	'jobid' => { 130 => 0xb8 },
	'jobname' => { 484 => 'JobName' },
	'jobref' => { 501 => 'JobRef' },
	'jobrefid' => { 501 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 501 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 501 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 484 => 'JobStatus' },
	'jpeg-heifswitch' => { 419 => 0x2039 },
	'jpeghandling' => { 476 => 'JPEGHandling', 478 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 319 => 0x43, 321 => 0x3034, 419 => 0xb047 },
	'jpegsize' => { 321 => 0x303a },
	'jpgcompression' => { 247 => 0x7d4 },
	'jpgfromraw' => { 96 => 0x2007, 113 => 'Exif-JpgFromRaw', 324 => 0x2e },
	'jpgfromrawlength' => { 118 => [0x117,0x202] },
	'jpgfromrawstart' => { 118 => [0x111,0x201] },
	'jpgrecordedpixels' => { 335 => '14.1' },
	'jurisdiction' => { 474 => 'jurisdiction' },
	'keepexposure' => { 294 => 0x237 },
	'kelvinwb_01' => { 343 => 0x5 },
	'kelvinwb_02' => { 343 => 0x9 },
	'kelvinwb_03' => { 343 => 0xd },
	'kelvinwb_04' => { 343 => 0x11 },
	'kelvinwb_05' => { 343 => 0x15 },
	'kelvinwb_06' => { 343 => 0x19 },
	'kelvinwb_07' => { 343 => 0x1d },
	'kelvinwb_08' => { 343 => 0x21 },
	'kelvinwb_09' => { 343 => 0x25 },
	'kelvinwb_10' => { 343 => 0x29 },
	'kelvinwb_11' => { 343 => 0x2d },
	'kelvinwb_12' => { 343 => 0x31 },
	'kelvinwb_13' => { 343 => 0x35 },
	'kelvinwb_14' => { 343 => 0x39 },
	'kelvinwb_15' => { 343 => 0x3d },
	'kelvinwb_16' => { 343 => 0x41 },
	'kelvinwb_daylight' => { 343 => 0x1 },
	'kerneldenominators' => { 137 => 0x933 },
	'key' => { 502 => 'key' },
	'keystonecompensation' => { 300 => 0x1900 },
	'keystonedirection' => { 300 => 0x1901 },
	'keystonevalue' => { 300 => 0x1906 },
	'keyword' => { 371 => 'keyw', 492 => 'keyword' },
	'keywordinfo' => { 170 => 'Keywords' },
	'keywords' => { 130 => 0x19, 156 => 'Keywords', 305 => 'Keywords', 370 => 'Keywords', 373 => 'keywords', 471 => 'keywords', 489 => 'Keywords', 500 => 'Keywords' },
	'killdate' => { 492 => 'killDate' },
	'killdatea-platform' => { 492 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 492 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 136 => 0xf908, 139 => 0xe, 141 => [0xfa1e,0xfa52], 147 => 0x70 },
	'kodakimagewidth' => { 136 => 0xf907, 139 => 0xc, 141 => [0xfa1d,0xfa51], 147 => 0x6c },
	'kodakinfotype' => { 136 => 0xfa00 },
	'kodaklook' => { 137 => 0xe4c },
	'kodaklookprofile' => { 137 => 0x138a },
	'kodakmaker' => { 147 => 0x8 },
	'kodakmodel' => { 139 => 0x0, 147 => 0x28 },
	'kodaktag' => { 137 => 0x3ea },
	'kodakversion' => { 137 => 0x0 },
	'label' => { 309 => 'Label', 500 => 'Label' },
	'labelname1' => { 486 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 486 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 486 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 486 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 486 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 486 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 319 => 0x6f },
	'landscapeoutputhighlightpoint' => { 108 => 0x26 },
	'landscapeoutputshadowpoint' => { 108 => 0x27 },
	'landscaperawcolortone' => { 108 => 0x1f },
	'landscaperawcontrast' => { 108 => 0x21 },
	'landscaperawhighlight' => { 108 => 0x77 },
	'landscaperawhighlightpoint' => { 108 => 0x24 },
	'landscaperawlinear' => { 108 => 0x22 },
	'landscaperawsaturation' => { 108 => 0x20 },
	'landscaperawshadow' => { 108 => 0x80 },
	'landscaperawshadowpoint' => { 108 => 0x25 },
	'landscaperawsharpness' => { 108 => 0x23 },
	'landscapeunsharpmaskfineness' => { 108 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 108 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 108 => 0xa2 },
	'language' => { 228 => 0x592, 479 => 'language' },
	'languageidentifier' => { 130 => 0x87 },
	'largestvalidinteriorrectheight' => { 464 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 464 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 464 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 464 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 180 => 0x1b },
	'lastkeywordiptc' => { 177 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 177 => 'LastKeywordXMP' },
	'lastphotodate' => { 464 => 'LastPhotoDate' },
	'lasturl' => { 503 => 'LastURL' },
	'lateralchromaticaberration' => { 419 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 473 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 117 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 117 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 117 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 117 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 117 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 115 => 'Latitude' },
	'lc1' => { 345 => 0x2 },
	'lc10' => { 345 => 0xb },
	'lc11' => { 345 => 0xc },
	'lc12' => { 345 => 0xd },
	'lc14' => { 345 => 0xf },
	'lc15' => { 345 => 0x10 },
	'lc3' => { 345 => 0x4 },
	'lc4' => { 345 => 0x5 },
	'lc5' => { 345 => 0x6 },
	'lc6' => { 345 => 0x7 },
	'lc7' => { 345 => 0x8 },
	'lc8' => { 345 => 0x9 },
	'lcddisplayatpoweron' => { 83 => 0x811, 87 => 0xa },
	'lcddisplayreturntoshoot' => { 88 => 0x12 },
	'lcdillumination' => { 278 => '17.5', 279 => '5.2', 281 => '5.1', 282 => '5.1', 287 => '10.3', 288 => '4.2', 291 => '5.2', 292 => '5.1', 293 => '5.4', 294 => 0x101 },
	'lcdilluminationduringbulb' => { 83 => 0x408 },
	'lcdmatrix' => { 137 => 0xe74 },
	'lcdmatrixchickfix' => { 137 => 0xe75 },
	'lcdmatrixmarvin' => { 137 => 0xe76 },
	'lcdpanels' => { 82 => 0x8 },
	'lcheditor' => { 271 => 0x8ae85e },
	'legacyiptcdigest' => { 490 => 'LegacyIPTCDigest' },
	'legalcode' => { 474 => 'legalcode' },
	'lens' => { 118 => 0xfdea, 225 => 0x84, 473 => 'Lens' },
	'lensafstopbutton' => { 81 => 0x11, 82 => 0x13, 83 => 0x506, 84 => 0x10, 85 => 0x12, 88 => 0x13, 89 => 0x9 },
	'lensaperturerange' => { 396 => [0x30,0x48] },
	'lenscontrolring' => { 294 => 0xad },
	'lenscorrectionsettings' => { 481 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 473 => 'LensDistortInfo' },
	'lensdistortionparams' => { 301 => 0x206 },
	'lensdrivenoaf' => { 83 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 408 => 0x3f0, 452 => 0xd },
	'lensfirmware' => { 387 => 0x20, 393 => 0xa004 },
	'lensfirmwareversion' => { 297 => 0x204, 319 => 0x60, 408 => 0x3f3, 452 => 0x14 },
	'lensfocallength' => { 102 => 0xf0512, 345 => 0x9 },
	'lensfocalrange' => { 396 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 279 => '55.1', 281 => '52.1', 282 => '52.1', 291 => '52.1', 292 => '52.1' },
	'lensformat' => { 431 => 0x1891, 433 => 0x18bd, 434 => 0x18ed, 435 => 0x17f1, 437 => 0x106, 438 => 0x106, 448 => 0x603, 449 => 0x5d },
	'lensfstops' => { 217 => 0x7, 218 => 0xc, 219 => 0xd, 223 => 0xe, 225 => 0x8b, 345 => '0.3' },
	'lensfunc1button' => { 294 => 0x9f },
	'lensfunc2button' => { 294 => 0xa7 },
	'lensid' => { 223 => 0x30, 473 => 'LensID' },
	'lensidnumber' => { 217 => 0x6, 218 => 0xb, 219 => 0xc, 223 => 0xd },
	'lensinfo' => { 118 => 0xa432, 351 => 0x2a, 473 => 'LensInfo', 483 => 'LensSpecification' },
	'lenskind' => { 345 => 0x1 },
	'lensmake' => { 118 => 0xa433, 162 => 'Make', 483 => 'LensMake' },
	'lensmanualdistortionamount' => { 476 => 'LensManualDistortionAmount', 478 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 177 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 396 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 63 => 0x95, 118 => 0xa434, 162 => 'Model', 177 => 'LensModel', 220 => 0x18a, 221 => 0x18b, 222 => 0x2ac, 297 => 0x203, 351 => 0xc, 363 => 0x412, 483 => 'LensModel' },
	'lensmodulationoptimizer' => { 126 => 0x1045 },
	'lensmount' => { 408 => 0x99, 431 => 0x1892, 433 => 0x18be, 434 => 0x18ee, 435 => 0x17f2, 437 => 0x105, 438 => 0x105, 448 => 0x604, 449 => 0x5e },
	'lensmount2' => { 452 => 0x8 },
	'lensprofilechromaticaberrationscale' => { 476 => 'LensProfileChromaticAberrationScale', 478 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 476 => 'LensProfileDigest', 478 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 476 => 'LensProfileDistortionScale', 478 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 476 => 'LensProfileEnable', 478 => 'LensProfileEnable' },
	'lensprofilefilename' => { 476 => 'LensProfileFilename', 478 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 476 => 'LensProfileIsEmbedded', 478 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 476 => 'LensProfileMatchKeyCameraModelName', 478 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 476 => 'LensProfileMatchKeyExifMake', 478 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 476 => 'LensProfileMatchKeyExifModel', 478 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 476 => 'LensProfileMatchKeyIsRaw', 478 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 476 => 'LensProfileMatchKeyLensID', 478 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 476 => 'LensProfileMatchKeyLensInfo', 478 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 476 => 'LensProfileMatchKeyLensName', 478 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 476 => 'LensProfileMatchKeySensorFormatFactor', 478 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 476 => 'LensProfileName', 478 => 'LensProfileName' },
	'lensprofilesetup' => { 476 => 'LensProfileSetup', 478 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 476 => 'LensProfileVignettingScale', 478 => 'LensProfileVignettingScale' },
	'lensproperties' => { 297 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 32 => 0x16b, 61 => 0x0, 118 => 0xa435, 162 => 'SerialNumber', 297 => 0x202, 317 => 0x321, 319 => 0x52, 379 => 'LENS', 387 => 0x30, 473 => 'LensSerialNumber', 483 => 'LensSerialNumber' },
	'lensshutterlock' => { 183 => 0x4a },
	'lensspec' => { 403 => 0x0, 404 => 0x0, 405 => 0x0, 419 => 0xb02a },
	'lensspecfeatures' => { 437 => [0x115,0x116], 438 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 301 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 34 => 0x16, 185 => 0x10c, 186 => 0x49bd, 225 => 0x83, 297 => 0x201, 310 => 0x16, 314 => 0x310, 316 => 0x303, 317 => 0x303, 319 => 0x51, 321 => 0x3405, 346 => 0x0, 347 => 0x0, 348 => 0x1, 349 => 0x1, 350 => 0x1, 352 => 0x0, 393 => 0xa003, 396 => 0x27, 419 => 0xb027, 431 => 0x1896, 433 => 0x18c2, 434 => 0x18f2, 435 => 0x17f6, 437 => 0x109, 438 => 0x109, 448 => 0x608, 449 => 0x62 },
	'lenstype2' => { 408 => 0x3f7, 431 => 0x1893, 433 => 0x18bf, 434 => 0x18ef, 435 => 0x17f3, 437 => 0x107, 438 => 0x107, 448 => 0x605, 449 => 0x60 },
	'lenstype3' => { 452 => 0x9 },
	'lenstypemake' => { 319 => 0xc4 },
	'lenstypemodel' => { 319 => [0xc5,0xe4] },
	'lenszoomposition' => { 445 => 0x19, 446 => 0x1e, 449 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 327 => 0x15 },
	'levelmeter' => { 379 => ['Lvlm','lvlm'] },
	'levelorientation' => { 353 => 0x0 },
	'license' => { 474 => 'license' },
	'licensee' => { 306 => 'Licensee' },
	'licenseeid' => { 306 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 306 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 306 => 'LicenseeImageNotes' },
	'licenseename' => { 306 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 306 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 306 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 306 => 'LicenseeTransactionID' },
	'licenseid' => { 306 => 'LicenseID' },
	'licensestartdate' => { 306 => 'LicenseStartDate' },
	'licensetransactiondate' => { 306 => 'LicenseTransactionDate' },
	'licensetype' => { 480 => 'licensetype' },
	'licensor' => { 306 => 'Licensor' },
	'licensorcity' => { 306 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 306 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 306 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 306 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 306 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 306 => 'LicensorImageID' },
	'licensorname' => { 306 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 306 => 'LicensorNotes' },
	'licensorpostalcode' => { 306 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 306 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 306 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 306 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 306 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 306 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 306 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 306 => 'LicensorTransactionID' },
	'licensorurl' => { 306 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 301 => 0x1009 },
	'lightingmode' => { 112 => 0x302a },
	'lightreading' => { 354 => 0x15 },
	'lightsource' => { 118 => 0x9208, 225 => 0x90, 304 => 0x1000, 482 => 'LightSource' },
	'lightsourcespecial' => { 395 => 0x21d },
	'lightswitch' => { 291 => '0.1', 293 => '0.1' },
	'lightvaluecenter' => { 301 => 0x103d },
	'lightvalueperiphery' => { 301 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 294 => 0x153 },
	'limitaf-areamodeseldynamic_l' => { 294 => 0x151 },
	'limitaf-areamodeseldynamic_m' => { 294 => 0x150 },
	'limitaf-areamodeseldynamic_s' => { 294 => 0x14f },
	'limitaf-areamodeselpinpoint' => { 294 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 294 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 294 => 0x13 },
	'limitafareamodeselauto' => { 294 => 0x15 },
	'limitafareamodeselection' => { 279 => '51.1', 281 => '49.1', 282 => '49.1', 291 => '49.1', 292 => '49.1' },
	'limitreleasemodeselc120' => { 294 => '269.4' },
	'limitreleasemodeselc30' => { 294 => '269.3' },
	'limitreleasemodeselch' => { 294 => '269.2' },
	'limitreleasemodeselcl' => { 294 => '269.1' },
	'limitreleasemodeselself' => { 294 => '269.5' },
	'limitselectableimagearea16to9' => { 294 => 0x47 },
	'limitselectableimagearea1to1' => { 294 => 0x46 },
	'limitselectableimageareadx' => { 294 => 0x45 },
	'linearitylimitblue' => { 324 => 0x10 },
	'linearitylimitgreen' => { 324 => 0xf },
	'linearitylimitred' => { 324 => 0xe },
	'linearityuppermargin' => { 41 => 0x32c, 42 => 0x282, 45 => [0x2ba,0x2d1,0x2d5], 47 => 0x1e5, 48 => [0x1fe,0x2de], 49 => [0x232,0x310], 50 => 0x31e },
	'linearizationtable' => { 118 => 0xc618 },
	'linearresponselimit' => { 118 => 0xc62e },
	'link' => { 492 => 'link' },
	'linkaetoafpoint' => { 335 => '14.2' },
	'linkedencodedrightsexpr' => { 488 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 488 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 488 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 488 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 137 => 0x904 },
	'lithostratigraphicterms' => { 117 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 373 => 'live-photo.auto' },
	'livephotovitalityscore' => { 373 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 373 => 'live-photo.vitality-scoring-version' },
	'liveviewaf' => { 283 => '32.1', 293 => '34.1' },
	'liveviewafareamode' => { 288 => '34.1' },
	'liveviewafmethod' => { 424 => 0x20 },
	'liveviewafmode' => { 288 => '34.2' },
	'liveviewafsetting' => { 408 => 0x36 },
	'liveviewbuttonoptions' => { 279 => '50.2', 281 => '48.2', 282 => '48.2', 291 => '48.2', 292 => '48.2' },
	'liveviewexposuresimulation' => { 83 => 0x810 },
	'liveviewfocusmode' => { 408 => [0x8b,0x28b] },
	'liveviewmetering' => { 408 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 279 => '21.2', 281 => '21.2', 282 => '21.2', 284 => '20.2', 285 => '20.2', 286 => '20.2', 288 => '20.2', 291 => '21.2', 292 => '21.2' },
	'liveviewshooting' => { 57 => 0x13 },
	'livingspecimen' => { 117 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 117 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 130 => 0x79 },
	'localizedcameramodel' => { 118 => 0xc615 },
	'locallocationname' => { 393 => 0x30 },
	'location' => { 224 => 0x9, 319 => 0x67, 469 => 'Location', 487 => 'Location', 491 => 'location', 492 => 'location' },
	'locationaccuracyhorizontal' => { 373 => 'location.accuracy.horizontal' },
	'locationareacode' => { 475 => 'lac' },
	'locationbody' => { 373 => 'location.body' },
	'locationcreated' => { 488 => 'LocationCreated' },
	'locationcreatedcity' => { 488 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 488 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 488 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 488 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 488 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 488 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 488 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 488 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 488 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 488 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 488 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 488 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 373 => 'location.date' },
	'locationinformation' => { 379 => 'loci' },
	'locationinfoversion' => { 224 => 0x0 },
	'locationname' => { 373 => 'location.name', 393 => 0x31 },
	'locationnote' => { 373 => 'location.note' },
	'locationrole' => { 373 => 'location.role' },
	'locationshown' => { 488 => 'LocationShown' },
	'locationshowncity' => { 488 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 488 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 488 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 488 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 488 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 488 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 488 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 488 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 488 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 488 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 488 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 488 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 83 => 0x709 },
	'logcomment' => { 502 => 'logComment' },
	'logscale' => { 137 => 0x902 },
	'longdescription' => { 371 => 'ldes' },
	'longexposurenoisereduction' => { 62 => 0x4, 83 => 0x201, 84 => 0x1, 85 => 0x2, 86 => 0x1, 87 => 0x1, 88 => 0x2, 89 => 0x1, 319 => 0x49, 406 => 0x2b, 407 => 0x25, 408 => 0x25, 419 => 0x2008, 424 => 0x11, 449 => 0x44 },
	'longexposurenoisereduction2' => { 57 => 0x8 },
	'longexposurenrused' => { 319 => 0xbe },
	'longitude' => { 115 => 'Longitude' },
	'look' => { 476 => 'Look', 478 => 'Look' },
	'lookamount' => { 476 => [\'Look','LookAmount'], 478 => [\'Look','LookAmount'] },
	'lookcluster' => { 476 => [\'Look','LookCluster'], 478 => [\'Look','LookCluster'] },
	'lookcopyright' => { 476 => [\'Look','LookCopyright'], 478 => [\'Look','LookCopyright'] },
	'lookgroup' => { 476 => [\'Look','LookGroup'], 478 => [\'Look','LookGroup'] },
	'lookname' => { 476 => 'LookName', 478 => 'LookName' },
	'lookparameters' => { 476 => [\'Look','LookParameters'], 478 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 476 => [\'Look','LookParametersCameraProfile'], 478 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 476 => [\'Look','LookParametersClarity2012'], 478 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 476 => [\'Look','LookParametersConvertToGrayscale'], 478 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparameterslooktable' => { 476 => [\'Look','LookParametersLookTable'], 478 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 476 => [\'Look','LookParametersProcessVersion'], 478 => [\'Look','LookParametersProcessVersion'] },
	'lookparameterstonecurvepv2012' => { 476 => [\'Look','LookParametersToneCurvePV2012'], 478 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 476 => [\'Look','LookParametersToneCurvePV2012Blue'], 478 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 476 => [\'Look','LookParametersToneCurvePV2012Green'], 478 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 476 => [\'Look','LookParametersToneCurvePV2012Red'], 478 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 476 => [\'Look','LookParametersVersion'], 478 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 476 => [\'Look','LookSupportsAmount'], 478 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 476 => [\'Look','LookSupportsMonochrome'], 478 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 476 => [\'Look','LookSupportsOutputReferred'], 478 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 476 => [\'Look','LookUUID'], 478 => [\'Look','LookUUID'] },
	'loop' => { 502 => 'loop' },
	'loopstyle' => { 379 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 117 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 476 => 'LuminanceAdjustmentAqua', 478 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 476 => 'LuminanceAdjustmentBlue', 478 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 476 => 'LuminanceAdjustmentGreen', 478 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 476 => 'LuminanceAdjustmentMagenta', 478 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 476 => 'LuminanceAdjustmentOrange', 478 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 476 => 'LuminanceAdjustmentPurple', 478 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 476 => 'LuminanceAdjustmentRed', 478 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 476 => 'LuminanceAdjustmentYellow', 478 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 107 => 0x150 },
	'luminancecurvepoints' => { 107 => 0x126 },
	'luminancenoisereduction' => { 102 => 0x20600, 108 => 0x5f, 396 => 0x1b },
	'luminancenoisereductioncontrast' => { 476 => 'LuminanceNoiseReductionContrast', 478 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 476 => 'LuminanceNoiseReductionDetail', 478 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 108 => 0x6d },
	'luminancesmoothing' => { 476 => 'LuminanceSmoothing', 478 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 83 => [0x40b,0x40c] },
	'lyrics' => { 371 => "\xa9lyr", 379 => "\xa9lyr", 502 => 'lyrics' },
	'lyricsuri' => { 379 => 'lrcu' },
	'm16cversion' => { 314 => 0x333 },
	'macatom' => { 477 => 'macAtom' },
	'macatomapplicationcode' => { 477 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 477 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 477 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 117 => 'MachineObservation' },
	'machineobservationday' => { 117 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 117 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 117 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 117 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 117 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 117 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 117 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 117 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 117 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 117 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 117 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 117 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 117 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 117 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 117 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 117 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 117 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 117 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 117 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 117 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 126 => 0x1020, 128 => 0x202, 150 => 0x2b, 301 => 0x202, 385 => 0x21, 395 => 0x202, 419 => 0xb040 },
	'macroled' => { 299 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 57 => 0x10 },
	'macromode' => { 34 => 0x1, 180 => 0xb, 296 => 0x300, 319 => 0x1c, 386 => 0x1009 },
	'magentahsl' => { 102 => 0x20917 },
	'magicfilter' => { 296 => 0x52c },
	'magnifiedview' => { 85 => 0x11, 87 => 0x9 },
	'mainboardversion' => { 137 => 0x438 },
	'maindialexposurecomp' => { 289 => '0.6' },
	'mainingredient' => { 494 => 'mainIngredient' },
	'majorversion' => { 467 => 'MajorVersion' },
	'make' => { 97 => 0x0, 114 => 0x1, 118 => 0x10f, 155 => 'Make', 309 => 'Make', 324 => 0x10f, 373 => 'make', 379 => ['@mak',"\xa9mak"], 491 => 'make', 498 => 'Make' },
	'makernote' => { 482 => 'MakerNote' },
	'makernoteapple' => { 116 => 'MakN', 118 => 0x927c },
	'makernotecanon' => { 116 => 'MakN', 118 => 0x927c },
	'makernotecasio' => { 116 => 'MakN', 118 => 0x927c },
	'makernotecasio2' => { 116 => 'MakN', 118 => 0x927c },
	'makernotedji' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteflir' => { 116 => 'MakN', 118 => 0x927c },
	'makernotefujifilm' => { 116 => 'MakN', 118 => 0x927c },
	'makernotege' => { 116 => 'MakN', 118 => 0x927c },
	'makernotege2' => { 116 => 'MakN', 118 => 0x927c },
	'makernotehasselblad' => { 116 => 'MakN', 118 => 0x927c },
	'makernotehp' => { 116 => 'MakN', 118 => 0x927c },
	'makernotehp2' => { 116 => 'MakN', 118 => 0x927c },
	'makernotehp4' => { 116 => 'MakN', 118 => 0x927c },
	'makernotehp6' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteisl' => { 116 => 'MakN', 118 => 0x927c },
	'makernotejvc' => { 116 => 'MakN', 118 => 0x927c },
	'makernotejvctext' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekodak10' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekodak11' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekodak12' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekodak1a' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekodak1b' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekodak2' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekodak3' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekodak4' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekodak5' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekodak6a' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekodak6b' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekodak7' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekodak8a' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekodak8b' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekodak8c' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekodak9' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekodakunknown' => { 116 => 'MakN', 118 => 0x927c },
	'makernotekyocera' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteleica' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteleica10' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteleica2' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteleica3' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteleica4' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteleica5' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteleica6' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteleica7' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteleica8' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteleica9' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteminolta' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteminolta2' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteminolta3' => { 116 => 'MakN', 118 => 0x927c },
	'makernotemotorola' => { 116 => 'MakN', 118 => 0x927c },
	'makernotenikon' => { 116 => 'MakN', 118 => 0x927c },
	'makernotenikon2' => { 116 => 'MakN', 118 => 0x927c },
	'makernotenikon3' => { 116 => 'MakN', 118 => 0x927c },
	'makernotenintendo' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteoffset' => { 395 => 0xff },
	'makernoteolympus' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteolympus2' => { 116 => 'MakN', 118 => 0x927c },
	'makernotepanasonic' => { 116 => 'MakN', 118 => 0x927c },
	'makernotepanasonic2' => { 116 => 'MakN', 118 => 0x927c },
	'makernotepanasonic3' => { 116 => 'MakN', 118 => 0x927c },
	'makernotepentax' => { 116 => 'MakN', 118 => 0x927c },
	'makernotepentax2' => { 116 => 'MakN', 118 => 0x927c },
	'makernotepentax3' => { 116 => 'MakN', 118 => 0x927c },
	'makernotepentax4' => { 116 => 'MakN', 118 => 0x927c },
	'makernotepentax5' => { 116 => 'MakN', 118 => 0x927c },
	'makernotepentax6' => { 116 => 'MakN', 118 => 0x927c },
	'makernotepentaxunknown' => { 379 => 'PXMN' },
	'makernotephaseone' => { 116 => 'MakN', 118 => 0x927c },
	'makernotereconyx' => { 116 => 'MakN', 118 => 0x927c },
	'makernotereconyx2' => { 116 => 'MakN', 118 => 0x927c },
	'makernotereconyx3' => { 116 => 'MakN', 118 => 0x927c },
	'makernotericoh' => { 116 => 'MakN', 118 => 0x927c },
	'makernotericoh2' => { 116 => 'MakN', 118 => 0x927c },
	'makernotericohpentax' => { 116 => 'MakN', 118 => 0x927c },
	'makernotericohtext' => { 116 => 'MakN', 118 => 0x927c },
	'makernotesafety' => { 118 => 0xc635 },
	'makernotesamsung1a' => { 116 => 'MakN', 118 => 0x927c },
	'makernotesamsung1b' => { 116 => 'MakN', 118 => 0x927c },
	'makernotesamsung2' => { 116 => 'MakN', 118 => 0x927c },
	'makernotesanyo' => { 116 => 'MakN', 118 => 0x927c },
	'makernotesanyoc4' => { 116 => 'MakN', 118 => 0x927c },
	'makernotesanyopatch' => { 116 => 'MakN', 118 => 0x927c },
	'makernotesigma' => { 116 => 'MakN', 118 => 0x927c },
	'makernotesony' => { 116 => 'MakN', 118 => 0x927c },
	'makernotesony2' => { 116 => 'MakN', 118 => 0x927c },
	'makernotesony3' => { 116 => 'MakN', 118 => 0x927c },
	'makernotesony4' => { 116 => 'MakN', 118 => 0x927c },
	'makernotesony5' => { 116 => 'MakN', 118 => 0x927c },
	'makernotesonyericsson' => { 116 => 'MakN', 118 => 0x927c },
	'makernotesonysrf' => { 116 => 'MakN', 118 => 0x927c },
	'makernotetype' => { 386 => 0x1 },
	'makernoteunknown' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteunknownbinary' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteunknowntext' => { 116 => 'MakN', 118 => 0x927c },
	'makernoteversion' => { 185 => 0x0, 225 => 0x1, 301 => 0x0, 319 => 0x8000, 390 => 0x0, 393 => 0x1, 396 => [0x1d,0x1f], 409 => 0x2000 },
	'makerurl' => { 379 => "\xa9mal" },
	'managedfrom' => { 503 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 503 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 503 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 503 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 503 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 503 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 503 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 503 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 503 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 503 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 503 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 503 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 503 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 503 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 503 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 503 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 503 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 503 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 503 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 503 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 503 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 503 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 503 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 503 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 503 => 'Manager' },
	'managervariant' => { 503 => 'ManagerVariant' },
	'manageto' => { 503 => 'ManageTo' },
	'manageui' => { 503 => 'ManageUI' },
	'manifest' => { 503 => 'Manifest' },
	'manifestlinkform' => { 503 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 503 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 503 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 503 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 503 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 503 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 503 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 503 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 503 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 503 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 503 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 503 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 503 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 503 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 503 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 503 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 503 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 503 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 503 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 503 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 503 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 503 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 503 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 503 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 503 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 503 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 503 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 503 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 296 => 0x900, 319 => 0x86 },
	'manometerreading' => { 296 => 0x901 },
	'manualafpointselectpattern' => { 83 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 299 => 0x1209 },
	'manualflashoutput' => { 34 => 0x29, 280 => '8.2', 283 => '22.2', 284 => '23.1', 285 => '23.2', 287 => '16.2', 288 => '23.2', 289 => '8.2', 290 => '23.2', 293 => '24.2', 386 => 0x100c },
	'manualflashstrength' => { 296 => 0x406 },
	'manualfocusdistance' => { 225 => 0x85, 301 => 0x100c, 395 => 0x223 },
	'manualfocuspointillumination' => { 294 => 0x17 },
	'manualfocusringinafmode' => { 294 => 0x1a },
	'manualtv' => { 82 => 0x5, 83 => 0x705 },
	'manufacturedate' => { 190 => 0x6705, 334 => 0x1 },
	'manufacturedate1' => { 388 => 0x4 },
	'manufacturedate2' => { 388 => 0x5 },
	'manufacturer' => { 461 => 'Manufacturer', 491 => 'manufacturer' },
	'mariahchromablursize' => { 137 => 0xf0d },
	'mariahmaphithreshold' => { 137 => 0xf0c },
	'mariahmaplothreshold' => { 137 => 0xf0b },
	'mariahsigmathreshold' => { 137 => 0xf0e },
	'mariahtexturethreshold' => { 137 => 0xf0a },
	'marked' => { 489 => 'Marked', 506 => 'Marked' },
	'markers' => { 502 => 'markers' },
	'markerscomment' => { 502 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 502 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 502 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 502 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 502 => [\'markers','markersCuePointType'] },
	'markersduration' => { 502 => [\'markers','markersDuration'] },
	'markerslocation' => { 502 => [\'markers','markersLocation'] },
	'markersname' => { 502 => [\'markers','markersName'] },
	'markersprobability' => { 502 => [\'markers','markersProbability'] },
	'markersspeaker' => { 502 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 502 => [\'markers','markersStartTime'] },
	'markerstarget' => { 502 => [\'markers','markersTarget'] },
	'markerstype' => { 502 => [\'markers','markersType'] },
	'maskedareas' => { 118 => 0xc68e },
	'maskgroupbasedcorractive' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 476 => 'MaskGroupBasedCorrections', 478 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 476 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 478 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 130 => 0xb9 },
	'mastergain' => { 236 => 0x50 },
	'materialsample' => { 117 => 'MaterialSample' },
	'materialsampleid' => { 117 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 279 => '50.1', 281 => '48.1', 282 => '48.1', 291 => '48.1', 292 => '48.1', 294 => 0x233 },
	'matrixselectk' => { 137 => 0x91b },
	'matrixselectthreshold' => { 137 => 0x91a },
	'matrixselectthreshold1' => { 137 => 0x91e },
	'matrixselectthreshold2' => { 137 => 0x91f },
	'matrixstructure' => { 378 => 0xa },
	'maxaperture' => { 34 => 0x1a, 137 => 0x3f9, 143 => 0x6103, 162 => 'MaxAperture', 180 => 0x17, 186 => 0x49c5, 223 => 0x36, 297 => 0x20a, 345 => '14.1' },
	'maxapertureatmaxfocal' => { 126 => 0x1407, 162 => 'MaxApertureAtMaxFocal', 217 => 0xb, 218 => 0x10, 219 => 0x11, 223 => 0x12, 297 => 0x206 },
	'maxapertureatminfocal' => { 126 => 0x1406, 217 => 0xa, 218 => 0xf, 219 => 0x10, 223 => 0x11, 297 => 0x205 },
	'maxaperturevalue' => { 118 => 0x9205, 363 => 0x414, 482 => 'MaxApertureValue' },
	'maxavailheight' => { 488 => 'MaxAvailHeight' },
	'maxavailwidth' => { 488 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 278 => 0xb, 279 => 0xc, 281 => '12.1', 282 => '12.1', 287 => 0xc, 288 => 0xb, 291 => '12.1', 292 => '12.1', 294 => 0x3d },
	'maxfaces' => { 300 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 34 => 0x17, 126 => 0x1405, 162 => 'MaxFocalLength', 217 => 0x9, 218 => 0xe, 219 => 0xf, 223 => 0x10, 297 => 0x208, 431 => 0x127c, 432 => 0x1138, 433 => 0x330, 434 => 0x330, 435 => 0x30e },
	'maximumdensityrange' => { 132 => 0x8c },
	'maxpagesize' => { 507 => 'MaxPageSize' },
	'maxpagesizeh' => { 507 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 507 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 507 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 137 => 0xc7d },
	'maxsamplevalue' => { 118 => 0x119 },
	'maxstorage' => { 497 => 'maxstorage' },
	'mb-d10batteries' => { 278 => '12.6' },
	'mb-d10batterytype' => { 287 => '13.3' },
	'mb-d11batterytype' => { 288 => '2.3' },
	'mb-d12batterytype' => { 291 => '3.2' },
	'mb-d80batteries' => { 289 => '6.5' },
	'mb-d80batterytype' => { 293 => '3.2' },
	'mcuversion' => { 217 => 0xc, 218 => 0x11, 219 => 0x12, 223 => 0x13 },
	'md5digest' => { 163 => 'zmd5' },
	'mditemfindercomment' => { 172 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 172 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 172 => 'MDItemFSLabel' },
	'mditemusertags' => { 172 => 'MDItemUserTags' },
	'meal' => { 494 => 'meal' },
	'measuredev' => { 28 => 0x9, 76 => 0x3, 96 => 0x1814, 155 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 76 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 186 => 0x690, 314 => 0x312, 317 => 0x312, 318 => 0x312, 321 => 0x3407 },
	'measuredrggb' => { 64 => 0x1 },
	'measuredrggbdata' => { 44 => 0x287 },
	'measurementaccuracy' => { 117 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 117 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 117 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 117 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 117 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 117 => 'MeasurementOrFact' },
	'measurementremarks' => { 117 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 117 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 117 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 117 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 461 => 'MeasureType' },
	'mechanicalshuttercount' => { 225 => 0x37 },
	'mediaclassprimaryid' => { 178 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 178 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 306 => 'MediaConstraints' },
	'mediacreatedate' => { 375 => 0x1 },
	'mediaeventiddate' => { 466 => 'MediaEventIdDate' },
	'mediagroupuuid' => { 1 => 0x11 },
	'mediamodifydate' => { 375 => 0x2 },
	'mediasummarycode' => { 306 => 'MediaSummaryCode' },
	'mediatype' => { 371 => 'stik' },
	'memoaudioquality' => { 83 => 0x812 },
	'memorycardconfiguration' => { 412 => 0x16 },
	'memorycardnumber' => { 207 => 0x2 },
	'menubuttondisplayposition' => { 81 => 0xb, 84 => 0xa, 85 => 0xb, 88 => 0xb },
	'menubuttonreturn' => { 89 => 0xb },
	'menumonitorofftime' => { 278 => '26.1', 279 => '22.1', 281 => '22.1', 282 => '22.1', 286 => '21.1', 287 => '8.2', 288 => '21.1', 291 => '22.1', 292 => '22.1', 293 => '22.1', 294 => 0x35 },
	'menusettingsz7iioffset' => { 259 => 0xceb6 },
	'metadatadate' => { 500 => 'MetadataDate' },
	'metadatamoddate' => { 502 => 'metadataModDate' },
	'metaversion' => { 426 => 0x34 },
	'meterinfo1row1' => { 420 => 0x0, 421 => 0x0 },
	'meterinfo1row2' => { 420 => 0x6c, 421 => 0x5a },
	'meterinfo1row3' => { 420 => 0xd8, 421 => 0xb4 },
	'meterinfo1row4' => { 420 => 0x144, 421 => 0x10e },
	'meterinfo1row5' => { 420 => 0x1b0, 421 => 0x168 },
	'meterinfo1row6' => { 420 => 0x21c, 421 => 0x1c2 },
	'meterinfo1row7' => { 420 => 0x288, 421 => 0x21c },
	'meterinfo2row1' => { 420 => 0x2f4, 421 => 0x276 },
	'meterinfo2row2' => { 420 => 0x378, 421 => 0x2e4 },
	'meterinfo2row3' => { 420 => 0x3fc, 421 => 0x352 },
	'meterinfo2row4' => { 420 => 0x480, 421 => 0x3c0 },
	'meterinfo2row5' => { 420 => 0x504, 421 => 0x42e },
	'meterinfo2row6' => { 420 => 0x588, 421 => 0x49c },
	'meterinfo2row7' => { 420 => 0x60c, 421 => 0x50a },
	'meterinfo2row8' => { 420 => 0x690, 421 => 0x578 },
	'meterinfo2row9' => { 420 => 0x714, 421 => 0x5e6 },
	'metering' => { 280 => '6.1' },
	'meteringmode' => { 34 => 0x11, 118 => 0x9207, 139 => 0x1c, 180 => 0x7, 181 => 0x25, 183 => 0x12, 296 => 0x202, 354 => 0x17, 396 => 0x9, 406 => 0x15, 407 => 0x13, 408 => 0x7, 424 => 0x3, 427 => 0x1174, 428 => 0x1178, 429 => 0x1154, 430 => 0x11d0, 431 => 0x11ac, 432 => 0x1064, 433 => 0x25c, 434 => 0x25c, 435 => 0x24b, 482 => 'MeteringMode' },
	'meteringmode2' => { 335 => '2.1', 419 => 0x202c },
	'meteringmode3' => { 335 => '16.1' },
	'meteringoffscaleindicator' => { 183 => 0x53 },
	'meteringtime' => { 278 => '22.2', 280 => '3.2', 283 => '17.1', 284 => '18.1', 287 => '7.3', 288 => '18.1', 289 => '3.2', 293 => '19.1' },
	'micro1version' => { 381 => 0x1f },
	'micro2version' => { 381 => 0x2d },
	'microphoneattenuator' => { 228 => 0x2d2 },
	'microphonefrequencyresponse' => { 228 => 0x2d4 },
	'microphonejackpower' => { 228 => 0x2fa },
	'microphonesensitivity' => { 228 => 0x2d0 },
	'microvideo' => { 459 => 'MicroVideo' },
	'microvideooffset' => { 459 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 459 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 459 => 'MicroVideoVersion' },
	'midrangesharpness' => { 232 => 0x3b },
	'mieversion' => { 163 => '0Vers' },
	'mime' => { 461 => 'Mime' },
	'minaperture' => { 34 => 0x1b, 137 => 0x3f8, 162 => 'MinAperture', 345 => '0.2' },
	'minaperturevalue' => { 363 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 34 => 0x18, 126 => 0x1404, 162 => 'MinFocalLength', 217 => 0x8, 218 => 0xd, 219 => 0xe, 223 => 0xf, 297 => 0x207, 431 => 0x127a, 432 => 0x1136, 433 => 0x32e, 434 => 0x32e, 435 => 0x30c },
	'minfocusdistance' => { 345 => 0x3 },
	'minintegrationrows' => { 137 => 0x1874 },
	'minoltadate' => { 180 => 0x15 },
	'minoltaimagesize' => { 180 => 0x4, 181 => 0xc, 182 => 0x2, 185 => 0x103 },
	'minoltamodelid' => { 180 => 0x25 },
	'minoltaquality' => { 180 => 0x5, 181 => 0xd, 182 => 0x3, 185 => [0x102,0x103] },
	'minoltatime' => { 180 => 0x16 },
	'minormodelagedisclosure' => { 306 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 467 => 'MinorVersion' },
	'minsamplevalue' => { 118 => 0x118 },
	'mirrorlockup' => { 81 => 0xc, 82 => 0xc, 83 => 0x60f, 84 => 0xb, 85 => 0xc, 86 => 0x6, 87 => 0x6, 88 => 0xc, 89 => 0x3 },
	'mobilecountrycode' => { 475 => 'mcc' },
	'mobilenetworkcode' => { 475 => 'mnc' },
	'moddate' => { 309 => 'modify-date', 489 => 'ModDate' },
	'modedialposition' => { 412 => 0x14 },
	'model' => { 97 => 0x6, 118 => 0x110, 155 => 'Model', 309 => 'Model', 324 => 0x110, 354 => 0x23f, 373 => 'model', 379 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 396 => 0x84, 461 => 'Model', 491 => 'model', 498 => 'Model' },
	'modelage' => { 488 => 'ModelAge' },
	'modelid' => { 295 => 0x0 },
	'modelingflash' => { 278 => '21.4', 279 => '31.1', 281 => '31.1', 282 => '31.1', 287 => '26.4', 288 => '30.2', 289 => '7.4', 290 => '30.1', 291 => '31.1', 292 => '31.1', 293 => '31.3', 294 => 0x5d },
	'modelreleaseid' => { 306 => 'ModelReleaseID' },
	'modelreleasestatus' => { 306 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 440 => 0x52, 441 => 0x46, 442 => 0x53 },
	'modeltiepoint' => { 118 => 0x8482 },
	'modeltransform' => { 118 => 0x85d8 },
	'modelyear' => { 491 => 'modelYear' },
	'modificationdate' => { 492 => 'modificationDate' },
	'modifiedcolortemp' => { 65 => 0x9 },
	'modifieddigitalgain' => { 65 => 0xb },
	'modifiedparamflag' => { 58 => 0x1 },
	'modifiedpicturestyle' => { 65 => 0xa },
	'modifiedsaturation' => { 296 => 0x504 },
	'modifiedsensorbluelevel' => { 65 => 0x5 },
	'modifiedsensorredlevel' => { 65 => 0x4 },
	'modifiedsharpness' => { 65 => 0x2 },
	'modifiedsharpnessfreq' => { 65 => 0x3 },
	'modifiedtonecurve' => { 65 => 0x1 },
	'modifiedwhitebalance' => { 65 => 0x8 },
	'modifiedwhitebalanceblue' => { 65 => 0x7 },
	'modifiedwhitebalancered' => { 65 => 0x6 },
	'modifydate' => { 118 => 0x132, 156 => 'ModifyDate', 305 => 'ModDate', 307 => 'tIME', 370 => 'ModDate', 376 => 0x2, 500 => 'ModifyDate' },
	'moirefilter' => { 118 => 0xfe58, 476 => 'MoireFilter', 478 => 'MoireFilter' },
	'monitorbrightness' => { 228 => 0x59a },
	'monitordisplayoff' => { 183 => 0x4c },
	'monitormatrix' => { 137 => 0x8fc },
	'monitorofftime' => { 278 => '18.2', 280 => '3.1', 289 => '3.1' },
	'monochromecolor' => { 296 => 0x53b },
	'monochromecontrast' => { 108 => 0x3c },
	'monochromefiltereffect' => { 102 => 0x20307, 108 => 0x3a, 319 => 0xac, 354 => 0x73 },
	'monochromegraineffect' => { 319 => 0xd2 },
	'monochromelinear' => { 108 => 0x3d },
	'monochromeoutputhighlightpoint' => { 108 => 0x41 },
	'monochromeoutputshadowpoint' => { 108 => 0x42 },
	'monochromeprofilesettings' => { 296 => 0x537 },
	'monochromerawhighlight' => { 108 => 0x7a },
	'monochromerawhighlightpoint' => { 108 => 0x3f },
	'monochromerawshadow' => { 108 => 0x83 },
	'monochromerawshadowpoint' => { 108 => 0x40 },
	'monochromesharpness' => { 108 => 0x3e },
	'monochrometoning' => { 354 => 0x74 },
	'monochrometoningeffect' => { 102 => 0x20306, 108 => 0x3b },
	'monochromeunsharpmaskfineness' => { 108 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 108 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 108 => 0xb4 },
	'monochromevignetting' => { 296 => 0x53a },
	'monthdaycreated' => { 139 => 0x12, 148 => 0xe },
	'mood' => { 178 => 'WM/Mood' },
	'moonphase' => { 380 => 0x12, 381 => 0x43, 382 => 0x4c },
	'morepermissions' => { 474 => 'morePermissions' },
	'motionsensitivity' => { 380 => 0x29, 382 => 0x60 },
	'movementcount' => { 371 => "\xa9mvc" },
	'movementname' => { 371 => "\xa9mvn" },
	'movementnumber' => { 371 => "\xa9mvi" },
	'movieactived-lighting' => { 227 => 0x238, 228 => 0x2b8 },
	'movieaelockbuttonassignment' => { 291 => '40.1' },
	'movieaf-onbutton' => { 294 => 0xcb },
	'movieafareamode' => { 228 => 0x2c6, 294 => 0x203 },
	'movieafspeed' => { 294 => 0xdd },
	'movieafspeedapply' => { 294 => 0xdf },
	'movieaftrackingsensitivity' => { 294 => 0xe1 },
	'movieaperturelock' => { 294 => 0x259 },
	'movieautodistortioncontrol' => { 227 => 0x242 },
	'moviediffractioncompensation' => { 227 => 0x241 },
	'moviedxcropalert' => { 228 => 0x2fb },
	'movieelectronicvr' => { 228 => 0x2cc },
	'movieevfgrid' => { 294 => 0x21d },
	'movieflickerreduction' => { 228 => 0x2c0 },
	'moviefocusmode' => { 227 => 0x248, 228 => 0x2c4 },
	'moviefocuspointlock' => { 294 => 0x226 },
	'movieframerate' => { 227 => 0x1f8, 228 => 0x2f4 },
	'movieframesize' => { 227 => 0x1f6, 228 => 0x2f2 },
	'moviefunc1button' => { 281 => '41.1', 282 => '41.1', 292 => '41.1', 294 => 0xc3 },
	'moviefunc3button' => { 294 => 0x127 },
	'moviefunctionbutton' => { 279 => '41.1', 291 => '41.1' },
	'moviefunctionbuttonplusdials' => { 279 => '52.1' },
	'moviehighisonoisereduction' => { 227 => 0x23c, 228 => 0x2ba },
	'moviehighlightdisplaythreshold' => { 294 => 0x215 },
	'movieimagearea' => { 228 => 0x25c },
	'movieisoautocontrolmanualmode' => { 228 => 0x26a },
	'movieisoautohilimit' => { 228 => 0x268 },
	'movieisoautomanualmode' => { 227 => 0x204, 228 => 0x26c },
	'moviemeteringmode' => { 228 => 0x2c2 },
	'moviemidtonedisplayrange' => { 294 => 0x219 },
	'moviemidtonedisplayvalue' => { 294 => 0x217 },
	'moviemultiselector' => { 294 => 0xd9 },
	'moviepreviewbutton' => { 279 => '41.2', 281 => '41.2', 282 => '41.2', 291 => '41.2', 292 => '41.2' },
	'moviepreviewbuttonplusdials' => { 279 => '52.2' },
	'movierecordbuttonplaybackmode' => { 294 => 0x1b5 },
	'movieshutterbutton' => { 279 => '38.3', 281 => '38.3', 282 => '38.3', 291 => '38.3', 292 => '38.3' },
	'movieshutterspeedlock' => { 294 => 0x225 },
	'movieslowmotion' => { 227 => 0x1fa },
	'moviesoundrecording' => { 228 => 0x2ce },
	'moviesubjectdetection' => { 228 => 0x2fc },
	'moviesubselectorassignment' => { 279 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 279 => '53.1' },
	'movietonemap' => { 228 => 0x2ec },
	'movietype' => { 227 => 0x1fe, 228 => 0x266, 251 => 0xc55c },
	'movievibrationreduction' => { 227 => 0x24e },
	'movievibrationreductionsameasphoto' => { 227 => 0x24f },
	'movievignettecontrol' => { 227 => 0x23e, 228 => 0x1a0 },
	'movievignettecontrolsameasphoto' => { 227 => 0x240 },
	'movievrmode' => { 228 => 0x2c8 },
	'moviezebrapattern' => { 294 => 0x213 },
	'multiburstimageheight' => { 419 => 0x1002 },
	'multiburstimagewidth' => { 419 => 0x1001 },
	'multiburstmode' => { 419 => 0x1000 },
	'multicontrollerwhilemetering' => { 83 => 0x517 },
	'multiexposure' => { 67 => 0x1, 319 => 0xb4 },
	'multiexposureautogain' => { 229 => 0x3 },
	'multiexposurecontrol' => { 67 => 0x2 },
	'multiexposuremode' => { 229 => 0x1 },
	'multiexposureshots' => { 67 => 0x3, 228 => 0x8e, 229 => 0x2 },
	'multiframenoisereduction' => { 408 => 0x35, 419 => 0x200b, 424 => 0x15 },
	'multiframenreffect' => { 419 => 0x2023 },
	'multifunctionlock' => { 83 => 0x70f },
	'multipleexposuremode' => { 228 => 0x8c, 300 => 0x101c },
	'multipleexposureset' => { 335 => '10.1' },
	'multisample' => { 236 => 0x40 },
	'multiselector' => { 278 => '9.4', 279 => '10.3', 281 => '10.3', 282 => '10.3', 287 => '27.4', 291 => '10.3', 292 => '10.3' },
	'multiselectorliveview' => { 278 => '4.3', 281 => '37.1', 282 => '37.1', 291 => '37.1', 292 => '37.1' },
	'multiselectorliveviewmode' => { 246 => 0x18c2 },
	'multiselectorplaybackmode' => { 278 => ['13.5','9.2'], 279 => '10.2', 282 => '10.2', 287 => '27.2', 291 => '10.2', 292 => '10.2', 294 => 0xb3 },
	'multiselectorshootmode' => { 278 => '9.1', 279 => '10.1', 281 => '10.1', 282 => '10.1', 287 => '27.1', 291 => '10.1', 292 => '10.1', 294 => 0xaf },
	'multishot' => { 324 => 0x121 },
	'mute' => { 373 => 'player.movie.audio.mute' },
	'mycolormode' => { 68 => 0x2 },
	'name' => { 379 => 'name', 476 => 'Name', 478 => 'Name' },
	'narrator' => { 371 => "\xa9nrt" },
	'nationalcatalognumber' => { 492 => 'nationalCatalogNumber' },
	'nativedigest' => { 482 => 'NativeDigest', 498 => 'NativeDigest' },
	'ndfilter' => { 76 => 0x1c, 296 => 0x204, 386 => 0x1019 },
	'near' => { 461 => 'Near' },
	'nefbitdepth' => { 225 => 0xe22 },
	'nefcompression' => { 225 => 0x93, 226 => 0xa },
	'neflinearizationtable' => { 225 => 0x96 },
	'negativecachelargepreviewsize' => { 476 => 'NegativeCacheLargePreviewSize', 478 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 476 => 'NegativeCacheMaximumSize', 478 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 476 => 'NegativeCachePath', 478 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 473 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 354 => 0x88 },
	'neutraloutputhighlightpoint' => { 108 => 0x2f },
	'neutraloutputshadowpoint' => { 108 => 0x30 },
	'neutralrawcolortone' => { 108 => 0x28 },
	'neutralrawcontrast' => { 108 => 0x2a },
	'neutralrawhighlight' => { 108 => 0x78 },
	'neutralrawhighlightpoint' => { 108 => 0x2d },
	'neutralrawlinear' => { 108 => 0x2b },
	'neutralrawsaturation' => { 108 => 0x29 },
	'neutralrawshadow' => { 108 => 0x81 },
	'neutralrawshadowpoint' => { 108 => 0x2e },
	'neutralrawsharpness' => { 108 => 0x2c },
	'neutralunsharpmaskfineness' => { 108 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 108 => 0xa8 },
	'neutraunsharpmaskstrength' => { 108 => 0xa4 },
	'newrawimagedigest' => { 118 => 0xc7a7 },
	'newsphotoversion' => { 132 => 0x0 },
	'nickname' => { 500 => 'Nickname' },
	'nikoncapturedata' => { 225 => 0xe01 },
	'nikoncaptureeditversions' => { 225 => 0xe13 },
	'nikoncaptureoffsets' => { 225 => 0xe0e },
	'nikoncaptureoutput' => { 225 => 0xe1e },
	'nikoncaptureversion' => { 225 => 0xe09 },
	'nikoniccprofile' => { 225 => 0xe1d },
	'nikonimagesize' => { 243 => '723.1', 244 => '732.1', 254 => 0x2c4 },
	'nikonmeteringmode' => { 227 => 0x146, 247 => 0x2ea4, 256 => 0x175e },
	'nikonsettings' => { 225 => 0x4e },
	'noisefilter' => { 296 => 0x527 },
	'noiseprofile' => { 118 => 0xc761 },
	'noisereduction' => { 126 => [0x100b,0x100e], 181 => 0xb0, 182 => 0x60, 183 => 0x3f, 225 => 0x95, 271 => 0x753dcbc0, 272 => 0x17, 296 => 0x50a, 301 => 0x103a, 319 => 0x2d, 354 => 0x49, 386 => 0x100f, 388 => 0x2a },
	'noisereduction2' => { 300 => 0x1010 },
	'noisereductionapplied' => { 118 => 0xc6f7 },
	'noisereductionintensity' => { 272 => 0x9 },
	'noisereductionmethod' => { 272 => 0x11 },
	'noisereductionmode' => { 453 => 0x801e },
	'noisereductionparametersatcapture' => { 137 => 0xe73 },
	'noisereductionparameterscamera' => { 137 => 0xe72 },
	'noisereductionparametershost3mp' => { 137 => 0xe71 },
	'noisereductionparametershost6mp' => { 137 => 0xe70 },
	'noisereductionparametershostrgb' => { 137 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 137 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 137 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 137 => 0xe63 },
	'noisereductionparams' => { 324 => 0x1b },
	'noisereductionsharpness' => { 272 => 0xd },
	'noisereductionstrength' => { 319 => 0xd6 },
	'noisereductionvalue' => { 453 => 0x8027 },
	'nomemorycard' => { 278 => '22.1', 279 => '4.2', 280 => '0.3', 283 => '2.4', 284 => '3.2', 285 => '3.2', 287 => '33.7', 288 => '3.2', 289 => '0.3', 291 => '4.2', 293 => '4.5' },
	'nominalmaxaperture' => { 345 => 0xa },
	'nominalminaperture' => { 345 => '10.1' },
	'normallinetime' => { 137 => 0x186a },
	'normalwhitelevel' => { 41 => 0x32a, 42 => 0x280, 45 => [0x2b8,0x2cf,0x2d3], 46 => 0x569, 47 => 0x1e3, 48 => [0x1fc,0x2dc], 49 => [0x230,0x30e], 50 => 0x31c },
	'notes' => { 454 => 'Notes', 471 => 'notes' },
	'npages' => { 507 => 'NPages' },
	'nullrecord' => { 96 => 0x0 },
	'numafpoints' => { 331 => 0x2 },
	'number' => { 492 => 'number' },
	'numberofbeats' => { 502 => 'numberOfBeats' },
	'numberoffocuspoints' => { 281 => '1.3', 282 => '1.3', 285 => '0.2', 286 => '0.3', 288 => '0.3' },
	'numfaceelements' => { 126 => 0x4200 },
	'numfacepositions' => { 311 => 0x0 },
	'numindexentries' => { 132 => 0x54 },
	'numwbentries' => { 325 => 0x0, 326 => 0x0 },
	'object' => { 492 => 'object' },
	'objectattributereference' => { 130 => 0x4 },
	'objectcycle' => { 130 => 0x4b, 471 => 'ObjectCycle' },
	'objectdescription' => { 491 => 'objectDescription' },
	'objectdistance' => { 111 => 0x6, 112 => 0x2022 },
	'objectname' => { 130 => 0x5 },
	'objectpreviewdata' => { 130 => 0xca },
	'objectpreviewfileformat' => { 130 => 0xc8 },
	'objectpreviewfileversion' => { 130 => 0xc9 },
	'objectsubtype' => { 491 => 'objectSubtype' },
	'objecttype' => { 491 => 'objectType' },
	'objecttypereference' => { 130 => 0x3 },
	'occurrence' => { 117 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 117 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 117 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 117 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 117 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 117 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 117 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 117 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 117 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 117 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 117 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 117 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 117 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 117 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 117 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 117 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 117 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 117 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 117 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 117 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 117 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 117 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 117 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 117 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 117 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 117 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 482 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 482 => [\'OECF','OECFNames'] },
	'oecfrows' => { 482 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 482 => [\'OECF','OECFValues'] },
	'offsaledate' => { 492 => 'offSaleDate' },
	'offsaledatea-platform' => { 492 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 492 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 137 => 0x190a },
	'offsetschema' => { 118 => 0xea1d },
	'offsettime' => { 118 => 0x9010 },
	'offsettimedigitized' => { 118 => 0x9012 },
	'offsettimeoriginal' => { 118 => 0x9011 },
	'okbutton' => { 288 => '15.1', 293 => '16.1' },
	'oldsubfiletype' => { 118 => 0xff },
	'olympusimageheight' => { 301 => 0x102f },
	'olympusimagewidth' => { 301 => 0x102e },
	'omenatcapturestrength' => { 137 => 0xa60 },
	'omenautostrength' => { 137 => 0xa5f },
	'omenearlystrength' => { 137 => 0xa5e },
	'omenfocallengthlimit' => { 137 => 0xa62 },
	'omeninitialipfstrength' => { 137 => 0xa5d },
	'omensurfaceindex' => { 137 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 301 => 0x302 },
	'onsaledate' => { 492 => 'onSaleDate' },
	'onsaledatea-platform' => { 492 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 492 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 492 => 'onSaleDay' },
	'onsaledaya-platform' => { 492 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 492 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 118 => 0xc740 },
	'opcodelist2' => { 118 => 0xc741 },
	'opcodelist3' => { 118 => 0xc74e },
	'opticalzoom' => { 141 => 0xfa3d, 143 => [0x6006,0xf006], 144 => 0x1000, 145 => 0xf, 148 => 0x1e, 150 => 0x20, 151 => 0x1c, 162 => 'OpticalZoom' },
	'opticalzoomcode' => { 76 => 0xa },
	'opticalzoommode' => { 319 => 0x34 },
	'opticalzoomon' => { 395 => 0x219 },
	'optionenddate' => { 495 => 'optionEndDate' },
	'opto-electricconvfactor' => { 482 => 'OECF' },
	'orangehsl' => { 102 => 0x20911 },
	'ordernumber' => { 126 => 0x8002 },
	'organisationinimagecode' => { 488 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 488 => 'OrganisationInImageName' },
	'organism' => { 117 => 'Organism' },
	'organismassociatedoccurrences' => { 117 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 117 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 117 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 117 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 117 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 117 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 117 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 492 => 'organization' },
	'orientation' => { 118 => 0x112, 324 => 0x112, 491 => 'orientation', 498 => 'Orientation' },
	'orientation2' => { 424 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 83 => 0x516 },
	'originalalbumtitle' => { 178 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 178 => 'WM/OriginalArtist', 371 => "\xa9ope" },
	'originalbestqualitysize' => { 118 => 0xc792 },
	'originalcreatedatetime' => { 466 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 113 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 63 => 0x83 },
	'originaldefaultcropsize' => { 118 => 0xc793 },
	'originaldefaultfinalsize' => { 118 => 0xc791 },
	'originaldirectory' => { 316 => 0x408 },
	'originaldocumentid' => { 503 => 'OriginalDocumentID' },
	'originalfilename' => { 96 => 0x816, 137 => 0x3e9, 149 => 0x20, 316 => 0x407, 466 => 'OriginalFilename' },
	'originalimageheight' => { 78 => 0xc, 122 => 0x1 },
	'originalimagewidth' => { 78 => 0xb, 122 => 0x0 },
	'originallyricist' => { 178 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 118 => 0xc68c },
	'originalrawfiledigest' => { 118 => 0xc71d },
	'originalrawfilename' => { 118 => 0xc68b },
	'originaltransmissionreference' => { 130 => 0x67 },
	'originatingprogram' => { 130 => 0x41, 471 => 'OriginatingProgram' },
	'originplatform' => { 492 => 'originPlatform' },
	'os' => { 480 => 'os' },
	'otherconditions' => { 306 => 'OtherConditions' },
	'otherconstraints' => { 306 => 'OtherConstraints' },
	'otherimage' => { 113 => 'Exif-OtherImage' },
	'otherimageinfo' => { 306 => 'OtherImageInfo' },
	'otherimagelength' => { 118 => 0x202 },
	'otherimagestart' => { 118 => 0x201 },
	'otherlicensedocuments' => { 306 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 306 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 306 => 'OtherLicenseRequirements' },
	'outcue' => { 502 => 'outCue' },
	'outcuescale' => { 502 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 502 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 196 => 0x3 },
	'outputimagewidth' => { 196 => 0x2 },
	'outputlut' => { 319 => 0xa7 },
	'outputprofile' => { 137 => 0x138b },
	'outputresolution' => { 196 => 0x4 },
	'overclockcols' => { 137 => 0x189c },
	'overclockrows' => { 137 => 0x18c4 },
	'overridelookvignette' => { 476 => 'OverrideLookVignette', 478 => 'OverrideLookVignette' },
	'owner' => { 506 => 'Owner' },
	'ownerid' => { 130 => 0xbc },
	'ownername' => { 15 => 0x10f, 63 => 0x9, 96 => 0x810, 118 => [0xa430,0xfde8], 155 => 'OwnerName', 473 => 'OwnerName', 483 => 'CameraOwnerName' },
	'padding' => { 118 => 0xea1c },
	'pagecount' => { 492 => 'pageCount' },
	'pageimage' => { 500 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 500 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 500 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 500 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 500 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 500 => 'PageInfo' },
	'pagename' => { 118 => 0x11d },
	'pagenumber' => { 118 => 0x129 },
	'pageprogressiondirection' => { 492 => 'pageProgressionDirection' },
	'pagerange' => { 492 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 476 => 'PaintBasedCorrections', 478 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 476 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 478 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 322 => 0x0 },
	'panasonicexifversion' => { 319 => 0x26 },
	'panasonicimageheight' => { 319 => 0x4c },
	'panasonicimagewidth' => { 319 => 0x4b },
	'panasonicrawversion' => { 324 => 0x1 },
	'panasonictitle' => { 118 => 0xc6d2 },
	'panasonictitle2' => { 118 => 0xc6d3 },
	'panoramaangle' => { 126 => 0x1153 },
	'panoramacropbottom' => { 425 => 0x7 },
	'panoramacropleft' => { 425 => 0x4 },
	'panoramacropright' => { 425 => 0x6 },
	'panoramacroptop' => { 425 => 0x5 },
	'panoramadirection' => { 71 => 0x5, 126 => 0x1154, 425 => 0x3 },
	'panoramaframeheight' => { 425 => 0x9 },
	'panoramaframenumber' => { 71 => 0x2 },
	'panoramaframewidth' => { 425 => 0x8 },
	'panoramafullheight' => { 425 => 0x2 },
	'panoramafullwidth' => { 425 => 0x1 },
	'panoramamode' => { 139 => 0x3c, 296 => 0x601 },
	'panoramasize3d' => { 408 => 0x38 },
	'panoramasourceheight' => { 425 => 0xb },
	'panoramasourcewidth' => { 425 => 0xa },
	'panoramicstitchcameramotion' => { 175 => 'PanoramicStitchCameraMotion', 176 => 0x1 },
	'panoramicstitchmaptype' => { 175 => 'PanoramicStitchMapType', 176 => 0x2 },
	'panoramicstitchphi0' => { 175 => 'PanoramicStitchPhi0', 176 => 0x5 },
	'panoramicstitchphi1' => { 175 => 'PanoramicStitchPhi1', 176 => 0x6 },
	'panoramicstitchtheta0' => { 175 => 'PanoramicStitchTheta0', 176 => 0x3 },
	'panoramicstitchtheta1' => { 175 => 'PanoramicStitchTheta1', 176 => 0x4 },
	'panoramicstitchversion' => { 176 => 0x0 },
	'pantry' => { 503 => 'Pantry' },
	'pantryinstanceid' => { 503 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 126 => 0xb211, 295 => 0x28 },
	'parametricdarks' => { 476 => 'ParametricDarks', 478 => 'ParametricDarks' },
	'parametrichighlights' => { 476 => 'ParametricHighlights', 478 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 476 => 'ParametricHighlightSplit', 478 => 'ParametricHighlightSplit' },
	'parametriclights' => { 476 => 'ParametricLights', 478 => 'ParametricLights' },
	'parametricmidtonesplit' => { 476 => 'ParametricMidtoneSplit', 478 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 476 => 'ParametricShadows', 478 => 'ParametricShadows' },
	'parametricshadowsplit' => { 476 => 'ParametricShadowSplit', 478 => 'ParametricShadowSplit' },
	'parentalrating' => { 178 => 'WM/ParentalRating' },
	'parentmediaeventid' => { 466 => 'ParentMediaEventID' },
	'parentmeid' => { 466 => 'ParentMEID' },
	'parentproductid' => { 371 => '@ppi' },
	'parentreference1' => { 486 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 486 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 486 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 486 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 486 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 486 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 371 => '@PST' },
	'parenttitle' => { 371 => '@pti' },
	'partialactivecols1' => { 137 => 0x17e8 },
	'partialactivecols2' => { 137 => 0x17f2 },
	'partialactiverows1' => { 137 => 0x17fc },
	'partialactiverows2' => { 137 => 0x1806 },
	'partofcompilation' => { 502 => 'partOfCompilation' },
	'patientbirthdate' => { 455 => 'PatientDOB' },
	'patientid' => { 455 => 'PatientID' },
	'patientname' => { 455 => 'PatientName' },
	'patientsex' => { 455 => 'PatientSex' },
	'patternareaheight' => { 137 => 0x963 },
	'patternareawidth' => { 137 => 0x962 },
	'patterncorrectionfactorscale' => { 137 => 0x969 },
	'patterncropcols1' => { 137 => 0x96c },
	'patterncropcols2' => { 137 => 0x96d },
	'patterncroprows1' => { 137 => 0x96a },
	'patterncroprows2' => { 137 => 0x96b },
	'patternimagerheight' => { 137 => 0x961 },
	'patternimagerwidth' => { 137 => 0x960 },
	'patternx' => { 137 => 0x966 },
	'patterny' => { 137 => 0x967 },
	'pdfversion' => { 489 => 'PDFVersion' },
	'pentaximagesize' => { 354 => 0x9 },
	'pentaxmodelid' => { 334 => 0x0, 354 => 0x5 },
	'pentaxmodeltype' => { 354 => 0x1 },
	'pentaxversion' => { 354 => 0x0 },
	'people' => { 457 => 'People', 469 => 'People' },
	'perchannelblacklevel' => { 41 => 0x157, 42 => 0x16b, 44 => 0xc4, 45 => [0x2b4,0x2cb,0x2cf], 46 => [0x108,0x14d], 47 => 0x1df, 48 => [0x1f8,0x2d8], 49 => [0x22c,0x30a], 50 => 0x149 },
	'performer' => { 371 => 'perf', 379 => 'perf' },
	'performerkeywords' => { 379 => "\xa9prk" },
	'performers' => { 379 => "\xa9prf" },
	'performerurl' => { 379 => "\xa9prl" },
	'period' => { 178 => 'WM/Period' },
	'peripheralillumcentralradius' => { 453 => 0x8030 },
	'peripheralillumcentralvalue' => { 453 => 0x8031 },
	'peripheralillumination' => { 102 => 0x20702, 108 => 0x68 },
	'peripheralilluminationcorr' => { 62 => 0x1, 344 => 0x2 },
	'peripheralilluminationon' => { 102 => '0x20702.0', 108 => 0x64 },
	'peripheralillumperiphvalue' => { 453 => 0x8032 },
	'peripherallighting' => { 78 => 0x2, 126 => 0x3804 },
	'peripherallightingsetting' => { 79 => 0x5 },
	'peripherallightingvalue' => { 78 => 0x6 },
	'permissions' => { 495 => 'permissions' },
	'permits' => { 474 => 'permits' },
	'person' => { 492 => 'person' },
	'personality' => { 466 => 'Personality' },
	'personheard' => { 488 => 'PersonHeard' },
	'personheardidentifier' => { 488 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 488 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 488 => 'PersonInImage' },
	'personinimagecharacteristic' => { 488 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 488 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 488 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 488 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 488 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 488 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 488 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 488 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 488 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 476 => 'PerspectiveAspect', 478 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 476 => 'PerspectiveHorizontal', 478 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 476 => 'PerspectiveRotate', 478 => 'PerspectiveRotate' },
	'perspectivescale' => { 476 => 'PerspectiveScale', 478 => 'PerspectiveScale' },
	'perspectiveupright' => { 476 => 'PerspectiveUpright', 478 => 'PerspectiveUpright' },
	'perspectivevertical' => { 476 => 'PerspectiveVertical', 478 => 'PerspectiveVertical' },
	'perspectivex' => { 476 => 'PerspectiveX', 478 => 'PerspectiveX' },
	'perspectivey' => { 476 => 'PerspectiveY', 478 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 91 => 0x1 },
	'pf10retainprogramshift' => { 91 => 0xb },
	'pf13drivepriority' => { 91 => 0xe },
	'pf14disablefocussearch' => { 91 => 0xf },
	'pf15disableafassistbeam' => { 91 => 0x10 },
	'pf16autofocuspointshoot' => { 91 => 0x11 },
	'pf17disableafpointsel' => { 91 => 0x12 },
	'pf18enableautoafpointsel' => { 91 => 0x13 },
	'pf19continuousshootspeed' => { 91 => 0x14 },
	'pf19shootingspeedhigh' => { 90 => 0xa },
	'pf19shootingspeedlow' => { 90 => 0x9 },
	'pf1disableshootingmodes' => { 91 => 0x2 },
	'pf1value' => { 90 => 0x1 },
	'pf20limitcontinousshots' => { 91 => 0x15 },
	'pf20maxcontinousshots' => { 90 => 0xb },
	'pf21enablequietoperation' => { 91 => 0x16 },
	'pf23felocktime' => { 90 => 0xd },
	'pf23postreleasetime' => { 90 => 0xe },
	'pf23settimerlengths' => { 91 => 0x18 },
	'pf23shutterbuttontime' => { 90 => 0xc },
	'pf24lightlcdduringbulb' => { 91 => 0x19 },
	'pf25aemode' => { 90 => 0xf },
	'pf25afmode' => { 90 => 0x12 },
	'pf25afpointsel' => { 90 => 0x13 },
	'pf25colormatrix' => { 90 => 0x17 },
	'pf25defaultclearsettings' => { 91 => 0x1a },
	'pf25drivemode' => { 90 => 0x11 },
	'pf25imagesize' => { 90 => 0x14 },
	'pf25meteringmode' => { 90 => 0x10 },
	'pf25parameters' => { 90 => 0x16 },
	'pf25wbmode' => { 90 => 0x15 },
	'pf26shortenreleaselag' => { 91 => 0x1b },
	'pf27reversedialrotation' => { 91 => 0x1c },
	'pf27value' => { 90 => 0x18 },
	'pf28noquickdialexpcomp' => { 91 => 0x1d },
	'pf29quickdialswitchoff' => { 91 => 0x1e },
	'pf2disablemeteringmodes' => { 91 => 0x3 },
	'pf2value' => { 90 => 0x2 },
	'pf30enlargementmode' => { 91 => 0x1f },
	'pf31originaldecisiondata' => { 91 => 0x20 },
	'pf3manualexposuremetering' => { 91 => 0x4 },
	'pf3value' => { 90 => 0x3 },
	'pf4exposuretimelimits' => { 91 => 0x5 },
	'pf4exposuretimemax' => { 90 => 0x5 },
	'pf4exposuretimemin' => { 90 => 0x4 },
	'pf5aperturelimits' => { 91 => 0x6 },
	'pf5aperturemax' => { 90 => 0x7 },
	'pf5aperturemin' => { 90 => 0x6 },
	'pf6presetshootingmodes' => { 91 => 0x7 },
	'pf7bracketcontinuousshoot' => { 91 => 0x8 },
	'pf8bracketshots' => { 90 => 0x8 },
	'pf8setbracketshots' => { 91 => 0x9 },
	'pf9changebracketsequence' => { 91 => 0xa },
	'phasedetectaf' => { 192 => 0x6 },
	'phonenumber' => { 156 => 'Phone' },
	'photoeffect' => { 34 => 0x28 },
	'photoeffecthistoryxml' => { 271 => 0xe9651831 },
	'photoeffects' => { 271 => 0xab5eca5e },
	'photoeffectsblue' => { 273 => 0x8 },
	'photoeffectsgreen' => { 273 => 0x6 },
	'photoeffectsred' => { 273 => 0x4 },
	'photoeffectstype' => { 273 => 0x0 },
	'photographicsensitivity' => { 483 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 278 => '17.6', 287 => '33.6' },
	'photometricinterpretation' => { 118 => 0x106, 498 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 228 => 0x112, 247 => 0xe7d, 257 => 0xfbd },
	'photoshootingmenubankimagearea' => { 228 => 0x134, 247 => '3716.1', 257 => 0x791 },
	'photoshopbgrthumbnail' => { 368 => 0x409 },
	'photoshopquality' => { 367 => 0x0 },
	'photoshopthumbnail' => { 368 => 0x40c },
	'photostyle' => { 319 => 0x89 },
	'picklabel' => { 481 => 'PickLabel' },
	'pictinfo' => { 395 => 0x208 },
	'picturecontrol' => { 271 => 0xe2173c47 },
	'picturecontrolactive' => { 274 => 0x0 },
	'picturecontroladjust' => { 230 => 0x30, 231 => 0x30, 232 => 0x36 },
	'picturecontrolbase' => { 230 => 0x18, 231 => 0x18, 232 => 0x1c },
	'picturecontroldata' => { 225 => [0xbd,0x23] },
	'picturecontrolmode' => { 274 => 0x13 },
	'picturecontrolname' => { 230 => 0x4, 231 => 0x4, 232 => 0x8 },
	'picturecontrolquickadjust' => { 230 => 0x31, 231 => 0x31, 232 => 0x37 },
	'pictureeffect' => { 419 => 0x200e },
	'pictureeffect2' => { 427 => 0x1163, 428 => 0x1167, 429 => 0x1143, 430 => 0x11bf, 431 => 0x119b, 432 => 0x1053, 433 => 0x24b, 434 => 0x24b, 435 => 0x23c, 449 => 0x46 },
	'picturefinish' => { 181 => 0x71 },
	'picturemode' => { 126 => 0x1031, 296 => 0x520, 354 => [0xb,0x33], 396 => 0x3d },
	'picturemode2' => { 335 => 0x0 },
	'picturemodebwfilter' => { 296 => 0x525 },
	'picturemodecontrast' => { 296 => 0x523 },
	'picturemodeeffect' => { 296 => 0x52d },
	'picturemodehue' => { 296 => 0x522 },
	'picturemodesaturation' => { 296 => 0x521 },
	'picturemodesharpness' => { 296 => 0x524 },
	'picturemodetone' => { 296 => 0x526 },
	'pictureprofile' => { 427 => [0x115e,0x115f], 428 => [0x1162,0x1163], 429 => [0x113e,0x113f], 430 => [0x11ba,0x11bb], 431 => [0x1196,0x1197], 432 => [0x104e,0x104f], 433 => [0x246,0x247], 434 => [0x246,0x247], 435 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 73 => 0xa, 102 => 0x20301, 108 => 0x2 },
	'picturestylepc' => { 63 => 0x4009 },
	'picturestyleuserdef' => { 63 => 0x4008 },
	'picturewizard' => { 393 => 0x21 },
	'picturewizardcolor' => { 392 => 0x1 },
	'picturewizardcontrast' => { 392 => 0x4 },
	'picturewizardmode' => { 392 => 0x0 },
	'picturewizardsaturation' => { 392 => 0x2 },
	'picturewizardsharpness' => { 392 => 0x3 },
	'pipelineversion' => { 175 => 'PipelineVersion' },
	'pitch' => { 114 => 0x6, 279 => '4.1', 291 => '4.1', 379 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 246 => 0x350f, 247 => 0x2c28, 251 => 0xc21e, 256 => 0x36f8, 257 => 0x2eff, 259 => 0xce36, 260 => 0xeaef, 296 => 0x904, 319 => 0x91, 353 => 0x2, 391 => 0x1 },
	'pitchshift' => { 373 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 372 => 'pasp' },
	'pixelclockfrequency' => { 137 => 0x40b },
	'pixelcorrectionoffset' => { 137 => 0x972 },
	'pixelcorrectionscale' => { 137 => 0x971 },
	'pixelscale' => { 118 => 0x830e },
	'pixelshiftinfo' => { 419 => 0x202f },
	'pixelshiftoffset' => { 126 => 0x1106 },
	'pixelshiftresolution' => { 355 => 0x0 },
	'pixelshiftshots' => { 126 => 0x1105 },
	'pixelsperunitx' => { 308 => 0x0 },
	'pixelsperunity' => { 308 => 0x4 },
	'pixelunits' => { 308 => 0x8 },
	'planarconfiguration' => { 118 => 0x11c, 498 => 'PlanarConfiguration' },
	'plane' => { 456 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 456 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 456 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 456 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 456 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 456 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 456 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 456 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 456 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 456 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 456 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 456 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 456 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 456 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 456 => 'Planes' },
	'planningref' => { 488 => 'PlanningRef' },
	'planningrefidentifier' => { 488 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 488 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 488 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 507 => 'PlateNames' },
	'platform' => { 492 => 'platform' },
	'playallframes' => { 379 => 'AllF' },
	'playbackflickdown' => { 294 => 0x159 },
	'playbackflickup' => { 294 => 0x155 },
	'playbackmenustime' => { 283 => '20.1', 284 => '21.1', 285 => '21.1' },
	'playbackmonitorofftime' => { 278 => '25.2', 279 => '36.1', 281 => '36.1', 282 => '36.1', 286 => '35.1', 287 => '8.1', 288 => '35.1', 291 => '36.1', 292 => '36.1', 293 => '21.1', 294 => 0x33 },
	'playbackzoom' => { 279 => '37.1' },
	'playdisplay' => { 183 => 0x4e },
	'playerversion' => { 373 => 'player.version' },
	'playgap' => { 371 => 'pgap' },
	'playlistid' => { 371 => 'plID' },
	'playmode' => { 379 => 'SDLN' },
	'playselection' => { 379 => 'SelO' },
	'plusversion' => { 306 => 'Version' },
	'pmversion' => { 366 => 'PMVersion' },
	'pngwarning' => { 309 => 'Warning' },
	'podcast' => { 371 => 'pcst' },
	'podcasturl' => { 371 => 'purl' },
	'poilevel' => { 224 => 0x8 },
	'portraitimpressionbalance' => { 259 => 0x7fa0 },
	'portraitnote' => { 459 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 108 => 0x1d },
	'portraitoutputshadowpoint' => { 108 => 0x1e },
	'portraitrawcolortone' => { 108 => 0x16 },
	'portraitrawcontrast' => { 108 => 0x18 },
	'portraitrawhighlight' => { 108 => 0x76 },
	'portraitrawhighlightpoint' => { 108 => 0x1b },
	'portraitrawlinear' => { 108 => 0x19 },
	'portraitrawsaturation' => { 108 => 0x17 },
	'portraitrawshadow' => { 108 => 0x7f },
	'portraitrawshadowpoint' => { 108 => 0x1c },
	'portraitrawsharpness' => { 108 => 0x1a },
	'portraitrefiner' => { 112 => 0x302b },
	'portraitrequest' => { 459 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 108 => 0x9a },
	'portraitunsharpmaskstrength' => { 108 => 0x98 },
	'portraitunsharpmaskthreshold' => { 108 => 0x9c },
	'portraitversion' => { 459 => 'PortraitVersion' },
	'pose' => { 456 => 'Pose' },
	'poseheadingdegrees' => { 464 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 464 => 'PosePitchDegrees' },
	'posepositionx' => { 456 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 456 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 456 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 464 => 'PoseRollDegrees' },
	'poserotationw' => { 456 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 456 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 456 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 456 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 456 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 491 => 'positionDescriptor' },
	'postalcode' => { 160 => 'PostalCode' },
	'postcropvignetteamount' => { 476 => 'PostCropVignetteAmount', 478 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 476 => 'PostCropVignetteFeather', 478 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 476 => 'PostCropVignetteHighlightContrast', 478 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 476 => 'PostCropVignetteMidpoint', 478 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 476 => 'PostCropVignetteRoundness', 478 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 476 => 'PostCropVignetteStyle', 478 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 319 => 0xbf },
	'potentialface1position' => { 416 => 0xb },
	'potentialface2position' => { 416 => 0x15 },
	'potentialface3position' => { 416 => 0x1f },
	'potentialface4position' => { 416 => 0x29 },
	'potentialface5position' => { 416 => 0x33 },
	'potentialface6position' => { 416 => 0x3d },
	'potentialface7position' => { 416 => 0x47 },
	'potentialface8position' => { 416 => 0x51 },
	'powersource' => { 333 => '0.1' },
	'poweruptime' => { 225 => 0xb6 },
	'preaf' => { 125 => '0.2' },
	'precaptureframes' => { 301 => 0x300 },
	'predictor' => { 118 => 0x13d },
	'preflashreturnstrength' => { 244 => 0x28a },
	'prefs' => { 130 => 0xdd, 366 => 'Prefs' },
	'prereadfastresetcount' => { 137 => 0x187e },
	'preservedfilename' => { 503 => 'PreservedFileName' },
	'preservedspecimen' => { 117 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 117 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 476 => 'PresetType', 478 => 'PresetType' },
	'presetwhitebalance' => { 183 => 0x24, 453 => 0x8002 },
	'presetwhitebalanceadj' => { 453 => 0x8014 },
	'pressure' => { 118 => 0x9402, 483 => 'Pressure' },
	'previewapplicationname' => { 118 => 0xc716 },
	'previewapplicationversion' => { 118 => 0xc717 },
	'previewbutton' => { 278 => ['14.1','15.1'], 279 => '15.1', 281 => '15.1', 282 => '15.1', 287 => '29.1', 288 => '14.1', 291 => '15.1', 292 => '15.1' },
	'previewbuttonplusdials' => { 278 => ['14.2','15.2'], 279 => '15.2', 281 => '43.1', 282 => '43.1', 287 => '31.2', 291 => '43.1', 292 => '43.1' },
	'previewcolorspace' => { 118 => 0xc71a },
	'previewcropbottom' => { 365 => 0xef },
	'previewcropleft' => { 365 => 0xec },
	'previewcropright' => { 365 => 0xee },
	'previewcroptop' => { 365 => 0xed },
	'previewdate' => { 377 => 0x0 },
	'previewdatetime' => { 118 => 0xc71b },
	'previewimage' => { 112 => 0x2000, 113 => 'Exif-PreviewImage', 119 => 'PreviewImage', 121 => 0x4, 165 => 'data', 185 => 0x81, 301 => 0x280, 317 => 0x300, 379 => 'mcvr', 419 => 0x2001 },
	'previewimageborders' => { 354 => 0x3e },
	'previewimageheight' => { 72 => 0x4, 141 => 0xfa58 },
	'previewimagelength' => { 72 => 0x2, 112 => 0x3, 118 => [0x117,0x202], 185 => 0x89, 233 => 0x202, 296 => 0x102, 301 => 0x1037, 354 => 0x3, 385 => 0x1e, 390 => 0x3, 396 => [0x1b,0x1d], 409 => 0x202 },
	'previewimagename' => { 165 => '1Name' },
	'previewimagesize' => { 112 => 0x2, 146 => 0x2, 165 => 'ImageSize', 354 => 0x2, 396 => [0x1c,0x1e], 419 => 0xb02c, 453 => 0x9012 },
	'previewimagestart' => { 72 => 0x5, 112 => 0x4, 118 => [0x111,0x201], 185 => 0x88, 233 => 0x201, 296 => 0x101, 301 => 0x1036, 354 => 0x4, 385 => 0x1c, 390 => 0x2, 396 => [0x1a,0x1c], 409 => 0x201 },
	'previewimagetype' => { 165 => '0Type' },
	'previewimagevalid' => { 296 => 0x100, 301 => 0x1035 },
	'previewimagewidth' => { 72 => 0x3, 141 => 0xfa57 },
	'previewquality' => { 72 => 0x1 },
	'previewsettingsdigest' => { 118 => 0xc719 },
	'previewsettingsname' => { 118 => 0xc718 },
	'primaryafpoint' => { 192 => [0x38,0x44,0x7] },
	'primarychromaticities' => { 118 => 0x13f, 498 => 'PrimaryChromaticities' },
	'primaryftp' => { 466 => 'PrimaryFTP' },
	'primaryslot' => { 247 => 0xe7f, 257 => 0xfbf },
	'printim' => { 118 => 0xc4a5 },
	'prioritysetinawb' => { 419 => 0x202b },
	'prioritysetupshutterrelease' => { 183 => 0x1d, 406 => 0x28 },
	'privatertkinfo' => { 468 => 'privateRTKInfo' },
	'processbordercolsleft' => { 137 => 0xc61 },
	'processbordercolsright' => { 137 => 0xc62 },
	'processborderrowsbottom' => { 137 => 0xc64 },
	'processborderrowstop' => { 137 => 0xc63 },
	'processingsoftware' => { 118 => 0xb },
	'processversion' => { 476 => 'ProcessVersion', 478 => 'ProcessVersion' },
	'producer' => { 178 => 'WM/Producer', 305 => 'Producer', 371 => "\xa9prd", 373 => 'producer', 379 => "\xa9prd", 489 => 'Producer' },
	'producerkeywords' => { 379 => "\xa9pdk" },
	'productcode' => { 492 => 'productCode' },
	'productid' => { 131 => 0x32, 371 => 'prID', 491 => 'productID' },
	'productidtype' => { 491 => 'productIDType' },
	'productinimage' => { 488 => 'ProductInImage' },
	'productinimagedescription' => { 488 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 488 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 488 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 334 => 0x2 },
	'productorserviceconstraints' => { 306 => 'ProductOrServiceConstraints' },
	'productversion' => { 371 => 'VERS' },
	'profession' => { 492 => 'profession' },
	'profile' => { 456 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 118 => 0xc6f4 },
	'profilecameraindices' => { 456 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 118 => 0xc6fe },
	'profileembedpolicy' => { 118 => 0xc6fd },
	'profilegaintablemap' => { 118 => 0xcd2d },
	'profilehuesatmapdata1' => { 118 => 0xc6fa },
	'profilehuesatmapdata2' => { 118 => 0xc6fb },
	'profilehuesatmapdata3' => { 118 => 0xcd39 },
	'profilehuesatmapdims' => { 118 => 0xc6f9 },
	'profilehuesatmapencoding' => { 118 => 0xc7a3 },
	'profilelooktabledata' => { 118 => 0xc726 },
	'profilelooktabledims' => { 118 => 0xc725 },
	'profilelooktableencoding' => { 118 => 0xc7a4 },
	'profilename' => { 118 => 0xc6f8, 307 => 'iCCP-name' },
	'profiles' => { 456 => 'Profiles' },
	'profiletonecurve' => { 118 => 0xc6fc },
	'profiletype' => { 456 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 319 => 0x3c },
	'programline' => { 335 => '1.1' },
	'programmode' => { 188 => 0x5 },
	'programshift' => { 225 => 0xd },
	'programversion' => { 130 => 0x46 },
	'prohibits' => { 474 => 'prohibits' },
	'projectiontype' => { 464 => 'ProjectionType', 465 => 'ProjectionType' },
	'projectname' => { 502 => 'projectName' },
	'projectref' => { 502 => 'projectRef' },
	'projectrefpath' => { 502 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 502 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 178 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 306 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 306 => 'PropertyReleaseStatus' },
	'provider' => { 178 => 'WM/Provider' },
	'province-state' => { 130 => 0x5f },
	'publicationdate' => { 492 => 'publicationDate' },
	'publicationdatea-platform' => { 492 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 492 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 492 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 492 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 492 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 488 => 'PublicationEvent' },
	'publicationeventdate' => { 488 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 488 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 488 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 492 => 'publicationName' },
	'publisher' => { 178 => 'WM/Publisher', 371 => "\xa9pub", 373 => 'publisher', 479 => 'publisher' },
	'publishingfrequency' => { 492 => 'publishingFrequency' },
	'pulldown' => { 502 => 'pullDown' },
	'purchasedate' => { 371 => 'purd' },
	'purplehsl' => { 102 => 0x20916 },
	'pxshiftperiphedgenr' => { 453 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 453 => 0x9014 },
	'quality' => { 0 => 0x1, 34 => 0x3, 111 => 0x2, 112 => 0x3002, 126 => 0x1000, 139 => 0x9, 225 => 0x4, 261 => 0x3, 301 => 0x201, 314 => 0x300, 354 => 0x8, 361 => 0x2, 396 => 0x16, 406 => 0x56, 407 => 0x56, 408 => 0xb, 419 => [0x102,0x202e] },
	'quality2' => { 427 => 0x1170, 428 => 0x1174, 429 => 0x1150, 431 => 0x11a8, 432 => 0x1060, 433 => 0x258, 434 => 0x258, 435 => 0x247, 440 => 0x29, 441 => 0x25, 442 => 0x2a },
	'qualitybutton' => { 294 => 0x17d },
	'qualitybuttonplaybackmode' => { 294 => 0x1bf },
	'qualitymode' => { 112 => 0x8 },
	'quantizationmethod' => { 132 => 0x78 },
	'quickadjust' => { 274 => 0x2a },
	'quickcontroldialinmeter' => { 83 => 0x703 },
	'quickfix' => { 271 => 0x416391c6 },
	'quickshot' => { 395 => 0x213 },
	'quiettime' => { 137 => 0x188a },
	'rads' => { 379 => 'rads' },
	'rangefinder' => { 283 => '4.1', 284 => '5.1', 285 => '5.1' },
	'rangemask' => { 476 => 'RangeMaskMapInfo', 478 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 476 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 478 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 476 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 478 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 476 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 478 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 476 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 478 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 476 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 478 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 476 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 478 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 130 => 0x7d },
	'rating' => { 118 => 0x4746, 126 => 0x1431, 365 => 0xdf, 371 => 'rtng', 379 => 'rtng', 419 => 0x2002, 471 => 'rating', 480 => 'rating', 488 => 'Rating', 492 => 'rating', 500 => 'Rating' },
	'ratingpercent' => { 118 => 0x4749, 177 => 'Rating', 371 => 'rate', 500 => 'RatingPercent' },
	'ratingregion' => { 488 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 488 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 488 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 488 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 488 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 488 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 488 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 488 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 488 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 488 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 488 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 488 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 488 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 488 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 488 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 488 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 488 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 488 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 81 => 0x8, 185 => 0x109, 335 => 0xd },
	'rawbrightnessadj' => { 102 => 0x20001, 107 => 0x38 },
	'rawburstimagecount' => { 74 => 0x2 },
	'rawburstimagenum' => { 74 => 0x1 },
	'rawcoloradj' => { 107 => 0x2e },
	'rawcropbottom' => { 365 => 0xd4 },
	'rawcropleft' => { 365 => 0xd1 },
	'rawcropright' => { 365 => 0xd3 },
	'rawcroptop' => { 365 => 0xd2 },
	'rawcustomsaturation' => { 107 => 0x30 },
	'rawcustomtone' => { 107 => 0x34 },
	'rawdata' => { 393 => 0xa048 },
	'rawdatabyteorder' => { 393 => 0x40 },
	'rawdatacfapattern' => { 393 => 0x50 },
	'rawdatauniqueid' => { 118 => 0xc65d },
	'rawdepth' => { 187 => 0x10 },
	'rawdevartfilter' => { 303 => 0x121 },
	'rawdevautogradation' => { 303 => 0x119 },
	'rawdevcolorspace' => { 302 => 0x108, 303 => 0x109 },
	'rawdevcontrastvalue' => { 302 => 0x106, 303 => 0x105 },
	'rawdeveditstatus' => { 302 => 0x10b },
	'rawdevelopmentprocess' => { 354 => 0x62 },
	'rawdevengine' => { 302 => 0x109, 303 => 0x10b },
	'rawdevexposurebiasvalue' => { 302 => 0x100, 303 => 0x100 },
	'rawdevgradation' => { 303 => 0x112 },
	'rawdevgraypoint' => { 302 => 0x103, 303 => 0x104 },
	'rawdevmemorycoloremphasis' => { 302 => 0x105, 303 => 0x108 },
	'rawdevnoisereduction' => { 302 => 0x10a, 303 => 0x10a },
	'rawdevpicturemode' => { 303 => 0x10c },
	'rawdevpm_bwfilter' => { 303 => 0x110 },
	'rawdevpmcontrast' => { 303 => 0x10e },
	'rawdevpmnoisefilter' => { 303 => 0x120 },
	'rawdevpmpicturetone' => { 303 => 0x111 },
	'rawdevpmsaturation' => { 303 => 0x10d },
	'rawdevpmsharpness' => { 303 => 0x10f },
	'rawdevsaturation3' => { 303 => 0x113 },
	'rawdevsaturationemphasis' => { 302 => 0x104, 303 => 0x107 },
	'rawdevsettings' => { 302 => 0x10c },
	'rawdevsharpnessvalue' => { 302 => 0x107, 303 => 0x106 },
	'rawdevversion' => { 302 => 0x0, 303 => 0x0 },
	'rawdevwbfineadjustment' => { 302 => 0x102, 303 => 0x103 },
	'rawdevwhitebalance' => { 303 => 0x101 },
	'rawdevwhitebalancevalue' => { 302 => 0x101, 303 => 0x102 },
	'rawfile' => { 118 => 0xfe4c },
	'rawfilename' => { 476 => 'RawFileName', 478 => 'RawFileName' },
	'rawfiletype' => { 419 => 0x2029 },
	'rawformat' => { 324 => 0x2d, 363 => 0x10e },
	'rawimagecenter' => { 225 => 0x99 },
	'rawimagedigest' => { 118 => 0xc71c },
	'rawimagesize' => { 354 => 0x39 },
	'rawinfoversion' => { 304 => 0x0 },
	'rawjpgheight' => { 98 => 0x4 },
	'rawjpgquality' => { 57 => 0x6, 98 => 0x1 },
	'rawjpgsize' => { 57 => 0x7, 98 => 0x2 },
	'rawjpgwidth' => { 98 => 0x3 },
	'rawmeasuredrggb' => { 43 => 0x26a, 45 => 0x280, 47 => 0x194, 48 => [0x1ad,0x26b] },
	'rawrppused' => { 471 => 'rawrppused' },
	'rawtopreviewgain' => { 118 => 0xc7a8 },
	'readouttypeactual' => { 137 => 0x1903 },
	'readouttyperequested' => { 137 => 0x1902 },
	'reardisplay' => { 278 => '12.3', 279 => '6.2' },
	'recdevice' => { 488 => 'RecDevice' },
	'recdeviceattlensdescription' => { 488 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 488 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 488 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 488 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 488 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 494 => 'recipeEndingPage' },
	'recipepagerange' => { 494 => 'recipePageRange' },
	'recipesource' => { 494 => 'recipeSource' },
	'recipestartingpage' => { 494 => 'recipeStartingPage' },
	'recipetitle' => { 494 => 'recipeTitle' },
	'recognizedface1age' => { 312 => 0x20 },
	'recognizedface1name' => { 312 => 0x4 },
	'recognizedface1position' => { 312 => 0x18 },
	'recognizedface2age' => { 312 => 0x50 },
	'recognizedface2name' => { 312 => 0x34 },
	'recognizedface2position' => { 312 => 0x48 },
	'recognizedface3age' => { 312 => 0x80 },
	'recognizedface3name' => { 312 => 0x64 },
	'recognizedface3position' => { 312 => 0x78 },
	'recognizedfaceflags' => { 319 => 0x63 },
	'recommendedexposureindex' => { 118 => 0x8832, 483 => 'RecommendedExposureIndex' },
	'record' => { 117 => 'Record' },
	'recordbasisofrecord' => { 117 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 117 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 117 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 117 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 117 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 117 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 183 => 0x4d },
	'recorddynamicproperties' => { 117 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 96 => 0x1804 },
	'recordinformationwithheld' => { 117 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 379 => "\xa9phg" },
	'recordingformat' => { 386 => 0x1000 },
	'recordingmode' => { 111 => 0x1, 361 => 0x1 },
	'recordinstitutioncode' => { 117 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 117 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 379 => "\xa9lab" },
	'recordlabelurl' => { 379 => "\xa9lal" },
	'recordlocationdata' => { 228 => 0x660 },
	'recordmode' => { 34 => 0x9, 112 => 0x3000 },
	'recordownerinstitutioncode' => { 117 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 395 => 0x217 },
	'redbalance' => { 301 => 0x1017, 324 => 0x11, 354 => 0x1c },
	'redcurvelimits' => { 107 => 0x18a },
	'redcurvepoints' => { 106 => 0x2d, 107 => 0x160 },
	'redeyecorrection' => { 275 => 0x0 },
	'redeyeinfo' => { 476 => 'RedEyeInfo', 478 => 'RedEyeInfo' },
	'redeyereduction' => { 183 => 0x41, 406 => 0x6a, 408 => 0x28 },
	'redeyeremoval' => { 319 => 0xb9 },
	'redhsl' => { 102 => 0x20910 },
	'redhue' => { 476 => 'RedHue', 478 => 'RedHue' },
	'redsaturation' => { 476 => 'RedSaturation', 478 => 'RedSaturation' },
	'reductionmatrix1' => { 118 => 0xc625 },
	'reductionmatrix2' => { 118 => 0xc626 },
	'reductionmatrix3' => { 118 => 0xcd3a },
	'reelname' => { 118 => 0xc789, 379 => 'reel' },
	'reference1' => { 486 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 486 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 486 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 486 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 486 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 486 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 118 => 0x214, 498 => 'ReferenceBlackWhite' },
	'referencedate' => { 130 => 0x2f },
	'referencenumber' => { 130 => 0x32 },
	'references' => { 156 => 'References' },
	'referenceservice' => { 130 => 0x2d },
	'regionappliedtodimensions' => { 171 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 171 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 171 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 171 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 171 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 171 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 171 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 171 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 171 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 171 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 171 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 171 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 306 => 'RegionConstraints' },
	'regiondescription' => { 171 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 171 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 171 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 171 => 'Regions' },
	'regioninfodateregionsvalid' => { 174 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 174 => 'RegionInfo' },
	'regioninforegions' => { 174 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 171 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 171 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 174 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 174 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 174 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 174 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 174 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 171 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 171 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 171 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 488 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 488 => 'RegistryId' },
	'registryitemid' => { 488 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 488 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 154 => 'data' },
	'relatedaudiofilename' => { 154 => '1Name' },
	'relatedaudiofiletype' => { 154 => '0Type' },
	'relatedimagefileformat' => { 118 => 0x1000 },
	'relatedimageheight' => { 118 => 0x1002 },
	'relatedimagewidth' => { 118 => 0x1001 },
	'relatedresourceid' => { 117 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 118 => 0xa004, 482 => 'RelatedSoundFile' },
	'relatedvideofile' => { 168 => 'data' },
	'relatedvideofilename' => { 168 => '1Name' },
	'relatedvideofiletype' => { 168 => '0Type' },
	'relation' => { 479 => 'relation' },
	'relationshipaccordingto' => { 117 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 117 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 117 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 117 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 115 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 502 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 502 => 'relativeTimestamp' },
	'relativetimestampscale' => { 502 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 502 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 278 => '17.8', 279 => '18.5', 281 => '18.4', 282 => '18.4', 287 => '33.8', 288 => '17.6', 291 => '18.5', 292 => '18.4' },
	'releasedate' => { 130 => 0x1e, 371 => 'rldt', 471 => 'ReleaseDate', 502 => 'releaseDate' },
	'releasemode' => { 112 => 0x3001, 246 => 0x184d, 419 => 0xb049 },
	'releasemode2' => { 427 => 0x112c, 428 => [0x112c,0x8], 429 => [0x1108,0x8], 430 => [0x1184,0x8], 431 => [0x1160,0x8], 432 => [0x4,0x1018], 433 => [0x4,0x210], 434 => [0x4,0x210], 435 => [0x4,0x208], 437 => [0x67,0x3f], 438 => [0x6b,0x6d,0x73,0x4b], 439 => [0x6b,0x4b], 440 => 0x10, 441 => 0x10, 442 => 0x9, 449 => 0x34 },
	'releasemode3' => { 427 => 0x1128, 428 => 0x1128, 429 => 0x1104, 430 => 0x1180, 431 => 0x115c, 432 => 0x1014, 433 => 0x20c, 434 => 0x20c, 435 => 0x204 },
	'releaseready' => { 488 => 'ReleaseReady' },
	'releasesetting' => { 96 => 0x1016 },
	'releasetime' => { 130 => 0x23, 471 => 'ReleaseTime' },
	'remoteonduration' => { 280 => '3.4', 283 => '17.2', 284 => '18.2', 285 => '18.2', 286 => '18.2', 288 => '18.2', 289 => '4.3', 293 => '19.2' },
	'renditionclass' => { 503 => 'RenditionClass' },
	'renditionof' => { 503 => 'RenditionOf' },
	'renditionofalternatepaths' => { 503 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 503 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 503 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 503 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 503 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 503 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 503 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 503 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 503 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 503 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 503 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 503 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 503 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 503 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 503 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 503 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 503 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 503 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 503 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 503 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 503 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 503 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 503 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 503 => 'RenditionParams' },
	'repeatingflashcount' => { 208 => 0xd, 209 => 0xe, 210 => 0xe, 211 => 0xe, 212 => 0xe, 287 => '17.2', 288 => '24.2', 289 => '9.2', 290 => '24.2', 293 => '25.2' },
	'repeatingflashcountbuilt-in' => { 255 => 0x4db },
	'repeatingflashcountexternal' => { 255 => 0x4c3 },
	'repeatingflashoutput' => { 287 => '17.1', 288 => '24.1', 289 => '9.1', 290 => '24.1', 293 => '25.1' },
	'repeatingflashoutputexternal' => { 255 => 0x4c0 },
	'repeatingflashrate' => { 208 => 0xc, 209 => 0xd, 210 => 0xd, 211 => 0xd, 212 => 0xd, 287 => '18.1', 288 => '25.1', 289 => '10.1', 290 => '25.1', 293 => '26.1' },
	'repeatingflashratebuilt-in' => { 255 => 0x4da },
	'repeatingflashrateexternal' => { 255 => 0x4c2 },
	'requirements' => { 379 => "\xa9req" },
	'requires' => { 474 => 'requires' },
	'resampleparams' => { 502 => 'resampleParams' },
	'resampleparamsquality' => { 502 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 137 => 0xe50 },
	'resamplingkerneldenominators067' => { 137 => 0xe4f },
	'resamplingkerneldenominators100' => { 137 => 0xe51 },
	'resaved' => { 395 => 0x21e },
	'resetblacksegrows' => { 137 => 0x181a },
	'resolution' => { 161 => 'Resolution' },
	'resolutionmode' => { 396 => [0x87,0x4] },
	'resolutionunit' => { 118 => 0x128, 133 => 0x2, 498 => 'ResolutionUnit' },
	'resourceid' => { 117 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 117 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 117 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 83 => 0x612 },
	'restrictions' => { 495 => 'restrictions' },
	'retouchareafeather' => { 476 => [\'RetouchAreas','RetouchAreasFeather'], 478 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 476 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 478 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 476 => [\'RetouchAreas','RetouchAreasMasksAngle'], 478 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 476 => [\'RetouchAreas','RetouchAreasMasksBottom'], 478 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 476 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 478 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 476 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 478 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 476 => [\'RetouchAreas','RetouchAreasMasksDabs'], 478 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 476 => [\'RetouchAreas','RetouchAreasMasksFeather'], 478 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 476 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 478 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 476 => [\'RetouchAreas','RetouchAreasMasksFlow'], 478 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 476 => [\'RetouchAreas','RetouchAreasMasksFullX'], 478 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 476 => [\'RetouchAreas','RetouchAreasMasksFullY'], 478 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 476 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 478 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 476 => [\'RetouchAreas','RetouchAreasMasksLeft'], 478 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 476 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 478 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 476 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 478 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 476 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 478 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 476 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 478 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 476 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 478 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasks'], 478 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 476 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 478 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 476 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 478 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 476 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 478 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 476 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 478 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 476 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 478 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 476 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 478 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 476 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 478 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 476 => [\'RetouchAreas','RetouchAreasMasksRadius'], 478 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 476 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 478 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 476 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 478 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 476 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 478 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 476 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 478 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 476 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 478 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 476 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 478 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 476 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 478 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 476 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 478 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 476 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 478 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 476 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 478 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 476 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 478 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 476 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 478 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 476 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 478 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 476 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 478 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 476 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 478 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 476 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 478 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 476 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 478 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 476 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 478 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 476 => [\'RetouchAreas','RetouchAreasMasksRight'], 478 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 476 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 478 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 476 => [\'RetouchAreas','RetouchAreasMasks'], 478 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 476 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 478 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 476 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 478 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 476 => [\'RetouchAreas','RetouchAreasMasksTop'], 478 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 476 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 478 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 476 => [\'RetouchAreas','RetouchAreasMasksVersion'], 478 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 476 => [\'RetouchAreas','RetouchAreasMasksWhat'], 478 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 476 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 478 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 476 => [\'RetouchAreas','RetouchAreasMasksX'], 478 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 476 => [\'RetouchAreas','RetouchAreasMasksY'], 478 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 476 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 478 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 476 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 478 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 476 => [\'RetouchAreas','RetouchAreasMethod'], 478 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 476 => [\'RetouchAreas','RetouchAreasOffsetY'], 478 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 476 => [\'RetouchAreas','RetouchAreasOpacity'], 478 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 476 => 'RetouchAreas', 478 => 'RetouchAreas' },
	'retouchareaseed' => { 476 => [\'RetouchAreas','RetouchAreasSeed'], 478 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 476 => [\'RetouchAreas','RetouchAreasSourceState'], 478 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 476 => [\'RetouchAreas','RetouchAreasSourceX'], 478 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 476 => [\'RetouchAreas','RetouchAreasSpotType'], 478 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 225 => 0x9e },
	'retouchinfo' => { 476 => 'RetouchInfo', 478 => 'RetouchInfo' },
	'retouchnefprocessing' => { 235 => 0x5 },
	'retractlensonpoweroff' => { 83 => 0x814 },
	'reuse' => { 306 => 'Reuse' },
	'reuseallowed' => { 505 => 'ReuseAllowed' },
	'reuseprohibited' => { 495 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 285 => '5.2' },
	'reversefocusring' => { 294 => 0x163 },
	'reverseindicators' => { 278 => '12.1', 279 => '6.1', 281 => '6.1', 282 => '6.1', 283 => '4.3', 284 => '5.2', 285 => '5.4', 287 => '33.5', 288 => '5.1', 291 => '6.1', 292 => '6.1', 293 => '6.2', 294 => 0xc1 },
	'reverseshutterspeedaperture' => { 285 => '5.3' },
	'revision' => { 480 => 'revision' },
	'rflensmffocusringsensitivity' => { 83 => 0x714 },
	'rflenstype' => { 57 => 0x3d },
	'rgbcurvelimits' => { 107 => 0x238 },
	'rgbcurvepoints' => { 106 => 0x7, 107 => 0x20e },
	'rgbtables' => { 118 => 0xcd3b },
	'richtextcomment' => { 485 => 'RichTextComment' },
	'ricohdate' => { 385 => 0x6 },
	'ricohimageheight' => { 385 => 0x2 },
	'ricohimagewidth' => { 385 => 0x0 },
	'rightalbedo' => { 467 => 'RightAlbedo' },
	'rightascension' => { 164 => 'RightAscension' },
	'rights' => { 479 => 'rights' },
	'rightsagent' => { 495 => 'rightsAgent' },
	'rightsowner' => { 495 => 'rightsOwner' },
	'roll' => { 114 => 0x8, 379 => ['roll',"\xa9frl"] },
	'rollangle' => { 246 => 0x350b, 247 => 0x2c24, 251 => 0xc21a, 256 => 0x36f4, 257 => 0x2efb, 259 => 0xce32, 260 => 0xeaeb, 296 => 0x903, 319 => 0x90, 353 => 0x1, 391 => 0x2 },
	'romoperationmode' => { 96 => 0x80d },
	'rotation' => { 30 => 0x17, 31 => 0x18, 95 => 0x3, 102 => 0x10002, 107 => 0x26e, 113 => 'QuickTime-Rotation', 122 => 0x4, 164 => 'Rotation', 181 => [0x65,0x50], 182 => 0x46, 183 => 0x5a, 186 => 0x10, 246 => 0x3693, 247 => 0xca, 254 => '590.1', 271 => 0x76a43207, 319 => 0x30, 335 => '17.2', 365 => 0xd8, 372 => 'irot', 406 => 0x3f, 407 => 0x3f, 417 => 0x10 },
	'routedto' => { 484 => 'RoutedTo' },
	'routing' => { 370 => 'Routing' },
	'routingdestinations' => { 466 => 'RoutingDestinations' },
	'routingexclusions' => { 466 => 'RoutingExclusions' },
	'routingnotes' => { 484 => 'RoutingNotes' },
	'rowsperstrip' => { 118 => 0x116 },
	'rpp' => { 471 => 'rpp' },
	'rtkflag' => { 115 => 'RtkFlag' },
	'rtkstdhgt' => { 115 => 'RtkStdHgt' },
	'rtkstdlat' => { 115 => 'RtkStdLat' },
	'rtkstdlon' => { 115 => 'RtkStdLon' },
	'safetyshift' => { 83 => 0x108 },
	'safetyshiftinavortv' => { 81 => 0x10, 82 => 0x10, 84 => 0xf, 85 => 0x10, 88 => 0x10 },
	'sameexposurefornewaperture' => { 83 => 0x112 },
	'samplebits' => { 154 => 'SampleBits' },
	'samplepagerange' => { 492 => 'samplePageRange' },
	'samplerate' => { 154 => 'SampleRate' },
	'samplesperpixel' => { 118 => 0x115, 324 => 0x8, 498 => 'SamplesPerPixel' },
	'samplestructure' => { 132 => 0x5a },
	'samsungmodelid' => { 393 => 0x3 },
	'sanyoquality' => { 395 => 0x201 },
	'sanyothumbnail' => { 395 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 34 => 0xe, 51 => 0x1, 111 => 0xd, 112 => [0x3013,0x1f], 118 => [0xa409,0xfe55], 126 => 0x1003, 155 => 'Saturation', 180 => 0x1f, 181 => 0x32, 182 => 0x28, 183 => 0x1a, 188 => 0x1, 225 => 0xaa, 230 => 0x35, 231 => 0x3b, 232 => 0x43, 319 => 0x40, 321 => 0x300d, 354 => 0x1f, 361 => 0xd, 380 => 0x27, 382 => 0x58, 385 => 0x28, 386 => 0x1013, 396 => 0x10, 406 => 0x1e, 407 => 0x1b, 419 => 0x2005, 476 => 'Saturation', 478 => 'Saturation', 482 => 'Saturation' },
	'saturationadj' => { 102 => 0x20901, 107 => 0x116, 225 => 0x94, 270 => 0x1, 274 => 0x2e, 453 => 0x8016 },
	'saturationadjustmentaqua' => { 476 => 'SaturationAdjustmentAqua', 478 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 476 => 'SaturationAdjustmentBlue', 478 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 476 => 'SaturationAdjustmentGreen', 478 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 476 => 'SaturationAdjustmentMagenta', 478 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 476 => 'SaturationAdjustmentOrange', 478 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 476 => 'SaturationAdjustmentPurple', 478 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 476 => 'SaturationAdjustmentRed', 478 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 476 => 'SaturationAdjustmentYellow', 478 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 70 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 69 => 0x68, 70 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 69 => 0x38, 70 => 0x38 },
	'saturationmonochrome' => { 69 => 0x80, 70 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 69 => 0x50, 70 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 69 => 0x20, 70 => 0x20 },
	'saturationsetting' => { 304 => 0x1010, 408 => 0x11, 424 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 69 => 0x8, 70 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 69 => 0x98, 70 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 69 => 0xb0, 70 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 69 => 0xc8, 70 => 0xe0 },
	'saveid' => { 503 => 'SaveID' },
	'sbaanalysiscomplete' => { 137 => 0xc35 },
	'sbablack' => { 137 => 0xc25 },
	'sbagmoffset' => { 137 => 0xc4a },
	'sbagray' => { 137 => 0xc26 },
	'sbagreenmagentabal' => { 137 => 0xc33 },
	'sbahighgray' => { 137 => 0xc46 },
	'sbailloffset' => { 137 => 0xc49 },
	'sbailluminantbal' => { 137 => 0xc34 },
	'sbalowgray' => { 137 => 0xc47 },
	'sbaneutralbal' => { 137 => 0xc32 },
	'sbawhite' => { 137 => 0xc27 },
	'scaletype' => { 502 => 'scaleType' },
	'scanimageenhancer' => { 236 => 0x60 },
	'scanningdirection' => { 132 => 0x64 },
	'scene' => { 379 => 'scen', 487 => 'Scene', 502 => 'scene' },
	'scenearea' => { 299 => 0x211, 301 => 0x1031 },
	'sceneassist' => { 225 => 0x9c },
	'scenecapturetype' => { 118 => 0xa406, 482 => 'SceneCaptureType' },
	'scenedetect' => { 299 => 0x210, 301 => 0x1030 },
	'scenedetectdata' => { 299 => 0x212, 301 => 0x1033 },
	'scenemode' => { 141 => 0xfa02, 185 => 0x100, 225 => 0x8f, 296 => 0x509, 301 => 0x403, 319 => 0x8001, 328 => 0xf, 419 => 0xb023 },
	'scenemodeused' => { 143 => [0x6002,0xf002] },
	'scenerecognition' => { 126 => 0x1425 },
	'sceneselect' => { 395 => 0x21f },
	'scenetype' => { 118 => 0xa301, 482 => 'SceneType' },
	'screentips' => { 278 => '12.7', 279 => '5.3', 287 => '13.1', 288 => '4.4', 291 => '5.4', 293 => '5.1' },
	'scriptversion' => { 137 => 0x1770 },
	'season' => { 488 => 'Season', 491 => 'season' },
	'seasonidentifier' => { 488 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 488 => [\'Season','SeasonName'] },
	'seasonnumber' => { 488 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 466 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 228 => 0x22c, 246 => 0x1d0, 256 => 0x1d0 },
	'section' => { 492 => 'section' },
	'securityclassification' => { 118 => 0x9212 },
	'selectableafpoint' => { 83 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 83 => 0x512 },
	'selfdata' => { 115 => 'SelfData' },
	'selftimer' => { 34 => 0x2, 319 => 0x2e, 395 => 0x214, 427 => 0x1134, 428 => 0x1134, 429 => 0x1110, 430 => 0x118c, 431 => 0x1168, 432 => 0x1020, 433 => 0x218, 434 => 0x218, 435 => 0x210 },
	'selftimer2' => { 76 => 0x1d },
	'selftimerinterval' => { 288 => '19.2' },
	'selftimermode' => { 118 => 0x882b },
	'selftimershotcount' => { 279 => '20.2', 281 => '20.3', 282 => '20.3', 283 => '18.2', 284 => '19.2', 285 => '19.2', 286 => '19.3', 288 => '19.3', 291 => '20.3', 292 => '20.3', 293 => '20.2', 294 => 0x2d },
	'selftimershotinterval' => { 279 => '20.3', 281 => '20.2', 282 => '20.2', 286 => '19.2', 291 => '20.2', 292 => '20.2', 294 => 0x31 },
	'selftimertime' => { 96 => 0x1806, 183 => 0x1f, 278 => '18.1', 279 => '20.1', 280 => '3.3', 281 => '20.1', 282 => '20.1', 283 => '18.1', 284 => '19.1', 285 => '19.1', 286 => '19.1', 287 => '7.2', 288 => '19.1', 289 => '3.3', 291 => '20.1', 292 => '20.1', 293 => '20.1', 294 => 0x2b },
	'sellingagency' => { 492 => 'sellingAgency' },
	'seminfo' => { 118 => 0x8546 },
	'sensingmethod' => { 118 => 0xa217, 482 => 'SensingMethod' },
	'sensitivityadjust' => { 354 => 0x40 },
	'sensitivitysteps' => { 335 => ['14.3','17.4'], 337 => 0x1 },
	'sensitivitytype' => { 118 => 0x8830, 483 => 'SensitivityType' },
	'sensor' => { 190 => 0x665e },
	'sensorarea' => { 301 => 0x400 },
	'sensorareas' => { 393 => 0xa010 },
	'sensorbitdepth' => { 321 => 0x312d },
	'sensorbluelevel' => { 73 => 0x5 },
	'sensorcalibration' => { 300 => 0x805 },
	'sensorcleaning' => { 89 => 0xd },
	'sensorfullheight' => { 136 => 0xf904 },
	'sensorfullwidth' => { 136 => 0xf903 },
	'sensorheight' => { 136 => 0xf901, 141 => 0xfa21, 187 => 0x8, 321 => 0x312c, 363 => 0x109, 386 => 0x1602 },
	'sensorimageheight' => { 137 => 0x3ee },
	'sensorimagewidth' => { 137 => 0x3ed },
	'sensorleftborder' => { 137 => 0x3eb },
	'sensorleftmargin' => { 363 => 0x10a },
	'sensorpixelsize' => { 225 => 0x9a },
	'sensorredlevel' => { 73 => 0x4 },
	'sensorserialnumber' => { 137 => 0x9ce },
	'sensorshield' => { 228 => 0x66d },
	'sensorsize' => { 155 => 'SensorSize', 354 => 0x35 },
	'sensortemperature' => { 299 => 0x1500, 301 => 0x1007, 359 => 0xc, 363 => 0x210, 396 => [0x39,0x55] },
	'sensortemperature2' => { 359 => 0xe, 363 => 0x211 },
	'sensortopborder' => { 137 => 0x3ec },
	'sensortopmargin' => { 363 => 0x10b },
	'sensortype' => { 319 => 0xca },
	'sensorwidth' => { 136 => 0xf900, 141 => 0xfa20, 187 => 0xa, 321 => 0x312b, 363 => 0x108, 386 => 0x1601 },
	'sequence' => { 380 => 0x7, 381 => 0x35, 382 => 0x36 },
	'sequencefilenumber' => { 428 => 0x4, 429 => 0x4, 430 => 0x4, 431 => 0x4, 440 => 0xc, 441 => 0xc, 442 => 0x1a },
	'sequenceimagenumber' => { 428 => 0x0, 429 => 0x0, 430 => 0x0, 431 => 0x0, 440 => 0x8, 441 => 0x8, 442 => 0x12, 449 => 0x24 },
	'sequencelength' => { 440 => 0x22, 441 => 0x1e, 442 => [0x16,0x1e] },
	'sequencename' => { 491 => 'sequenceName' },
	'sequencenumber' => { 76 => 0x9, 112 => 0x301c, 126 => 0x1101, 139 => 0x1d, 255 => 0x51c, 319 => 0x2b, 408 => [0x10c,0x30c], 419 => 0xb04a, 491 => 'sequenceNumber' },
	'sequenceshotinterval' => { 395 => 0x224 },
	'sequencetotalnumber' => { 491 => 'sequenceTotalNumber' },
	'sequentialshot' => { 395 => 0x20e },
	'serialnumber' => { 63 => 0xc, 96 => 0x180b, 118 => [0xa431,0xfde9], 136 => 0xfa04, 138 => 0xfa00, 140 => 0xc354, 141 => 0xfa19, 152 => 0x0, 155 => 'SerialNumber', 190 => 0x5501, 225 => [0xa0,0x1d], 297 => 0x101, 301 => [0x404,0x101a], 314 => 0x303, 316 => 0x305, 321 => 0x3103, 354 => 0x229, 363 => 0x102, 364 => 0x407, 379 => ['SNum','slno'], 380 => 0x15, 381 => 0x4b, 382 => 0x7e, 386 => 0x5, 393 => 0xa002, 396 => 0x2, 419 => 0x2031, 473 => 'SerialNumber', 483 => 'BodySerialNumber' },
	'serialnumberformat' => { 63 => 0x15, 96 => 0x183b },
	'serialnumberhash' => { 379 => 'CAME' },
	'series' => { 488 => 'Series' },
	'seriesdatetime' => { 455 => 'SeriesDateTime' },
	'seriesdescription' => { 455 => 'SeriesDescription' },
	'seriesidentifier' => { 488 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 455 => 'SeriesModality' },
	'seriesname' => { 488 => [\'Series','SeriesName'] },
	'seriesnumber' => { 455 => 'SeriesNumber', 492 => 'seriesNumber' },
	'seriestitle' => { 492 => 'seriesTitle' },
	'serviceidentifier' => { 131 => 0x1e },
	'servingsize' => { 494 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 86 => 0x0, 87 => 0x0 },
	'setbuttonwhenshooting' => { 81 => 0x1, 83 => 0x704, 89 => 0xc },
	'setclockfromlocationdata' => { 228 => 0x61d },
	'setfunctionwhenshooting' => { 84 => 0x0, 85 => 0x1, 88 => 0x1 },
	'setting' => { 491 => 'setting' },
	'shadingcompensation' => { 296 => 0x50c, 319 => 0x8a },
	'shadingcompensation2' => { 300 => 0x1012 },
	'shadow' => { 396 => 0xe },
	'shadowadj' => { 102 => 0x2030b },
	'shadowcorrection' => { 354 => 0x79 },
	'shadowprotection' => { 270 => 0x0 },
	'shadows' => { 118 => 0xfe52, 419 => 0x2032, 470 => 'Shadows', 476 => 'Shadows', 478 => 'Shadows' },
	'shadows2012' => { 476 => 'Shadows2012', 478 => 'Shadows2012' },
	'shadowsadj' => { 453 => 0x901a },
	'shadowscale' => { 118 => 0xc633 },
	'shadowtint' => { 476 => 'ShadowTint', 478 => 'ShadowTint' },
	'shadowtone' => { 126 => 0x1040 },
	'shakereduction' => { 356 => 0x1, 357 => 0x1 },
	'shareduserrating' => { 178 => 'WM/SharedUserRating' },
	'sharpendetail' => { 476 => 'SharpenDetail', 478 => 'SharpenDetail' },
	'sharpenedgemasking' => { 476 => 'SharpenEdgeMasking', 478 => 'SharpenEdgeMasking' },
	'sharpening' => { 321 => 0x300b },
	'sharpeningadj' => { 274 => 0x2b },
	'sharpeningkernel' => { 137 => 0x92f },
	'sharpenradius' => { 476 => 'SharpenRadius', 478 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 34 => 0xf, 73 => 0x2, 111 => 0xb, 112 => [0x3011,0x21], 118 => [0xa40a,0xfe56], 126 => 0x1001, 139 => 0x6b, 148 => 0x37, 155 => 'Sharpness', 180 => 0x21, 181 => 0x30, 182 => 0x26, 183 => 0x18, 188 => 0x3, 225 => 0x6, 230 => 0x32, 231 => 0x33, 232 => 0x39, 301 => 0x100f, 319 => 0x41, 354 => 0x21, 361 => 0xb, 380 => 0x26, 382 => 0x56, 385 => 0x22, 386 => [0x1003,0x1014], 396 => 0x11, 406 => 0x1c, 407 => 0x19, 419 => 0x2006, 449 => 0x52, 476 => 'Sharpness', 478 => 'Sharpness', 482 => 'Sharpness' },
	'sharpnessadj' => { 102 => 0x20310, 107 => 0x25a, 453 => 0x801a },
	'sharpnessadjon' => { 102 => '0x20310.0' },
	'sharpnessauto' => { 70 => 0x94 },
	'sharpnessfactor' => { 301 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 69 => 0x64, 70 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 73 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 69 => 0x34, 70 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 69 => 0x7c, 70 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 69 => 0x4c, 70 => 0x4c },
	'sharpnessovershoot' => { 453 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 69 => 0x1c, 70 => 0x1c },
	'sharpnessrange' => { 419 => 0x2035 },
	'sharpnesssetting' => { 296 => 0x506, 304 => 0x1013, 408 => 0x12, 424 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 69 => 0x4, 70 => 0x4 },
	'sharpnessstrength' => { 102 => 0x20311 },
	'sharpnessthreshold' => { 453 => 0x801d },
	'sharpnessundershoot' => { 453 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 69 => 0x94, 70 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 69 => 0xac, 70 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 69 => 0xc4, 70 => 0xdc },
	'shiftcols' => { 137 => 0xc70 },
	'shootid' => { 491 => 'shootID' },
	'shootingdistance' => { 102 => 0x20701 },
	'shootinginfodisplay' => { 278 => '13.2', 279 => '5.1', 287 => '10.2', 288 => '4.1', 291 => '5.1', 293 => '5.3' },
	'shootinginfomonitorofftime' => { 278 => '26.2', 279 => '22.2', 281 => '22.2', 282 => '22.2', 286 => '21.2', 287 => '9.1', 288 => '21.2', 291 => '22.2', 292 => '22.2', 293 => '22.2', 294 => 0x37 },
	'shootingmode' => { 155 => 'ShootingMode', 225 => 0x89, 319 => 0x1f },
	'shootingmodesetting' => { 280 => '5.1' },
	'shortdescription' => { 480 => 'shortdescription' },
	'shortdocumentid' => { 130 => 0xba },
	'shortname' => { 476 => 'ShortName', 478 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 83 => 0x80d },
	'shorttitle' => { 371 => '@sti' },
	'shotdate' => { 502 => 'shotDate' },
	'shotday' => { 502 => 'shotDay' },
	'shotlocation' => { 502 => 'shotLocation' },
	'shotname' => { 379 => 'shot', 502 => 'shotName' },
	'shotnumber' => { 502 => 'shotNumber' },
	'shotnumbersincepowerup' => { 423 => 0x44e, 440 => 0x1a, 441 => 0x16, 442 => 0xa },
	'shotnumbersincepowerup2' => { 408 => 0x200 },
	'shotsize' => { 502 => 'shotSize' },
	'shotsperinterval' => { 227 => 0xb4, 228 => 0xc0, 251 => 0xc412 },
	'showmovement' => { 371 => 'shwm' },
	'shownevent' => { 488 => 'EventExt' },
	'showneventidentifier' => { 488 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 488 => [\'EventExt','EventExtName'] },
	'shutter' => { 437 => 0x20, 438 => 0x26, 439 => 0x26 },
	'shutter-aelock' => { 81 => 0x4, 83 => 0x701, 84 => 0x3, 85 => 0x4, 86 => 0x3, 87 => 0x3, 88 => 0x4, 89 => 0x2 },
	'shutteraelbutton' => { 82 => 0x4 },
	'shutterbuttonafonbutton' => { 83 => 0x701 },
	'shuttercount' => { 11 => 0x176, 57 => 0x1, 225 => 0xa7, 237 => [0x6a,0x157,0x24d], 238 => 0x286, 239 => 0x279, 240 => 0x284, 241 => 0x242, 242 => 0x280, 243 => 0x276, 244 => [0x27d,0x27f], 245 => 0x246, 248 => 0x2d6, 249 => 0x321, 250 => 0xbd8, 252 => 0x287, 253 => 0x320, 254 => 0x24a, 255 => 0x5fb, 258 => 0x2d5, 354 => 0x5d, 417 => 0x846, 422 => [0x125,0x14a], 437 => 0x32, 438 => 0x3a, 439 => 0x3a },
	'shuttercount2' => { 437 => 0x4c, 438 => [0x50,0x52,0x58], 439 => 0x50 },
	'shuttercount3' => { 437 => [0x1a0,0x1aa,0x1bd], 438 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 81 => 0xf, 82 => 0xf, 83 => 0x305, 84 => 0xe, 85 => 0xf, 86 => 0x8, 87 => 0x8, 88 => 0xf, 89 => 0x8 },
	'shuttermode' => { 57 => 0x17, 139 => 0x1b, 225 => 0x34 },
	'shutterreleasebuttonae-l' => { 278 => '17.7', 279 => '18.4', 281 => '78.4', 282 => '78.4', 283 => '16.1', 284 => '17.1', 285 => '17.1', 286 => '17.1', 287 => '7.1', 288 => '17.5', 291 => '18.4', 292 => '78.4', 293 => '18.2', 294 => 0x29 },
	'shutterreleasemethod' => { 96 => 0x1010 },
	'shutterreleasenocfcard' => { 81 => 0x2, 82 => 0x2, 89 => 0xf },
	'shutterreleasetiming' => { 96 => 0x1011 },
	'shutterreleasewithoutlens' => { 83 => 0x711 },
	'shutterspeedlock' => { 279 => '38.1', 281 => '38.1', 282 => '38.1', 291 => '38.1', 292 => '38.1', 294 => 0xb7 },
	'shutterspeedrange' => { 83 => 0x10c },
	'shutterspeedsetting' => { 183 => 0x6, 406 => 0x2f, 407 => 0x28, 408 => 0x0 },
	'shutterspeedvalue' => { 92 => 0x1, 118 => 0x9201, 301 => 0x1000, 363 => 0x400, 482 => 'ShutterSpeedValue' },
	'shuttertype' => { 126 => 0x1050, 319 => 0x9f, 354 => 0x87 },
	'sidecarforextension' => { 490 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 137 => 0xe0d },
	'sigmascalingfactorcamera' => { 137 => 0xe0c },
	'sigmascalingfactorlowres' => { 137 => 0xe0b },
	'sigmasizetable' => { 137 => 0xe0f },
	'silentphotography' => { 225 => 0xbf },
	'similarityindex' => { 130 => 0xe4 },
	'singleframebracketing' => { 183 => 0x21 },
	'skilllevel' => { 494 => 'skillLevel' },
	'skintonecorrection' => { 354 => 0x95 },
	'skiplinetime' => { 137 => 0x184e },
	'slaveflashmeteringsegments' => { 354 => 0x20b },
	'slideshowname' => { 491 => 'slideshowName' },
	'slideshownumber' => { 491 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 491 => 'slideshowTotalNumber' },
	'slowshutter' => { 76 => 0x8 },
	'slowsync' => { 126 => 0x1030 },
	'smartalbumcolor' => { 393 => 0x20 },
	'smartrange' => { 393 => 0xa012 },
	'smileshutter' => { 408 => 0x31 },
	'smileshuttermode' => { 408 => 0x27 },
	'smoothness' => { 118 => 0xfe57, 476 => 'Smoothness', 478 => 'Smoothness' },
	'snapshot' => { 488 => 'SnapshotLink' },
	'snapshotformat' => { 488 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 488 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 488 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 488 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 488 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 471 => 'Snapshots' },
	'snapshotusedvideoframe' => { 488 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 488 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 488 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 488 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 488 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 419 => 0x200f },
	'software' => { 118 => 0x131, 156 => 'Software', 309 => 'Software', 363 => 0x203, 373 => 'software', 396 => 0x18, 461 => 'Software', 498 => 'Software' },
	'softwareversion' => { 379 => ['@swr',"\xa9swr"], 395 => 0x207 },
	'soloist' => { 371 => "\xa9sol" },
	'songwriter' => { 379 => "\xa9swf" },
	'songwriterkeywords' => { 379 => "\xa9swk" },
	'sonycropsize' => { 118 => 0x74c8 },
	'sonycroptopleft' => { 118 => 0x74c7 },
	'sonydatetime' => { 426 => 0x6, 428 => 0x1b6, 429 => 0x210, 430 => 0x1fe, 431 => 0x22c },
	'sonydatetime2' => { 437 => 0x51 },
	'sonyexposuretime' => { 437 => 0x3a, 438 => 0x46, 439 => [0x66,0x46] },
	'sonyexposuretime2' => { 449 => 0xe },
	'sonyfnumber' => { 437 => 0x3c, 438 => 0x48, 439 => [0x68,0x48], 449 => 0x14 },
	'sonyimageheight' => { 426 => 0x1a, 440 => 0x44, 441 => 0x3f, 442 => 0x47 },
	'sonyimageheightmax' => { 449 => 0x40 },
	'sonyimagesize' => { 183 => 0x3b, 406 => 0x54, 407 => 0x54, 408 => 0x9 },
	'sonyimagewidth' => { 426 => 0x1c },
	'sonyimagewidthmax' => { 449 => 0x3e },
	'sonyiso' => { 428 => 0x1218, 429 => 0x11f4, 430 => 0x1270, 431 => [0x1254,0x1258,0x1280], 432 => 0x113c, 433 => 0x344, 434 => 0x346, 435 => 0x320, 449 => 0x4 },
	'sonymaxaperture' => { 437 => 0x0, 438 => 0x0 },
	'sonymaxaperturevalue' => { 449 => 0x16 },
	'sonyminaperture' => { 437 => 0x1, 438 => 0x1 },
	'sonymodelid' => { 419 => 0xb001 },
	'sonyquality' => { 183 => 0x3c },
	'sonytimeminsec' => { 438 => 0x61 },
	'sortalbum' => { 371 => 'soal' },
	'sortalbumartist' => { 371 => 'soaa' },
	'sortartist' => { 371 => 'soar' },
	'sortcomposer' => { 371 => 'soco' },
	'sortname' => { 371 => 'sonm', 476 => 'SortName', 478 => 'SortName' },
	'sortshow' => { 371 => 'sosn' },
	'soundengineer' => { 371 => "\xa9sne" },
	'source' => { 130 => 0x73, 309 => 'Source', 479 => 'source', 480 => 'source', 490 => 'Source' },
	'sourcecount' => { 465 => 'SourceCount' },
	'sourcecredits' => { 379 => "\xa9src" },
	'sourcedirectoryindex' => { 341 => 0x0 },
	'sourcefileindex' => { 341 => 0x2 },
	'sourcephotoscount' => { 464 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 137 => 0x1390 },
	'spatialfrequencyresponse' => { 482 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 482 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 482 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 482 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 482 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 502 => 'speakerPlacement' },
	'specialeffectlevel' => { 112 => 0x3030 },
	'specialeffectmode' => { 112 => 0x2076 },
	'specialeffectsetting' => { 112 => 0x3031 },
	'specialinstructions' => { 130 => 0x28 },
	'specialmode' => { 301 => 0x200, 395 => 0x200 },
	'specialoccasion' => { 494 => 'specialOccasion' },
	'specialtypeid' => { 459 => 'SpecialTypeID' },
	'spectralsensitivity' => { 118 => 0x8824, 482 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 41 => 0x32b, 42 => 0x281, 45 => [0x2b9,0x2d0,0x2d4], 46 => 0x56a, 47 => 0x1e4, 48 => [0x1fd,0x2dd], 49 => [0x231,0x30f], 50 => 0x31d },
	'speedx' => { 114 => 0x3, 379 => "\xa9xsp" },
	'speedy' => { 114 => 0x4, 379 => "\xa9ysp" },
	'speedz' => { 114 => 0x5, 379 => "\xa9zsp" },
	'spherical' => { 465 => 'Spherical' },
	'splitcolumn' => { 363 => 0x222 },
	'splittoningbalance' => { 476 => 'SplitToningBalance', 478 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 476 => 'SplitToningHighlightHue', 478 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 476 => 'SplitToningHighlightSaturation', 478 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 476 => 'SplitToningShadowHue', 478 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 476 => 'SplitToningShadowSaturation', 478 => 'SplitToningShadowSaturation' },
	'sport' => { 492 => 'sport' },
	'spotfocuspointx' => { 180 => 0x2d },
	'spotfocuspointy' => { 180 => 0x2e },
	'spotmeteringmode' => { 34 => 0x27 },
	'spotmeterlinktoafpoint' => { 83 => 0x107 },
	'sractive' => { 335 => '17.1' },
	'srawquality' => { 34 => 0x2e },
	'srfocallength' => { 356 => 0x3 },
	'srgbrendering' => { 307 => 'sRGB' },
	'srhalfpresstime' => { 356 => 0x2 },
	'srresult' => { 356 => 0x0, 357 => 0x0 },
	'stackedimage' => { 296 => 0x804 },
	'standardmatrixcustom' => { 137 => 0x7d4 },
	'standardmatrixdaylight' => { 137 => 0x7d0 },
	'standardmatrixflash' => { 137 => 0x7d3 },
	'standardmatrixfluorescent' => { 137 => 0x7d2 },
	'standardmatrixtungsten' => { 137 => 0x7d1 },
	'standardoutputhighlightpoint' => { 108 => 0x14 },
	'standardoutputsensitivity' => { 118 => 0x8831, 483 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 108 => 0x15 },
	'standardrawcolortone' => { 108 => 0xd },
	'standardrawcontrast' => { 108 => 0xf },
	'standardrawhighlight' => { 108 => 0x75 },
	'standardrawhighlightpoint' => { 108 => 0x12 },
	'standardrawlinear' => { 108 => 0x10 },
	'standardrawsaturation' => { 108 => 0xe },
	'standardrawshadow' => { 108 => 0x7e },
	'standardrawshadowpoint' => { 108 => 0x13 },
	'standardrawsharpness' => { 108 => 0x11 },
	'standardunsharpmaskfineness' => { 108 => 0x94 },
	'standardunsharpmaskstrength' => { 108 => 0x92 },
	'standardunsharpmaskthreshold' => { 108 => 0x96 },
	'standardwhitecustom' => { 137 => 0x838 },
	'standardwhitedaylight' => { 137 => 0x834 },
	'standardwhiteflash' => { 137 => 0x837 },
	'standardwhitefluorescent' => { 137 => 0x836 },
	'standardwhitetungsten' => { 137 => 0x835 },
	'standbytimer' => { 279 => '19.1', 281 => '19.1', 282 => '19.1', 285 => '18.1', 286 => '18.1', 291 => '19.1', 292 => '19.1' },
	'starlightview' => { 294 => 0x249 },
	'startingpage' => { 492 => 'startingPage' },
	'startmovieshooting' => { 83 => 0x70d },
	'starttimecode' => { 379 => "\xa9TIM", 502 => 'startTimecode' },
	'starttimecodetimeformat' => { 502 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 502 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 502 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 379 => "\xa9TSZ", 502 => 'startTimeSampleSize' },
	'starttimescale' => { 379 => "\xa9TSC", 502 => 'startTimeScale' },
	'state' => { 160 => 'State', 319 => 0x6b, 490 => 'State' },
	'status' => { 457 => 'Status', 469 => 'Status' },
	'stereomode' => { 465 => 'StereoMode' },
	'stitched' => { 465 => 'Stitched' },
	'stitchingsoftware' => { 464 => 'StitchingSoftware', 465 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 427 => 0x113e, 428 => 0x113e, 429 => 0x111a, 430 => 0x1196, 431 => 0x1172, 432 => 0x102a, 433 => 0x222, 434 => 0x222, 435 => 0x217, 449 => 0xa },
	'storagemethod' => { 187 => 0x12 },
	'storebyorientation' => { 279 => '46.3', 281 => '47.3', 282 => '47.3', 291 => '47.3', 292 => '47.3', 294 => 0xd },
	'storedescription' => { 371 => 'sdes' },
	'storylineidentifier' => { 488 => 'StorylineIdentifier' },
	'straightenangle' => { 271 => 0x2fc08431 },
	'streamready' => { 488 => 'StreamReady' },
	'streamtype' => { 175 => 'StreamType' },
	'stretchmode' => { 502 => 'stretchMode' },
	'studydatetime' => { 455 => 'StudyDateTime' },
	'studydescription' => { 455 => 'StudyDescription' },
	'studyid' => { 455 => 'StudyID' },
	'studyphysician' => { 455 => 'StudyPhysician' },
	'styleperiod' => { 488 => 'StylePeriod' },
	'sub-location' => { 130 => 0x5c },
	'subcommanddialplaybackmode' => { 294 => 0x1cf },
	'subfiledata' => { 163 => 'data' },
	'subfiledirectory' => { 163 => '1Directory' },
	'subfilemimetype' => { 163 => '2MIME' },
	'subfilename' => { 163 => '1Name' },
	'subfileresource' => { 163 => 'rsrc' },
	'subfiletype' => { 118 => 0xfe, 163 => '0Type' },
	'subject' => { 305 => 'Subject', 370 => 'Subject', 479 => 'subject', 489 => 'Subject', 503 => 'subject' },
	'subjectarea' => { 118 => 0x9214, 482 => 'SubjectArea' },
	'subjectcode' => { 487 => 'SubjectCode' },
	'subjectdetection' => { 228 => 0x23e },
	'subjectdistance' => { 118 => 0x9206, 139 => 0x3e, 482 => 'SubjectDistance' },
	'subjectdistancerange' => { 118 => 0xa40c, 482 => 'SubjectDistanceRange' },
	'subjectlocation' => { 118 => 0xa214, 482 => 'SubjectLocation' },
	'subjectmotion' => { 281 => '78.2', 282 => '78.2', 292 => '78.2', 294 => 0x103 },
	'subjectprogram' => { 180 => 0x22 },
	'subjectreference' => { 130 => 0xc },
	'sublabels1' => { 486 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 486 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 486 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 486 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 486 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 113 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 113 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 113 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 118 => 0x9290 },
	'subsectimedigitized' => { 118 => 0x9292 },
	'subsectimeoriginal' => { 118 => 0x9291 },
	'subsection1' => { 492 => 'subsection1' },
	'subsection2' => { 492 => 'subsection2' },
	'subsection3' => { 492 => 'subsection3' },
	'subsection4' => { 492 => 'subsection4' },
	'subselector' => { 279 => '49.1', 281 => '71.1', 282 => '71.1', 292 => '71.1', 294 => 0x8f },
	'subselectorassignment' => { 279 => '48.1' },
	'subselectorcenter' => { 281 => '72.1', 282 => '72.1', 292 => '72.1' },
	'subselectorplusdials' => { 279 => '49.2', 281 => '73.1', 282 => '73.1', 292 => '73.1' },
	'subtitle' => { 178 => 'WM/SubTitle', 371 => "\xa9st3", 379 => "\xa9snm", 492 => 'subtitle' },
	'subtitlekeywords' => { 379 => "\xa9snk" },
	'subversionfilename' => { 486 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 486 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 486 => 'SubVersions' },
	'superimposeddisplay' => { 81 => 0xa, 83 => 0x510, 84 => 0x9, 85 => 0xa, 88 => 0xa, 89 => 0xe },
	'supermacro' => { 63 => 0x1a },
	'supplementalcategories' => { 130 => 0x14, 490 => 'SupplementalCategories' },
	'supplementaltype' => { 132 => 0x37 },
	'supplementdisplayid' => { 492 => 'supplementDisplayID' },
	'supplementstartingpage' => { 492 => 'supplementStartingPage' },
	'supplementtitle' => { 492 => 'supplementTitle' },
	'supplychainsource' => { 488 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 488 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 488 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 476 => 'SupportsAmount', 478 => 'SupportsAmount' },
	'supportscolor' => { 476 => 'SupportsColor', 478 => 'SupportsColor' },
	'supportshighdynamicrange' => { 476 => 'SupportsHighDynamicRange', 478 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 476 => 'SupportsMonochrome', 478 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 476 => 'SupportsNormalDynamicRange', 478 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 476 => 'SupportsOutputReferred', 478 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 476 => 'SupportsSceneReferred', 478 => 'SupportsSceneReferred' },
	'svisosetting' => { 335 => 0x14 },
	'swatchcoloranta' => { 507 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 507 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 507 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 507 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 507 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 507 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 507 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 507 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 507 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 507 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 507 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 507 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 507 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 507 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 507 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 507 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 507 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 507 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 507 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 319 => 0x93, 408 => 0x33 },
	'sweeppanoramafieldofview' => { 319 => 0x94 },
	'sweeppanoramasize' => { 408 => 0x32 },
	'switchtoregisteredafpoint' => { 82 => 0x12, 83 => 0x50a },
	'symlink' => { 119 => 'SymLink' },
	'syncreleasemode' => { 281 => '77.1', 282 => '77.1', 292 => '77.1', 294 => 0x41 },
	'system' => { 363 => 0x204 },
	'tagged' => { 365 => 0xdd, 366 => 'Tagged', 471 => 'tagged' },
	'tagslist' => { 481 => 'TagsList' },
	'tagstructure' => { 486 => 'TagStructure' },
	'takenumber' => { 502 => 'takeNumber' },
	'tapename' => { 502 => 'tapeName' },
	'targetaperture' => { 76 => 0x4 },
	'targetcompressionratio' => { 94 => 0x1 },
	'targetdistancesetting' => { 96 => 0x1807 },
	'targetexposuretime' => { 76 => 0x5 },
	'targetimagetype' => { 96 => 0x100a },
	'targetprinter' => { 118 => 0x151 },
	'taxon' => { 117 => 'Taxon' },
	'taxonacceptednameusage' => { 117 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 117 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 117 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 117 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 117 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 117 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 117 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 117 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 117 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 117 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 117 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 117 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 117 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 117 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 117 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 117 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 117 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 117 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 117 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 117 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 117 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 117 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 117 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 117 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 117 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 117 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 117 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 117 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 117 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 117 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 117 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 117 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 117 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 137 => 0x196f },
	'tda1edgepolarity' => { 137 => 0x1971 },
	'tda1gain' => { 137 => 0x1970 },
	'tda1offset' => { 137 => 0x196e },
	'tda2bandwidth' => { 137 => 0x1979 },
	'tda2edgepolarity' => { 137 => 0x197b },
	'tda2gain' => { 137 => 0x197a },
	'tda2offset' => { 137 => 0x1978 },
	'tda3bandwidth' => { 137 => 0x1983 },
	'tda3edgepolarity' => { 137 => 0x1985 },
	'tda3gain' => { 137 => 0x1984 },
	'tda3offset' => { 137 => 0x1982 },
	'tda4bandwidth' => { 137 => 0x198d },
	'tda4edgepolarity' => { 137 => 0x198f },
	'tda4gain' => { 137 => 0x198e },
	'tda4offset' => { 137 => 0x198c },
	'teaser' => { 492 => 'teaser' },
	'teleconverter' => { 185 => 0x105, 419 => 0x105 },
	'tempampgainx100' => { 137 => 0x1914 },
	'tempo' => { 502 => 'tempo' },
	'temporalcoverage' => { 488 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 488 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 488 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 306 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 306 => 'TermsAndConditionsURL' },
	'testname' => { 119 => 'TestName' },
	'textencoding' => { 224 => 0x4 },
	'textlayername' => { 490 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 490 => 'TextLayers' },
	'textlayertext' => { 490 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 319 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 476 => 'Texture', 478 => 'Texture' },
	'three-dtrackingfacedetection' => { 281 => '1.4', 282 => '1.4', 292 => '1.4' },
	'three-dtrackingwatcharea' => { 281 => '78.1', 282 => '78.1', 292 => '78.1' },
	'thresholding' => { 118 => 0x107 },
	'thumbnailfilename' => { 96 => 0x817 },
	'thumbnailformat' => { 500 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 141 => 0xfa55, 500 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 96 => 0x2008, 113 => 'Exif-ThumbnailImage', 121 => 0x3, 166 => 'data', 301 => 0x100, 379 => 'thmb', 500 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 166 => '1Name' },
	'thumbnailimagesize' => { 166 => 'ImageSize' },
	'thumbnailimagetype' => { 166 => '0Type' },
	'thumbnailimagevalidarea' => { 63 => 0x13 },
	'thumbnaillength' => { 118 => 0x202 },
	'thumbnailoffset' => { 118 => 0x201 },
	'thumbnailpng' => { 379 => 'thmb' },
	'thumbnails' => { 500 => 'Thumbnails' },
	'thumbnailwidth' => { 141 => 0xfa54, 500 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 492 => 'ticker' },
	'tiffhandling' => { 476 => 'TIFFHandling', 478 => 'TIFFHandling' },
	'tiffmeteringimage' => { 186 => 0x104c, 417 => 0x1110 },
	'tilelength' => { 118 => 0x143 },
	'tilewidth' => { 118 => 0x142 },
	'time' => { 137 => 0x401, 354 => 0x7 },
	'timecodes' => { 118 => 0xc763 },
	'timecreated' => { 130 => 0x3c, 139 => 0x14, 148 => 0x10, 366 => 'TimeCreated' },
	'timelapseshotnumber' => { 322 => 0x10 },
	'timeperiod' => { 492 => 'timePeriod' },
	'timerfunctionbutton' => { 280 => '5.2', 283 => '12.1', 284 => '13.1' },
	'timerlength' => { 83 => 0x80c },
	'timerrecording' => { 319 => 0x96 },
	'timescaleparams' => { 502 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 502 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 502 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 502 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 131 => 0x50 },
	'timeshot' => { 466 => 'TimeShot' },
	'timesignature' => { 502 => 'timeSignature' },
	'timesincepoweron' => { 319 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 295 => 0x8, 309 => 'TimeStamp', 319 => 0xaf, 465 => 'Timestamp', 472 => 'Timestamp', 486 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 77 => 0x1, 228 => 0x594, 263 => 0x0, 389 => 0xa },
	'timezonecity' => { 77 => 0x2 },
	'timezonecode' => { 99 => 0x1 },
	'timezoneinfo' => { 99 => 0x2 },
	'timezoneoffset' => { 118 => 0x882a },
	'tint' => { 373 => 'player.movie.visual.tint', 476 => 'Tint', 478 => 'Tint' },
	'title' => { 156 => 'Title', 305 => 'Title', 309 => 'Title', 319 => 0x65, 370 => 'Title', 371 => ['titl',"\xa9nam"], 373 => 'title', 379 => ['titl',"\xa9nam"], 479 => 'title', 489 => 'Title', 500 => 'Title' },
	'togglestyleamount' => { 476 => 'ToggleStyleAmount', 478 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 476 => 'ToggleStyleDigest', 478 => 'ToggleStyleDigest' },
	'tonecomp' => { 225 => 0x81 },
	'tonecurve' => { 73 => 0x1, 354 => 0x402, 476 => 'ToneCurve', 478 => 'ToneCurve' },
	'tonecurveactive' => { 107 => 0x110 },
	'tonecurveadobergb' => { 393 => 0xa043 },
	'tonecurveadobergbdefault' => { 393 => 0xa041 },
	'tonecurveblue' => { 476 => 'ToneCurveBlue', 478 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 453 => 0x9003 },
	'tonecurvebluey' => { 453 => 0x9007 },
	'tonecurvebrightness' => { 102 => 0x20410 },
	'tonecurvebrightnessx' => { 453 => 0x9000 },
	'tonecurvebrightnessy' => { 453 => 0x9004 },
	'tonecurvecolorspace' => { 106 => 0x0 },
	'tonecurvecontrast' => { 102 => 0x20411 },
	'tonecurvegreen' => { 476 => 'ToneCurveGreen', 478 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 453 => 0x9002 },
	'tonecurvegreeny' => { 453 => 0x9006 },
	'tonecurveinputrange' => { 106 => 0x3 },
	'tonecurveinterpolation' => { 107 => 0x159 },
	'tonecurvemode' => { 107 => 0x113 },
	'tonecurvename' => { 476 => 'ToneCurveName', 478 => 'ToneCurveName' },
	'tonecurvename2012' => { 476 => 'ToneCurveName2012', 478 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 102 => '0x20400.1' },
	'tonecurveoutputrange' => { 106 => 0x5 },
	'tonecurveprofilename' => { 137 => 0x1391 },
	'tonecurveproperty' => { 107 => 0x3c },
	'tonecurvepv2012' => { 476 => 'ToneCurvePV2012', 478 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 476 => 'ToneCurvePV2012Blue', 478 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 476 => 'ToneCurvePV2012Green', 478 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 476 => 'ToneCurvePV2012Red', 478 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 476 => 'ToneCurveRed', 478 => 'ToneCurveRed' },
	'tonecurveredx' => { 453 => 0x9001 },
	'tonecurveredy' => { 453 => 0x9005 },
	'tonecurves' => { 354 => 0x403 },
	'tonecurveshape' => { 106 => 0x1 },
	'tonecurvesrgb' => { 393 => 0xa042 },
	'tonecurvesrgbdefault' => { 393 => 0xa040 },
	'tonecurvex' => { 106 => 0xa },
	'tonecurvey' => { 106 => 0xb },
	'tonelevel' => { 296 => 0x52e },
	'tonemapstrength' => { 476 => 'ToneMapStrength', 478 => 'ToneMapStrength' },
	'toningeffect' => { 57 => 0xf, 225 => 0xb3, 230 => 0x38, 231 => 0x40, 232 => 0x48, 386 => 0x1015 },
	'toningeffectauto' => { 70 => 0xa4 },
	'toningeffectfaithful' => { 69 => 0x74, 70 => 0x74 },
	'toningeffectlandscape' => { 69 => 0x44, 70 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 69 => 0x8c, 70 => 0x8c },
	'toningeffectneutral' => { 69 => 0x5c, 70 => 0x5c },
	'toningeffectportrait' => { 69 => 0x2c, 70 => 0x2c },
	'toningeffectstandard' => { 69 => 0x14, 70 => 0x14 },
	'toningeffectuserdef1' => { 69 => 0xa4, 70 => 0xbc },
	'toningeffectuserdef2' => { 69 => 0xbc, 70 => 0xd4 },
	'toningeffectuserdef3' => { 69 => 0xd4, 70 => 0xec },
	'toningsaturation' => { 230 => 0x39, 231 => 0x41, 232 => 0x49 },
	'totalzoom' => { 139 => 0x62 },
	'touchae' => { 319 => 0xab },
	'track' => { 371 => "\xa9trk", 379 => "\xa9trk" },
	'trackcreatedate' => { 378 => 0x1 },
	'trackmodifydate' => { 378 => 0x2 },
	'tracknumber' => { 371 => 'trkn', 502 => 'trackNumber' },
	'tracks' => { 502 => 'Tracks' },
	'tracksframerate' => { 502 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 502 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 502 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 502 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 502 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 502 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 502 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 502 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 502 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 502 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 502 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 502 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 502 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 502 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 502 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 502 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 502 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 379 => 'kgtt' },
	'trailer' => { 119 => 'Trailer' },
	'trailersignature' => { 163 => 'zmie' },
	'transcript' => { 488 => 'Transcript' },
	'transcriptlink' => { 488 => 'TranscriptLink' },
	'transcriptlinklink' => { 488 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 488 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 118 => 0x12d, 498 => 'TransferFunction' },
	'transfertimenormal' => { 137 => 0x1888 },
	'transfertimetest' => { 137 => 0x1889 },
	'transform' => { 319 => [0x8012,0x59] },
	'transmissionreference' => { 490 => 'TransmissionReference' },
	'trapped' => { 305 => 'Trapped', 489 => 'Trapped' },
	'trashbuttonfunction' => { 83 => 0x710 },
	'travelday' => { 319 => 0x36 },
	'treble' => { 373 => 'player.movie.audio.treble' },
	'triggermode' => { 380 => 0x6, 381 => 0x34, 382 => 0x34 },
	'tstop' => { 118 => 0xc772 },
	'ttl_da_adown' => { 342 => 0x5 },
	'ttl_da_aup' => { 342 => 0x4 },
	'ttl_da_bdown' => { 342 => 0x7 },
	'ttl_da_bup' => { 342 => 0x6 },
	'tungstenawb' => { 332 => 0x1 },
	'tvepisode' => { 371 => 'tves' },
	'tvepisodeid' => { 371 => 'tven' },
	'tvexposuretimesetting' => { 335 => 0x12 },
	'tvnetworkname' => { 371 => 'tvnn' },
	'tvseason' => { 371 => 'tvsn' },
	'tvshow' => { 371 => 'tvsh' },
	'type' => { 479 => 'type', 497 => 'type' },
	'typestatus' => { 117 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 118 => 0xc614 },
	'uniquedocumentid' => { 130 => 0xbb },
	'uniquematrixauto' => { 137 => 0x7e9 },
	'uniquematrixcustom' => { 137 => 0x7e8 },
	'uniquematrixdaylight' => { 137 => 0x7e4 },
	'uniquematrixflash' => { 137 => 0x7e7 },
	'uniquematrixfluorescent' => { 137 => 0x7e6 },
	'uniquematrixtungsten' => { 137 => 0x7e5 },
	'uniqueobjectname' => { 131 => 0x64 },
	'units' => { 461 => 'Units' },
	'unknown_aacr' => { 371 => 'AACR' },
	'unknown_cdek' => { 371 => 'CDEK' },
	'unknown_cdet' => { 371 => 'CDET' },
	'unknownblock' => { 354 => 0x405 },
	'unknownblock1' => { 300 => 0x635 },
	'unknownblock2' => { 300 => 0x636 },
	'unknownblock3' => { 300 => 0x1103 },
	'unknownblock4' => { 300 => 0x1104 },
	'unknowncontrast' => { 108 => 0x45 },
	'unknowndate' => { 363 => 0x212 },
	'unknownev' => { 137 => 0x1 },
	'unknownlinear' => { 108 => 0x46 },
	'unknownnumber' => { 96 => 0x180b },
	'unknownoutputhighlightpoint' => { 108 => 0x4a },
	'unknownoutputshadowpoint' => { 108 => 0x4b },
	'unknownrawhighlight' => { 108 => 0x7b },
	'unknownrawhighlightpoint' => { 108 => 0x48 },
	'unknownrawshadow' => { 108 => 0x84 },
	'unknownrawshadowpoint' => { 108 => 0x49 },
	'unknownsharpness' => { 108 => 0x47 },
	'unknowntags' => { 379 => 'TAGS' },
	'unknowntemperature' => { 120 => 0x4 },
	'unknownthumbnail' => { 379 => 'thmb' },
	'unsharp1color' => { 276 => 0x13 },
	'unsharp1halowidth' => { 276 => 0x19 },
	'unsharp1intensity' => { 276 => 0x17 },
	'unsharp1threshold' => { 276 => 0x1b },
	'unsharp2color' => { 276 => 0x2e },
	'unsharp2halowidth' => { 276 => 0x34 },
	'unsharp2intensity' => { 276 => 0x32 },
	'unsharp2threshold' => { 276 => 0x36 },
	'unsharp3color' => { 276 => 0x49 },
	'unsharp3halowidth' => { 276 => 0x4f },
	'unsharp3intensity' => { 276 => 0x4d },
	'unsharp3threshold' => { 276 => 0x51 },
	'unsharp4color' => { 276 => 0x64 },
	'unsharp4halowidth' => { 276 => 0x6a },
	'unsharp4intensity' => { 276 => 0x68 },
	'unsharp4threshold' => { 276 => 0x6c },
	'unsharpcount' => { 276 => 0x0 },
	'unsharpmask' => { 108 => 0x90, 271 => 0x76a43200 },
	'unsharpmaskfineness' => { 102 => 0x20309 },
	'unsharpmaskstrength' => { 102 => 0x20308 },
	'unsharpmaskthreshold' => { 102 => 0x2030a },
	'uprightcentermode' => { 476 => 'UprightCenterMode', 478 => 'UprightCenterMode' },
	'uprightcenternormx' => { 476 => 'UprightCenterNormX', 478 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 476 => 'UprightCenterNormY', 478 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 476 => 'UprightDependentDigest', 478 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 476 => 'UprightFocalLength35mm', 478 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 476 => 'UprightFocalMode', 478 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 476 => 'UprightFourSegmentsCount', 478 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 476 => 'UprightPreview', 478 => 'UprightPreview' },
	'uprighttransform_0' => { 476 => 'UprightTransform_0', 478 => 'UprightTransform_0' },
	'uprighttransform_1' => { 476 => 'UprightTransform_1', 478 => 'UprightTransform_1' },
	'uprighttransform_2' => { 476 => 'UprightTransform_2', 478 => 'UprightTransform_2' },
	'uprighttransform_3' => { 476 => 'UprightTransform_3', 478 => 'UprightTransform_3' },
	'uprighttransform_4' => { 476 => 'UprightTransform_4', 478 => 'UprightTransform_4' },
	'uprighttransform_5' => { 476 => 'UprightTransform_5', 478 => 'UprightTransform_5' },
	'uprighttransformcount' => { 476 => 'UprightTransformCount', 478 => 'UprightTransformCount' },
	'uprightversion' => { 476 => 'UprightVersion', 478 => 'UprightVersion' },
	'urgency' => { 130 => 0xa, 490 => 'Urgency' },
	'url' => { 156 => 'URL', 309 => 'URL', 368 => 0x40b, 492 => 'url' },
	'url_list' => { 368 => 0x41e },
	'urla-platform' => { 492 => [\'url','urlA-platform'] },
	'urlurl' => { 492 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 83 => 0x10a },
	'usableshootingmodes' => { 83 => 0x109 },
	'usage' => { 493 => 'usage' },
	'usageterms' => { 506 => 'UsageTerms' },
	'usbpowerdelivery' => { 228 => 0x664 },
	'usedialwithouthold' => { 294 => 0xbf },
	'useguidelines' => { 474 => 'useGuidelines' },
	'usepanoramaviewer' => { 464 => 'UsePanoramaViewer' },
	'usercollection' => { 373 => 'collection.user' },
	'usercomment' => { 96 => 0x805, 118 => 0x9286, 482 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 69 => 0xd8, 70 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 69 => 0xda, 70 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 69 => 0xdc, 70 => 0xf4 },
	'userfields' => { 469 => 'UserFields' },
	'userlabel' => { 380 => 0x2b, 381 => 0x5a, 382 => 0x68 },
	'userprofile' => { 314 => 0x302, 318 => 0x34c, 321 => 0x3038 },
	'userrating' => { 373 => 'rating.user', 379 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 82 => 0x7, 83 => 0x501 },
	'uspsnumber' => { 492 => 'uspsNumber' },
	'utmeasting' => { 167 => 'Easting' },
	'utmmapdatum' => { 167 => 'Datum' },
	'utmnorthing' => { 167 => 'Northing' },
	'utmzone' => { 167 => 'Zone' },
	'uuid' => { 476 => 'UUID', 478 => 'UUID' },
	'uv-irfiltercorrection' => { 314 => 0x325 },
	'validbits' => { 300 => 0x611, 301 => 0x102c },
	'validpixeldepth' => { 304 => 0x611 },
	'variablelowpassfilter' => { 419 => 0x2028 },
	'variousmodes' => { 139 => 0x26 },
	'variousmodes2' => { 139 => 0x3a },
	'variprogram' => { 225 => 0xab },
	'varraydacnominalvalues' => { 137 => 0x191e },
	'vendor' => { 379 => 'vndr' },
	'vendorinfo' => { 456 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 456 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 456 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 456 => [\'VendorInfo','VendorInfoNotes'] },
	'version' => { 126 => 0x0, 370 => 'Version', 373 => 'version', 476 => 'Version', 478 => 'Version' },
	'versioncreatedate' => { 453 => 0xd100 },
	'versionid' => { 503 => 'VersionID' },
	'versionidentifier' => { 492 => 'versionIdentifier' },
	'versionmodifydate' => { 453 => 0xd101 },
	'versions' => { 503 => 'Versions' },
	'versionscomments' => { 503 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 503 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 503 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 503 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 503 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 503 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 503 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 503 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 503 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 503 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 503 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 278 => '3.2', 279 => '47.2', 281 => '79.1', 294 => 0x11d },
	'verticalclockoverlaps' => { 137 => 0x412 },
	'verticalfuncbutton' => { 279 => '42.2', 281 => '67.1', 294 => 0x115 },
	'verticalfuncbuttonplaybackmode' => { 294 => 0x1b7 },
	'verticalfuncbuttonplusdials' => { 279 => '43.1' },
	'verticalfuncplusdials' => { 281 => '68.1' },
	'verticalmovieafonbutton' => { 294 => 0x1f9 },
	'verticalmoviefuncbutton' => { 294 => 0x1e1 },
	'verticalmultiselector' => { 279 => '42.1', 281 => '66.1', 282 => '66.1', 292 => '66.1', 294 => 0x18f },
	'verticalmultiselectorplaybackmode' => { 294 => 0x125 },
	'vfdisplayillumination' => { 2 => 0x11, 83 => [0x510,0x51d] },
	'vibrance' => { 470 => 'Vibrance', 476 => 'Vibrance', 478 => 'Vibrance' },
	'vibrationreduction' => { 237 => [0x75,0x82,0x1ae], 245 => '586.1', 254 => '590.2', 262 => 0x4 },
	'videoalphamode' => { 502 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 502 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 502 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 502 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 502 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 502 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 502 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 502 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 502 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 502 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 502 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 502 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 502 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 502 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 502 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 502 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 502 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 502 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 488 => 'videoBitRate' },
	'videobitratemode' => { 488 => 'videoBitRateMode' },
	'videoburstmode' => { 319 => 0xbb },
	'videoburstresolution' => { 319 => 0xb3 },
	'videocodec' => { 66 => 0x74 },
	'videocolorspace' => { 502 => 'videoColorSpace' },
	'videocompression' => { 126 => 0x3806 },
	'videocompressor' => { 502 => 'videoCompressor' },
	'videodisplayaspectratio' => { 488 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 488 => 'videoEncodingProfile' },
	'videofieldorder' => { 502 => 'videoFieldOrder' },
	'videoframerate' => { 319 => 0x27, 502 => 'videoFrameRate' },
	'videoframesize' => { 502 => 'videoFrameSize' },
	'videoframesizeh' => { 502 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 502 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 502 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 502 => 'videoModDate' },
	'videopixelaspectratio' => { 502 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 502 => 'videoPixelDepth' },
	'videopreburst' => { 319 => 0xc1 },
	'videoquality' => { 112 => 0x4003 },
	'videorecordingmode' => { 126 => 0x3803 },
	'videoshottype' => { 488 => 'VideoShotType' },
	'videoshottypeidentifier' => { 488 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 488 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 488 => 'videoStreamsCount' },
	'viewfinder' => { 363 => 0x455 },
	'viewfinderdisplay' => { 278 => '12.4', 279 => '6.3' },
	'viewfinderwarning' => { 278 => '13.4', 288 => '3.5', 289 => '6.2', 293 => '4.4' },
	'viewfinderwarnings' => { 83 => 0x40a },
	'viewinfoduringexposure' => { 83 => 0x407 },
	'viewingmode' => { 408 => 0x2f, 424 => 0x18 },
	'viewingmode2' => { 408 => [0x85,0x285] },
	'viewpoint' => { 491 => 'viewpoint' },
	'vignetteamount' => { 476 => 'VignetteAmount', 478 => 'VignetteAmount' },
	'vignettecontrol' => { 225 => 0x2a, 271 => 0x76a43205 },
	'vignettecontrolintensity' => { 271 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 473 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 476 => 'VignetteMidpoint', 478 => 'VignetteMidpoint' },
	'vignetting' => { 386 => 0x1011, 393 => 0xa052 },
	'vignettingcorrection' => { 118 => 0x7031, 393 => 0xa053, 419 => 0x2011 },
	'vignettingcorrparams' => { 118 => 0x7032, 448 => 0x64a, 449 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 393 => 0xa054 },
	'virtualhorizonstyle' => { 294 => 0x167 },
	'visualcolor' => { 488 => 'VisualColour' },
	'visualtechnique' => { 491 => 'visualTechnique' },
	'voicememo' => { 395 => 0x216 },
	'volume' => { 492 => 'volume' },
	'vr_0x66' => { 237 => 0x66 },
	'vrdoffset' => { 63 => 0xd0 },
	'vrmode' => { 228 => 0x212, 262 => 0x6 },
	'waterdepth' => { 118 => 0x9403, 483 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 186 => 0x19a },
	'wb_bluelevel6500k' => { 186 => 0x18a },
	'wb_bluelevelcustom' => { 186 => 0x18e },
	'wb_bluelevelscloudy' => { 186 => 0x106 },
	'wb_bluelevelsdaylight' => { 186 => 0xea },
	'wb_bluelevelsflash' => { 186 => 0x122 },
	'wb_bluelevelsfluorescent' => { 186 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 186 => 0x254 },
	'wb_bluelevelsshade' => { 186 => 0x176 },
	'wb_bluelevelstungsten' => { 186 => 0xce },
	'wb_gbrglevels' => { 186 => 0xae, 189 => 0x4 },
	'wb_glevel' => { 300 => 0x11f },
	'wb_glevel3000k' => { 300 => 0x113 },
	'wb_glevel3300k' => { 300 => 0x114 },
	'wb_glevel3600k' => { 300 => 0x115 },
	'wb_glevel3900k' => { 300 => 0x116 },
	'wb_glevel4000k' => { 300 => 0x117 },
	'wb_glevel4300k' => { 300 => 0x118 },
	'wb_glevel4500k' => { 300 => 0x119 },
	'wb_glevel4800k' => { 300 => 0x11a },
	'wb_glevel5300k' => { 300 => 0x11b },
	'wb_glevel6000k' => { 300 => 0x11c },
	'wb_glevel6600k' => { 300 => 0x11d },
	'wb_glevel7500k' => { 300 => 0x11e },
	'wb_grbglevels' => { 200 => 0x0 },
	'wb_grgblevelsauto' => { 80 => 0x2 },
	'wb_grgblevelscloudy' => { 80 => 0x12 },
	'wb_grgblevelscustom1' => { 80 => 0x42 },
	'wb_grgblevelscustom2' => { 80 => 0x4a },
	'wb_grgblevelsdaylight' => { 80 => 0xa },
	'wb_grgblevelsflash' => { 80 => 0x32 },
	'wb_grgblevelsfluorescent' => { 80 => 0x22 },
	'wb_grgblevelsfluorhigh' => { 80 => 0x2a },
	'wb_grgblevelstungsten' => { 80 => 0x1a },
	'wb_grgblevelsunderwater' => { 80 => 0x3a },
	'wb_rbgglevels' => { 197 => 0x0 },
	'wb_rblevels' => { 201 => 0x270, 225 => 0xc, 300 => 0x100 },
	'wb_rblevels1' => { 325 => 0x2 },
	'wb_rblevels2' => { 325 => 0x5 },
	'wb_rblevels3' => { 325 => 0x8 },
	'wb_rblevels3000k' => { 300 => 0x102 },
	'wb_rblevels3300k' => { 300 => 0x103 },
	'wb_rblevels3500k' => { 186 => 0x430 },
	'wb_rblevels3600k' => { 300 => 0x104 },
	'wb_rblevels3900k' => { 300 => 0x105 },
	'wb_rblevels4' => { 325 => 0xb },
	'wb_rblevels4000k' => { 300 => 0x106 },
	'wb_rblevels4300k' => { 300 => 0x107 },
	'wb_rblevels4500k' => { 300 => 0x108 },
	'wb_rblevels4800k' => { 300 => 0x109 },
	'wb_rblevels5' => { 325 => 0xe },
	'wb_rblevels5300k' => { 300 => 0x10a },
	'wb_rblevels6' => { 325 => 0x11 },
	'wb_rblevels6000k' => { 300 => 0x10b },
	'wb_rblevels6500k' => { 186 => 0x420 },
	'wb_rblevels6600k' => { 300 => 0x10c },
	'wb_rblevels7' => { 325 => 0x14 },
	'wb_rblevels7500k' => { 300 => 0x10d },
	'wb_rblevelsauto' => { 201 => 0x272, 304 => 0x110 },
	'wb_rblevelscloudy' => { 186 => 0x3f0, 188 => 0x10, 201 => 0x296, 304 => 0x121 },
	'wb_rblevelscoolwhitef' => { 186 => 0x308, 188 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 304 => 0x132 },
	'wb_rblevelscustom' => { 186 => 0x424, 188 => 0x1c },
	'wb_rblevelscwb1' => { 300 => 0x10e },
	'wb_rblevelscwb2' => { 300 => 0x10f },
	'wb_rblevelscwb3' => { 300 => 0x110 },
	'wb_rblevelscwb4' => { 300 => 0x111 },
	'wb_rblevelsdaylight' => { 186 => [0x3ec,0x528], 188 => 0xc, 201 => 0x274 },
	'wb_rblevelsdaylightf' => { 188 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 304 => 0x130 },
	'wb_rblevelsdaywhitef' => { 188 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 304 => 0x131 },
	'wb_rblevelseveningsunlight' => { 304 => 0x124 },
	'wb_rblevelsfineweather' => { 304 => 0x122 },
	'wb_rblevelsflash' => { 186 => [0x3f4,0x304], 188 => 0x18, 201 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 201 => 0x290 },
	'wb_rblevelsincandescent' => { 201 => 0x282 },
	'wb_rblevelsshade' => { 186 => 0x418, 188 => 0x20, 201 => 0x2b2, 304 => 0x120 },
	'wb_rblevelstungsten' => { 186 => 0x3e8, 188 => 0x8, 304 => 0x123 },
	'wb_rblevelsused' => { 304 => 0x100 },
	'wb_rblevelswhitef' => { 188 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 304 => 0x133 },
	'wb_redlevel3500k' => { 186 => 0x198 },
	'wb_redlevel6500k' => { 186 => 0x188 },
	'wb_redlevelcustom' => { 186 => 0x18c },
	'wb_redlevelscloudy' => { 186 => 0xf8 },
	'wb_redlevelsdaylight' => { 186 => 0xdc },
	'wb_redlevelsflash' => { 186 => 0x114 },
	'wb_redlevelsfluorescent' => { 186 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 186 => 0x1be },
	'wb_redlevelsshade' => { 186 => 0x168 },
	'wb_redlevelstungsten' => { 186 => 0xc0 },
	'wb_rgbglevels' => { 199 => 0x0 },
	'wb_rgblevels' => { 186 => [0x546,0x96], 315 => 0xd, 316 => 0x413, 321 => 0x3036, 363 => 0x107, 427 => 0x117c, 428 => 0x1180, 429 => 0x115c, 430 => 0x11d8, 431 => 0x11b4, 432 => 0x106c, 433 => 0x264, 434 => 0x264, 435 => 0x252 },
	'wb_rgblevels1' => { 326 => 0x2 },
	'wb_rgblevels2' => { 326 => 0x6 },
	'wb_rgblevels3' => { 326 => 0xa },
	'wb_rgblevels4' => { 326 => 0xe },
	'wb_rgblevels5' => { 326 => 0x12 },
	'wb_rgblevels6' => { 326 => 0x16 },
	'wb_rgblevels7' => { 326 => 0x1a },
	'wb_rgblevelsauto' => { 397 => 0x0 },
	'wb_rgblevelscustom1' => { 397 => 0x15 },
	'wb_rgblevelscustom2' => { 397 => 0x18 },
	'wb_rgblevelscustom3' => { 397 => 0x1b },
	'wb_rgblevelsdaylight' => { 397 => 0x3 },
	'wb_rgblevelsflash' => { 397 => 0x12 },
	'wb_rgblevelsfluorescent' => { 397 => 0xf },
	'wb_rgblevelsincandescent' => { 397 => 0xc },
	'wb_rgblevelsovercast' => { 397 => 0x9 },
	'wb_rgblevelsshade' => { 397 => 0x6 },
	'wb_rgblevelsunknown0' => { 398 => 0x0 },
	'wb_rgblevelsunknown1' => { 398 => 0x3 },
	'wb_rgblevelsunknown2' => { 398 => 0x6 },
	'wb_rgblevelsunknown3' => { 398 => 0x9 },
	'wb_rgblevelsunknown4' => { 398 => 0xc },
	'wb_rgblevelsunknown5' => { 398 => 0xf },
	'wb_rgblevelsunknown6' => { 398 => 0x12 },
	'wb_rgblevelsunknown7' => { 398 => 0x15 },
	'wb_rgblevelsunknown8' => { 398 => 0x18 },
	'wb_rgblevelsunknown9' => { 398 => 0x1b },
	'wb_rgbmuldaylight' => { 137 => 0x852 },
	'wb_rgbmulflash' => { 137 => 0x855 },
	'wb_rgbmulfluorescent' => { 137 => 0x854 },
	'wb_rgbmultungsten' => { 137 => 0x853 },
	'wb_rggbblacklevels' => { 35 => 0x25 },
	'wb_rggblevels' => { 189 => 0x4, 198 => 0x0, 202 => 0x13e8, 203 => 0x38 },
	'wb_rggblevelsasshot' => { 38 => 0x0, 39 => 0x0, 40 => 0x19, 41 => 0x55, 42 => 0x69, 43 => 0x22, 44 => 0x3f, 47 => 0x3f, 48 => 0x3f, 49 => 0x3f, 50 => 0x47 },
	'wb_rggblevelsauto' => { 35 => 0x1, 38 => 0x5, 39 => 0x8, 40 => 0x1e, 41 => 0x5a, 42 => 0x6e, 43 => 0x18, 44 => 0x44, 47 => 0x44, 48 => 0x44, 49 => 0x44, 50 => 0x4c, 202 => 0x1478, 203 => 0x114, 393 => 0xa022 },
	'wb_rggblevelsblack' => { 393 => 0xa028 },
	'wb_rggblevelscloudy' => { 35 => 0xd, 38 => 0x1e, 39 => 0x30, 40 => 0x2d, 41 => 0xa0, 42 => 0xd7, 43 => 0x31, 44 => 0x58, 47 => 0x71, 48 => 0x8a, 49 => 0x8f, 50 => 0x92, 202 => 0x1408, 203 => 0x60, 354 => 0x20f, 362 => 0x14 },
	'wb_rggblevelscustom' => { 35 => 0x1d, 44 => 0x80, 202 => 0x1468, 203 => 0x100 },
	'wb_rggblevelscustom1' => { 40 => 0x41 },
	'wb_rggblevelscustom2' => { 40 => 0x46 },
	'wb_rggblevelsdaylight' => { 35 => 0x5, 38 => 0x14, 39 => 0x20, 40 => 0x23, 41 => 0x96, 42 => 0xcd, 43 => 0x27, 44 => 0x4e, 47 => 0x67, 48 => 0x80, 49 => 0x85, 50 => 0x88, 202 => 0x13f8, 203 => 0x4c, 354 => 0x20d, 362 => 0x2 },
	'wb_rggblevelsflash' => { 35 => 0x19, 38 => 0x32, 39 => 0x50, 40 => 0x3c, 41 => 0xb4, 42 => 0xeb, 43 => 0x45, 44 => 0x6c, 47 => 0x85, 48 => 0x9e, 49 => 0xa3, 50 => 0xa6, 202 => 0x1448, 354 => 0x214, 362 => 0x41 },
	'wb_rggblevelsfluorescent' => { 35 => 0x15, 38 => 0x28, 39 => 0x40, 40 => 0x37, 41 => 0xaa, 42 => 0xe1, 43 => 0x3b, 44 => 0x62, 47 => 0x7b, 48 => 0x94, 49 => 0x99, 50 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 203 => 0xc4, 354 => 0x211, 362 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 362 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 203 => 0xb0, 354 => 0x212, 362 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 202 => 0x1438, 203 => 0x9c, 354 => 0x213, 362 => 0x38 },
	'wb_rggblevelshtmercury' => { 203 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 393 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 393 => 0xa024 },
	'wb_rggblevelskelvin' => { 35 => 0x21, 38 => 0x2d, 39 => 0x48, 41 => 0xaf, 42 => 0xe6, 43 => 0x40, 44 => 0x67, 47 => 0x80, 48 => 0x99, 49 => 0x9e, 50 => 0xa1 },
	'wb_rggblevelsmeasured' => { 38 => 0xa, 39 => 0x10, 41 => 0x5f, 42 => 0x73, 44 => 0x49, 47 => 0x49, 48 => 0x49, 49 => 0x49, 50 => 0x51 },
	'wb_rggblevelspc1' => { 43 => 0x90, 44 => 0x71 },
	'wb_rggblevelspc2' => { 43 => 0x95, 44 => 0x76 },
	'wb_rggblevelspc3' => { 43 => 0x9a, 44 => 0x7b },
	'wb_rggblevelsshade' => { 35 => 0x9, 38 => 0x19, 39 => 0x28, 40 => 0x28, 41 => 0x9b, 42 => 0xd2, 43 => 0x2c, 44 => 0x53, 47 => 0x6c, 48 => 0x85, 49 => 0x8a, 50 => 0x8d, 203 => 0x74, 354 => 0x20e, 362 => 0xb },
	'wb_rggblevelstungsten' => { 35 => 0x11, 38 => 0x23, 39 => 0x38, 40 => 0x32, 41 => 0xa5, 42 => 0xdc, 43 => 0x36, 44 => 0x5d, 47 => 0x76, 48 => 0x8f, 49 => 0x94, 50 => 0x97, 202 => 0x1428, 203 => 0x88, 354 => 0x210, 362 => 0x1d },
	'wb_rggblevelsuncorrected' => { 393 => 0xa021 },
	'wb_rggblevelsunknown' => { 38 => 0xf, 39 => 0x18, 41 => 0x64, 42 => 0x78, 43 => 0x1d, 47 => 0x4e, 48 => 0x4e, 49 => 0x4e, 50 => 0x56, 362 => 0x53 },
	'wb_rggblevelsunknown10' => { 38 => 0x5f, 39 => 0x98, 41 => 0x91, 42 => 0xa5, 43 => 0x72, 47 => 0x9e, 48 => 0x7b, 49 => 0x7b, 50 => 0x83 },
	'wb_rggblevelsunknown11' => { 38 => 0x64, 39 => 0xa0, 41 => 0xb9, 42 => [0xaa,0xaf], 43 => 0x77, 47 => 0xa3, 48 => 0xa3, 49 => 0x80, 50 => 0xab },
	'wb_rggblevelsunknown12' => { 38 => 0x69, 39 => 0xa8, 41 => 0xbe, 42 => 0xb4, 43 => 0x7c, 47 => 0xa8, 48 => 0xa8, 49 => 0xa8, 50 => 0xb0 },
	'wb_rggblevelsunknown13' => { 38 => 0x6e, 39 => 0xb0, 41 => 0xc3, 42 => 0xb9, 43 => 0x81, 47 => 0xad, 48 => 0xad, 49 => 0xad, 50 => 0xb5 },
	'wb_rggblevelsunknown14' => { 41 => 0xc8, 42 => 0xbe, 43 => 0x86, 47 => 0xb2, 48 => 0xb2, 49 => 0xb2, 50 => 0xba },
	'wb_rggblevelsunknown15' => { 41 => 0xcd, 42 => 0xc3, 43 => 0x8b, 47 => 0xb7, 48 => 0xb7, 49 => 0xb7, 50 => 0xbf },
	'wb_rggblevelsunknown16' => { 41 => 0xd2, 42 => 0xc8, 43 => 0x9f, 48 => 0xbc, 49 => 0xbc, 50 => 0xc4 },
	'wb_rggblevelsunknown17' => { 41 => 0xd7, 42 => 0xf0, 48 => 0xc1, 49 => 0xc1, 50 => 0xc9 },
	'wb_rggblevelsunknown18' => { 41 => 0xdc, 42 => 0xf5, 48 => 0xc6, 49 => 0xc6, 50 => 0xce },
	'wb_rggblevelsunknown19' => { 41 => 0xe1, 42 => 0xfa, 48 => 0xcb, 49 => 0xcb, 50 => 0xd3 },
	'wb_rggblevelsunknown2' => { 38 => 0x37, 39 => 0x58, 41 => 0x69, 42 => 0x7d, 43 => 0x4a, 47 => 0x53, 48 => 0x53, 49 => 0x53, 50 => 0x5b },
	'wb_rggblevelsunknown20' => { 41 => 0xe6, 42 => 0xff, 48 => 0xd0, 49 => 0xd0, 50 => 0xd8 },
	'wb_rggblevelsunknown21' => { 41 => 0xeb, 42 => 0x104, 49 => 0xd5, 50 => 0xdd },
	'wb_rggblevelsunknown22' => { 41 => 0xf0, 42 => 0x109, 49 => 0xda, 50 => 0xe2 },
	'wb_rggblevelsunknown23' => { 41 => 0xf5, 42 => 0x10e, 49 => 0xdf, 50 => 0xe7 },
	'wb_rggblevelsunknown24' => { 41 => 0xfa, 42 => 0x113, 49 => 0xe4, 50 => 0xec },
	'wb_rggblevelsunknown25' => { 41 => 0xff, 42 => 0x118, 49 => 0xe9, 50 => 0xf1 },
	'wb_rggblevelsunknown26' => { 41 => 0x104, 42 => 0x11d, 49 => 0xee, 50 => 0xf6 },
	'wb_rggblevelsunknown27' => { 41 => 0x109, 42 => 0x122, 49 => 0xf3, 50 => 0xfb },
	'wb_rggblevelsunknown28' => { 41 => 0x10e, 49 => 0xf8, 50 => 0x100 },
	'wb_rggblevelsunknown29' => { 41 => 0x113, 49 => 0xfd, 50 => 0x105 },
	'wb_rggblevelsunknown3' => { 38 => 0x3c, 39 => 0x60, 41 => 0x6e, 42 => 0x82, 43 => 0x4f, 47 => 0x58, 48 => 0x58, 49 => 0x58, 50 => 0x60 },
	'wb_rggblevelsunknown30' => { 49 => 0x102 },
	'wb_rggblevelsunknown4' => { 38 => 0x41, 39 => 0x68, 41 => 0x73, 42 => 0x87, 43 => 0x54, 47 => 0x5d, 48 => 0x5d, 49 => 0x5d, 50 => 0x65 },
	'wb_rggblevelsunknown5' => { 38 => 0x46, 39 => 0x70, 41 => 0x78, 42 => 0x8c, 43 => 0x59, 47 => 0x62, 48 => 0x62, 49 => 0x62, 50 => 0x6a },
	'wb_rggblevelsunknown6' => { 38 => 0x4b, 39 => 0x78, 41 => 0x7d, 42 => 0x91, 43 => 0x5e, 47 => 0x8a, 48 => 0x67, 49 => 0x67, 50 => 0x6f },
	'wb_rggblevelsunknown7' => { 38 => 0x50, 39 => 0x80, 41 => 0x82, 42 => 0x96, 43 => 0x63, 47 => 0x8f, 48 => 0x6c, 49 => 0x6c, 50 => 0x74 },
	'wb_rggblevelsunknown8' => { 38 => 0x55, 39 => 0x88, 41 => 0x87, 42 => 0x9b, 43 => 0x68, 47 => 0x94, 48 => 0x71, 49 => 0x71, 50 => 0x79 },
	'wb_rggblevelsunknown9' => { 38 => 0x5a, 39 => 0x90, 41 => 0x8c, 42 => 0xa0, 43 => 0x6d, 47 => 0x99, 48 => 0x76, 49 => 0x76, 50 => 0x7e },
	'wb_rggblevelsuserselected' => { 362 => 0x5c },
	'wbadjblueamber' => { 102 => 0x20106 },
	'wbadjbluebalance' => { 277 => 0x8 },
	'wbadjcolortemp' => { 102 => 0x20102, 107 => 0x1a },
	'wbadjlighting' => { 277 => 0x14 },
	'wbadjmagentagreen' => { 102 => 0x20105 },
	'wbadjmode' => { 277 => 0x10 },
	'wbadjredbalance' => { 277 => 0x0 },
	'wbadjrggblevels' => { 102 => 0x20125, 107 => 0x6 },
	'wbadjtemperature' => { 277 => 0x18 },
	'wbadjtint' => { 277 => 0x25 },
	'wbbluelevel' => { 314 => 0x324, 319 => 0x8006, 324 => 0x26 },
	'wbbracketingsteps' => { 246 => 0x174d, 247 => 0x87c, 256 => 0x1757 },
	'wbbracketmode' => { 57 => 0x9 },
	'wbbracketshotnumber' => { 186 => 0x2b, 386 => 0x101a },
	'wbbracketvalueab' => { 57 => 0xc },
	'wbbracketvaluegm' => { 57 => 0xd },
	'wbfinetuneactive' => { 107 => 0x24 },
	'wbfinetunesaturation' => { 107 => 0x28 },
	'wbfinetunetone' => { 107 => 0x2c },
	'wbgreenlevel' => { 314 => 0x323, 319 => 0x8005, 324 => 0x25 },
	'wbmediaimagesizesetting' => { 83 => 0x708 },
	'wbmode' => { 188 => 0x4, 301 => 0x1015 },
	'wbredlevel' => { 314 => 0x322, 319 => 0x8004, 324 => 0x24 },
	'wbscale' => { 189 => 0x0 },
	'wbshiftab' => { 73 => 0xc, 319 => 0x46, 336 => 0x10 },
	'wbshiftab_gm' => { 419 => 0x2014 },
	'wbshiftab_gm_precise' => { 419 => 0x2026 },
	'wbshiftcreativecontrol' => { 319 => 0x92 },
	'wbshiftgm' => { 73 => 0xd, 319 => 0x47, 336 => 0x11 },
	'wbshiftintelligentauto' => { 319 => 0x8b },
	'wbtype1' => { 325 => 0x1, 326 => 0x1 },
	'wbtype2' => { 325 => 0x4, 326 => 0x5 },
	'wbtype3' => { 325 => 0x7, 326 => 0x9 },
	'wbtype4' => { 325 => 0xa, 326 => 0xd },
	'wbtype5' => { 325 => 0xd, 326 => 0x11 },
	'wbtype6' => { 325 => 0x10, 326 => 0x15 },
	'wbtype7' => { 325 => 0x13, 326 => 0x19 },
	'webstatement' => { 506 => 'WebStatement' },
	'weightedflatsubject' => { 468 => 'weightedFlatSubject' },
	'what' => { 476 => 'What', 478 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 73 => 0x8, 76 => 0x7, 111 => 0x7, 112 => [0x19,0x2012], 118 => [0xa403,0xfe4e], 126 => 0x1002, 137 => 0x3fc, 138 => 0xfa0d, 139 => 0x40, 150 => 0x1a, 180 => 0x3, 181 => 0xe, 182 => 0x4, 183 => 0xb, 185 => 0x115, 225 => 0x5, 261 => 0x7, 314 => 0x304, 319 => 0x3, 321 => 0x3033, 354 => 0x19, 361 => 0x7, 385 => 0x26, 386 => 0x1003, 396 => [0x88,0x3c,0x7,0x58], 406 => 0xf, 407 => 0xe, 419 => [0x115,0xb054], 476 => 'WhiteBalance', 478 => 'WhiteBalance', 482 => 'WhiteBalance' },
	'whitebalance0' => { 175 => 'WhiteBalance0' },
	'whitebalance1' => { 175 => 'WhiteBalance1' },
	'whitebalance2' => { 175 => 'WhiteBalance2', 296 => 0x500 },
	'whitebalanceadj' => { 102 => 0x20101, 107 => 0x18, 271 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 332 => 0x0 },
	'whitebalancebias' => { 112 => 0x2011, 301 => 0x304, 319 => 0x23 },
	'whitebalanceblue' => { 73 => 0x7 },
	'whitebalancebracket' => { 296 => 0x502, 301 => 0x303 },
	'whitebalancebracketing' => { 183 => 0x22, 186 => 0x2c, 417 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 294 => 0x1c5 },
	'whitebalancecomp' => { 304 => 0x1001 },
	'whitebalancedetected' => { 137 => 0x3fb },
	'whitebalancefinetune' => { 126 => 0x100a, 183 => 0x38, 185 => 0x112, 225 => 0xb, 386 => 0x1004, 406 => 0x6, 407 => 0x5, 419 => 0x112 },
	'whitebalancemode' => { 137 => 0x3fa, 354 => 0x1a },
	'whitebalancered' => { 73 => 0x6 },
	'whitebalanceset' => { 335 => 0xa },
	'whitebalancesetting' => { 183 => 0x23, 406 => 0x5, 407 => 0x4, 408 => 0x16, 424 => 0xd },
	'whitebalancesetup' => { 393 => 0x41 },
	'whitebalancetemperature' => { 296 => 0x501 },
	'whiteboard' => { 301 => 0x301 },
	'whitelevel' => { 118 => 0xc61d, 354 => 0x7e },
	'whitepoint' => { 118 => 0x13e, 318 => 0x35d, 354 => 0x201, 498 => 'WhitePoint' },
	'whites2012' => { 476 => 'Whites2012', 478 => 'Whites2012' },
	'whitesadj' => { 453 => 0x9017 },
	'wideadapter' => { 386 => 0x1017 },
	'widefocuszone' => { 180 => 0x2f },
	'widerange' => { 395 => 0x20f },
	'windmode' => { 137 => 0x3f4 },
	'windnoisereduction' => { 228 => 0x2d6 },
	'windowlocation' => { 379 => 'WLOC' },
	'windowsatom' => { 477 => 'windowsAtom' },
	'windowsatomextension' => { 477 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 477 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 477 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 492 => 'wordCount' },
	'work' => { 371 => "\xa9wrk" },
	'workcolorspace' => { 102 => 0x10200, 107 => 0x270 },
	'workflowtag' => { 488 => 'WorkflowTag' },
	'workflowtagcvid' => { 488 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 488 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 488 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 488 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 484 => 'WorkToDo' },
	'worldtimelocation' => { 319 => 0x3a, 354 => 0x22, 360 => '0.1' },
	'writer' => { 178 => 'WM/Writer' },
	'writer-editor' => { 130 => 0x7a },
	'x3filllight' => { 396 => 0x12 },
	'xattrquarantine' => { 173 => 'com.apple.quarantine' },
	'xilinxversion' => { 137 => 0x414 },
	'xml' => { 135 => 'xml ' },
	'xmp' => { 105 => 0xffff00f6, 119 => 'XMP' },
	'xmptoolkit' => { 499 => 'xmptk' },
	'xpauthor' => { 118 => 0x9c9d },
	'xpcomment' => { 118 => 0x9c9c },
	'xpkeywords' => { 118 => 0x9c9e },
	'xposition' => { 118 => 0x11e },
	'xpsubject' => { 118 => 0x9c9f },
	'xptitle' => { 118 => 0x9c9b },
	'xresolution' => { 118 => 0x11a, 133 => 0x3, 369 => 0x0, 498 => 'XResolution' },
	'xyresolution' => { 122 => 0x3 },
	'yaw' => { 114 => 0x7, 379 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 246 => 0x3513, 247 => 0x2c2c, 251 => 0xc222, 256 => 0x36fc, 257 => 0x2f03, 259 => 0xce3a, 260 => 0xeaf3, 391 => 0x0 },
	'ycbcrcoefficients' => { 118 => 0x211, 498 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 118 => 0x213, 498 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 118 => 0x212, 498 => 'YCbCrSubSampling' },
	'year' => { 371 => 'yrrc', 373 => 'year', 379 => 'yrrc' },
	'yearcreated' => { 139 => 0x10, 148 => 0xc },
	'yellowhsl' => { 102 => 0x20912 },
	'yield' => { 494 => 'yield' },
	'yposition' => { 118 => 0x11f },
	'yresolution' => { 118 => 0x11b, 133 => 0x5, 369 => 0x4, 498 => 'YResolution' },
	'zebrapatterntonerange' => { 294 => 0x211 },
	'zoneidentifier' => { 119 => 'ZoneIdentifier' },
	'zonematching' => { 185 => 0x10a, 188 => [0x3a,0x4a], 419 => 0xb024 },
	'zonematchingmode' => { 183 => 0x14 },
	'zonematchingon' => { 182 => 0x75 },
	'zonematchingvalue' => { 406 => 0x1f },
	'zoomedpreviewlength' => { 301 => 0xf05 },
	'zoomedpreviewsize' => { 301 => 0xf06 },
	'zoomedpreviewstart' => { 301 => 0xf04 },
	'zoomsourcewidth' => { 34 => 0x24 },
	'zoomstepcount' => { 299 => 0x300, 301 => 0x100d },
	'zoomtargetwidth' => { 34 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airspeed' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'angleaxis' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'auxiliaryimagetype' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd850' => 1,
	'customsettingsd90' => 1,
	'customsettingsz9' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji_dtat' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroypr' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indications' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'masksubarea' => 1,
	'mastergainadjustment' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumshutterangle' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menusettingsz7ii' => 1,
	'menusettingsz9' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metdata' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'moviefunc2button' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parameters' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	's2n' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceifd' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorreadouttime' => 1,
	'sensorrightborder' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailref' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailtiff' => 1,
	'thumbnailurl' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelstungsten' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2022, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
