/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.geom;

import net.sourceforge.plantuml.klimt.geom.Positionable;
import net.sourceforge.plantuml.klimt.geom.PositionableImpl;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;

public class PositionableUtils {
    private static XRectangle2D convert(Positionable positionable) {
        XPoint2D position = positionable.getPosition();
        XDimension2D size = positionable.getSize();
        return new XRectangle2D(position.getX(), position.getY(), size.getWidth(), size.getHeight());
    }

    public static boolean intersect(Positionable big, Positionable small) {
        XRectangle2D bigR = PositionableUtils.convert(big);
        XRectangle2D smallR = PositionableUtils.convert(small);
        return bigR.intersects(smallR);
    }

    public static Positionable addMargin(final Positionable pos, final double widthMargin, final double heightMargin) {
        return new Positionable(){

            @Override
            public XPoint2D getPosition() {
                XPoint2D p = pos.getPosition();
                return new XPoint2D(p.getX() - widthMargin, p.getY() - heightMargin);
            }

            @Override
            public XDimension2D getSize() {
                return pos.getSize().delta(2.0 * widthMargin, 2.0 * heightMargin);
            }

            @Override
            public void moveDelta(double deltaX, double deltaY) {
                pos.moveDelta(deltaX, deltaY);
            }
        };
    }

    private static XPoint2D getCenter(Positionable p) {
        XPoint2D pt = p.getPosition();
        XDimension2D dim = p.getSize();
        return new XPoint2D(pt.getX() + dim.getWidth() / 2.0, pt.getY() + dim.getHeight() / 2.0);
    }

    private static Positionable move(Positionable p, double deltaX, double deltaY) {
        XPoint2D pt = p.getPosition();
        XDimension2D dim = p.getSize();
        return new PositionableImpl(pt.getX() + deltaX, pt.getY() + deltaY, dim);
    }

    public static Positionable moveAwayFrom(Positionable fixe, Positionable toMove) {
        double min;
        double deltaY;
        XPoint2D centerFixe = PositionableUtils.getCenter(fixe);
        XPoint2D centerToMove = PositionableUtils.getCenter(toMove);
        double deltaX = centerToMove.getX() - centerFixe.getX();
        if (!PositionableUtils.doesIntersectWithThisCoef(fixe, toMove, deltaX, deltaY = centerToMove.getY() - centerFixe.getY(), min = 0.0)) {
            throw new IllegalArgumentException();
        }
        double max = 0.1;
        while (PositionableUtils.doesIntersectWithThisCoef(fixe, toMove, deltaX, deltaY, max)) {
            max *= 2.0;
        }
        for (int i = 0; i < 5; ++i) {
            assert (PositionableUtils.doesIntersectWithThisCoef(fixe, toMove, deltaX, deltaY, min));
            assert (!PositionableUtils.doesIntersectWithThisCoef(fixe, toMove, deltaX, deltaY, max));
            double candidat = (min + max) / 2.0;
            if (PositionableUtils.doesIntersectWithThisCoef(fixe, toMove, deltaX, deltaY, candidat)) {
                min = candidat;
                continue;
            }
            max = candidat;
        }
        double candidat = (min + max) / 2.0;
        return PositionableUtils.move(toMove, deltaX * candidat, deltaY * candidat);
    }

    private static boolean doesIntersectWithThisCoef(Positionable fixe, Positionable toMove, double deltaX, double deltaY, double c) {
        Positionable result = PositionableUtils.move(toMove, deltaX * c, deltaY * c);
        return PositionableUtils.intersect(fixe, result);
    }
}

