/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FloatingNote;
import net.sourceforge.plantuml.ebnf.ETile;
import net.sourceforge.plantuml.ebnf.Symbol;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.preproc.ConfigurationStore;
import net.sourceforge.plantuml.preproc.OptionKey;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.utils.I18n;

public class ETileBox
extends ETile {
    private final String value;
    private final FontConfiguration fc;
    private final Style style;
    private final UText utext;
    private final HColorSet colorSet;
    private final Symbol symbol;
    private final ISkinParam skinParam;
    private final ConfigurationStore<OptionKey> option;
    private String commentAbove;
    private String commentBelow;
    private static final Map<String, String> VALUE_MAP = new HashMap<String, String>();

    public ETileBox mergeWith(ETileBox other) {
        return new ETileBox(this.value + other.value, this.symbol, this.fc, this.style, this.colorSet, this.skinParam, this.option);
    }

    public ETileBox(String value, Symbol symbol, FontConfiguration fc, Style style, HColorSet colorSet, ISkinParam skinParam, ConfigurationStore<OptionKey> option) {
        this.symbol = symbol;
        this.skinParam = skinParam;
        this.option = option;
        this.value = this.getDrawValue(value);
        this.fc = fc;
        this.utext = UText.build(this.value, fc);
        this.style = style;
        this.colorSet = colorSet;
    }

    private double getPureH1(StringBounder stringBounder) {
        double height = this.getTextDim(stringBounder).getHeight() + 10.0;
        return height / 2.0;
    }

    @Override
    public double getH1(StringBounder stringBounder) {
        double h1 = this.getPureH1(stringBounder);
        TextBlock note = this.getNoteAbove(stringBounder);
        if (note != TextBlockUtils.EMPTY_TEXT_BLOCK) {
            h1 += note.calculateDimension(stringBounder).getHeight() + 20.0;
        }
        return h1;
    }

    @Override
    public double getH2(StringBounder stringBounder) {
        double h2 = this.getPureH1(stringBounder);
        TextBlock note = this.getNoteBelow(stringBounder);
        if (note != TextBlockUtils.EMPTY_TEXT_BLOCK) {
            h2 += note.calculateDimension(stringBounder).getHeight() + 20.0;
        }
        return h2;
    }

    @Override
    public double getWidth(StringBounder stringBounder) {
        TextBlock noteBelow;
        double width = this.getTextDim(stringBounder).getWidth() + 10.0;
        TextBlock noteAbove = this.getNoteAbove(stringBounder);
        if (noteAbove != TextBlockUtils.EMPTY_TEXT_BLOCK) {
            width = Math.max(width, noteAbove.calculateDimension(stringBounder).getWidth());
        }
        if ((noteBelow = this.getNoteBelow(stringBounder)) != TextBlockUtils.EMPTY_TEXT_BLOCK) {
            width = Math.max(width, noteBelow.calculateDimension(stringBounder).getWidth());
        }
        return width;
    }

    private XDimension2D getTextDim(StringBounder stringBounder) {
        return stringBounder.calculateDimension(this.fc.getFont(), this.value);
    }

    private XDimension2D getBoxDim(StringBounder stringBounder) {
        return this.getTextDim(stringBounder).delta(10.0);
    }

    @Override
    protected void addCommentAbove(String comment) {
        this.commentAbove = comment;
    }

    @Override
    protected void addCommentBelow(String comment) {
        this.commentBelow = comment;
    }

    @Override
    public void drawU(UGraphic ug) {
        URectangle rect;
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dim = this.calculateDimension(stringBounder);
        XDimension2D dimText = this.getTextDim(stringBounder);
        XDimension2D dimBox = this.getBoxDim(stringBounder);
        HColor lineColor = this.style.value(PName.LineColor).asColor(this.colorSet);
        HColor backgroundColor = this.style.value(PName.BackGroundColor).asColor(this.colorSet);
        TextBlock noteAbove = this.getNoteAbove(stringBounder);
        TextBlock noteBelow = this.getNoteBelow(stringBounder);
        double posy = noteAbove == TextBlockUtils.EMPTY_TEXT_BLOCK ? 0.0 : noteAbove.calculateDimension(stringBounder).getHeight() + 20.0;
        double posxBox = (dim.getWidth() - dimBox.getWidth()) / 2.0;
        if (this.symbol == Symbol.TERMINAL_STRING1 || this.symbol == Symbol.TERMINAL_STRING2) {
            rect = URectangle.build(dimBox);
            ug.apply(new UTranslate(posxBox, posy)).apply(lineColor).apply(UStroke.withThickness(0.5)).draw(rect);
        } else if (this.symbol == Symbol.SPECIAL_SEQUENCE) {
            rect = URectangle.build(dimBox);
            ug.apply(new UTranslate(posxBox, posy)).apply(lineColor).apply(new UStroke(5.0, 5.0, 1.0)).draw(rect);
        } else {
            rect = URectangle.build(dimBox).rounded(10.0);
            ug.apply(new UTranslate(posxBox, posy)).apply(lineColor).apply(backgroundColor.bg()).apply(UStroke.withThickness(1.5)).draw(rect);
        }
        ug.apply(new UTranslate(5.0 + posxBox, posy + 5.0 + dimText.getHeight() - this.utext.getDescent(stringBounder))).draw(this.utext);
        if (noteAbove != TextBlockUtils.EMPTY_TEXT_BLOCK) {
            double posxAbove = (dim.getWidth() - noteAbove.calculateDimension(stringBounder).getWidth()) / 2.0;
            noteAbove.drawU(ug.apply(new UTranslate(posxAbove, 0.0)));
        }
        if (noteBelow != TextBlockUtils.EMPTY_TEXT_BLOCK) {
            double posxBelow = (dim.getWidth() - noteBelow.calculateDimension(stringBounder).getWidth()) / 2.0;
            double posyBelow = dim.getHeight() - noteBelow.calculateDimension(stringBounder).getHeight();
            noteBelow.drawU(ug.apply(new UTranslate(posxBelow, posyBelow)));
        }
        if (posxBox > 0.0) {
            this.drawHlineDirected(ug, this.getH1(stringBounder), 0.0, posxBox, 0.5, 25.0);
            this.drawHlineDirected(ug, this.getH1(stringBounder), posxBox + dimBox.getWidth(), dim.getWidth(), 0.5, 25.0);
        }
    }

    private TextBlock getNoteAbove(StringBounder stringBounder) {
        if (this.commentAbove == null) {
            return TextBlockUtils.EMPTY_TEXT_BLOCK;
        }
        FloatingNote note = FloatingNote.createOpale(Display.getWithNewlines(this.skinParam.getPragma(), this.commentAbove), this.skinParam, SName.ebnf);
        XDimension2D dim = note.calculateDimension(stringBounder);
        double pos = dim.getWidth() * 0.5;
        XPoint2D pp1 = new XPoint2D(pos, dim.getHeight());
        XPoint2D pp2 = new XPoint2D(pos, 20.0 + dim.getHeight());
        note.setOpale(Direction.DOWN, pp1, pp2);
        return note;
    }

    private TextBlock getNoteBelow(StringBounder stringBounder) {
        if (this.commentBelow == null) {
            return TextBlockUtils.EMPTY_TEXT_BLOCK;
        }
        FloatingNote note = FloatingNote.createOpale(Display.getWithNewlines(this.skinParam.getPragma(), this.commentBelow), this.skinParam, SName.ebnf);
        XDimension2D dim = note.calculateDimension(stringBounder);
        double pos = dim.getWidth() * 0.5;
        XPoint2D pp1 = new XPoint2D(pos, 0.0);
        XPoint2D pp2 = new XPoint2D(pos, -20.0);
        note.setOpale(Direction.UP, pp1, pp2);
        return note;
    }

    @Override
    public void push(ETile tile) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getRepetitionLabel() {
        return this.value;
    }

    public final Symbol getSymbol() {
        return this.symbol;
    }

    private String getDrawValue(String value) {
        if (!Boolean.parseBoolean(this.option.getValue(OptionKey.USE_DESCRIPTIVE_NAMES)) || !VALUE_MAP.containsKey(value)) {
            return value;
        }
        String language = this.option.getValue(OptionKey.LANGUAGE);
        return I18n.getLocalizedValue(language, "ebnf." + VALUE_MAP.get(value), value);
    }

    static {
        VALUE_MAP.put("\\b", "wordBoundary");
        VALUE_MAP.put("\\B", "nonWordBoundary");
        VALUE_MAP.put("\\d", "digit");
        VALUE_MAP.put("\\D", "nonDigit");
        VALUE_MAP.put("\\w", "word");
        VALUE_MAP.put("\\W", "nonWord");
        VALUE_MAP.put("\\s", "whitespace");
        VALUE_MAP.put("\\S", "nonWhitespace");
        VALUE_MAP.put(".", "anyChar");
    }
}

