/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl.provider;

import java.io.InputStream;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.xml.ParserPool;
import net.shibboleth.shared.xml.impl.BasicParserPool;
import org.apache.xml.security.parser.XMLParser;
import org.apache.xml.security.parser.XMLParserException;
import org.opensaml.core.config.ConfigurationProperties;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ApacheSantuarioXMLParser
implements XMLParser {
    @Nonnull
    @NotEmpty
    public static final String CONFIG_PROPERTY_MAX_POOL_SIZE = "opensaml.config.xmlsec.ApacheSantuarioXMLParser.maxPoolSize";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ApacheSantuarioXMLParser.class);
    @Nonnull
    private final ParserPool parserPool;

    public ApacheSantuarioXMLParser() throws InitializationException {
        XMLObjectProviderRegistry registry = ConfigurationService.get(XMLObjectProviderRegistry.class);
        ParserPool globalPool = null;
        if (registry != null) {
            globalPool = registry.getParserPool();
        }
        if (globalPool != null) {
            this.parserPool = globalPool;
            this.log.trace("Configured parser pool as global ParserPool");
        } else {
            try {
                ConfigurationProperties props = ConfigurationService.getConfigurationProperties();
                int maxPoolSize = Integer.parseUnsignedInt(props.getProperty(CONFIG_PROPERTY_MAX_POOL_SIZE, "50"));
                BasicParserPool basicPool = new BasicParserPool();
                basicPool.setMaxPoolSize(maxPoolSize);
                basicPool.initialize();
                this.parserPool = basicPool;
                this.log.trace("Configured parser pool as internally-constructed BasicParserPool with maxPoolSize: {}", (Object)maxPoolSize);
            }
            catch (ComponentInitializationException e) {
                throw new InitializationException("Error initializing internal BasicParserPool", e);
            }
        }
    }

    public Document parse(InputStream inputStream, boolean disallowDocTypeDeclarations) throws XMLParserException {
        if (!disallowDocTypeDeclarations) {
            throw new XMLParserException("This implementation does not support disallowDocTypeDeclarations=false");
        }
        try {
            return this.parserPool.parse(inputStream);
        }
        catch (Exception e) {
            this.log.warn("Fatal error parsing XML InputStream", (Throwable)e);
            throw new XMLParserException(e, "Fatal error parsing XML InputStream");
        }
    }
}

