/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.configuration;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.ClusterStateTaskConfig;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Priority;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.env.Environment;
import org.opensearch.index.shard.IndexEventListener;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.configuration.ConfigUpdateAlreadyInProgressException;
import org.opensearch.security.configuration.ConfigurationChangeListener;
import org.opensearch.security.configuration.ConfigurationLoaderSecurity7;
import org.opensearch.security.configuration.ConfigurationMap;
import org.opensearch.security.configuration.InvalidConfigException;
import org.opensearch.security.securityconf.DynamicConfigFactory;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.ssl.util.ExceptionUtils;
import org.opensearch.security.state.SecurityConfig;
import org.opensearch.security.state.SecurityMetadata;
import org.opensearch.security.support.ConfigHelper;
import org.opensearch.security.support.SecurityIndexHandler;
import org.opensearch.security.support.SecurityUtils;
import org.opensearch.security.support.SnapshotRestoreHelper;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class ConfigurationRepository
implements ClusterStateListener,
IndexEventListener {
    private static final Logger LOGGER = LogManager.getLogger(ConfigurationRepository.class);
    private final String securityIndex;
    private final Client client;
    private final Cache<CType<?>, SecurityDynamicConfiguration<?>> configCache;
    private final List<ConfigurationChangeListener> configurationChangedListener;
    private final ConfigurationLoaderSecurity7 cl;
    private final Settings settings;
    private final Path configPath;
    private final ClusterService clusterService;
    private final AuditLog auditLog;
    private final ThreadPool threadPool;
    private DynamicConfigFactory dynamicConfigFactory;
    public static final int DEFAULT_CONFIG_VERSION = 2;
    private final CompletableFuture<Void> initalizeConfigTask = new CompletableFuture();
    private final boolean acceptInvalid;
    private final AtomicBoolean auditHotReloadingEnabled = new AtomicBoolean(false);
    private final AtomicBoolean initializationInProcess = new AtomicBoolean(false);
    private final SecurityIndexHandler securityIndexHandler;
    private final Lock LOCK = new ReentrantLock();

    protected ConfigurationRepository(String securityIndex, Settings settings, Path configPath, ThreadPool threadPool, Client client, ClusterService clusterService, AuditLog auditLog, SecurityIndexHandler securityIndexHandler, ConfigurationLoaderSecurity7 configurationLoaderSecurity7) {
        this.securityIndex = securityIndex;
        this.settings = settings;
        this.configPath = configPath;
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.auditLog = auditLog;
        this.configurationChangedListener = new ArrayList<ConfigurationChangeListener>();
        this.acceptInvalid = settings.getAsBoolean("plugins.security.unsupported.accept_invalid_config", Boolean.valueOf(false));
        this.cl = configurationLoaderSecurity7;
        this.configCache = CacheBuilder.newBuilder().build();
        this.securityIndexHandler = securityIndexHandler;
    }

    private Path resolveConfigDir() {
        return Optional.ofNullable(System.getProperty("security.default_init.dir")).map(x$0 -> Path.of(x$0, new String[0])).orElseGet(() -> new Environment(this.settings, this.configPath).configDir().resolve("opensearch-security/"));
    }

    public void clusterChanged(ClusterChangedEvent event) {
        SecurityMetadata securityMetadata = (SecurityMetadata)event.state().custom("security");
        if (this.nodeSelectedAsManager(event) && securityMetadata == null) {
            this.initSecurityIndex(event);
        }
        if (securityMetadata != null) {
            this.executeConfigurationInitialization(securityMetadata);
        }
    }

    private boolean nodeSelectedAsManager(ClusterChangedEvent event) {
        boolean wasClusterManager = event.previousState().nodes().isLocalNodeElectedClusterManager();
        boolean isClusterManager = event.localNodeClusterManager();
        return !wasClusterManager && isClusterManager;
    }

    public String getConfigDirectory() {
        String lookupDir = System.getProperty("security.default_init.dir");
        String cd = lookupDir != null ? lookupDir + File.separator : new Environment(this.settings, this.configPath).configDir().toAbsolutePath().resolve("opensearch-security").toString() + File.separator;
        return cd;
    }

    private void initalizeClusterConfiguration(boolean installDefaultConfig) {
        try {
            block20: {
                LOGGER.info("Background init thread started. Install default config?: " + installDefaultConfig);
                while (this.clusterService.state().blocks().hasGlobalBlockWithStatus(RestStatus.SERVICE_UNAVAILABLE)) {
                    LOGGER.info("Wait for cluster to be available ...");
                    TimeUnit.SECONDS.sleep(1L);
                }
                if (installDefaultConfig) {
                    try {
                        String cd = this.getConfigDirectory();
                        File confFile = new File(cd + "config.yml");
                        if (confFile.exists()) {
                            ThreadContext threadContext = this.threadPool.getThreadContext();
                            try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
                                threadContext.putHeader("_opendistro_security_conf_request", "true");
                                this.createSecurityIndexIfAbsent();
                                this.waitForSecurityIndexToBeAtLeastYellow();
                                int initializationDelaySeconds = this.settings.getAsInt("plugins.security.unsupported.delay_initialization_seconds", Integer.valueOf(0));
                                if (initializationDelaySeconds > 0) {
                                    LOGGER.error("Test setting loaded to delay initialization for {} seconds", (Object)initializationDelaySeconds);
                                    TimeUnit.SECONDS.sleep(initializationDelaySeconds);
                                }
                                ConfigHelper.uploadFile(this.client, cd + "config.yml", this.securityIndex, CType.CONFIG, 2);
                                ConfigHelper.uploadFile(this.client, cd + "roles.yml", this.securityIndex, CType.ROLES, 2);
                                ConfigHelper.uploadFile(this.client, cd + "roles_mapping.yml", this.securityIndex, CType.ROLESMAPPING, 2);
                                ConfigHelper.uploadFile(this.client, cd + "internal_users.yml", this.securityIndex, CType.INTERNALUSERS, 2);
                                ConfigHelper.uploadFile(this.client, cd + "action_groups.yml", this.securityIndex, CType.ACTIONGROUPS, 2);
                                ConfigHelper.uploadFile(this.client, cd + "tenants.yml", this.securityIndex, CType.TENANTS, 2);
                                boolean populateEmptyIfFileMissing = true;
                                ConfigHelper.uploadFile(this.client, cd + "nodes_dn.yml", this.securityIndex, CType.NODESDN, 2, true);
                                ConfigHelper.uploadFile(this.client, cd + "allowlist.yml", this.securityIndex, CType.ALLOWLIST, 2, true);
                                String auditConfigPath = cd + "audit.yml";
                                if (new File(auditConfigPath).exists()) {
                                    ConfigHelper.uploadFile(this.client, auditConfigPath, this.securityIndex, CType.AUDIT, 2);
                                }
                                break block20;
                            }
                        }
                        LOGGER.error("{} does not exist", (Object)confFile.getAbsolutePath());
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot apply default config (this is maybe not an error!)", (Throwable)e);
                    }
                }
            }
            while (!this.dynamicConfigFactory.isInitialized()) {
                try {
                    LOGGER.debug("Try to load config ...");
                    this.reloadConfiguration(CType.values(), true);
                }
                catch (Exception e) {
                    LOGGER.debug("Unable to load configuration due to {}", (Object)String.valueOf(ExceptionUtils.getRootCause(e)));
                    try {
                        TimeUnit.MILLISECONDS.sleep(3000L);
                        continue;
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        LOGGER.debug("Thread was interrupted so we cancel initialization");
                    }
                }
                break;
            }
            this.setupAuditConfigurationIfAny(this.cl.isAuditConfigDocPresentInIndex());
            LOGGER.info("Node '{}' initialized", (Object)this.clusterService.localNode().getName());
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception while initializing node " + String.valueOf(e), (Throwable)e);
        }
    }

    private void setupAuditConfigurationIfAny(boolean auditConfigDocPresent) {
        Set<String> deprecatedAuditKeysInSettings = AuditConfig.getDeprecatedKeys(this.settings);
        if (!deprecatedAuditKeysInSettings.isEmpty()) {
            LOGGER.warn("Following keys {} are deprecated in opensearch settings. They will be removed in plugin v4.0.0.0", deprecatedAuditKeysInSettings);
        }
        if (auditConfigDocPresent) {
            if (!deprecatedAuditKeysInSettings.isEmpty()) {
                LOGGER.warn("Audit configuration settings found in both index and opensearch settings (deprecated)");
            }
            LOGGER.info("Hot-reloading of audit configuration is enabled");
        } else {
            LOGGER.info("Hot-reloading of audit configuration is disabled. Using configuration with defaults from opensearch settings.  Populate the configuration in index using audit.yml or securityadmin to enable it.");
            this.auditLog.setConfig(AuditConfig.from(this.settings));
        }
    }

    private boolean createSecurityIndexIfAbsent() {
        try {
            ImmutableMap indexSettings = ImmutableMap.of((Object)"index.number_of_shards", (Object)1, (Object)"index.auto_expand_replicas", (Object)"0-all");
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(this.securityIndex).settings((Map)indexSettings);
            boolean ok = ((CreateIndexResponse)this.client.admin().indices().create(createIndexRequest).actionGet()).isAcknowledged();
            LOGGER.info("Index {} created?: {}", (Object)this.securityIndex, (Object)ok);
            return ok;
        }
        catch (ResourceAlreadyExistsException resourceAlreadyExistsException) {
            LOGGER.info("Index {} already exists", (Object)this.securityIndex);
            return false;
        }
    }

    private void waitForSecurityIndexToBeAtLeastYellow() {
        LOGGER.info("Node started, try to initialize it. Wait for at least yellow cluster state....");
        ClusterHealthResponse response = null;
        try {
            response = (ClusterHealthResponse)this.client.admin().cluster().health(new ClusterHealthRequest(new String[]{this.securityIndex}).waitForActiveShards(1).waitForYellowStatus()).actionGet();
        }
        catch (Exception e) {
            LOGGER.debug("Caught a {} but we just try again ...", (Object)e.toString());
        }
        while (response == null || response.isTimedOut() || response.getStatus() == ClusterHealthStatus.RED) {
            LOGGER.debug("index '{}' not healthy yet, we try again ... (Reason: {})", (Object)this.securityIndex, (Object)(response == null ? "no response" : (response.isTimedOut() ? "timeout" : "other, maybe red cluster")));
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                response = (ClusterHealthResponse)this.client.admin().cluster().health(new ClusterHealthRequest(new String[]{this.securityIndex}).waitForYellowStatus()).actionGet();
            }
            catch (Exception e) {
                LOGGER.debug("Caught again a {} but we just try again ...", (Object)e.toString());
            }
        }
    }

    void initSecurityIndex(ClusterChangedEvent event) {
        if (!event.state().metadata().hasIndex(this.securityIndex)) {
            this.securityIndexHandler.createIndex((ActionListener<Boolean>)ActionListener.wrap(r -> this.uploadDefaultConfiguration0(), e -> LOGGER.error("Couldn't create index {}", (Object)this.securityIndex, e)));
        } else {
            this.uploadDefaultConfiguration0();
        }
    }

    private void uploadDefaultConfiguration0() {
        this.securityIndexHandler.uploadDefaultConfiguration(this.resolveConfigDir(), (ActionListener<Set<SecurityConfig>>)ActionListener.wrap(configuration -> this.clusterService.submitStateUpdateTask("init-security-configuration", (ClusterStateTaskConfig)new ClusterStateUpdateTask(this, Priority.IMMEDIATE, (Set)configuration){
            final /* synthetic */ Set val$configuration;
            {
                this.val$configuration = set;
                super(arg0);
            }

            public ClusterState execute(ClusterState clusterState) throws Exception {
                return ClusterState.builder((ClusterState)clusterState).putCustom("security", (ClusterState.Custom)new SecurityMetadata(Instant.now(), this.val$configuration)).build();
            }

            public void onFailure(String s, Exception e) {
                LOGGER.error(s, (Throwable)e);
            }
        }), e -> LOGGER.error("Couldn't upload default configuration", (Throwable)e)));
    }

    Future<Void> executeConfigurationInitialization(SecurityMetadata securityMetadata) {
        if (!this.initalizeConfigTask.isDone() && this.initializationInProcess.compareAndSet(false, true)) {
            return this.threadPool.generic().submit(() -> {
                this.securityIndexHandler.loadConfiguration(securityMetadata.configuration(), (ActionListener<ConfigurationMap>)ActionListener.wrap(cTypeConfigs -> {
                    this.notifyConfigurationListeners((ConfigurationMap)cTypeConfigs);
                    boolean auditConfigDocPresent = cTypeConfigs.containsKey(CType.AUDIT) && cTypeConfigs.get(CType.AUDIT).notEmpty();
                    this.setupAuditConfigurationIfAny(auditConfigDocPresent);
                    this.auditHotReloadingEnabled.getAndSet(auditConfigDocPresent);
                    this.initalizeConfigTask.complete(null);
                    LOGGER.info("Security configuration initialized. Applied hashes: {}", securityMetadata.configuration().stream().map(c -> String.format("%s:%s", c.type().toLCString(), c.hash())).collect(Collectors.toList()));
                }, e -> LOGGER.error("Couldn't reload security configuration", (Throwable)e)));
                return null;
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    @Deprecated
    public CompletableFuture<Boolean> initOnNodeStart() {
        boolean installDefaultConfig = this.settings.getAsBoolean("plugins.security.allow_default_init_securityindex", Boolean.valueOf(false));
        Supplier<CompletableFuture> startInitialization = () -> {
            new Thread(() -> {
                this.initalizeClusterConfiguration(installDefaultConfig);
                this.initalizeConfigTask.complete(null);
            }).start();
            return this.initalizeConfigTask.thenApply(result -> installDefaultConfig);
        };
        try {
            if (installDefaultConfig) {
                LOGGER.info("Will attempt to create index {} and default configs if they are absent", (Object)this.securityIndex);
                return startInitialization.get();
            }
            if (this.settings.getAsBoolean("plugins.security.background_init_if_securityindex_not_exist", Boolean.valueOf(true)).booleanValue()) {
                LOGGER.info("Will not attempt to create index {} and default configs if they are absent. Use securityadmin to initialize cluster", (Object)this.securityIndex);
                return startInitialization.get();
            }
            LOGGER.info("Will not attempt to create index {} and default configs if they are absent. Will not perform background initialization", (Object)this.securityIndex);
            this.initalizeConfigTask.complete(null);
            return this.initalizeConfigTask.thenApply(result -> installDefaultConfig);
        }
        catch (Throwable e2) {
            LOGGER.error("Error during node initialization: {}", (Object)e2, (Object)e2);
            return startInitialization.get();
        }
    }

    public boolean isAuditHotReloadingEnabled() {
        if (this.settings.getAsBoolean("plugins.security.allow_default_init_securityindex.use_cluster_state", Boolean.valueOf(false)).booleanValue()) {
            return this.auditHotReloadingEnabled.get();
        }
        return this.cl.isAuditConfigDocPresentInIndex();
    }

    public static ConfigurationRepository create(Settings settings, Path configPath, ThreadPool threadPool, Client client, ClusterService clusterService, AuditLog auditLog) {
        String securityIndex = settings.get("plugins.security.config_index_name", ".opendistro_security");
        return new ConfigurationRepository(securityIndex, settings, configPath, threadPool, client, clusterService, auditLog, new SecurityIndexHandler(securityIndex, settings, client), new ConfigurationLoaderSecurity7(client, threadPool, settings, clusterService));
    }

    public void setDynamicConfigFactory(DynamicConfigFactory dynamicConfigFactory) {
        this.dynamicConfigFactory = dynamicConfigFactory;
    }

    public <T> SecurityDynamicConfiguration<T> getConfiguration(CType<T> configurationType) {
        SecurityDynamicConfiguration conf = (SecurityDynamicConfiguration)this.configCache.getIfPresent(configurationType);
        if (conf != null) {
            SecurityDynamicConfiguration result = conf.deepClone();
            return result;
        }
        return SecurityDynamicConfiguration.empty(configurationType);
    }

    public boolean reloadConfiguration(Collection<CType<?>> configTypes) throws ConfigUpdateAlreadyInProgressException {
        return this.reloadConfiguration(configTypes, false);
    }

    private boolean reloadConfiguration(Collection<CType<?>> configTypes, boolean fromBackgroundThread) throws ConfigUpdateAlreadyInProgressException {
        if (!fromBackgroundThread && !this.initalizeConfigTask.isDone()) {
            LOGGER.warn("Unable to reload configuration, initalization thread has not yet completed.");
            return false;
        }
        return this.loadConfigurationWithLock(configTypes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadConfigurationWithLock(Collection<CType<?>> configTypes) {
        if (!this.LOCK.tryLock(60L, TimeUnit.SECONDS)) throw new ConfigUpdateAlreadyInProgressException("A config update is already in progress", new Object[0]);
        try {
            this.reloadConfiguration0(configTypes, this.acceptInvalid);
            boolean bl = true;
            this.LOCK.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.LOCK.unlock();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ConfigUpdateAlreadyInProgressException("Interrupted config update", new Object[0]);
            }
        }
    }

    private void reloadConfiguration0(Collection<CType<?>> configTypes, boolean acceptInvalid) {
        ConfigurationMap loaded = this.getConfigurationsFromIndex(configTypes, false, acceptInvalid);
        this.notifyConfigurationListeners(loaded);
    }

    private void notifyConfigurationListeners(ConfigurationMap configuration) {
        this.configCache.putAll(configuration.rawMap());
        this.notifyAboutChanges(configuration);
    }

    public synchronized void subscribeOnChange(ConfigurationChangeListener listener) {
        this.configurationChangedListener.add(listener);
    }

    private synchronized void notifyAboutChanges(ConfigurationMap typeToConfig) {
        for (ConfigurationChangeListener listener : this.configurationChangedListener) {
            try {
                LOGGER.debug("Notify {} listener about change configuration with type {}", (Object)listener, (Object)typeToConfig);
                listener.onChange(typeToConfig);
            }
            catch (Exception e) {
                LOGGER.error("{} listener errored: " + String.valueOf(e), (Object)listener, (Object)e);
                throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
            }
        }
    }

    public ConfigurationMap getConfigurationsFromIndex(Collection<CType<?>> configTypes, boolean logComplianceEvent) {
        return this.getConfigurationsFromIndex(configTypes, logComplianceEvent, this.acceptInvalid);
    }

    public ConfigurationMap getConfigurationsFromIndex(Collection<CType<?>> configTypes, boolean logComplianceEvent, boolean acceptInvalid) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        ConfigurationMap.Builder resultBuilder = new ConfigurationMap.Builder();
        try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
            MappingMetadata mappingMetadata;
            threadContext.putHeader("_opendistro_security_conf_request", "true");
            IndexMetadata securityMetadata = this.clusterService.state().metadata().index(this.securityIndex);
            MappingMetadata mappingMetadata2 = mappingMetadata = securityMetadata == null ? null : securityMetadata.mapping();
            if (securityMetadata != null && mappingMetadata != null) {
                if ("security".equals(mappingMetadata.type())) {
                    LOGGER.debug("security index exists and was created before ES 7 (legacy layout)");
                } else {
                    LOGGER.debug("security index exists and was created with ES 7 (new layout)");
                }
                resultBuilder.with(this.validate(this.cl.load(configTypes.toArray(new CType[0]), 10L, TimeUnit.SECONDS, acceptInvalid), configTypes.size()));
            } else {
                LOGGER.debug("security index not exists (yet)");
                resultBuilder.with(this.validate(this.cl.load(configTypes.toArray(new CType[0]), 10L, TimeUnit.SECONDS, acceptInvalid), configTypes.size()));
            }
        }
        catch (Exception e) {
            throw new OpenSearchException((Throwable)e);
        }
        ConfigurationMap result = resultBuilder.build();
        if (logComplianceEvent && this.auditLog.getComplianceConfig() != null && this.auditLog.getComplianceConfig().isEnabled()) {
            CType<?> configurationType = configTypes.iterator().next();
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put(configurationType.toLCString(), Strings.toString((MediaType)MediaTypeRegistry.JSON, result.get(configurationType)));
            this.auditLog.logDocumentRead(this.securityIndex, configurationType.toLCString(), null, fields);
        }
        return result;
    }

    private ConfigurationMap validate(ConfigurationMap conf, int expectedSize) throws InvalidConfigException {
        if (conf == null || conf.size() != expectedSize) {
            throw new InvalidConfigException("Retrieved only partial configuration");
        }
        return conf;
    }

    private static String formatDate(long date) {
        return new SimpleDateFormat("yyyy-MM-dd", SecurityUtils.EN_Locale).format(new Date(date));
    }

    public static int getDefaultConfigVersion() {
        return 2;
    }

    public void afterIndexShardStarted(IndexShard indexShard) {
        ShardId shardId = indexShard.shardId();
        Index index = shardId.getIndex();
        if (this.securityIndex.equals(index.getName()) && indexShard.routingEntry() != null && indexShard.routingEntry().primary()) {
            this.threadPool.generic().execute(() -> {
                if (SnapshotRestoreHelper.isSecurityIndexRestoredFromSnapshot(this.clusterService, index, this.securityIndex)) {
                    LOGGER.info("Security index primary shard {} started - config reloading for snapshot restore", (Object)shardId);
                    this.reloadConfiguration(CType.values());
                }
            });
        }
    }

    private class AccessControllerWrappedThread
    extends Thread {
        private final Thread innerThread;

        public AccessControllerWrappedThread(ConfigurationRepository configurationRepository, Thread innerThread) {
            this.innerThread = innerThread;
        }

        @Override
        public void run() {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    AccessControllerWrappedThread.this.innerThread.run();
                    return null;
                }
            });
        }
    }
}

