/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import software.amazon.awssdk.crt.CrtResource;

public class HttpStreamBase
extends CrtResource {
    protected HttpStreamBase(long ptr) {
        this.acquireNativeHandle(ptr);
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            HttpStreamBase.httpStreamBaseRelease(this.getNativeHandle());
        }
    }

    public void incrementWindow(int windowSize) {
        if (windowSize < 0) {
            throw new IllegalArgumentException("windowSize must be >= 0. Actual value: " + windowSize);
        }
        if (!this.isNull()) {
            HttpStreamBase.httpStreamBaseIncrementWindow(this.getNativeHandle(), windowSize);
        }
    }

    public void activate() {
        if (!this.isNull()) {
            HttpStreamBase.httpStreamBaseActivate(this.getNativeHandle(), this);
        }
    }

    public int getResponseStatusCode() {
        if (!this.isNull()) {
            return HttpStreamBase.httpStreamBaseGetResponseStatusCode(this.getNativeHandle());
        }
        throw new IllegalStateException("Can't get Status Code on Closed Stream");
    }

    private static native void httpStreamBaseRelease(long var0);

    private static native void httpStreamBaseIncrementWindow(long var0, int var2);

    private static native void httpStreamBaseActivate(long var0, HttpStreamBase var2);

    private static native int httpStreamBaseGetResponseStatusCode(long var0);
}

