/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IdsQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, IdsQuery> {
    @Nonnull
    private final List<String> values;
    public static final JsonpDeserializer<IdsQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IdsQuery::setupIdsQueryDeserializer);

    private IdsQuery(Builder builder) {
        super(builder);
        this.values = ApiTypeHelper.unmodifiable(builder.values);
    }

    public static IdsQuery of(Function<Builder, ObjectBuilder<IdsQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Ids;
    }

    @Nonnull
    public final List<String> values() {
        return this.values;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.values)) {
            generator.writeKey("values");
            generator.writeStartArray();
            for (String item0 : this.values) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIdsQueryDeserializer(ObjectDeserializer<Builder> op) {
        IdsQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::values, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "values");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.values);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdsQuery other = (IdsQuery)o;
        return Objects.equals(this.values, other.values);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, IdsQuery> {
        @Nullable
        private List<String> values;

        public Builder() {
        }

        private Builder(IdsQuery o) {
            super(o);
            this.values = Builder._listCopy(o.values);
        }

        private Builder(Builder o) {
            super(o);
            this.values = Builder._listCopy(o.values);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder values(List<String> list) {
            this.values = Builder._listAddAll(this.values, list);
            return this;
        }

        @Nonnull
        public final Builder values(String value, String ... values) {
            this.values = Builder._listAdd(this.values, value, values);
            return this;
        }

        @Override
        @Nonnull
        public IdsQuery build() {
            this._checkSingleUse();
            return new IdsQuery(this);
        }
    }
}

