/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.model;

import java.io.IOException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class InitProgressProfile
implements Writeable,
ToXContent {
    public static final String PERCENTAGE = "percentage";
    public static final String ESTIMATED_MINUTES_LEFT = "estimated_minutes_left";
    public static final String NEEDED_SHINGLES = "needed_shingles";
    private final String percentage;
    private final long estimatedMinutesLeft;
    private final int neededShingles;

    public InitProgressProfile(String percentage, long estimatedMinutesLeft, int neededDataPoints) {
        this.percentage = percentage;
        this.estimatedMinutesLeft = estimatedMinutesLeft;
        this.neededShingles = neededDataPoints;
    }

    public InitProgressProfile(StreamInput in) throws IOException {
        this.percentage = in.readString();
        this.estimatedMinutesLeft = in.readVLong();
        this.neededShingles = in.readVInt();
    }

    public String getPercentage() {
        return this.percentage;
    }

    public long getEstimatedMinutesLeft() {
        return this.estimatedMinutesLeft;
    }

    public int getNeededDataPoints() {
        return this.neededShingles;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(PERCENTAGE, this.percentage);
        if (this.estimatedMinutesLeft > 0L) {
            builder.field(ESTIMATED_MINUTES_LEFT, this.estimatedMinutesLeft);
        }
        if (this.neededShingles > 0) {
            builder.field(NEEDED_SHINGLES, this.neededShingles);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.percentage);
        out.writeVLong(this.estimatedMinutesLeft);
        out.writeVInt(this.neededShingles);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append(PERCENTAGE, (Object)this.percentage);
        if (this.estimatedMinutesLeft > 0L) {
            builder.append(ESTIMATED_MINUTES_LEFT, this.estimatedMinutesLeft);
        }
        if (this.neededShingles > 0) {
            builder.append(NEEDED_SHINGLES, this.neededShingles);
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj instanceof InitProgressProfile) {
            InitProgressProfile other = (InitProgressProfile)obj;
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            equalsBuilder.append((Object)this.percentage, (Object)other.percentage);
            equalsBuilder.append(this.estimatedMinutesLeft, other.estimatedMinutesLeft);
            equalsBuilder.append(this.neededShingles, other.neededShingles);
            return equalsBuilder.isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.percentage).append(this.estimatedMinutesLeft).append(this.neededShingles).toHashCode();
    }
}

