/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.pki.internal.asn1.ASN1ConstructedInputStream;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1Header;
import oracle.security.pki.internal.asn1.ASN1TaggedObject;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.util.Utils;

public class ASN1String
implements ASN1TaggedObject {
    private ASN1Header a;
    private String b;
    private byte[] c;
    private static final int d = 22;

    public ASN1String(String string) {
        this.a(string, 22);
    }

    public ASN1String(String string, int n) {
        this.a(string, n);
    }

    public ASN1String(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    private void a(String string, int n) {
        int n2;
        this.b = string;
        if (n == 12) {
            this.c = Utils.toUTF8(string);
            n2 = this.c.length;
        } else {
            n2 = n == 30 ? 2 * string.length() : (n == 28 ? 4 * string.length() : string.length());
        }
        this.a = new ASN1Header(n, 0, 0, n2);
    }

    @Override
    public ASN1Header a() {
        return this.a;
    }

    public String b() {
        return this.b;
    }

    public int c() {
        return this.a.a();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.a.a()) {
            case 19: {
                stringBuffer.append("PrintableString");
                break;
            }
            case 20: {
                stringBuffer.append("T61String");
                break;
            }
            case 22: {
                stringBuffer.append("IA5String");
                break;
            }
            case 25: {
                stringBuffer.append("GraphicString");
                break;
            }
            case 26: {
                stringBuffer.append("VisibleString");
                break;
            }
            case 27: {
                stringBuffer.append("GeneralString");
                break;
            }
            case 30: {
                stringBuffer.append("BMPString");
                break;
            }
            case 28: {
                stringBuffer.append("UniversalString");
                break;
            }
            case 12: {
                stringBuffer.append("UTF8String");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ASN.1 string type.");
            }
        }
        stringBuffer.append(" \"");
        stringBuffer.append(this.b);
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = ASN1String.a(inputStream, stringBuffer);
        this.a(stringBuffer.toString(), n);
    }

    public static String a(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        ASN1String.a(inputStream, stringBuffer);
        return stringBuffer.toString();
    }

    private static int a(InputStream inputStream, StringBuffer stringBuffer) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.d(0);
        int n = aSN1Header.a();
        if (n != 19 && n != 20 && n != 22 && n != 25 && n != 26 && n != 27 && n != 30 && n != 28 && n != 12) {
            throw new ASN1FormatException("Got tag " + n + " instead of an ASN.1 string type.");
        }
        if (aSN1Header.c() == 0) {
            byte[] byArray = aSN1Header.d(inputStream);
            if (n == 30) {
                int n2 = byArray.length - 1;
                for (int i = 0; i < n2; i += 2) {
                    stringBuffer.append((char)(byArray[i] << 8 | byArray[i + 1] & 0xFF));
                }
            } else if (n == 28) {
                int n3 = byArray.length - 1;
                for (int i = 0; i < n3; i += 4) {
                    stringBuffer.append((char)(byArray[i] << 24 | byArray[i + 1] << 16 | byArray[i + 2] << 8 | byArray[i + 3] & 0xFF));
                }
            } else if (n == 12) {
                stringBuffer.append(Utils.fromUTF8(byArray));
            } else {
                int n4 = byArray.length;
                for (int i = 0; i < n4; ++i) {
                    stringBuffer.append((char)(byArray[i] & 0xFF));
                }
            }
        } else {
            ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream(inputStream, aSN1Header);
            while (aSN1ConstructedInputStream.a()) {
                int n5 = ASN1String.a(inputStream, stringBuffer);
                if (n5 == n) continue;
                throw new ASN1FormatException("Got tag " + n5 + " instead of " + n + ".");
            }
            aSN1ConstructedInputStream.b();
        }
        return n;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.a.output(outputStream);
        int n = this.a.a();
        if (n == 12) {
            outputStream.write(this.c);
        } else if (n == 30) {
            ASN1String.b(outputStream, this.b);
        } else if (n == 28) {
            ASN1String.c(outputStream, this.b);
        } else {
            ASN1String.d(outputStream, this.b);
        }
    }

    @Override
    public int length() {
        return this.a.g();
    }

    public static void a(OutputStream outputStream, String string) throws IOException {
        ASN1String.a(outputStream, string, 22, 0);
    }

    public static void a(OutputStream outputStream, String string, int n) throws IOException {
        ASN1String.a(outputStream, string, n, 0);
    }

    public static void b(OutputStream outputStream, String string, int n) throws IOException {
        ASN1String.a(outputStream, string, n, 128);
    }

    private static void a(OutputStream outputStream, String string, int n, int n2) throws IOException {
        outputStream.write(n2 + n);
        if (n == 12) {
            byte[] byArray = Utils.toUTF8(string);
            ASN1Utils.a(outputStream, byArray.length);
            outputStream.write(byArray);
        } else if (n == 30) {
            ASN1Utils.a(outputStream, 2 * string.length());
            ASN1String.b(outputStream, string);
        } else {
            ASN1Utils.a(outputStream, string.length());
            ASN1String.d(outputStream, string);
        }
    }

    private static void b(OutputStream outputStream, String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            outputStream.write((byte)(c >> 8));
            outputStream.write((byte)c);
        }
    }

    private static void c(OutputStream outputStream, String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            outputStream.write((byte)(c >> 24));
            outputStream.write((byte)(c >> 16));
            outputStream.write((byte)(c >> 8));
            outputStream.write((byte)c);
        }
    }

    private static void d(OutputStream outputStream, String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            outputStream.write((byte)string.charAt(i));
        }
    }
}

