import { IrcClientState, IrcConnection, IrcConnectionEventsMap } from "matrix-org-irc";
import { ClientId, IrcConnectionPoolCommandOut, OutCommandType } from "./types";
import TypedEmitter from "typed-emitter";
import { IrcPoolClient } from "./IrcPoolClient";
export type RedisIrcConnectionEvents = {
    'not-connected': () => void;
};
declare const RedisIrcConnection_base: new () => TypedEmitter<RedisIrcConnectionEvents & IrcConnectionEventsMap>;
export declare class RedisIrcConnection extends RedisIrcConnection_base implements IrcConnection {
    private readonly redis;
    readonly clientId: ClientId;
    state: IrcClientState;
    private readonly log;
    get connecting(): boolean;
    get readyState(): string;
    private isConnecting;
    localPort?: number;
    localIp?: string;
    constructor(redis: IrcPoolClient, clientId: ClientId, state: IrcClientState);
    setConnectionInfo(info: IrcConnectionPoolCommandOut<OutCommandType.Connected>["info"]): void;
    setTimeout(timeout: number): void;
    destroy(): void;
    write(data: string): void;
    end(): void;
}
export {};
