/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMExtractor;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMGenerator;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyPairGenerator;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsKemConfig;
import org.bouncycastle.tls.crypto.TlsKemDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsMLKem;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceTlsMLKemDomain
implements TlsKemDomain {
    protected final JcaTlsCrypto crypto;
    protected final MLKEMParameters kyberParameters;
    protected final boolean isServer;

    protected static MLKEMParameters getKyberParameters(int n) {
        switch (n) {
            case 583: {
                return MLKEMParameters.ml_kem_512;
            }
            case 584: 
            case 1896: {
                return MLKEMParameters.ml_kem_768;
            }
            case 585: 
            case 4132: {
                return MLKEMParameters.ml_kem_1024;
            }
        }
        return null;
    }

    public JceTlsMLKemDomain(JcaTlsCrypto jcaTlsCrypto, TlsKemConfig tlsKemConfig) {
        this.crypto = jcaTlsCrypto;
        this.kyberParameters = JceTlsMLKemDomain.getKyberParameters(tlsKemConfig.getNamedGroup());
        this.isServer = tlsKemConfig.isServer();
    }

    public JceTlsSecret adoptLocalSecret(byte[] byArray) {
        return this.crypto.adoptLocalSecret(byArray);
    }

    @Override
    public TlsAgreement createKem() {
        return new JceTlsMLKem(this);
    }

    public JceTlsSecret decapsulate(MLKEMPrivateKeyParameters mLKEMPrivateKeyParameters, byte[] byArray) {
        MLKEMExtractor mLKEMExtractor = new MLKEMExtractor(mLKEMPrivateKeyParameters);
        byte[] byArray2 = mLKEMExtractor.extractSecret(byArray);
        return this.adoptLocalSecret(byArray2);
    }

    public MLKEMPublicKeyParameters decodePublicKey(byte[] byArray) {
        return new MLKEMPublicKeyParameters(this.kyberParameters, byArray);
    }

    public SecretWithEncapsulation encapsulate(MLKEMPublicKeyParameters mLKEMPublicKeyParameters) {
        MLKEMGenerator mLKEMGenerator = new MLKEMGenerator(this.crypto.getSecureRandom());
        return mLKEMGenerator.generateEncapsulated((AsymmetricKeyParameter)mLKEMPublicKeyParameters);
    }

    public byte[] encodePublicKey(MLKEMPublicKeyParameters mLKEMPublicKeyParameters) {
        return mLKEMPublicKeyParameters.getEncoded();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        MLKEMKeyPairGenerator mLKEMKeyPairGenerator = new MLKEMKeyPairGenerator();
        mLKEMKeyPairGenerator.init((KeyGenerationParameters)new MLKEMKeyGenerationParameters(this.crypto.getSecureRandom(), this.kyberParameters));
        return mLKEMKeyPairGenerator.generateKeyPair();
    }

    public boolean isServer() {
        return this.isServer;
    }
}

