/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.ImmutableRGBColorValue;
import io.sf.carte.echosvg.css.engine.value.ImmutableUnitValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.w3c.api.DOMSyntaxException;
import org.w3c.css.om.typed.CSSNumericValue;
import org.w3c.css.om.typed.CSSRGB;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public class RGBColorValue
extends ColorValue
implements CSSRGB {
    private static final long serialVersionUID = 1L;
    NumericValue red;
    NumericValue green;
    NumericValue blue;
    private transient boolean pcntSpecified;
    private transient boolean alphaPcntSpecified;

    public RGBColorValue(NumericValue r, NumericValue g, NumericValue b) throws DOMSyntaxException {
        this(r, g, b, SVGValueConstants.NUMBER_1.clone());
    }

    public RGBColorValue(NumericValue r, NumericValue g, NumericValue b, NumericValue a) throws DOMSyntaxException {
        super(a);
        this.setRGB(r, g, b);
    }

    void setRGB(NumericValue r, NumericValue g, NumericValue b) {
        this.setR(r);
        this.setG(g);
        this.setB(b);
    }

    public RGBColorValue(float[] comp) {
        super(new FloatValue(0, comp[3]));
        this.red = new FloatValue(0, comp[0]);
        this.componentize(this.red);
        this.green = new FloatValue(0, comp[1]);
        this.componentize(this.green);
        this.blue = new FloatValue(0, comp[2]);
        this.componentize(this.blue);
    }

    public static RGBColorValue createConstant(NumericValue r, NumericValue g, NumericValue b) throws DOMSyntaxException, IllegalArgumentException {
        r = RGBColorValue.constantLegacyRange(r);
        g = RGBColorValue.constantLegacyRange(g);
        b = RGBColorValue.constantLegacyRange(b);
        return new ImmutableRGBColorValue(r, g, b);
    }

    public static RGBColorValue createConstant(NumericValue r, NumericValue g, NumericValue b, NumericValue a) throws DOMSyntaxException, IllegalArgumentException {
        r = RGBColorValue.constantLegacyRange(r);
        g = RGBColorValue.constantLegacyRange(g);
        b = RGBColorValue.constantLegacyRange(b);
        return new ImmutableRGBColorValue(r, g, b, a);
    }

    private static NumericValue constantLegacyRange(NumericValue ch) throws DOMSyntaxException, IllegalArgumentException {
        if (ch.getUnitType() == 0) {
            return new ImmutableUnitValue(0, ch.getFloatValue() / 255.0f);
        }
        if (ch.getUnitType() != 2) {
            throw new DOMSyntaxException("RGB component must be a number or percentage, not " + ch.getCssText() + '.');
        }
        if (ch.handler != null) {
            ch = new ImmutableUnitValue(ch.getUnitType(), ch.getFloatValue());
        }
        return ch;
    }

    void setSpecifiedAsPercentage(boolean spec) {
        this.pcntSpecified = spec;
    }

    void setAlphaSpecifiedAsPercentage(boolean spec) {
        this.alphaPcntSpecified = spec;
    }

    @Override
    public String getCSSColorSpace() {
        return "rgb";
    }

    public String getCssText() {
        DecimalFormat df = null;
        if (!this.pcntSpecified || !this.alphaPcntSpecified) {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.ROOT);
            df = new DecimalFormat("#.#", dfs);
            df.setMinimumFractionDigits(0);
            df.setMaximumFractionDigits(3);
        }
        String sr = this.rgbComponentText(this.red, df);
        String sg = this.rgbComponentText(this.green, df);
        String sb = this.rgbComponentText(this.blue, df);
        StringBuilder buf = new StringBuilder(sr.length() + sg.length() + sb.length() + 16);
        boolean opaque = this.isOpaque();
        if (opaque) {
            buf.append("rgb(");
        } else {
            buf.append("rgba(");
        }
        buf.append(sr).append(", ").append(sg).append(", ").append(sb);
        if (!opaque) {
            buf.append(", ").append(this.alphaComponentText(this.alpha, df));
        }
        buf.append(')');
        return buf.toString();
    }

    private String rgbComponentText(NumericValue comp, DecimalFormat df) {
        if (this.pcntSpecified) {
            return comp.getCssText();
        }
        double f = comp.getFloatValue();
        switch (comp.getUnitType()) {
            case 0: {
                f *= 255.0;
                break;
            }
            case 2: {
                f *= 2.55;
            }
        }
        return df.format(f);
    }

    private String alphaComponentText(NumericValue alpha, DecimalFormat df) {
        if (this.alphaPcntSpecified || alpha.getUnitType() == 0) {
            return alpha.getCssText();
        }
        return df.format(alpha.getFloatValue() / 100.0f);
    }

    @Override
    public RGBColorValue getColorValue() {
        return this;
    }

    public NumericValue getR() {
        return this.red;
    }

    public NumericValue getG() {
        return this.green;
    }

    public NumericValue getB() {
        return this.blue;
    }

    public NumericValue getRed() {
        return this.red;
    }

    public NumericValue getGreen() {
        return this.green;
    }

    public NumericValue getBlue() {
        return this.blue;
    }

    public void setR(double r) {
        this.red = new FloatValue(2, (float)r * 100.0f);
        this.pcntSpecified = true;
        this.componentize(this.red);
        this.componentChanged(this.red);
    }

    public void setR(CSSNumericValue r) throws DOMSyntaxException {
        this.red = this.component(r);
        this.componentChanged(this.red);
        this.pcntSpecified = this.red.getUnitType() == 2;
    }

    private NumericValue component(CSSNumericValue c) throws DOMSyntaxException {
        NumericValue ch = (NumericValue)c;
        if (ch.getUnitType() != 2 && ch.getUnitType() != 0) {
            throw new DOMSyntaxException("RGB component must be a number or percentage, not a " + CSSUnit.dimensionUnitString((short)ch.getUnitType()) + '.');
        }
        if (ch.handler != null) {
            ch = ch.clone();
        }
        this.componentize(ch);
        return ch;
    }

    public void setG(double g) {
        this.green = new FloatValue(2, (float)g * 100.0f);
        this.pcntSpecified = true;
        this.componentize(this.green);
        this.componentChanged(this.green);
    }

    public void setG(CSSNumericValue g) throws DOMSyntaxException {
        this.green = this.component(g);
        this.componentChanged(this.green);
    }

    public void setB(double b) {
        this.blue = new FloatValue(2, (float)b * 100.0f);
        this.pcntSpecified = true;
        this.componentize(this.blue);
        this.componentChanged(this.blue);
    }

    public void setB(CSSNumericValue b) throws DOMSyntaxException {
        this.blue = this.component(b);
        this.componentChanged(this.blue);
    }

    @Override
    public int getLength() throws DOMException {
        return 4;
    }

    @Override
    public NumericValue item(int index) throws DOMException {
        switch (index) {
            case 0: {
                return this.getR();
            }
            case 1: {
                return this.getG();
            }
            case 2: {
                return this.getB();
            }
            case 3: {
                return this.getAlpha();
            }
        }
        return null;
    }

    @Override
    CSSNumberValue componentValue(String lcComponent) throws DOMException {
        switch (lcComponent) {
            case "r": {
                return this.zeroTo255(this.getR());
            }
            case "g": {
                return this.zeroTo255(this.getG());
            }
            case "b": {
                return this.zeroTo255(this.getB());
            }
            case "alpha": {
                return this.zeroToOne((NumericValue)this.getAlpha());
            }
        }
        throw new DOMException(12, "Unknown component: " + lcComponent);
    }

    private CSSNumberValue zeroTo255(NumericValue c) {
        float f = 0.0f;
        if (c != null) {
            f = c.getFloatValue();
            switch (c.getUnitType()) {
                case 0: {
                    f *= 255.0f;
                    break;
                }
                case 2: {
                    f *= 2.55f;
                }
            }
        }
        NumberValue num = new NumberValue();
        num.setFloatValue((short)0, f);
        return num;
    }

    @Override
    public RGBColorValue clone() {
        RGBColorValue clon = (RGBColorValue)super.clone();
        clon.red = this.red.clone();
        clon.green = this.green.clone();
        clon.blue = this.blue.clone();
        return clon;
    }
}

