
# Loading plot data from JSON

Many of the underlying visualization tools can store their plot
data in JSON form, and you might have some generated by another
source or downloaded from the web.  For example, in this package's
directory, the file `example/EV Charge Points.json`
contains JSON data from one of the Plotly project's blog posts.

You can load it and use it in a visualization as follows.

```
# load and convert into a record
jsonText := ReadAll( InputTextFile( "EV Charge Points.json" ) );;
gapRecord := JsonStringToGap( jsonText );;

# ensure it's big enough to be visible:
if IsBound( gapRecord.layout ) then
    gapRecord.layout.height := 500;;
else
    gapRecord.layout := rec( height := 500 );;
fi;

# show it
CreateVisualization( rec( tool := "plotly", data := gapRecord ) );
```

