/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.JavaClass;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.ActionUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.codeexplorer.map.AncestorsHider;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.DependencySnapshotCondition;
import org.freeplane.plugin.codeexplorer.map.SelectedNodeDependencies;

public class FilterClassesByDependencies
extends AFreeplaneAction {
    private Supplier<Collection<JavaClass>> selectedClassesSupplier;

    private static Collection<JavaClass> getSelectedClasses() {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        SelectedNodeDependencies selectedNodeDependencies = new SelectedNodeDependencies(selection);
        List<JavaClass> selectedClasses = selectedNodeDependencies.getSelectedClasses();
        return selectedClasses;
    }

    public FilterClassesByDependencies() {
        this("code.FilterClassesByDependencies", FilterClassesByDependencies::getSelectedClasses);
    }

    protected FilterClassesByDependencies(String key, Supplier<Collection<JavaClass>> selectedClassesSupplier) {
        super(key);
        this.selectedClassesSupplier = selectedClassesSupplier;
    }

    public void setSelectedClassesSupplier(Supplier<Collection<JavaClass>> selectedClassesSupplier) {
        this.selectedClassesSupplier = selectedClassesSupplier;
        this.setEnabled(selectedClassesSupplier != null);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.selectedClassesSupplier == null) {
            return;
        }
        IMapSelection selection = Controller.getCurrentController().getSelection();
        Collection<JavaClass> selectedClasses = this.selectedClassesSupplier.get();
        Set<String> dependentNodeIDs = selectedClasses.stream().map(((CodeMap)selection.getMap())::getClassNodeId).collect(Collectors.toSet());
        if (dependentNodeIDs.isEmpty()) {
            UITools.informationMessage((Object)TextUtils.getRawText((String)"code.no_dependencies_found"));
            return;
        }
        DependencySnapshotCondition condition = new DependencySnapshotCondition(dependentNodeIDs, ActionUtils.getActionTitle((AFreeplaneAction)this));
        Filter lastFilter = selection.getFilter();
        Filter filter = new Filter((ICondition)condition, false, true, lastFilter.areDescendantsShown(), false, lastFilter.getFilteredElement(), null);
        FilterController filterController = FilterController.getCurrentFilterController();
        filterController.applyFilter(selection.getMap(), false, filter);
        if (!lastFilter.areAncestorsShown()) {
            AncestorsHider.hideAncestors();
        }
    }
}

