/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.draggable;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.ScrollButtonBox;
import net.infonode.gui.ScrollButtonBoxListener;
import net.infonode.gui.ScrollableBox;
import net.infonode.gui.ScrollableBoxListener;
import net.infonode.gui.draggable.DraggableComponent;
import net.infonode.gui.draggable.DraggableComponentBoxEvent;
import net.infonode.gui.draggable.DraggableComponentBoxListener;
import net.infonode.gui.draggable.DraggableComponentEvent;
import net.infonode.gui.draggable.DraggableComponentListener;
import net.infonode.gui.layout.DirectionLayout;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.util.Direction;

public class DraggableComponentBox
extends SimplePanel {
    private final boolean componentBoxEnabled = true;
    private final JComponent componentBox;
    private JComponent componentContainer;
    private JComponent outerParentArea = this;
    private Direction componentDirection = Direction.UP;
    private boolean scrollEnabled = false;
    private boolean ensureSelectedVisible;
    private boolean autoSelect = true;
    private boolean descendingSortOrder = true;
    private boolean doReverseSort = false;
    private boolean mustSort = false;
    private int scrollOffset;
    private final int iconSize;
    private DraggableComponent selectedComponent;
    private DraggableComponent topComponent;
    private ArrayList listeners;
    private final ArrayList draggableComponentList = new ArrayList(10);
    private final ArrayList layoutOrderList = new ArrayList(10);
    private ScrollButtonBox scrollButtonBox;
    private boolean useDefaultScrollButtons = true;
    private final DraggableComponentListener draggableComponentListener = new DraggableComponentListener(){

        @Override
        public void changed(DraggableComponentEvent event) {
            if (event.getType() == 0) {
                DraggableComponentBox.this.sortComponentList(!DraggableComponentBox.this.descendingSortOrder);
            }
            DraggableComponentBox.this.fireChangedEvent(event);
        }

        @Override
        public void selected(DraggableComponentEvent event) {
            DraggableComponentBox.this.doSelectComponent(event.getSource());
        }

        @Override
        public void dragged(DraggableComponentEvent event) {
            DraggableComponentBox.this.fireDraggedEvent(event);
        }

        @Override
        public void dropped(DraggableComponentEvent event) {
            DraggableComponentBox.this.ensureSelectedVisible();
            DraggableComponentBox.this.fireDroppedEvent(event);
        }

        @Override
        public void dragAborted(DraggableComponentEvent event) {
            DraggableComponentBox.this.ensureSelectedVisible();
            DraggableComponentBox.this.fireNotDroppedEvent(event);
        }
    };

    public DraggableComponentBox(int iconSize) {
        this(iconSize, true);
    }

    public DraggableComponentBox(int iconSize, boolean useDefaultScrollButtons) {
        this.iconSize = iconSize;
        this.useDefaultScrollButtons = useDefaultScrollButtons;
        DirectionLayout layout = new DirectionLayout(this.componentDirection == Direction.UP ? Direction.RIGHT : (this.componentDirection == Direction.LEFT ? Direction.DOWN : (this.componentDirection == Direction.DOWN ? Direction.RIGHT : Direction.DOWN))){

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                Dimension min = super.minimumLayoutSize(parent);
                Dimension pref = super.preferredLayoutSize(parent);
                return DraggableComponentBox.this.componentDirection.isHorizontal() ? new Dimension(pref.width, min.height) : new Dimension(min.width, pref.height);
            }

            @Override
            public void layoutContainer(Container parent) {
                if (DraggableComponentBox.this != null) {
                    DraggableComponentBox.this.doSort();
                    super.layoutContainer(parent);
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                DraggableComponentBox.this.doSort();
                return super.preferredLayoutSize(parent);
            }
        };
        layout.setLayoutOrderList(this.layoutOrderList);
        this.componentBox = new SimplePanel((LayoutManager)layout){

            @Override
            public boolean isOptimizedDrawingEnabled() {
                return DraggableComponentBox.this != null && DraggableComponentBox.this.getComponentSpacing() >= 0;
            }
        };
        this.componentBox.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                DraggableComponentBox.this.fireChangedEvent();
            }
        });
        this.initialize();
    }

    public void addListener(DraggableComponentBoxListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(listener);
    }

    public void removeListener(DraggableComponentBoxListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    public void addDraggableComponent(DraggableComponent component) {
        this.insertDraggableComponent(component, -1);
    }

    public void insertDraggableComponent(DraggableComponent component, int index) {
        component.setLayoutOrderList(this.layoutOrderList);
        component.addListener(this.draggableComponentListener);
        if (index < 0) {
            this.layoutOrderList.add(component.getComponent());
            this.componentBox.add(component.getComponent());
        } else {
            this.layoutOrderList.add(index, component.getComponent());
            this.componentBox.add((Component)component.getComponent(), index);
        }
        this.sortComponentList(!this.descendingSortOrder);
        this.draggableComponentList.add(component);
        component.setOuterParentArea(this.outerParentArea);
        this.componentBox.revalidate();
        this.fireAddedEvent(component);
        if (this.autoSelect && this.layoutOrderList.size() == 1 && this.selectedComponent == null && component.isEnabled()) {
            this.doSelectComponent(component);
        }
        this.updateScrollButtons();
    }

    private void updateScrollButtons() {
        if (this.scrollButtonBox != null) {
            ScrollableBox scrollableBox = (ScrollableBox)this.componentContainer;
            this.scrollButtonBox.setButton1Enabled(!scrollableBox.isLeftEnd());
            this.scrollButtonBox.setButton2Enabled(!scrollableBox.isRightEnd());
        }
    }

    public void insertDraggableComponent(DraggableComponent component, Point p) {
        int componentIndex = this.getComponentIndexAtPoint(p);
        if (componentIndex != -1 && this.layoutOrderList.size() > 0) {
            this.insertDraggableComponent(component, componentIndex);
        } else {
            this.insertDraggableComponent(component, -1);
        }
    }

    public void selectDraggableComponent(DraggableComponent component) {
        if (component == null) {
            if (this.selectedComponent != null) {
                DraggableComponent oldSelected = this.selectedComponent;
                this.selectedComponent = null;
                this.fireSelectedEvent(this.selectedComponent, oldSelected);
            }
        } else {
            component.select();
        }
    }

    public void removeDraggableComponent(DraggableComponent component) {
        if (component != null && this.draggableComponentList.contains(component)) {
            int index = this.layoutOrderList.indexOf(component.getComponent());
            component.removeListener(this.draggableComponentListener);
            if (component == this.topComponent) {
                this.topComponent = null;
            }
            if (this.layoutOrderList.size() > 1 && this.selectedComponent != null) {
                if (this.selectedComponent == component) {
                    if (this.autoSelect) {
                        int selectIndex = this.findSelectableComponentIndex(index);
                        if (selectIndex > -1) {
                            this.selectDraggableComponent(this.findDraggableComponent((Component)this.layoutOrderList.get(selectIndex)));
                        } else {
                            this.selectedComponent = null;
                        }
                    } else {
                        this.selectDraggableComponent(null);
                    }
                }
            } else if (this.selectedComponent != null) {
                DraggableComponent oldSelected = this.selectedComponent;
                this.selectedComponent = null;
                this.fireSelectedEvent(this.selectedComponent, oldSelected);
            }
            this.draggableComponentList.remove(component);
            this.layoutOrderList.remove(component.getComponent());
            this.componentBox.remove(component.getComponent());
            this.componentBox.revalidate();
            component.setLayoutOrderList(null);
            this.sortComponentList(!this.descendingSortOrder);
            this.updateScrollButtons();
            this.fireRemovedEvent(component);
        }
    }

    public boolean containsDraggableComponent(DraggableComponent component) {
        return this.draggableComponentList.contains(component);
    }

    public DraggableComponent getSelectedDraggableComponent() {
        return this.selectedComponent;
    }

    public int getDraggableComponentCount() {
        return this.layoutOrderList.size();
    }

    public DraggableComponent getDraggableComponentAt(int index) {
        return index < this.layoutOrderList.size() ? this.findDraggableComponent((Component)this.layoutOrderList.get(index)) : null;
    }

    public int getDraggableComponentIndex(DraggableComponent component) {
        return this.layoutOrderList.indexOf(component.getComponent());
    }

    public Object[] getDraggableComponents() {
        return this.draggableComponentList.toArray();
    }

    public Component[] getBoxComponents() {
        return this.componentBox.getComponents();
    }

    public boolean getDepthSortOrder() {
        return this.descendingSortOrder;
    }

    public void setDepthSortOrder(boolean descending) {
        if (descending != this.descendingSortOrder) {
            this.descendingSortOrder = descending;
            this.sortComponentList(!descending);
            this.doSort();
        }
    }

    public boolean isScrollEnabled() {
        return this.scrollEnabled;
    }

    public void setScrollEnabled(boolean scrollEnabled) {
        if (scrollEnabled != this.scrollEnabled) {
            this.scrollEnabled = scrollEnabled;
            this.initialize();
        }
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public void setScrollOffset(int scrollOffset) {
        if (scrollOffset != this.scrollOffset) {
            this.scrollOffset = scrollOffset;
            if (this.scrollEnabled) {
                ((ScrollableBox)this.componentContainer).setScrollOffset(scrollOffset);
            }
        }
    }

    public int getComponentSpacing() {
        return this.getDirectionLayout().getComponentSpacing();
    }

    public void setComponentSpacing(int componentSpacing) {
        if (componentSpacing != this.getDirectionLayout().getComponentSpacing()) {
            if (this.getComponentSpacing() < 0 && componentSpacing >= 0) {
                DraggableComponent tmp = this.topComponent;
                this.sortComponentList(false);
                this.topComponent = tmp;
            }
            this.getDirectionLayout().setComponentSpacing(componentSpacing);
            this.sortComponentList(!this.descendingSortOrder);
            this.componentBox.revalidate();
        }
    }

    public boolean isEnsureSelectedVisible() {
        return this.ensureSelectedVisible;
    }

    public void setEnsureSelectedVisible(boolean ensureSelectedVisible) {
        this.ensureSelectedVisible = ensureSelectedVisible;
    }

    public boolean isAutoSelect() {
        return this.autoSelect;
    }

    public void setAutoSelect(boolean autoSelect) {
        this.autoSelect = autoSelect;
    }

    public Direction getComponentDirection() {
        return this.componentDirection;
    }

    public void setComponentDirection(Direction componentDirection) {
        if (componentDirection != this.componentDirection) {
            this.componentDirection = componentDirection;
            this.getDirectionLayout().setDirection(componentDirection == Direction.UP ? Direction.RIGHT : (componentDirection == Direction.LEFT ? Direction.DOWN : (componentDirection == Direction.DOWN ? Direction.RIGHT : Direction.DOWN)));
            if (this.scrollEnabled) {
                this.scrollButtonBox.setVertical(componentDirection.isHorizontal());
                ((ScrollableBox)this.componentContainer).setVertical(componentDirection.isHorizontal());
            }
        }
    }

    public void setTopComponent(DraggableComponent topComponent) {
        if (topComponent != this.topComponent) {
            this.topComponent = topComponent;
            this.sortComponentList(!this.descendingSortOrder);
        }
    }

    public ScrollButtonBox getScrollButtonBox() {
        return this.scrollButtonBox;
    }

    public JComponent getOuterParentArea() {
        return this.outerParentArea;
    }

    public void setOuterParentArea(JComponent outerParentArea) {
        this.outerParentArea = outerParentArea;
    }

    public void dragDraggableComponent(DraggableComponent component, Point p) {
        if (this.draggableComponentList.contains(component)) {
            component.drag(SwingUtilities.convertPoint(this, p, component.getComponent()));
        }
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.scrollEnabled) {
            return this.getPreferredSize();
        }
        if (this.componentDirection == Direction.LEFT || this.componentDirection == Direction.RIGHT) {
            return new Dimension((int)this.getPreferredSize().getWidth(), (int)super.getMaximumSize().getHeight());
        }
        return new Dimension((int)super.getMaximumSize().getWidth(), (int)this.getPreferredSize().getHeight());
    }

    public Dimension getInnerSize() {
        boolean mustSort = this.mustSort;
        this.mustSort = false;
        Dimension d = this.scrollEnabled ? this.componentBox.getPreferredSize() : this.componentBox.getSize();
        this.mustSort = mustSort;
        return d;
    }

    public void scrollToVisible(final DraggableComponent c) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DraggableComponentBox.this.scrollEnabled) {
                    ((ScrollableBox)DraggableComponentBox.this.componentContainer).ensureVisible(DraggableComponentBox.this.layoutOrderList.indexOf(c.getComponent()));
                }
            }
        });
    }

    private void setIgnoreAddRemoveNotify(boolean ignore) {
        int i = 0;
        while (i < this.draggableComponentList.size()) {
            ((DraggableComponent)this.draggableComponentList.get(i)).setIgnoreAddNotify(ignore);
            ++i;
        }
    }

    private void doSort() {
        if (this.mustSort && this.getComponentSpacing() < 0 && this.componentBox.getComponentCount() > 0) {
            this.setIgnoreAddRemoveNotify(true);
            this.mustSort = false;
            JComponent tc = this.topComponent != null ? this.topComponent.getComponent() : null;
            int index = 0;
            if (tc != null) {
                if (this.componentBox.getComponent(0) != tc) {
                    this.componentBox.remove(tc);
                    this.componentBox.add((Component)tc, index);
                }
                ++index;
            }
            int switc = 0;
            int size = this.layoutOrderList.size();
            int i = 0;
            while (i < size) {
                Component c = (Component)this.layoutOrderList.get(this.doReverseSort ? size - i - 1 : i);
                if (c != tc) {
                    if (this.componentBox.getComponent(index) != c) {
                        ++switc;
                        this.componentBox.remove(c);
                        this.componentBox.add(c, index);
                    }
                    ++index;
                }
                ++i;
            }
            this.setIgnoreAddRemoveNotify(false);
        }
    }

    private void sortComponentList(boolean reverseSort) {
        this.doReverseSort = reverseSort;
        this.mustSort = true;
    }

    private int getComponentIndexAtPoint(Point p) {
        JComponent c = null;
        Point p2 = SwingUtilities.convertPoint(this, p, this.componentBox);
        Point p3 = SwingUtilities.convertPoint(this.componentBox, p, this.outerParentArea);
        if (this.outerParentArea.contains(p3)) {
            c = (JComponent)ComponentUtil.getChildAtLine(this.componentBox, p2, this.getDirectionLayout().getDirection().isHorizontal());
        }
        return this.layoutOrderList.indexOf(c);
    }

    private void doSelectComponent(DraggableComponent component) {
        if (this.selectedComponent != null) {
            DraggableComponent oldSelected = this.selectedComponent;
            this.selectedComponent = component;
            this.ensureSelectedVisible();
            this.fireSelectedEvent(this.selectedComponent, oldSelected);
        } else {
            this.selectedComponent = component;
            this.ensureSelectedVisible();
            this.fireSelectedEvent(this.selectedComponent, null);
        }
    }

    private int findSelectableComponentIndex(int index) {
        int selectIndex = -1;
        int i = 0;
        while (i < this.layoutOrderList.size()) {
            if (this.findDraggableComponent((Component)this.layoutOrderList.get(i)).isEnabled() && i != index) {
                int k = selectIndex;
                selectIndex = i;
                if (k < index && selectIndex > index) {
                    return selectIndex;
                }
                if (k > index && selectIndex > index) {
                    return k;
                }
            }
            ++i;
        }
        return selectIndex;
    }

    private DraggableComponent findDraggableComponent(Component c) {
        int i = 0;
        while (i < this.draggableComponentList.size()) {
            if (((DraggableComponent)this.draggableComponentList.get(i)).getComponent() == c) {
                return (DraggableComponent)this.draggableComponentList.get(i);
            }
            ++i;
        }
        return null;
    }

    private DirectionLayout getDirectionLayout() {
        return (DirectionLayout)this.componentBox.getLayout();
    }

    private void initialize() {
        if (this.componentContainer != null) {
            this.remove(this.componentContainer);
        }
        DirectionLayout layout = this.getDirectionLayout();
        layout.setCompressing(!this.scrollEnabled);
        if (this.scrollEnabled) {
            this.scrollButtonBox = this.useDefaultScrollButtons ? new ScrollButtonBox(this.componentDirection.isHorizontal(), this.iconSize) : new ScrollButtonBox(this.componentDirection.isHorizontal(), null, null, null, null);
            final ScrollableBox scrollableBox = new ScrollableBox(this.componentBox, this.componentDirection.isHorizontal(), this.scrollOffset);
            scrollableBox.setLayoutOrderList(this.layoutOrderList);
            this.scrollButtonBox.addListener(new ScrollButtonBoxListener(){

                @Override
                public void scrollButton1() {
                    scrollableBox.scrollLeft(1);
                }

                @Override
                public void scrollButton2() {
                    scrollableBox.scrollRight(1);
                }
            });
            scrollableBox.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    DraggableComponentBox.this.scrollButtonBox.setButton1Enabled(!scrollableBox.isLeftEnd());
                    DraggableComponentBox.this.scrollButtonBox.setButton2Enabled(!scrollableBox.isRightEnd());
                }
            });
            this.scrollButtonBox.setButton1Enabled(!scrollableBox.isLeftEnd());
            this.scrollButtonBox.setButton2Enabled(!scrollableBox.isRightEnd());
            scrollableBox.addScrollableBoxListener(new ScrollableBoxListener(){

                @Override
                public void scrolledLeft(ScrollableBox box) {
                    DraggableComponentBox.this.scrollButtonBox.setButton1Enabled(!box.isLeftEnd());
                    DraggableComponentBox.this.scrollButtonBox.setButton2Enabled(true);
                }

                @Override
                public void scrolledRight(ScrollableBox box) {
                    DraggableComponentBox.this.scrollButtonBox.setButton1Enabled(true);
                    DraggableComponentBox.this.scrollButtonBox.setButton2Enabled(!box.isRightEnd());
                }

                @Override
                public void changed(ScrollableBox box) {
                    DraggableComponentBox.this.fireChangedEvent();
                }
            });
            this.componentContainer = scrollableBox;
        } else {
            this.scrollButtonBox = null;
            this.componentContainer = this.componentBox;
        }
        this.componentContainer.setAlignmentY(0.0f);
        this.add((Component)this.componentContainer, "Center");
        this.revalidate();
    }

    private void ensureSelectedVisible() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DraggableComponentBox.this.scrollEnabled && DraggableComponentBox.this.ensureSelectedVisible && DraggableComponentBox.this.selectedComponent != null) {
                    ((ScrollableBox)DraggableComponentBox.this.componentContainer).ensureVisible(DraggableComponentBox.this.layoutOrderList.indexOf(DraggableComponentBox.this.selectedComponent.getComponent()));
                }
            }
        });
    }

    private void fireDraggedEvent(DraggableComponentEvent e) {
        if (this.listeners != null) {
            DraggableComponentBoxEvent event = new DraggableComponentBoxEvent(this, e.getSource(), e, SwingUtilities.convertPoint(e.getSource().getComponent(), e.getMouseEvent().getPoint(), this));
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((DraggableComponentBoxListener)l[i]).componentDragged(event);
                ++i;
            }
        }
    }

    private void fireDroppedEvent(DraggableComponentEvent e) {
        if (this.listeners != null) {
            DraggableComponentBoxEvent event = new DraggableComponentBoxEvent(this, e.getSource(), e, SwingUtilities.convertPoint(e.getSource().getComponent(), e.getMouseEvent().getPoint(), this));
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((DraggableComponentBoxListener)l[i]).componentDropped(event);
                ++i;
            }
        }
    }

    private void fireNotDroppedEvent(DraggableComponentEvent e) {
        if (this.listeners != null) {
            DraggableComponentBoxEvent event = new DraggableComponentBoxEvent(this, e.getSource(), e);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((DraggableComponentBoxListener)l[i]).componentDragAborted(event);
                ++i;
            }
        }
    }

    private void fireSelectedEvent(DraggableComponent component, DraggableComponent oldDraggableComponent) {
        if (this.listeners != null) {
            DraggableComponentBoxEvent event = new DraggableComponentBoxEvent(this, component, oldDraggableComponent);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((DraggableComponentBoxListener)l[i]).componentSelected(event);
                ++i;
            }
        }
    }

    private void fireAddedEvent(DraggableComponent component) {
        if (this.listeners != null) {
            DraggableComponentBoxEvent event = new DraggableComponentBoxEvent(this, component);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((DraggableComponentBoxListener)l[i]).componentAdded(event);
                ++i;
            }
        }
    }

    private void fireRemovedEvent(DraggableComponent component) {
        if (this.listeners != null) {
            DraggableComponentBoxEvent event = new DraggableComponentBoxEvent(this, component);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((DraggableComponentBoxListener)l[i]).componentRemoved(event);
                ++i;
            }
        }
    }

    private void fireChangedEvent(DraggableComponentEvent e) {
        if (this.listeners != null) {
            DraggableComponentBoxEvent event = new DraggableComponentBoxEvent(this, e.getSource(), e);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((DraggableComponentBoxListener)l[i]).changed(event);
                ++i;
            }
        }
    }

    private void fireChangedEvent() {
        if (this.listeners != null) {
            DraggableComponentBoxEvent event = new DraggableComponentBoxEvent(this);
            Object[] l = this.listeners.toArray();
            int i = 0;
            while (i < l.length) {
                ((DraggableComponentBoxListener)l[i]).changed(event);
                ++i;
            }
        }
    }
}

