/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.drag;

import javax.swing.JComponent;
import net.infonode.docking.drag.DockingWindowDragger;
import net.infonode.docking.drag.DockingWindowDraggerProvider;
import net.infonode.gui.draggable.DraggableComponent;
import net.infonode.gui.draggable.DraggableComponentAdapter;
import net.infonode.gui.draggable.DraggableComponentEvent;

public class DockingWindowDragSource {
    private final DraggableComponent draggableComponent;
    private DockingWindowDragger dragger;

    public DockingWindowDragSource(JComponent component, final DockingWindowDraggerProvider draggerProvider) {
        this.draggableComponent = new DraggableComponent(component);
        this.draggableComponent.setReorderEnabled(false);
        this.draggableComponent.setEnableInsideDrag(true);
        this.draggableComponent.addListener(new DraggableComponentAdapter(){

            @Override
            public void dragAborted(DraggableComponentEvent event) {
                DockingWindowDragSource.this.abortDrag();
            }

            @Override
            public void dragged(DraggableComponentEvent event) {
                if (DockingWindowDragSource.this.dragger == null) {
                    DockingWindowDragSource.this.dragger = draggerProvider.getDragger(event.getMouseEvent());
                    if (DockingWindowDragSource.this.dragger == null) {
                        DockingWindowDragSource.this.draggableComponent.abortDrag();
                        return;
                    }
                    DockingWindowDragSource.this.draggableComponent.setAbortDragKeyCode(DockingWindowDragSource.this.dragger.getDropTarget().getRootWindowProperties().getAbortDragKey());
                }
                DockingWindowDragSource.this.dragger.dragWindow(event.getMouseEvent());
            }

            @Override
            public void dropped(DraggableComponentEvent event) {
                if (DockingWindowDragSource.this.dragger != null) {
                    DockingWindowDragSource.this.dragger.dropWindow(event.getMouseEvent());
                    DockingWindowDragSource.this.dragger = null;
                }
            }
        });
    }

    public void abortDrag() {
        if (this.dragger != null) {
            this.dragger.abortDrag();
        }
        this.dragger = null;
    }
}

