/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.attribute;

import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.IAttributeTableModel;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.attribute.AttributeView;

abstract class AttributeTableModel
extends AbstractTableModel
implements IAttributeTableModel,
TableModelListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private final AttributeController attributeController;
    private AttributeRegistry attributeRegistry;
    private NodeAttributeTableModel nodeAttributeModel;
    private final TextController textController;
    private final NodeModel node;

    public AttributeTableModel(AttributeView attrView) {
        ModeController modeController = attrView.getMapView().getModeController();
        this.attributeController = AttributeController.getController(modeController);
        this.textController = TextController.getController(modeController);
        this.node = attrView.getNode();
        this.setNodeAttributeModel(attrView.getAttributes());
        this.setAttributeRegistry(attrView.getAttributeRegistry());
        this.addListeners();
    }

    private void addListeners() {
        this.getNodeAttributeModel().addTableModelListener(this);
        this.getAttributeRegistry().addChangeListener(this);
    }

    public abstract boolean areAttributesVisible();

    public void editingCanceled() {
    }

    public AttributeController getAttributeController() {
        return this.attributeController;
    }

    public AttributeRegistry getAttributeRegistry() {
        return this.attributeRegistry;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return " ";
    }

    @Override
    public Quantity<LengthUnit> getColumnWidth(int col) {
        return this.getNodeAttributeModel().getColumnWidth(col);
    }

    NodeModel getNode() {
        return this.node;
    }

    public NodeAttributeTableModel getNodeAttributeModel() {
        return this.nodeAttributeModel;
    }

    private void removeListeners() {
        this.getNodeAttributeModel().removeTableModelListener(this);
        this.getAttributeRegistry().removeChangeListener(this);
    }

    public void setAttributeRegistry(AttributeRegistry attributeRegistry) {
        this.attributeRegistry = attributeRegistry;
    }

    public void setColumnWidth(int col, Quantity<LengthUnit> width) {
        this.getAttributeController().performSetColumnWidth(this.getNode(), this.getNodeAttributeModel(), col, width);
    }

    public void setNodeAttributeModel(NodeAttributeTableModel nodeAttributeModel) {
        this.nodeAttributeModel = nodeAttributeModel;
        int rowCount = nodeAttributeModel.getRowCount();
        this.cacheTransformedValues(0, rowCount - 1);
    }

    private void cacheTransformedValue(int row) {
        try {
            Object value = this.nodeAttributeModel.getValueAt(row, 1);
            if (value != null) {
                this.textController.getTransformedText(this.getNode(), this.nodeAttributeModel, value.toString());
            }
        }
        catch (Exception e) {
            LogUtils.warn(e.getLocalizedMessage());
        }
    }

    public void viewRemoved(NodeView nodeView) {
        this.removeListeners();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        switch (e.getType()) {
            case 0: 
            case 1: {
                this.cacheTransformedValues(e.getFirstRow(), e.getLastRow());
            }
        }
    }

    private void cacheTransformedValues(int firstRow, int lastRow) {
        for (int row = firstRow; row <= lastRow; ++row) {
            this.cacheTransformedValue(row);
        }
    }
}

