/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.time;

import java.awt.FontMetrics;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.time.TimeCondition;

public class TimeConditionCreatedBefore
extends TimeCondition {
    static final String NAME = "time_condition_created_before";

    public TimeConditionCreatedBefore(FormattedDate date) {
        super(date);
    }

    @Override
    public boolean checkNode(NodeModel node) {
        Date createdAt = node.getHistoryInformation().getCreatedAt();
        Date filterDate = this.getDate();
        boolean before = createdAt.getTime() < filterDate.getTime();
        return before;
    }

    @Override
    protected String createDescription() {
        String filterTime = TextUtils.getText("filter_time");
        String dateAsString = this.getDate().toString();
        String before = TextUtils.getText("filter_created_before");
        return this.createDescription(filterTime, before, dateAsString);
    }

    @Override
    protected List<Icon> createRenderedIcons(FontMetrics fontMetrics) {
        return this.createRenderedIconsFromDescription(fontMetrics);
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

