/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class FilterIterator<T>
implements Iterator<T> {
    private final Iterator<T> sourceIterator;
    private final Predicate<T> pred;
    private T current;
    private boolean hasCurrent;

    public FilterIterator(Iterator<T> sourceIterator, Predicate<T> pred) {
        this.sourceIterator = sourceIterator;
        this.pred = pred;
    }

    @Override
    public boolean hasNext() {
        while (!this.hasCurrent) {
            if (!this.sourceIterator.hasNext()) {
                return false;
            }
            T next = this.sourceIterator.next();
            if (!this.pred.test(next)) continue;
            this.current = next;
            this.hasCurrent = true;
        }
        return true;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T next = this.current;
        this.current = null;
        this.hasCurrent = false;
        return next;
    }
}

