/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IAnnotationModelFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.BasicMarkerUpdater;
import org.eclipse.ui.texteditor.IMarkerUpdater;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class SQLEditorSemanticAnnotationModelFactory
implements IAnnotationModelFactory {
    public IAnnotationModel createAnnotationModel(IPath location) {
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)location);
        return file != null ? new ResourceMarkerSemanticAnnotationModel((IResource)file) : new AnnotationModel();
    }

    private static class ResourceMarkerSemanticAnnotationModel
    extends ResourceMarkerAnnotationModel {
        public ResourceMarkerSemanticAnnotationModel(IResource file) {
            super(file);
        }

        protected void addMarkerUpdater(IMarkerUpdater markerUpdater) {
            if (markerUpdater instanceof BasicMarkerUpdater) {
                final BasicMarkerUpdater defaultMarkerUpdater = (BasicMarkerUpdater)markerUpdater;
                markerUpdater = new IMarkerUpdater(){

                    public String getMarkerType() {
                        return defaultMarkerUpdater.getMarkerType();
                    }

                    public String[] getAttribute() {
                        return defaultMarkerUpdater.getAttribute();
                    }

                    public boolean updateMarker(IMarker iMarker, IDocument iDocument, Position position) {
                        if (1.isSemanticErrorMarker(iMarker)) {
                            if (position == null) {
                                return true;
                            }
                            return !position.isDeleted();
                        }
                        return defaultMarkerUpdater.updateMarker(iMarker, iDocument, position);
                    }

                    private static boolean isSemanticErrorMarker(IMarker marker) {
                        try {
                            return marker.getType().equalsIgnoreCase("org.jkiss.dbeaver.ui.editors.sql.semanticProblemMarker");
                        }
                        catch (CoreException coreException) {
                            return false;
                        }
                    }
                };
            }
            super.addMarkerUpdater(markerUpdater);
        }
    }
}

