/*
 * Decompiled with CFR 0.152.
 */
package bt747.j2se_view.model;

import bt747.j2se_view.model.FileWaypoint;
import bt747.sys.File;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Date;
import bt747.sys.interfaces.BT747Path;
import gps.log.GPSRecord;
import net.sf.bt747.j2se.app.exif.ExifAttribute;
import net.sf.bt747.j2se.app.exif.ExifJPG;

public class ImageData
extends FileWaypoint {
    private int width;
    private int height;
    private byte[] thumbnailData;

    public static final ImageData getInstance(BT747Path bT747Path) {
        ImageData imageData = new ImageData();
        imageData.setFilePath(bT747Path);
        return imageData;
    }

    public final byte[] getThumbnailData() {
        this.getImageInfo();
        return this.thumbnailData;
    }

    @Override
    protected final boolean getInfo() {
        return this.getImageInfo();
    }

    private static double getLatOrLon(ExifAttribute exifAttribute) {
        double d;
        if (exifAttribute.getCount() == 3) {
            double d2 = exifAttribute.getFloatValue(0);
            double d3 = exifAttribute.getFloatValue(1);
            double d4 = exifAttribute.getFloatValue(2);
            d = d2 + d3 / 60.0 + d4 / 3600.0;
        } else {
            d = -99999.0;
        }
        return d;
    }

    private boolean getImageInfo() {
        ExifAttribute exifAttribute;
        int n;
        ExifJPG exifJPG;
        this.getGpsRecord().voxStr = this.getFilePath().getPath();
        int n2 = this.getGpsRecord().voxStr.lastIndexOf(47);
        int n3 = this.getGpsRecord().voxStr.lastIndexOf(92);
        if (n3 > n2) {
            n2 = n3;
        }
        this.getGpsRecord().valid = 128;
        this.getGpsRecord().rcr = 260;
        if (n2 >= 0 && n2 < this.getGpsRecord().voxStr.length()) {
            this.getGpsRecord().voxStr = this.getGpsRecord().voxStr.substring(n2 + 1);
        }
        if (!(exifJPG = new ExifJPG()).setFilePath(this.getFilePath())) {
            return false;
        }
        this.getGpsRecord().rcr = 257;
        Object object = exifJPG.getExifAttribute(40962);
        if (object != null) {
            this.width = n = ((ExifAttribute)object).getIntValue$134621();
        }
        this.thumbnailData = exifJPG.getThumbnailData();
        object = exifJPG.getExifAttribute(40963);
        if (object != null) {
            this.height = n = ((ExifAttribute)object).getIntValue$134621();
        }
        if ((object = exifJPG.getGpsAttribute(2)) != null) {
            this.getGpsRecord().latitude = ImageData.getLatOrLon((ExifAttribute)object);
            object = exifJPG.getGpsAttribute(1);
            if (object != null && ((ExifAttribute)object).getStringValue().toUpperCase().indexOf(83) >= 0) {
                this.getGpsRecord().latitude = -this.getGpsRecord().latitude;
            }
        }
        if ((object = exifJPG.getGpsAttribute(4)) != null) {
            this.getGpsRecord().longitude = ImageData.getLatOrLon((ExifAttribute)object);
            object = exifJPG.getGpsAttribute(3);
            if (object != null && ((ExifAttribute)object).getStringValue().toUpperCase().indexOf(87) >= 0) {
                this.getGpsRecord().longitude = -this.getGpsRecord().longitude;
            }
        }
        if ((object = exifJPG.getGpsAttribute(6)) != null) {
            float f = ((ExifAttribute)object).getFloatValue(0);
            object = exifJPG.getGpsAttribute(5);
            if (object != null && ((ExifAttribute)object).getIntValue$134621() == 1) {
                f = -f;
            }
            this.getGpsRecord().height = f;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        boolean bl = false;
        object = exifJPG.getGpsAttribute(29);
        if (object != null) {
            object = ((ExifAttribute)object).getStringValue();
            try {
                n6 = Integer.valueOf(((String)object).substring(0, 4));
                n5 = Integer.valueOf(((String)object).substring(5, 6));
                n4 = Integer.valueOf(((String)object).substring(7, 8));
                bl = true;
            }
            catch (Exception exception) {}
        }
        if ((object = exifJPG.getGpsAttribute(7)) != null) {
            try {
                n7 = (int)((ExifAttribute)object).getFloatValue(0);
                n8 = (int)((ExifAttribute)object).getFloatValue(1);
                n9 = (int)((ExifAttribute)object).getFloatValue(2);
                bl = true;
            }
            catch (Exception exception) {}
        }
        if (bl) {
            int n10;
            this.getGpsRecord().utc = n10 = JavaLibBridge.getDateInstance(n4, n5, n6).dateToUTCepoch1970() + (n7 * 3600 + n8 * 60 + n9);
        }
        if ((exifAttribute = exifJPG.getExifAttribute(36868)) == null && (exifAttribute = exifJPG.getExifAttribute(36867)) == null) {
            exifAttribute = exifJPG.getExifAttribute(306);
        }
        if (exifAttribute != null) {
            String string = exifAttribute.getStringValue();
            if (string.length() == 20 && string.charAt(4) == ':' && string.charAt(7) == ':' && string.charAt(10) == ' ' && string.charAt(13) == ':' && string.charAt(16) == ':') {
                n5 = JavaLibBridge.toInt(string.substring(0, 4));
                n6 = JavaLibBridge.toInt(string.substring(5, 7));
                n7 = JavaLibBridge.toInt(string.substring(8, 10));
                n8 = JavaLibBridge.toInt(string.substring(11, 13)) * 3600 + JavaLibBridge.toInt(string.substring(14, 16)) * 60 + JavaLibBridge.toInt(string.substring(17, 19));
                BT747Date bT747Date = JavaLibBridge.getDateInstance(n7, n6, n5);
                this.setUtc(bT747Date.dateToUTCepoch1970() + n8);
            }
        } else {
            n5 = new File(this.getFilePath()).getModificationTime();
            if (n5 != 0) {
                this.setUtc(n5);
            }
        }
        return true;
    }

    public final void writeImage(BT747Path object, BT747Path bT747Path) {
        ExifJPG exifJPG = new ExifJPG();
        exifJPG.setFilePath((BT747Path)object);
        if (this.getGpsRecord().hasPosition()) {
            Object object2;
            object = this.getGpsRecord();
            if (((GPSRecord)object).hasPosition()) {
                exifJPG.setGpsPosition(((GPSRecord)object).latitude, ((GPSRecord)object).longitude);
            }
            if (((GPSRecord)object).hasPdop()) {
                exifJPG.setGpsPDOP(((GPSRecord)object).pdop);
            } else if (((GPSRecord)object).hasHdop()) {
                exifJPG.setGpsHDOP(((GPSRecord)object).hdop);
            }
            if (((GPSRecord)object).hasUtc()) {
                object2 = JavaLibBridge.getTimeInstance();
                object2.setUTCTime(((GPSRecord)object).utc);
                exifJPG.setGpsTime(object2.getYear(), object2.getMonth(), object2.getDay(), object2.getHour(), object2.getMinute(), object2.getSecond());
            }
            if (((GPSRecord)object).hasHeight()) {
                exifJPG.setGpsAltitudeMSL(((GPSRecord)object).height);
            }
            object2 = "";
            if (((GPSRecord)object).hasNsat()) {
                object2 = (((GPSRecord)object).nsat >> 8 & 0xFF) + "(" + (((GPSRecord)object).nsat & 0xFF) + ")";
            }
            if (((GPSRecord)object).hasSid()) {
                if (((String)object2).length() != 0) {
                    object2 = (String)object2 + " ";
                }
                object2 = (String)object2 + ImageData.nsatInfoToString((GPSRecord)object);
            }
            if (((String)object2).length() != 0) {
                exifJPG.setGpsSatInformation((String)object2);
            }
            if (((GPSRecord)object).hasHeading()) {
                exifJPG.setGpsTrack(((GPSRecord)object).heading);
            }
            if (((GPSRecord)object).hasSpeed()) {
                exifJPG.setGpsSpeedKmH(((GPSRecord)object).speed);
            }
            if (((GPSRecord)object).hasValid()) {
                exifJPG.setDifferential((((GPSRecord)object).valid & 4) != 0);
            }
            exifJPG.setUsedSoftWare();
        }
        exifJPG.copyTo(bT747Path);
    }

    private static final String nsatInfoToString(GPSRecord gPSRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        if (gPSRecord.hasSid()) {
            int n = 0;
            if (gPSRecord.hasSid()) {
                for (int i = gPSRecord.sid.length - 1; i >= 0; --i) {
                    if (n != 0) {
                        stringBuffer.append(';');
                    }
                    if (gPSRecord.sidinuse[n]) {
                        stringBuffer.append('#');
                    }
                    if (gPSRecord.sid[n] < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(gPSRecord.sid[n]);
                    stringBuffer.append('-');
                    if (gPSRecord.hasEle()) {
                        if (gPSRecord.ele[n] < 10) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(gPSRecord.ele[n]);
                    }
                    stringBuffer.append('-');
                    if (gPSRecord.hasAzi()) {
                        if (gPSRecord.azi[n] < 10) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(gPSRecord.azi[n]);
                    }
                    stringBuffer.append('-');
                    if (gPSRecord.hasSnr()) {
                        if (gPSRecord.snr[n] < 10) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(gPSRecord.snr[n]);
                    }
                    ++n;
                }
            }
        }
        return stringBuffer.toString();
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }
}

