/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi.clients;

import java.util.LinkedList;
import java.util.List;
import org.a11y.brlapi.Connection;
import org.a11y.brlapi.CursorPositionUsage;
import org.a11y.brlapi.DisplayNumberUsage;
import org.a11y.brlapi.OperandUsage;
import org.a11y.brlapi.Parse;
import org.a11y.brlapi.ProgramException;
import org.a11y.brlapi.SyntaxException;
import org.a11y.brlapi.WriteArguments;
import org.a11y.brlapi.clients.PauseClient;

public class WriteArgumentsClient
extends PauseClient {
    private final List<WriteArguments> writeArgumentsList = new LinkedList<WriteArguments>();
    private WriteArguments writeArguments = new WriteArguments();
    private boolean fixWriteArguments = true;
    private final OperandUsage cursorPositionUsage = new CursorPositionUsage(this.writeArguments.getCursorPosition());
    private final OperandUsage displayNumberUsage = new DisplayNumberUsage(this.writeArguments.getDisplayNumber());
    public static final int MINIMUM_REGION_BEGIN = 1;
    public static final int MINIMUM_REGION_SIZE = 1;

    public WriteArgumentsClient(String ... stringArray2) {
        super(stringArray2);
        this.writeArgumentsList.add(this.writeArguments);
        this.addOption("text", stringArray -> this.writeArguments.setText(stringArray[0]), "text");
        this.addOption("begin", stringArray -> this.writeArguments.setRegionBegin(Parse.asInt("region begin", stringArray[0], 1)), "region begin");
        this.addOption("length", stringArray -> this.writeArguments.setRegionSize(Parse.asInt("region size", stringArray[0], 1)), "region size");
        this.addOption("cursor", stringArray -> this.writeArguments.setCursorPosition(Parse.asCursorPosition(stringArray[0])), "position");
        this.addOption("display", stringArray -> this.writeArguments.setDisplayNumber(Parse.asDisplayNumber(stringArray[0])), "number");
        this.addOption("fix", stringArray -> {
            this.fixWriteArguments = true;
        }, new String[0]);
        this.addOption("nofix", stringArray -> {
            this.fixWriteArguments = false;
        }, new String[0]);
        this.addOption("render", stringArray -> {
            this.writeArguments = new WriteArguments();
            this.writeArgumentsList.add(this.writeArguments);
        }, new String[0]);
    }

    @Override
    protected final void extendUsageSummary(StringBuilder stringBuilder) {
        super.extendUsageSummary(stringBuilder);
        new OperandUsage("region begin").setDefault(1).setRangeMinimum(1).appendTo(stringBuilder);
        new OperandUsage("region size").setDefault(String.format("the size of the largest content property (%s, %s, %s)", "text", "and-mask", "or-mask")).setRangeMinimum(1).setRangeUnits("cells").appendTo(stringBuilder);
        this.cursorPositionUsage.appendTo(stringBuilder);
        this.displayNumberUsage.appendTo(stringBuilder);
    }

    @Override
    protected final void runClient(Connection connection2) throws ProgramException {
        this.ttyMode(connection2, false, (Connection connection) -> {
            int n = connection.getCellCount();
            for (WriteArguments writeArguments : this.writeArgumentsList) {
                try {
                    writeArguments.check(n, this.fixWriteArguments);
                }
                catch (IllegalStateException illegalStateException) {
                    throw new SyntaxException(illegalStateException.getMessage(), new Object[0]);
                }
                connection.write(writeArguments);
            }
            Object object = connection.getParameters().renderedCells.get();
            WriteArgumentsClient.printf("%s\n", WriteArgumentsClient.toUnicodeBraille((byte[])object));
            this.pause(connection);
        }, new int[0]);
    }
}

