﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/resiliencehub/ResilienceHubRequest.h>
#include <aws/resiliencehub/ResilienceHub_EXPORTS.h>

#include <utility>

namespace Aws {
namespace ResilienceHub {
namespace Model {

/**
 */
class DescribeResourceGroupingRecommendationTaskRequest : public ResilienceHubRequest {
 public:
  AWS_RESILIENCEHUB_API DescribeResourceGroupingRecommendationTaskRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeResourceGroupingRecommendationTask"; }

  AWS_RESILIENCEHUB_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>Amazon Resource Name (ARN) of the Resilience Hub application. The format for
   * this ARN is:
   * arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
   * For more information about ARNs, see <a
   * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
   * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General
   * Reference</i> guide.</p>
   */
  inline const Aws::String& GetAppArn() const { return m_appArn; }
  inline bool AppArnHasBeenSet() const { return m_appArnHasBeenSet; }
  template <typename AppArnT = Aws::String>
  void SetAppArn(AppArnT&& value) {
    m_appArnHasBeenSet = true;
    m_appArn = std::forward<AppArnT>(value);
  }
  template <typename AppArnT = Aws::String>
  DescribeResourceGroupingRecommendationTaskRequest& WithAppArn(AppArnT&& value) {
    SetAppArn(std::forward<AppArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Identifier of the grouping recommendation task.</p>
   */
  inline const Aws::String& GetGroupingId() const { return m_groupingId; }
  inline bool GroupingIdHasBeenSet() const { return m_groupingIdHasBeenSet; }
  template <typename GroupingIdT = Aws::String>
  void SetGroupingId(GroupingIdT&& value) {
    m_groupingIdHasBeenSet = true;
    m_groupingId = std::forward<GroupingIdT>(value);
  }
  template <typename GroupingIdT = Aws::String>
  DescribeResourceGroupingRecommendationTaskRequest& WithGroupingId(GroupingIdT&& value) {
    SetGroupingId(std::forward<GroupingIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_appArn;

  Aws::String m_groupingId;
  bool m_appArnHasBeenSet = false;
  bool m_groupingIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ResilienceHub
}  // namespace Aws
