﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/UUID.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/medialive/MediaLiveRequest.h>
#include <aws/medialive/MediaLive_EXPORTS.h>
#include <aws/medialive/model/CloudWatchAlarmTemplateComparisonOperator.h>
#include <aws/medialive/model/CloudWatchAlarmTemplateStatistic.h>
#include <aws/medialive/model/CloudWatchAlarmTemplateTargetResourceType.h>
#include <aws/medialive/model/CloudWatchAlarmTemplateTreatMissingData.h>

#include <utility>

namespace Aws {
namespace MediaLive {
namespace Model {

/**
 * Placeholder documentation for CreateCloudWatchAlarmTemplateRequest<p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCloudWatchAlarmTemplateRequest">AWS
 * API Reference</a></p>
 */
class CreateCloudWatchAlarmTemplateRequest : public MediaLiveRequest {
 public:
  AWS_MEDIALIVE_API CreateCloudWatchAlarmTemplateRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CreateCloudWatchAlarmTemplate"; }

  AWS_MEDIALIVE_API Aws::String SerializePayload() const override;

  ///@{

  inline CloudWatchAlarmTemplateComparisonOperator GetComparisonOperator() const { return m_comparisonOperator; }
  inline bool ComparisonOperatorHasBeenSet() const { return m_comparisonOperatorHasBeenSet; }
  inline void SetComparisonOperator(CloudWatchAlarmTemplateComparisonOperator value) {
    m_comparisonOperatorHasBeenSet = true;
    m_comparisonOperator = value;
  }
  inline CreateCloudWatchAlarmTemplateRequest& WithComparisonOperator(CloudWatchAlarmTemplateComparisonOperator value) {
    SetComparisonOperator(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * The number of datapoints within the evaluation period that must be breaching to
   * trigger the alarm.
   */
  inline int GetDatapointsToAlarm() const { return m_datapointsToAlarm; }
  inline bool DatapointsToAlarmHasBeenSet() const { return m_datapointsToAlarmHasBeenSet; }
  inline void SetDatapointsToAlarm(int value) {
    m_datapointsToAlarmHasBeenSet = true;
    m_datapointsToAlarm = value;
  }
  inline CreateCloudWatchAlarmTemplateRequest& WithDatapointsToAlarm(int value) {
    SetDatapointsToAlarm(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * A resource's optional description.
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  CreateCloudWatchAlarmTemplateRequest& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The number of periods over which data is compared to the specified threshold.
   */
  inline int GetEvaluationPeriods() const { return m_evaluationPeriods; }
  inline bool EvaluationPeriodsHasBeenSet() const { return m_evaluationPeriodsHasBeenSet; }
  inline void SetEvaluationPeriods(int value) {
    m_evaluationPeriodsHasBeenSet = true;
    m_evaluationPeriods = value;
  }
  inline CreateCloudWatchAlarmTemplateRequest& WithEvaluationPeriods(int value) {
    SetEvaluationPeriods(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * A cloudwatch alarm template group's identifier. Can be either be its id or
   * current name.
   */
  inline const Aws::String& GetGroupIdentifier() const { return m_groupIdentifier; }
  inline bool GroupIdentifierHasBeenSet() const { return m_groupIdentifierHasBeenSet; }
  template <typename GroupIdentifierT = Aws::String>
  void SetGroupIdentifier(GroupIdentifierT&& value) {
    m_groupIdentifierHasBeenSet = true;
    m_groupIdentifier = std::forward<GroupIdentifierT>(value);
  }
  template <typename GroupIdentifierT = Aws::String>
  CreateCloudWatchAlarmTemplateRequest& WithGroupIdentifier(GroupIdentifierT&& value) {
    SetGroupIdentifier(std::forward<GroupIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The name of the metric associated with the alarm. Must be compatible with
   * targetResourceType.
   */
  inline const Aws::String& GetMetricName() const { return m_metricName; }
  inline bool MetricNameHasBeenSet() const { return m_metricNameHasBeenSet; }
  template <typename MetricNameT = Aws::String>
  void SetMetricName(MetricNameT&& value) {
    m_metricNameHasBeenSet = true;
    m_metricName = std::forward<MetricNameT>(value);
  }
  template <typename MetricNameT = Aws::String>
  CreateCloudWatchAlarmTemplateRequest& WithMetricName(MetricNameT&& value) {
    SetMetricName(std::forward<MetricNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * A resource's name. Names must be unique within the scope of a resource type in a
   * specific region.
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  CreateCloudWatchAlarmTemplateRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The period, in seconds, over which the specified statistic is applied.
   */
  inline int GetPeriod() const { return m_period; }
  inline bool PeriodHasBeenSet() const { return m_periodHasBeenSet; }
  inline void SetPeriod(int value) {
    m_periodHasBeenSet = true;
    m_period = value;
  }
  inline CreateCloudWatchAlarmTemplateRequest& WithPeriod(int value) {
    SetPeriod(value);
    return *this;
  }
  ///@}

  ///@{

  inline CloudWatchAlarmTemplateStatistic GetStatistic() const { return m_statistic; }
  inline bool StatisticHasBeenSet() const { return m_statisticHasBeenSet; }
  inline void SetStatistic(CloudWatchAlarmTemplateStatistic value) {
    m_statisticHasBeenSet = true;
    m_statistic = value;
  }
  inline CreateCloudWatchAlarmTemplateRequest& WithStatistic(CloudWatchAlarmTemplateStatistic value) {
    SetStatistic(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  CreateCloudWatchAlarmTemplateRequest& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  CreateCloudWatchAlarmTemplateRequest& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline CloudWatchAlarmTemplateTargetResourceType GetTargetResourceType() const { return m_targetResourceType; }
  inline bool TargetResourceTypeHasBeenSet() const { return m_targetResourceTypeHasBeenSet; }
  inline void SetTargetResourceType(CloudWatchAlarmTemplateTargetResourceType value) {
    m_targetResourceTypeHasBeenSet = true;
    m_targetResourceType = value;
  }
  inline CreateCloudWatchAlarmTemplateRequest& WithTargetResourceType(CloudWatchAlarmTemplateTargetResourceType value) {
    SetTargetResourceType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * The threshold value to compare with the specified statistic.
   */
  inline double GetThreshold() const { return m_threshold; }
  inline bool ThresholdHasBeenSet() const { return m_thresholdHasBeenSet; }
  inline void SetThreshold(double value) {
    m_thresholdHasBeenSet = true;
    m_threshold = value;
  }
  inline CreateCloudWatchAlarmTemplateRequest& WithThreshold(double value) {
    SetThreshold(value);
    return *this;
  }
  ///@}

  ///@{

  inline CloudWatchAlarmTemplateTreatMissingData GetTreatMissingData() const { return m_treatMissingData; }
  inline bool TreatMissingDataHasBeenSet() const { return m_treatMissingDataHasBeenSet; }
  inline void SetTreatMissingData(CloudWatchAlarmTemplateTreatMissingData value) {
    m_treatMissingDataHasBeenSet = true;
    m_treatMissingData = value;
  }
  inline CreateCloudWatchAlarmTemplateRequest& WithTreatMissingData(CloudWatchAlarmTemplateTreatMissingData value) {
    SetTreatMissingData(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * An ID that you assign to a create request. This ID ensures idempotency when
   * creating resources.
   */
  inline const Aws::String& GetRequestId() const { return m_requestId; }
  inline bool RequestIdHasBeenSet() const { return m_requestIdHasBeenSet; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateCloudWatchAlarmTemplateRequest& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  CloudWatchAlarmTemplateComparisonOperator m_comparisonOperator{CloudWatchAlarmTemplateComparisonOperator::NOT_SET};

  int m_datapointsToAlarm{0};

  Aws::String m_description;

  int m_evaluationPeriods{0};

  Aws::String m_groupIdentifier;

  Aws::String m_metricName;

  Aws::String m_name;

  int m_period{0};

  CloudWatchAlarmTemplateStatistic m_statistic{CloudWatchAlarmTemplateStatistic::NOT_SET};

  Aws::Map<Aws::String, Aws::String> m_tags;

  CloudWatchAlarmTemplateTargetResourceType m_targetResourceType{CloudWatchAlarmTemplateTargetResourceType::NOT_SET};

  double m_threshold{0.0};

  CloudWatchAlarmTemplateTreatMissingData m_treatMissingData{CloudWatchAlarmTemplateTreatMissingData::NOT_SET};

  Aws::String m_requestId{Aws::Utils::UUID::PseudoRandomUUID()};
  bool m_comparisonOperatorHasBeenSet = false;
  bool m_datapointsToAlarmHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_evaluationPeriodsHasBeenSet = false;
  bool m_groupIdentifierHasBeenSet = false;
  bool m_metricNameHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_periodHasBeenSet = false;
  bool m_statisticHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_targetResourceTypeHasBeenSet = false;
  bool m_thresholdHasBeenSet = false;
  bool m_treatMissingDataHasBeenSet = false;
  bool m_requestIdHasBeenSet = true;
};

}  // namespace Model
}  // namespace MediaLive
}  // namespace Aws
