﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appflow/Appflow_EXPORTS.h>
#include <aws/appflow/model/ConnectorOAuthRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Appflow {
namespace Model {

/**
 * <p> The connector-specific profile credentials required by Marketo.
 * </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/MarketoConnectorProfileCredentials">AWS
 * API Reference</a></p>
 */
class MarketoConnectorProfileCredentials {
 public:
  AWS_APPFLOW_API MarketoConnectorProfileCredentials() = default;
  AWS_APPFLOW_API MarketoConnectorProfileCredentials(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPFLOW_API MarketoConnectorProfileCredentials& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPFLOW_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The identifier for the desired client. </p>
   */
  inline const Aws::String& GetClientId() const { return m_clientId; }
  inline bool ClientIdHasBeenSet() const { return m_clientIdHasBeenSet; }
  template <typename ClientIdT = Aws::String>
  void SetClientId(ClientIdT&& value) {
    m_clientIdHasBeenSet = true;
    m_clientId = std::forward<ClientIdT>(value);
  }
  template <typename ClientIdT = Aws::String>
  MarketoConnectorProfileCredentials& WithClientId(ClientIdT&& value) {
    SetClientId(std::forward<ClientIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The client secret used by the OAuth client to authenticate to the
   * authorization server. </p>
   */
  inline const Aws::String& GetClientSecret() const { return m_clientSecret; }
  inline bool ClientSecretHasBeenSet() const { return m_clientSecretHasBeenSet; }
  template <typename ClientSecretT = Aws::String>
  void SetClientSecret(ClientSecretT&& value) {
    m_clientSecretHasBeenSet = true;
    m_clientSecret = std::forward<ClientSecretT>(value);
  }
  template <typename ClientSecretT = Aws::String>
  MarketoConnectorProfileCredentials& WithClientSecret(ClientSecretT&& value) {
    SetClientSecret(std::forward<ClientSecretT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The credentials used to access protected Marketo resources. </p>
   */
  inline const Aws::String& GetAccessToken() const { return m_accessToken; }
  inline bool AccessTokenHasBeenSet() const { return m_accessTokenHasBeenSet; }
  template <typename AccessTokenT = Aws::String>
  void SetAccessToken(AccessTokenT&& value) {
    m_accessTokenHasBeenSet = true;
    m_accessToken = std::forward<AccessTokenT>(value);
  }
  template <typename AccessTokenT = Aws::String>
  MarketoConnectorProfileCredentials& WithAccessToken(AccessTokenT&& value) {
    SetAccessToken(std::forward<AccessTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The OAuth requirement needed to request security tokens from the connector
   * endpoint. </p>
   */
  inline const ConnectorOAuthRequest& GetOAuthRequest() const { return m_oAuthRequest; }
  inline bool OAuthRequestHasBeenSet() const { return m_oAuthRequestHasBeenSet; }
  template <typename OAuthRequestT = ConnectorOAuthRequest>
  void SetOAuthRequest(OAuthRequestT&& value) {
    m_oAuthRequestHasBeenSet = true;
    m_oAuthRequest = std::forward<OAuthRequestT>(value);
  }
  template <typename OAuthRequestT = ConnectorOAuthRequest>
  MarketoConnectorProfileCredentials& WithOAuthRequest(OAuthRequestT&& value) {
    SetOAuthRequest(std::forward<OAuthRequestT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_clientId;

  Aws::String m_clientSecret;

  Aws::String m_accessToken;

  ConnectorOAuthRequest m_oAuthRequest;
  bool m_clientIdHasBeenSet = false;
  bool m_clientSecretHasBeenSet = false;
  bool m_accessTokenHasBeenSet = false;
  bool m_oAuthRequestHasBeenSet = false;
};

}  // namespace Model
}  // namespace Appflow
}  // namespace Aws
