/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.media.j3d.Canvas3D;

class EventCatcher
implements ComponentListener,
FocusListener,
KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
WindowListener {
    private Canvas3D canvas;
    private static final boolean DEBUG = false;
    private boolean stopped = false;
    private boolean focusEvents = false;
    private boolean keyEvents = false;
    private boolean mouseEvents = false;
    private boolean mouseMotionEvents = false;
    private boolean mouseWheelEvents = false;
    private boolean mouseListenerAdded = false;

    EventCatcher(Canvas3D canvas3D) {
        this.canvas = canvas3D;
    }

    void enableFocusEvents() {
        if (!this.focusEvents) {
            this.canvas.addFocusListener(this);
            this.focusEvents = true;
        }
    }

    void disableFocusEvents() {
        if (this.focusEvents) {
            this.canvas.removeFocusListener(this);
            this.focusEvents = false;
        }
    }

    void enableKeyEvents() {
        if (!this.keyEvents) {
            this.canvas.addKeyListener(this);
            this.keyEvents = true;
            if (!this.mouseListenerAdded) {
                this.canvas.addMouseListener(this);
                this.mouseListenerAdded = true;
            }
        }
    }

    void disableKeyEvents() {
        if (this.keyEvents) {
            this.canvas.removeKeyListener(this);
            this.keyEvents = false;
            if (!this.mouseEvents && this.mouseListenerAdded) {
                this.canvas.removeMouseListener(this);
                this.mouseListenerAdded = false;
            }
        }
    }

    void enableMouseEvents() {
        if (!this.mouseEvents) {
            this.mouseEvents = true;
            if (!this.mouseListenerAdded) {
                this.canvas.addMouseListener(this);
                this.mouseListenerAdded = true;
            }
        }
    }

    void disableMouseEvents() {
        if (this.mouseEvents) {
            this.mouseEvents = false;
            if (!this.keyEvents && this.mouseListenerAdded) {
                this.canvas.removeMouseListener(this);
                this.mouseListenerAdded = false;
            }
        }
    }

    void enableMouseMotionEvents() {
        if (!this.mouseMotionEvents) {
            this.canvas.addMouseMotionListener(this);
            this.mouseMotionEvents = true;
        }
    }

    void disableMouseMotionEvents() {
        if (this.mouseMotionEvents) {
            this.canvas.removeMouseMotionListener(this);
            this.mouseMotionEvents = false;
        }
    }

    void enableMouseWheelEvents() {
        if (!this.mouseWheelEvents) {
            this.canvas.addMouseWheelListener(this);
            this.mouseWheelEvents = true;
        }
    }

    void disableMouseWheelEvents() {
        if (this.mouseWheelEvents) {
            this.canvas.removeMouseWheelListener(this);
            this.mouseWheelEvents = false;
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (componentEvent.getSource() == this.canvas) {
            this.canvas.sendEventToBehaviorScheduler(componentEvent);
            this.canvas.evaluateVisiblilty();
            this.canvas.redraw();
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (componentEvent.getSource() == this.canvas) {
            this.canvas.sendEventToBehaviorScheduler(componentEvent);
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        if (componentEvent.getSource() == this.canvas) {
            this.canvas.sendEventToBehaviorScheduler(componentEvent);
        }
        this.canvas.evaluateVisiblilty();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (componentEvent.getSource() == this.canvas) {
            this.canvas.sendEventToBehaviorScheduler(componentEvent);
        }
        this.canvas.evaluateVisiblilty();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.canvas.sendEventToBehaviorScheduler(focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.canvas.sendEventToBehaviorScheduler(focusEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.canvas.sendEventToBehaviorScheduler(keyEvent);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.canvas.sendEventToBehaviorScheduler(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.canvas.sendEventToBehaviorScheduler(keyEvent);
        this.stopped = !this.stopped;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(mouseEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseEvents) {
            this.canvas.sendEventToBehaviorScheduler(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.canvas.sendEventToBehaviorScheduler(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.canvas.sendEventToBehaviorScheduler(mouseEvent);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.canvas.sendEventToBehaviorScheduler(mouseWheelEvent);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.canvas.sendEventToBehaviorScheduler(windowEvent);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.canvas.sendEventToBehaviorScheduler(windowEvent);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.canvas.sendEventToBehaviorScheduler(windowEvent);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        this.canvas.sendEventToBehaviorScheduler(windowEvent);
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
        this.canvas.sendEventToBehaviorScheduler(windowEvent);
        if (this.canvas.view != null) {
            this.canvas.view.sendEventToSoundScheduler(windowEvent);
        }
        this.canvas.evaluateVisiblilty();
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        this.canvas.sendEventToBehaviorScheduler(windowEvent);
        if (this.canvas.view != null) {
            this.canvas.view.sendEventToSoundScheduler(windowEvent);
        }
        this.canvas.evaluateVisiblilty();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.canvas.sendEventToBehaviorScheduler(windowEvent);
        this.canvas.evaluateVisiblilty();
    }

    void reset() {
        this.focusEvents = false;
        this.keyEvents = false;
        this.mouseEvents = false;
        this.mouseMotionEvents = false;
        this.mouseWheelEvents = false;
        this.mouseListenerAdded = false;
        this.stopped = false;
    }
}

