/// \file
/// \ingroup tutorial_tree
/// \notebook -nodraw
/// Copy a subset of a Tree to a new Tree
///
/// The input file has been generated by the program in `$ROOTSYS/test/Event`
/// with `Event 1000 1 1 1`.
///
/// \macro_code
///
/// \author Rene Brun

#ifdef ACTUAL_RUN  // -------- Second pass: dictionary already built --------

#include "./Event.h"  // now safe to include Event, its dictionary is loaded

void run()
{
   TFile oldfile("tree108.root");
   TTree *oldtree;
   oldfile.GetObject("t4", oldtree);

   // Deactivate all branches
   oldtree->SetBranchStatus("*", 0);

   // Activate only four of them
   for (auto activeBranchName : {"event_split", "fNtrack", "fNseg", "fH"})
      oldtree->SetBranchStatus(activeBranchName, 1);

   // Create a new file + a clone of old tree in new file
   TFile newfile("tree110.root", "recreate");
   auto newtree = oldtree->CloneTree();

   newtree->Print();
   newfile.Write();
}

#else  // -------- First pass: build dictionary + rerun macro --------

void tree110_copy()
{
   TString tutdir = gROOT->GetTutorialDir();
   gROOT->ProcessLine(".L " + tutdir + "/io/tree/Event.cxx+");
   gROOT->ProcessLine("#define ACTUAL_RUN yes");
   gROOT->ProcessLine("#include \"" __FILE__ "\"");
   gROOT->ProcessLine("run()");
}

#endif
