/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class ObjectPropertyDefinitionExtractor {
    @Nonnull
    private final OWLObjectProperty property;
    @Nonnull
    private final OWLOntology ontology;
    @Nonnull
    private final OWLDataFactory dataFactory;

    public ObjectPropertyDefinitionExtractor(@Nonnull OWLObjectProperty property, @Nonnull OWLOntology ontology, @Nonnull OWLDataFactory dataFactory) {
        this.property = (OWLObjectProperty)Preconditions.checkNotNull((Object)property);
        this.ontology = (OWLOntology)Preconditions.checkNotNull((Object)ontology);
        this.dataFactory = (OWLDataFactory)Preconditions.checkNotNull((Object)dataFactory);
    }

    public Set<OWLAxiom> getDefiningAxioms() {
        return Stream.concat(this.getUnaryAxioms(), this.ontology.getDisjointObjectPropertiesAxioms((OWLObjectPropertyExpression)this.property).stream()).collect(Collectors.toSet());
    }

    private Stream<OWLAxiom> getUnaryAxioms() {
        return Stream.of(this.ontology.getObjectSubPropertyAxiomsForSubProperty((OWLObjectPropertyExpression)this.property), this.ontology.getEquivalentObjectPropertiesAxioms((OWLObjectPropertyExpression)this.property), this.ontology.getFunctionalObjectPropertyAxioms((OWLObjectPropertyExpression)this.property), this.ontology.getInverseFunctionalObjectPropertyAxioms((OWLObjectPropertyExpression)this.property), this.ontology.getSymmetricObjectPropertyAxioms((OWLObjectPropertyExpression)this.property), this.ontology.getTransitiveObjectPropertyAxioms((OWLObjectPropertyExpression)this.property), this.ontology.getAsymmetricObjectPropertyAxioms((OWLObjectPropertyExpression)this.property), this.ontology.getReflexiveObjectPropertyAxioms((OWLObjectPropertyExpression)this.property), this.ontology.getIrreflexiveObjectPropertyAxioms((OWLObjectPropertyExpression)this.property), this.ontology.getObjectPropertyDomainAxioms((OWLObjectPropertyExpression)this.property), this.ontology.getObjectPropertyRangeAxioms((OWLObjectPropertyExpression)this.property)).flatMap(Collection::stream);
    }

    public List<OWLOntologyChange> getChangesToRemoveDefinition() {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        this.getUnaryAxioms().forEach(ax -> changes.add((OWLOntologyChange)new RemoveAxiom(this.ontology, ax)));
        this.ontology.getDisjointObjectPropertiesAxioms((OWLObjectPropertyExpression)this.property).forEach(ax -> {
            changes.add((OWLOntologyChange)new RemoveAxiom(this.ontology, (OWLAxiom)ax));
            if (ax.getProperties().size() > 2) {
                OWLDisjointObjectPropertiesAxiom replacement = this.dataFactory.getOWLDisjointObjectPropertiesAxiom(ax.getPropertiesMinus((OWLPropertyExpression)this.property), ax.getAnnotations());
                changes.add((OWLOntologyChange)new RemoveAxiom(this.ontology, (OWLAxiom)replacement));
            }
        });
        return changes;
    }
}

