/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc.store;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.misc.store.ByteTrackingIndexOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;

public final class ByteWritesTrackingDirectoryWrapper
extends FilterDirectory {
    private final AtomicLong flushedBytes = new AtomicLong();
    private final AtomicLong mergedBytes = new AtomicLong();
    public final boolean trackTempOutput;

    public ByteWritesTrackingDirectoryWrapper(Directory in) {
        this(in, false);
    }

    public ByteWritesTrackingDirectoryWrapper(Directory in, boolean trackTempOutput) {
        super(in);
        this.trackTempOutput = trackTempOutput;
    }

    public IndexOutput createOutput(String name, IOContext ioContext) throws IOException {
        IndexOutput output = this.in.createOutput(name, ioContext);
        return this.createByteTrackingOutput(output, ioContext.context());
    }

    public IndexOutput createTempOutput(String prefix, String suffix, IOContext ioContext) throws IOException {
        IndexOutput output = this.in.createTempOutput(prefix, suffix, ioContext);
        return this.trackTempOutput ? this.createByteTrackingOutput(output, ioContext.context()) : output;
    }

    private IndexOutput createByteTrackingOutput(IndexOutput output, IOContext.Context context) {
        switch (context) {
            case FLUSH: {
                return new ByteTrackingIndexOutput(output, this.flushedBytes);
            }
            case MERGE: {
                return new ByteTrackingIndexOutput(output, this.mergedBytes);
            }
        }
        return output;
    }

    public long getFlushedBytes() {
        return this.flushedBytes.get();
    }

    public long getMergedBytes() {
        return this.mergedBytes.get();
    }
}

