/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.PageInfo;

public class CompilerHacks {
    private static final Logger LOGGER = Logger.getLogger(CompilerHacks.class.getName());
    private Compiler comp;
    private final JspCompilationContext ctxt;
    private static Field pageInfoF;
    private static Field errDispatcherF;

    public CompilerHacks(JspCompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    static void initMethodsAndFields() {
        try {
            pageInfoF = Compiler.class.getDeclaredField("pageInfo");
            pageInfoF.setAccessible(true);
            errDispatcherF = Compiler.class.getDeclaredField("errDispatcher");
            errDispatcherF.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            LOGGER.log(Level.INFO, null, e);
        }
    }

    private synchronized void setupCompiler() throws JasperException {
        if (this.comp == null) {
            this.comp = this.ctxt.createParser();
            CompilerHacks.setErrDispatcherInCompiler(this.comp, new ErrorDispatcher(false));
            this.comp.setPageInfo((PageInfo)new HackPageInfo(new BeanRepository(this.ctxt.getClassLoader(), this.comp.getErrorDispatcher()), this.ctxt.getJspFile()));
        }
    }

    Compiler getCompiler() throws JasperException {
        this.setupCompiler();
        return this.comp;
    }

    private static void setErrDispatcherInCompiler(Compiler c, ErrorDispatcher errDispatcher) throws JasperException {
        try {
            errDispatcherF.set(c, errDispatcher);
        }
        catch (IllegalAccessException e) {
            throw new JasperException((Throwable)e);
        }
    }

    static {
        CompilerHacks.initMethodsAndFields();
    }

    static final class HackPageInfo
    extends PageInfo {
        private final Map<String, String> approxXmlPrefixMapper = new HashMap<String, String>();

        HackPageInfo(BeanRepository beanRepository, String jspFile) {
            super(beanRepository, jspFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pushPrefixMapping(String prefix, String uri) {
            super.pushPrefixMapping(prefix, uri);
            if (uri != null) {
                Map<String, String> map = this.approxXmlPrefixMapper;
                synchronized (map) {
                    this.approxXmlPrefixMapper.put(prefix, uri);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Map<String, String> getApproxXmlPrefixMapper() {
            Map<String, String> map = this.approxXmlPrefixMapper;
            synchronized (map) {
                return this.approxXmlPrefixMapper;
            }
        }
    }
}

