/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ActionUtils;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.update.FileUpdateInfo;
import org.netbeans.modules.subversion.ui.update.UpdateResults;
import org.netbeans.modules.subversion.util.ClientCheckSupport;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningOutputManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class UpdateAction
extends ContextAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/subversion/resources/icons/update.png";
    private static final int STATUS_RECURSIVELY_TRAVERSIBLE = -4;

    public UpdateAction() {
        this(ICON_RESOURCE);
    }

    protected UpdateAction(String iconResource) {
        super(iconResource);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Update";
    }

    @Override
    protected int getFileEnabledStatus() {
        return 90108;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performContextAction(final Node[] nodes) {
        ClientCheckSupport.getInstance().runInAWTIfAvailable(ActionUtils.cutAmpersand(this.getRunningName(nodes)), new Runnable(){
            final /* synthetic */ UpdateAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.performUpdate(nodes);
            }
        });
    }

    void performUpdate(final Node[] nodes) {
        final Context ctx = this.getContext(nodes);
        if (ctx.getRootFiles().length == 0) {
            Subversion.LOG.info("UpdateAction.performUpdate: context is empty, some files may be unversioned.");
            return;
        }
        final SVNRevision revision = this.getRevision(ctx);
        if (revision == null) {
            return;
        }
        final ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, this, nodes, ctx){
            final /* synthetic */ UpdateAction this$0;
            {
                this.this$0 = this$0;
                super(action, nodes2, ctx2);
            }

            @Override
            public void perform() {
                this.this$0.update(ctx, this, this.this$0.getContextDisplayName(nodes), revision);
            }
        };
        Utils.post((Runnable)new Runnable(){
            final /* synthetic */ UpdateAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                support.start(this.this$0.createRequestProcessor(ctx));
            }
        });
    }

    protected SVNRevision getRevision(Context ctx) {
        return SVNRevision.HEAD;
    }

    private void update(Context ctx, SvnProgressSupport progress, String contextDisplayName, SVNRevision revision) {
        File[] roots = ctx.getRootFiles();
        HashMap<File, ArrayList<File>> rootsPerCheckout = new HashMap<File, ArrayList<File>>();
        for (File root : roots) {
            File topManaged = Subversion.getInstance().getTopmostManagedAncestor(root);
            if (topManaged == null) continue;
            ArrayList<File> files = (ArrayList<File>)rootsPerCheckout.get(topManaged);
            if (files == null) {
                files = new ArrayList<File>();
                rootsPerCheckout.put(topManaged, files);
            }
            files.add(root);
        }
        if (rootsPerCheckout.isEmpty()) {
            return;
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        cache.refreshCached(ctx);
        for (Map.Entry e : rootsPerCheckout.entrySet()) {
            List files = (List)e.getValue();
            try {
                File root;
                SVNUrl repositoryUrl;
                if (rootsPerCheckout.size() > 1) {
                    contextDisplayName = this.getContextDisplayName(files);
                }
                if ((repositoryUrl = SvnUtils.getRepositoryRootUrl(root = (File)files.get(0))) == null) {
                    Subversion.LOG.log(Level.WARNING, "Could not retrieve repository root for context file {0}", new Object[]{root});
                    continue;
                }
                UpdateAction.update((File)e.getKey(), files.toArray(new File[0]), progress, contextDisplayName, repositoryUrl, revision);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void update(File checkoutRoot, File[] roots, final SvnProgressSupport progress, String contextDisplayName, SVNUrl repositoryUrl, final SVNRevision revision) {
        UpdateNotifyListener l;
        SvnClient client;
        UpdateOutputListener listener;
        block14: {
            int i;
            File[][] split = Utils.splitFlatOthers((File[])roots);
            final ArrayList<File> recursiveFiles = new ArrayList<File>();
            final ArrayList<File> flatFiles = new ArrayList<File>();
            for (i = 0; i < split[1].length; ++i) {
                recursiveFiles.add(split[1][i]);
            }
            for (i = 0; i < split[0].length; ++i) {
                flatFiles.add(split[0][i]);
            }
            listener = new UpdateOutputListener();
            try {
                client = Subversion.getInstance().getClient(repositoryUrl);
                client.removeNotifyListener(Subversion.getInstance().getRefreshHandler());
                client.addNotifyListener(listener);
                client.addNotifyListener(progress);
                progress.setCancellableDelegate(client);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                return;
            }
            l = new UpdateNotifyListener();
            client.addNotifyListener(l);
            SvnUtils.runWithoutIndexing(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    UpdateAction.updateRoots(recursiveFiles, progress, client, true, revision);
                    if (progress.isCanceled()) {
                        return null;
                    }
                    UpdateAction.updateRoots(flatFiles, progress, client, false, revision);
                    return null;
                }
            }, roots);
            if (!progress.isCanceled()) break block14;
            client.removeNotifyListener(l);
            client.removeNotifyListener(progress);
            UpdateAction.openResults(listener.getResults(), repositoryUrl, contextDisplayName, checkoutRoot == null ? "" : checkoutRoot.getAbsolutePath());
            return;
        }
        try {
            block16: {
                break block16;
                {
                    catch (Throwable throwable) {
                        client.removeNotifyListener(l);
                        client.removeNotifyListener(progress);
                        throw throwable;
                    }
                }
            }
            client.removeNotifyListener(l);
            client.removeNotifyListener(progress);
            if (!l.existedFiles.isEmpty() || !l.conflictedFiles.isEmpty()) {
                HashSet<File> filesToRefresh = new HashSet<File>(l.existedFiles);
                filesToRefresh.addAll(l.conflictedFiles);
                Subversion.getInstance().getStatusCache().refreshAsync(filesToRefresh.toArray(new File[0]));
            }
            if (!l.conflictedFiles.isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(UpdateAction.class, (String)"MSG_UpdateCausedConflicts_Prompt"), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                });
            } else {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(UpdateAction.class, (String)"MSG_Update_Completed"));
            }
            UpdateAction.openResults(listener.getResults(), repositoryUrl, contextDisplayName, checkoutRoot == null ? "" : checkoutRoot.getAbsolutePath());
        }
        catch (SVNClientException e1) {
            try {
                progress.annotate(e1);
                UpdateAction.openResults(listener.getResults(), repositoryUrl, contextDisplayName, checkoutRoot == null ? "" : checkoutRoot.getAbsolutePath());
            }
            catch (Throwable throwable) {
                UpdateAction.openResults(listener.getResults(), repositoryUrl, contextDisplayName, checkoutRoot == null ? "" : checkoutRoot.getAbsolutePath());
                throw throwable;
            }
        }
    }

    private static void openResults(final List<FileUpdateInfo> resultsList, final SVNUrl url, final String contextDisplayName, final String checkoutRoot) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UpdateResults results = new UpdateResults(resultsList, url, contextDisplayName);
                VersioningOutputManager vom = VersioningOutputManager.getInstance();
                vom.addComponent(SvnUtils.decodeToString(url) + "-UpdateExecutor-" + checkoutRoot, (JComponent)results);
            }
        });
    }

    private static void updateRoots(List<File> roots, SvnProgressSupport support, SvnClient client, boolean recursive, SVNRevision revision) throws SVNClientException {
        for (File root : roots) {
            if (support.isCanceled()) break;
            long rev = client.update(root, revision == null ? SVNRevision.HEAD : revision, recursive);
            UpdateAction.revisionUpdateWorkaround(recursive, FileUtil.normalizeFile((File)root), client, rev);
        }
    }

    private static void revisionUpdateWorkaround(final boolean recursive, final File root, final SvnClient client, final long revision) throws SVNClientException {
        Utils.post((Runnable)new Runnable(){

            @Override
            public void run() {
                File[] fileArray;
                List filesToRefresh;
                SVNRevision.Number svnRevision = null;
                if (revision < -1L) {
                    ISVNInfo info = null;
                    try {
                        info = SvnUtils.getInfoFromWorkingCopy(client, root);
                        svnRevision = info.getRevision();
                        if (svnRevision == null) {
                            info = client.getInfo(root);
                            svnRevision = info.getRevision();
                        }
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                    }
                } else {
                    svnRevision = new SVNRevision.Number(revision);
                }
                if (recursive) {
                    Subversion.getInstance().getStatusCache().patchRevision(new File[]{root}, svnRevision);
                    int maxItems = 5;
                    filesToRefresh = UpdateAction.patchFilesRecursively(root, svnRevision, maxItems);
                    fileArray = filesToRefresh.size() >= maxItems ? null : filesToRefresh.toArray(new File[0]);
                } else {
                    filesToRefresh = new ArrayList<File>();
                    filesToRefresh.add(root);
                    File[] files = root.listFiles();
                    if (files != null) {
                        filesToRefresh.addAll(Arrays.asList(files));
                    }
                    fileArray = filesToRefresh.toArray(new File[0]);
                    Subversion.getInstance().getStatusCache().patchRevision(fileArray, svnRevision);
                }
                Subversion.getInstance().getStatusCache().getLabelsCache().flushFileLabels(fileArray);
                Subversion.getInstance().refreshAnnotationsAndSidebars(fileArray);
            }
        });
    }

    public static void performUpdate(final Context context, final String contextDisplayName) {
        SVNUrl repository;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        if (context == null || context.getRoots().size() == 0) {
            return;
        }
        try {
            repository = UpdateAction.getSvnUrl(context);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repository);
        SvnProgressSupport support = new SvnProgressSupport(){

            @Override
            public void perform() {
                ((UpdateAction)SystemAction.get(UpdateAction.class)).update(context, this, contextDisplayName, null);
            }
        };
        support.start(rp, repository, NbBundle.getMessage(UpdateAction.class, (String)"MSG_Update_Progress"));
    }

    public static void performUpdate(final File file) {
        SVNUrl repository;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        if (file == null) {
            return;
        }
        try {
            repository = SvnUtils.getRepositoryRootUrl(file);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        final SVNUrl repositoryUrl = repository;
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repositoryUrl);
        SvnProgressSupport support = new SvnProgressSupport(){

            @Override
            public void perform() {
                UpdateAction.update(Subversion.getInstance().getTopmostManagedAncestor(file), new File[]{file}, this, file.getAbsolutePath(), repositoryUrl, null);
            }
        };
        support.start(rp, repositoryUrl, NbBundle.getMessage(UpdateAction.class, (String)"MSG_Update_Progress"));
    }

    private static List<File> patchFilesRecursively(File root, SVNRevision.Number revision, int maxReturnFiles) {
        File[] files;
        ArrayList<File> ret = new ArrayList<File>();
        if (root == null) {
            return ret;
        }
        if (maxReturnFiles > 0) {
            ret.add(root);
        }
        if ((files = root.listFiles()) != null) {
            FileStatusCache cache = Subversion.getInstance().getStatusCache();
            cache.patchRevision(files, revision);
            for (File file : files) {
                FileInformation info = cache.getCachedStatus(file);
                if (SvnUtils.isPartOfSubversionMetadata(file) || SvnUtils.isAdministrative(file) || info != null && (info.getStatus() & 0xFFFFFFFC) == 0) continue;
                if (file.isDirectory()) {
                    ret.addAll(UpdateAction.patchFilesRecursively(file, revision, maxReturnFiles - ret.size()));
                    continue;
                }
                if (maxReturnFiles - ret.size() <= 0) continue;
                ret.add(file);
            }
        }
        return ret;
    }

    private String getContextDisplayName(List<File> files) {
        Node[] nodes = new Node[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            final File file = files.get(i);
            nodes[i] = new AbstractNode(this, Children.LEAF, Lookups.fixed((Object[])new Object[]{file})){
                final /* synthetic */ UpdateAction this$0;
                {
                    this.this$0 = this$0;
                    super(children, lookup);
                }

                public String getName() {
                    return file.getName();
                }
            };
        }
        return this.getContextDisplayName(nodes);
    }

    private static class UpdateOutputListener
    implements ISVNNotifyListener {
        private List<FileUpdateInfo> results;

        private UpdateOutputListener() {
        }

        public void setCommand(int command) {
        }

        public void logCommandLine(String str) {
        }

        public void logMessage(String logMsg) {
            this.catchMessage(logMsg);
        }

        public void logError(String str) {
            if (str == null) {
                return;
            }
            this.catchMessage(str);
        }

        public void logRevision(long rev, String str) {
        }

        public void logCompleted(String str) {
        }

        public void onNotify(File file, SVNNodeKind kind) {
        }

        List<FileUpdateInfo> getResults() {
            if (this.results == null) {
                this.results = new ArrayList<FileUpdateInfo>();
            }
            return this.results;
        }

        private void catchMessage(String logMsg) {
            FileUpdateInfo[] fuis = FileUpdateInfo.createFromLogMsg(logMsg);
            if (fuis != null) {
                for (FileUpdateInfo fui : fuis) {
                    if (fui == null) continue;
                    this.getResults().add(fui);
                }
            }
        }
    }

    private static class UpdateNotifyListener
    implements ISVNNotifyListener {
        private static Pattern conflictFilePattern = Pattern.compile("(C...|.C..|..C.|...C) ?(.+)");
        private static Pattern existedFilePattern = Pattern.compile("E    ?(.+)");
        HashSet<File> conflictedFiles = new HashSet();
        HashSet<File> existedFiles = new HashSet();

        private UpdateNotifyListener() {
        }

        public void logMessage(String msg) {
            this.catchMessage(msg);
        }

        public void logError(String msg) {
            if (msg == null) {
                return;
            }
            this.catchMessage(msg);
        }

        public void setCommand(int arg0) {
        }

        public void logCommandLine(String arg0) {
        }

        public void logRevision(long arg0, String arg1) {
        }

        public void logCompleted(String arg0) {
        }

        public void onNotify(File arg0, SVNNodeKind arg1) {
        }

        private void catchMessage(String message) {
            Matcher m = conflictFilePattern.matcher(message);
            if (m.matches() && m.groupCount() > 1) {
                String filePath = m.group(2);
                this.conflictedFiles.add(FileUtil.normalizeFile((File)new File(filePath)));
            } else {
                m = existedFilePattern.matcher(message);
                if (m.matches() && m.groupCount() > 0) {
                    String filePath = m.group(1);
                    this.existedFiles.add(FileUtil.normalizeFile((File)new File(filePath)));
                }
            }
        }
    }
}

