/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.queries;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.queries.SourceJavadocAttacher;
import org.netbeans.modules.java.j2seplatform.queries.Bundle;
import org.netbeans.modules.java.j2seplatform.queries.QueriesCache;
import org.netbeans.modules.java.j2seplatform.queries.SourceJavadocAttacherUtil;
import org.netbeans.spi.java.queries.SourceJavadocAttacherImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;

public class DefaultSourceJavadocAttacher
implements SourceJavadocAttacherImplementation {
    private static File currentFolder;

    public boolean attachSources(@NonNull URL root, @NonNull SourceJavadocAttacher.AttachmentListener listener) throws IOException {
        return this.attach(root, listener, 0);
    }

    public boolean attachJavadoc(@NonNull URL root, @NonNull SourceJavadocAttacher.AttachmentListener listener) throws IOException {
        return this.attach(root, listener, 1);
    }

    private boolean attach(final @NonNull URL root, final @NonNull SourceJavadocAttacher.AttachmentListener listener, final int mode) throws IOException {
        Runnable call = new Runnable(){
            final /* synthetic */ DefaultSourceJavadocAttacher this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean success = false;
                try {
                    List currentRoots;
                    QueriesCache<QueriesCache.ResultBase> cache;
                    switch (mode) {
                        case 0: {
                            cache = QueriesCache.getSources();
                            break;
                        }
                        case 1: {
                            cache = QueriesCache.getJavadoc();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(Integer.toString(mode));
                        }
                    }
                    QueriesCache.ResultBase rb = cache.getRoots().get(root);
                    if (rb == null) {
                        currentRoots = Collections.emptyList();
                    } else {
                        currentRoots = new ArrayList();
                        currentRoots.addAll(rb.getRootURIs());
                    }
                    URL[] toAttach = DefaultSourceJavadocAttacher.selectRoots(root, currentRoots, mode);
                    if (toAttach != null) {
                        FileObject[] queryRoots = SourceForBinaryQuery.findSourceRoots((URL)root).getRoots();
                        ArrayList<FileObject> filesToAttach = new ArrayList<FileObject>();
                        boolean allMatches = true;
                        for (URL u : toAttach) {
                            FileObject f = URLMapper.findFileObject((URL)u);
                            if (f == null) {
                                allMatches = false;
                                break;
                            }
                            filesToAttach.add(f);
                        }
                        if (allMatches) {
                            allMatches = Arrays.asList(queryRoots).containsAll(filesToAttach);
                        }
                        if (!allMatches) {
                            cache.updateRoot(root, toAttach);
                        }
                        success = true;
                    }
                }
                catch (MalformedURLException | FileStateInvalidException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                finally {
                    SourceJavadocAttacherUtil.callListener(listener, success);
                }
            }
        };
        Mutex.EVENT.writeAccess(call);
        return true;
    }

    private static URL[] selectRoots(@NonNull URL root, @NonNull List<? extends URI> attachedRoots, int mode) throws MalformedURLException, FileStateInvalidException {
        List<? extends URI> selected;
        File[] cfh = new File[]{currentFolder};
        if (mode == 0) {
            selected = SourceJavadocAttacherUtil.selectSources(root, attachedRoots, SourceJavadocAttacherUtil.createDefaultBrowseCall(Bundle.TXT_Title(), Bundle.TXT_Sources(), cfh), SourceJavadocAttacherUtil.createDefaultURIConvertor(true), Lookup.getDefault().lookupAll(SourceJavadocAttacherImplementation.Definer.class));
        } else if (mode == 1) {
            selected = SourceJavadocAttacherUtil.selectJavadoc(root, attachedRoots, SourceJavadocAttacherUtil.createDefaultBrowseCall(Bundle.TXT_Title(), Bundle.TXT_Javadoc(), cfh), SourceJavadocAttacherUtil.createDefaultURIConvertor(false), Lookup.getDefault().lookupAll(SourceJavadocAttacherImplementation.Definer.class));
        } else {
            throw new IllegalStateException(Integer.toString(mode));
        }
        if (selected == null) {
            return null;
        }
        currentFolder = cfh[0];
        URL[] result = new URL[selected.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = selected.get(i).toURL();
        }
        return result;
    }
}

