/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.awt.Image;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.layers.Bundle;
import org.netbeans.modules.apisupport.project.layers.LayerFileSystem;
import org.netbeans.modules.apisupport.project.layers.LayerFilterNode;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.layers.OpenLayerFilesAction;
import org.netbeans.modules.apisupport.project.layers.PickIconAction;
import org.netbeans.modules.apisupport.project.layers.PickNameAction;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.ImageDecorator;
import org.openide.filesystems.StatusDecorator;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;
import org.openide.xml.XMLUtil;

public final class LayerNode
extends FilterNode
implements Node.Cookie {
    private final boolean specialDisplayName;

    public LayerNode(LayerHandle handle) {
        this(LayerNode.getDataNode(handle), handle, true);
    }

    LayerNode(Node delegate, LayerHandle handle, boolean specialDisplayName) {
        super(delegate, FilterNode.Children.create((ChildFactory)new LayerChildren(handle), (boolean)true));
        this.specialDisplayName = specialDisplayName;
    }

    private static Node getDataNode(LayerHandle handle) {
        FileObject layer = handle.getLayerFile();
        try {
            return DataObject.find((FileObject)layer).getNodeDelegate();
        }
        catch (DataObjectNotFoundException e) {
            assert (false) : e;
            return Node.EMPTY;
        }
    }

    private static FileSystem badge(final @NonNull FileSystem base, final @NonNull FileObject layer, final @NonNull String rootLabel, final @NullAllowed FileSystem highlighted) {
        class BadgingMergedFileSystem
        extends LayerFileSystem {
            BadgingMergedFileSystem() {
                super(new FileSystem[]{fileSystem});
                this.setPropagateMasks(true);
                this.status.addFileStatusListener(new FileStatusListener(){

                    public void annotationChanged(FileStatusEvent ev) {
                        this.fireFileStatusChanged(ev);
                    }
                });
                this.addFileChangeListener(new FileChangeListener(){

                    private void fire() {
                        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, true, true));
                    }

                    public void fileAttributeChanged(FileAttributeEvent fe) {
                        this.fire();
                    }

                    public void fileChanged(FileEvent fe) {
                        this.fire();
                    }

                    public void fileDataCreated(FileEvent fe) {
                        this.fire();
                    }

                    public void fileDeleted(FileEvent fe) {
                        this.fire();
                    }

                    public void fileFolderCreated(FileEvent fe) {
                        this.fire();
                    }

                    public void fileRenamed(FileRenameEvent fe) {
                        this.fire();
                    }
                });
            }

            @Override
            public StatusDecorator getDecorator() {
                return new 1BadgingMergedFileSystem.Dec(this, rootLabel, highlighted);
            }

            public String getDisplayName() {
                return FileUtil.getFileDisplayName((FileObject)layer);
            }

            public SystemAction[] getActions(Set<FileObject> foSet) {
                return new SystemAction[]{SystemAction.get(PickNameAction.class), SystemAction.get(PickIconAction.class), SystemAction.get(OpenLayerFilesAction.class)};
            }

            class 1BadgingMergedFileSystem.Dec
            implements StatusDecorator,
            ImageDecorator {
                final /* synthetic */ String val$rootLabel;
                final /* synthetic */ FileSystem val$highlighted;
                final /* synthetic */ BadgingMergedFileSystem this$0;

                /*
                 * WARNING - void declaration
                 */
                1BadgingMergedFileSystem.Dec() {
                    void var1_1;
                    this.val$rootLabel = var2_2;
                    this.val$highlighted = var3_3;
                    this.this$0 = var1_1;
                }

                public String annotateNameHtml(String name, Set<? extends FileObject> files) {
                    String htmlLabel;
                    String nonHtmlLabel = this.this$0.status.annotateName(name, files);
                    if (files.size() == 1 && files.iterator().next().isRoot()) {
                        nonHtmlLabel = this.val$rootLabel;
                    }
                    try {
                        htmlLabel = XMLUtil.toElementContent((String)nonHtmlLabel);
                    }
                    catch (CharConversionException e) {
                        Util.err.notify(1, (Throwable)e);
                        htmlLabel = nonHtmlLabel;
                    }
                    boolean deleted = false;
                    for (FileObject fileObject : files) {
                        if (!fileObject.getNameExt().endsWith("_hidden")) continue;
                        deleted = true;
                        break;
                    }
                    if (this.val$highlighted != null) {
                        boolean local = false;
                        for (FileObject fileObject : files) {
                            if (fileObject.isRoot() || this.val$highlighted.findResource(fileObject.getPath()) == null) continue;
                            local = true;
                            break;
                        }
                        if (local) {
                            htmlLabel = "<b>" + htmlLabel + "</b>";
                        }
                    }
                    if (deleted) {
                        htmlLabel = "<s>" + htmlLabel + "</s>";
                    }
                    return htmlLabel;
                }

                public String annotateName(String name, Set<? extends FileObject> files) {
                    return name;
                }

                public Image annotateIcon(Image icon, int iconType, Set<? extends FileObject> files) {
                    return this.this$0.status.annotateIcon(icon, iconType, files);
                }
            }
        }
        return new BadgingMergedFileSystem();
    }

    public String getDisplayName() {
        if (this.specialDisplayName) {
            return Bundle.LayerNode_label();
        }
        return super.getDisplayName();
    }

    public String getHtmlDisplayName() {
        if (this.specialDisplayName) {
            return null;
        }
        return this.getOriginal().getHtmlDisplayName();
    }

    private static final class LayerChildren
    extends ChildFactory<DataObject> {
        private final LayerHandle handle;

        LayerChildren(LayerHandle handle) {
            this.handle = handle;
        }

        protected boolean createKeys(List<DataObject> keys) {
            this.handle.setAutosave(true);
            FileObject layer = this.handle.getLayerFile();
            if (layer == null) {
                return true;
            }
            Project p = FileOwnerQuery.getOwner((FileObject)layer);
            if (p == null) {
                return true;
            }
            FileSystem layerfs = this.handle.layer(false);
            try {
                LayerHandle h;
                if (layerfs != null) {
                    keys.add(DataObject.find((FileObject)LayerNode.badge(layerfs, this.handle.getLayerFile(), Bundle.LBL_this_layer(), null).getRoot()));
                }
                if (layer.equals((h = LayerHandle.forProject(p)).getLayerFile())) {
                    h.setAutosave(true);
                    keys.add(DataObject.find((FileObject)LayerNode.badge(LayerUtils.getEffectiveSystemFilesystem(p), this.handle.getLayerFile(), Bundle.LBL_this_layer_in_context(), this.handle.layer(false)).getRoot()));
                }
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
            }
            return true;
        }

        protected Node createNodeForKey(DataObject key) {
            return new LayerFilterNode(key.getNodeDelegate());
        }
    }
}

