/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.templates;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class CreateDescriptor {
    public static final String FREE_FILE_EXTENSION = "freeFileExtension";
    public static final String PREFORMATTED_TEMPLATE = "org-netbeans-modules-java-preformattedSource";
    private final FileObject template;
    private final FileObject target;
    private Lookup contextLookup = Lookup.EMPTY;
    String name;
    String proposedName;
    Map<String, Object> parameters;
    Locale locale = Locale.getDefault();
    boolean freeExtension;
    boolean preformatted;

    CreateDescriptor(FileObject template, FileObject target) {
        this.template = template;
        this.target = target;
    }

    @NonNull
    public FileObject getTemplate() {
        return this.template;
    }

    @NonNull
    public FileObject getTarget() {
        return this.target;
    }

    @CheckForNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getProposedName() {
        return this.proposedName != null ? this.proposedName : this.name;
    }

    @NonNull
    public Locale getLocale() {
        return this.locale;
    }

    @CheckForNull
    public <T> T getValue(String n) {
        return (T)this.parameters.get(n);
    }

    @NonNull
    public Map<String, Object> getParameters() {
        return this.parameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.parameters);
    }

    public boolean hasFreeExtension() {
        return this.freeExtension;
    }

    public boolean isPreformatted() {
        return this.preformatted;
    }

    void setLookup(Lookup contextLookup) {
        this.contextLookup = contextLookup;
    }

    public Lookup getLookup() {
        return this.contextLookup;
    }
}

