/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

class ProxySettings {
    public static final String PROXY_HTTP_HOST = "proxyHttpHost";
    public static final String PROXY_HTTP_PORT = "proxyHttpPort";
    public static final String PROXY_HTTPS_HOST = "proxyHttpsHost";
    public static final String PROXY_HTTPS_PORT = "proxyHttpsPort";
    public static final String PROXY_SOCKS_HOST = "proxySocksHost";
    public static final String PROXY_SOCKS_PORT = "proxySocksPort";
    public static final String NOT_PROXY_HOSTS = "proxyNonProxyHosts";
    public static final String PROXY_TYPE = "proxyType";
    public static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
    public static final String PROXY_AUTHENTICATION_USERNAME = "proxyAuthenticationUsername";
    public static final String PROXY_AUTHENTICATION_PASSWORD = "proxyAuthenticationPassword";
    public static final String USE_PROXY_ALL_PROTOCOLS = "useProxyAllProtocols";
    public static final String DIRECT = "DIRECT";
    private static String presetNonProxyHosts;
    public static final int DIRECT_CONNECTION = 0;
    public static final int AUTO_DETECT_PROXY = 1;
    public static final int MANUAL_SET_PROXY = 2;

    ProxySettings() {
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(ProxySettings.class);
    }

    public static String getHttpHost() {
        return ProxySettings.normalizeProxyHost(ProxySettings.getPreferences().get(PROXY_HTTP_HOST, ""));
    }

    public static String getHttpPort() {
        return ProxySettings.getPreferences().get(PROXY_HTTP_PORT, "");
    }

    public static String getHttpsHost() {
        if (ProxySettings.useProxyAllProtocols()) {
            return ProxySettings.getHttpHost();
        }
        return ProxySettings.getPreferences().get(PROXY_HTTPS_HOST, "");
    }

    public static String getHttpsPort() {
        if (ProxySettings.useProxyAllProtocols()) {
            return ProxySettings.getHttpPort();
        }
        return ProxySettings.getPreferences().get(PROXY_HTTPS_PORT, "");
    }

    public static String getSocksHost() {
        if (ProxySettings.useProxyAllProtocols()) {
            return ProxySettings.getHttpHost();
        }
        return ProxySettings.getPreferences().get(PROXY_SOCKS_HOST, "");
    }

    public static String getSocksPort() {
        if (ProxySettings.useProxyAllProtocols()) {
            return ProxySettings.getHttpPort();
        }
        return ProxySettings.getPreferences().get(PROXY_SOCKS_PORT, "");
    }

    public static String getNonProxyHosts() {
        return ProxySettings.getPreferences().get(NOT_PROXY_HOSTS, ProxySettings.getDefaultUserNonProxyHosts());
    }

    public static int getProxyType() {
        return ProxySettings.getPreferences().getInt(PROXY_TYPE, 1);
    }

    public static boolean useAuthentication() {
        return ProxySettings.getPreferences().getBoolean(USE_PROXY_AUTHENTICATION, false);
    }

    public static boolean useProxyAllProtocols() {
        return ProxySettings.getPreferences().getBoolean(USE_PROXY_ALL_PROTOCOLS, false);
    }

    public static String getAuthenticationUsername() {
        return ProxySettings.getPreferences().get(PROXY_AUTHENTICATION_USERNAME, "");
    }

    public static char[] getAuthenticationPassword() {
        return ProxySettings.getPreferences().get(PROXY_AUTHENTICATION_PASSWORD, "").toCharArray();
    }

    static void addPreferenceChangeListener(PreferenceChangeListener l) {
        ProxySettings.getPreferences().addPreferenceChangeListener(l);
    }

    static void removePreferenceChangeListener(PreferenceChangeListener l) {
        ProxySettings.getPreferences().removePreferenceChangeListener(l);
    }

    private static String getSystemNonProxyHosts() {
        String systemProxy = System.getProperty("netbeans.system_http_non_proxy_hosts");
        return systemProxy == null ? "" : systemProxy;
    }

    private static String getPresetNonProxyHosts() {
        if (presetNonProxyHosts == null) {
            presetNonProxyHosts = System.getProperty("http.nonProxyHosts", "");
        }
        return presetNonProxyHosts;
    }

    private static String getDefaultUserNonProxyHosts() {
        return ProxySettings.getModifiedNonProxyHosts(ProxySettings.getSystemNonProxyHosts());
    }

    private static String getModifiedNonProxyHosts(String systemPreset) {
        String fromUser;
        String fromSystem = systemPreset.replace(";", "|").replace(",", "|");
        String string = fromUser = ProxySettings.getPresetNonProxyHosts() == null ? "" : ProxySettings.getPresetNonProxyHosts().replace(";", "|").replace(",", "|");
        if (Utilities.isWindows()) {
            fromSystem = ProxySettings.addReguralToNonProxyHosts(fromSystem);
        }
        String nonProxy = fromUser + (fromUser.length() == 0 ? "" : "|") + fromSystem + (fromSystem.length() == 0 ? "" : "|") + "localhost|127.0.0.1";
        String localhost = "";
        try {
            localhost = InetAddress.getLocalHost().getHostName();
            if (!"localhost".equals(localhost)) {
                nonProxy = nonProxy + "|" + localhost;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ProxySettings.compactNonProxyHosts(nonProxy);
    }

    private static String compactNonProxyHosts(String nonProxyHost) {
        StringTokenizer st = new StringTokenizer(nonProxyHost, "|");
        HashSet<String> s = new HashSet<String>();
        StringBuilder compactedProxyHosts = new StringBuilder();
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (!s.add(t.toLowerCase(Locale.US))) continue;
            if (compactedProxyHosts.length() > 0) {
                compactedProxyHosts.append('|');
            }
            compactedProxyHosts.append(t);
        }
        return compactedProxyHosts.toString();
    }

    private static String addReguralToNonProxyHosts(String nonProxyHost) {
        StringTokenizer st = new StringTokenizer(nonProxyHost, "|");
        StringBuilder reguralProxyHosts = new StringBuilder();
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.indexOf(42) == -1) {
                t = t + '*';
            }
            if (reguralProxyHosts.length() > 0) {
                reguralProxyHosts.append('|');
            }
            reguralProxyHosts.append(t);
        }
        return reguralProxyHosts.toString();
    }

    private static String normalizeProxyHost(String proxyHost) {
        if (proxyHost.toLowerCase(Locale.US).startsWith("http://")) {
            return proxyHost.substring(7, proxyHost.length());
        }
        return proxyHost;
    }
}

