/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.problems;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.prep.CssPreprocessorType;
import org.netbeans.modules.css.prep.problems.Bundle;
import org.netbeans.modules.css.prep.problems.CustomizerProblemResolver;
import org.netbeans.modules.css.prep.problems.OptionsProblemResolver;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.ProjectProblemsProviderSupport;

abstract class BaseProjectProblemsProvider
implements ProjectProblemsProvider {
    private static final Logger LOGGER = Logger.getLogger(BaseProjectProblemsProvider.class.getName());
    protected static final ProjectProblemResolver OPTIONS_PROBLEM_RESOLVER = new OptionsProblemResolver();
    final ProjectProblemsProviderSupport problemsProviderSupport = new ProjectProblemsProviderSupport((Object)this);
    final Project project;

    protected BaseProjectProblemsProvider(Project project) {
        assert (project != null);
        this.project = project;
    }

    abstract String getDisplayName();

    abstract boolean isEnabled(Project var1);

    abstract CssPreprocessorType getFileType();

    abstract void checkCompiler(Collection<ProjectProblemsProvider.ProjectProblem> var1);

    abstract ValidationResult validatePreferences(Project var1);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.problemsProviderSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.problemsProviderSupport.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        if (!this.isEnabled(this.project)) {
            return Collections.emptyList();
        }
        return this.problemsProviderSupport.getProblems(new ProjectProblemsProviderSupport.ProblemsCollector(){

            public Collection<ProjectProblemsProvider.ProjectProblem> collectProblems() {
                ArrayList<ProjectProblemsProvider.ProjectProblem> currentProblems = new ArrayList<ProjectProblemsProvider.ProjectProblem>();
                BaseProjectProblemsProvider.this.checkCompiler(currentProblems);
                BaseProjectProblemsProvider.this.checkPreferences(currentProblems, BaseProjectProblemsProvider.this.project);
                return currentProblems;
            }
        });
    }

    protected void checkPreferences(Collection<ProjectProblemsProvider.ProjectProblem> currentProblems, Project project) {
        ValidationResult validationResult = this.validatePreferences(project);
        if (validationResult.isFaultless()) {
            return;
        }
        String message = validationResult.getFirstErrorMessage();
        if (message == null) {
            message = validationResult.getFirstWarningMessage();
        }
        assert (message != null) : "Message should be found for invalid preferences: " + this.getDisplayName();
        message = Bundle.BaseProjectProblemsProvider_error(this.getDisplayName(), message);
        ProjectProblemsProvider.ProjectProblem problem = ProjectProblemsProvider.ProjectProblem.createError((String)message, (String)message, (ProjectProblemResolver)new CustomizerProblemResolver(project));
        currentProblems.add(problem);
    }
}

